/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DbgArb;

class DataArrayNavigationPanel
extends JPanel {
    private JButton firstButton;
    private JButton previousButton;
    private JButton nextButton;
    private JButton lastButton;
    private JButton objectPreferencesButton;
    private boolean objectPreferencesPermitted = true;
    private boolean navigationButtonsPermitted = true;

    DataArrayNavigationPanel() {
        this.setLayout((LayoutManager)new MigLayout("ins 0, hidemode 3, gap 0 0, fill"));
        this.firstButton = DataArrayNavigationPanel.createButton(OracleIcons.getIcon((String)"first.png"), DbgArb.getString(844));
        this.add(this.firstButton);
        this.previousButton = DataArrayNavigationPanel.createButton(OracleIcons.getIcon((String)"previous.png"), DbgArb.getString(847));
        this.add(this.previousButton);
        this.nextButton = DataArrayNavigationPanel.createButton(OracleIcons.getIcon((String)"next.png"), DbgArb.getString(846));
        this.add(this.nextButton);
        this.lastButton = DataArrayNavigationPanel.createButton(OracleIcons.getIcon((String)"last.png"), DbgArb.getString(845));
        this.add(this.lastButton);
        this.objectPreferencesButton = DataArrayNavigationPanel.createButton(OracleIcons.getIcon((String)"debugger/objectdisplaypreferences.png"), DbgArb.getString(301));
        this.add(this.objectPreferencesButton);
        this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.setOpaque(false);
        this.setVisible(false);
    }

    void addObjectPreferencesActionListener(ActionListener listener) {
        this.objectPreferencesButton.addActionListener(listener);
    }

    void addFirstButtonActionListener(ActionListener listener) {
        this.firstButton.addActionListener(listener);
    }

    void addLastButtonActionListener(ActionListener listener) {
        this.lastButton.addActionListener(listener);
    }

    void addPreviousButtonActionListener(ActionListener listener) {
        this.previousButton.addActionListener(listener);
    }

    void addNextButtonActionListener(ActionListener listener) {
        this.nextButton.addActionListener(listener);
    }

    private void setNavigationButtonsVisible(boolean visible) {
        this.firstButton.setVisible(visible);
        this.lastButton.setVisible(visible);
        this.previousButton.setVisible(visible);
        this.nextButton.setVisible(visible);
    }

    void enableNavigationButtons(DataItem dataItem) {
        this.firstButton.setEnabled(dataItem.canAdjustRangeFirst());
        this.lastButton.setEnabled(dataItem.canAdjustRangeLast(true));
        this.previousButton.setEnabled(dataItem.canAdjustRangePrevious());
        this.nextButton.setEnabled(dataItem.canAdjustRangeNext(true));
    }

    private void setObjectPreferencesButtonVisible(boolean visible) {
        this.objectPreferencesButton.setVisible(visible);
    }

    static JButton createButton(Icon icon, String tooltip) {
        final JButton b = new JButton(icon);
        final Border emptyButtonBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        b.setBorder(emptyButtonBorder);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setOpaque(false);
        b.setToolTipText(tooltip);
        b.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                b.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            }

            @Override
            public void focusLost(FocusEvent e) {
                b.setBorder(emptyButtonBorder);
            }
        });
        return b;
    }

    void updatePanel(DataItem dataItem) {
        try {
            boolean noButtons = true;
            this.setNavigationButtonsVisible(false);
            this.setObjectPreferencesButtonVisible(false);
            if (dataItem != null && this.navigationButtonsPermitted && dataItem.shouldShowArrayNavigationButtons()) {
                noButtons = false;
                this.setNavigationButtonsVisible(true);
                this.enableNavigationButtons(dataItem);
            }
            if (dataItem != null && this.objectPreferencesPermitted && dataItem.canAdjustObjectPreferences()) {
                noButtons = false;
                this.setObjectPreferencesButtonVisible(true);
            }
            this.setVisible(!noButtons);
        }
        catch (DataExpiredException dataExpiredException) {
            // empty catch block
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Point p = mouseEvent.getPoint();
        for (Component c : this.getComponents()) {
            if (!c.isVisible() || !c.getBounds().contains(p) || !(c instanceof JComponent)) continue;
            return ((JComponent)c).getToolTipText();
        }
        return null;
    }

    public void setObjectPreferencesPermitted(boolean objectPreferencesPermitted) {
        this.objectPreferencesPermitted = objectPreferencesPermitted;
    }

    public boolean isObjectPreferencesPermitted() {
        return this.objectPreferencesPermitted;
    }

    public void setNavigationButtonsPermitted(boolean navigationButtonsPermitted) {
        this.navigationButtonsPermitted = navigationButtonsPermitted;
    }

    public boolean isNavigationButtonsPermitted() {
        return this.navigationButtonsPermitted;
    }
}

