/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.patch;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.file.ContentSetRoot;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.patch.PatchAssistance;
import oracle.javatools.patch.PatchEntry;
import oracle.javatools.patch.PatchFormat;
import oracle.javatools.patch.PatchModel;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.patch.ApplyPatchDialog;
import oracle.jdeveloper.patch.PatchAssistanceManager;
import oracle.jdeveloper.patch.PatchExceptionHandler;
import oracle.jdeveloper.patch.res.Resource;

public class ApplyPatch {
    public static final String ENCODING = "apply-patch-encoding";
    private String _patchFile;

    public void setPatchFile(String patch) {
        this._patchFile = patch;
    }

    public boolean locateSourceAndApply() {
        Set<String> paths;
        PatchModel patchModel;
        PatchAssistance assistance;
        final PatchPanel panel = new PatchPanel();
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)panel, (Component)panel.getDefaultComp(), (String)Resource.get("PATCH_LOCATION_TITLE"), (int)7);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(Resource.get("PATCH_DLG_HEADER"));
        dialog.setDialogHeader((Component)header);
        PatchFormat patchFormat = new PatchFormat();
        try {
            patchFormat.setEncoding(StreamDecoder.getDefaultEncoding((URL)URLFactory.newURL((String)this._patchFile)));
            String patch = this.readStringFromURL(URLFactory.newURL((String)this._patchFile), patchFormat.getEncoding());
            assistance = PatchAssistanceManager.getAssistance(patch.getBytes());
            patchModel = patchFormat.parse(patch, assistance);
            paths = this.getPatchPaths(patchModel.getEntries());
            panel.setPaths(paths);
        }
        catch (IOException e) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)e.getLocalizedMessage(), (String)Resource.get("PATCH_LOC_ERROR_TITLE"), null);
            return false;
        }
        catch (ParseException e) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)e.getLocalizedMessage(), (String)Resource.get("PATCH_LOC_ERROR_TITLE"), null);
            return false;
        }
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    return;
                }
                URL url = panel.getRootLocation();
                this.basicValidation(evt, url);
                this.filesExists(url, evt);
            }

            private void basicValidation(PropertyChangeEvent evt, URL url) throws PropertyVetoException {
                if (url == null) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)Resource.get("ROOT_LOC_EMPTY"), (String)Resource.get("PATCH_LOC_ERROR_TITLE"), null);
                    throw new PropertyVetoException(Resource.get("ROOT_LOC_EMPTY"), evt);
                }
                if (!URLFileSystem.exists((URL)url)) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)Resource.format("ROOT_LOC_EXIST", URLFileSystem.getPlatformPathName((URL)url)), (String)Resource.get("PATCH_LOC_ERROR_TITLE"), null);
                    throw new PropertyVetoException(Resource.format("ROOT_LOC_EXIST", URLFileSystem.getPlatformPathName((URL)url)), evt);
                }
            }

            private void filesExists(URL url, PropertyChangeEvent evt) throws PropertyVetoException {
                HashSet<String> notExist = new HashSet<String>();
                for (String path : paths) {
                    if (ApplyPatch.this.exists(url, path)) continue;
                    notExist.add(path);
                }
                if (!notExist.isEmpty()) {
                    StringBuilder para = new StringBuilder();
                    Iterator it = notExist.iterator();
                    while (it.hasNext()) {
                        if (para.length() > 0) {
                            para.append("\n");
                        }
                        para.append((String)it.next());
                    }
                    boolean ans = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)Resource.format("WARNING_FILES_EXIST", para.toString()), (String)Resource.get("PATCH_LOC_ERROR_TITLE"), null);
                    if (!ans) {
                        throw new PropertyVetoException(Resource.get("PATCH_LOC_ERROR_TITLE"), evt);
                    }
                }
            }
        });
        if (dialog.runDialog()) {
            try {
                ApplyPatchDialog patchDialog = new ApplyPatchDialog(patchFormat.getEncoding(), new PatchExceptionHandler());
                patchDialog.apply(new URL[]{panel.getRootLocation()}, patchModel, assistance);
            }
            catch (Exception e) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)e.getMessage(), (String)Resource.get("PATCH_LOC_ERROR_TITLE"), null);
                return false;
            }
        }
        dialog.dispose();
        return true;
    }

    private boolean exists(URL url, String path) {
        URL fUrl = URLFactory.newURL((URL)url, (String)path);
        if (URLFileSystem.exists((URL)fUrl)) {
            return true;
        }
        int index = path.indexOf(47);
        if (index == -1 || index + 1 > path.length()) {
            return false;
        }
        String spath = path.substring(index + 1);
        return this.exists(url, spath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStringFromURL(URL url, String charsetName) throws IOException {
        InputStreamReader isr = null;
        StringWriter sw = new StringWriter();
        try {
            int n;
            isr = new InputStreamReader(URLFileSystem.openInputStream((URL)url), charsetName);
            char[] c = new char[(int)Math.pow(2.0, 10.0)];
            while ((n = isr.read(c, 0, c.length)) >= 0) {
                if (n <= 0) continue;
                sw.write(c, 0, n);
            }
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sw.toString();
    }

    private Set<String> getPatchPaths(PatchEntry[] patchEntrys) {
        HashSet<String> paths = new HashSet<String>();
        for (PatchEntry entry : patchEntrys) {
            paths.add(entry.getFromFile().substring(entry.getFromFile().indexOf(47) + 1));
            paths.add(entry.getToFile().substring(entry.getToFile().indexOf(47) + 1));
        }
        return paths;
    }

    private class PatchPanel
    extends JPanel {
        private JTree _tree;
        private JLabel _label;
        private JLabel _infoMessage;
        private FileField _file;
        private JButton _browse;
        private Set<String> _paths;

        PatchPanel() {
            this.init();
            this.layoutComponents();
            this.addListeners();
        }

        Component getDefaultComp() {
            return this._tree;
        }

        private void init() {
            this._tree = new JTree(new DefaultTreeModel(new RootNode(), true));
            this._tree.getSelectionModel().setSelectionMode(1);
            this._tree.setRootVisible(true);
            this._tree.getSelectionModel().setSelectionMode(1);
            this._label = new JLabel();
            this._file = new FileField();
            this._browse = new JButton();
            this._infoMessage = new JLabel();
            ResourceUtils.resLabel((JLabel)this._label, (Component)this._file, (String)Resource.get("PATCH_ROOT_LABEL"));
            ResourceUtils.resButton((AbstractButton)this._browse, (String)Resource.get("PATCH_ROOT_BROWSE"));
        }

        private void layoutComponents() {
            Insets ins = new Insets(5, 5, 5, 5);
            this.setLayout(new GridBagLayout());
            this.add((Component)new JScrollPane(this._tree), new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 17, 1, ins, 0, 0));
            this.add((Component)this._label, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, ins, 0, 0));
            this.add((Component)this._file, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 2, ins, 0, 0));
            this.add((Component)this._browse, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
            this.add((Component)this._infoMessage, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 13, 2, ins, 0, 0));
        }

        private void addListeners() {
            this._browse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    URLChooser urlChooser = DialogUtil.newURLChooser();
                    urlChooser.setSelectionScope(1);
                    urlChooser.setSelectedURL(URLFactory.newDirURL((String)PatchPanel.this._file.getText()));
                    int ret = urlChooser.showOpenDialog((Component)PatchPanel.this, Resource.get("PATCH_BROWSE_TITLE"));
                    if (ret == 0) {
                        URL url = urlChooser.getSelectedURL();
                        PatchPanel.this._file.setText(URLFileSystem.getPlatformPathName((URL)url));
                    }
                }
            });
            this._tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreeNode node = (TreeNode)PatchPanel.this._tree.getLastSelectedPathComponent();
                    PatchPanel.this._file.setText(((BaseNode)node).getDirectory());
                }
            });
            this._tree.setCellRenderer(new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                    BaseNode node = (BaseNode)value;
                    this.setIcon(node.getIcon());
                    return this;
                }
            });
            this._file.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.validatePaths();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.validatePaths();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.validatePaths();
                }

                private void validatePaths() {
                    URL url = URLFactory.newURL((String)PatchPanel.this._file.getText());
                    if (url == null) {
                        PatchPanel.this._infoMessage.setText("");
                        return;
                    }
                    for (String path : PatchPanel.this._paths) {
                        if (ApplyPatch.this.exists(url, path)) continue;
                        PatchPanel.this._infoMessage.setText(Resource.get("PATCH_PATHS_NOT_EXIST"));
                        return;
                    }
                    PatchPanel.this._infoMessage.setText(Resource.get("PATCH_PATHS_EXIST"));
                }
            });
        }

        private URL getRootLocation() {
            if (this._file.getText().isEmpty()) {
                return null;
            }
            return URLFactory.newDirURL((String)this._file.getText());
        }

        private void setPaths(Set<String> paths) {
            this._paths = paths;
        }

        private class RootNode
        extends BaseNode {
            RootNode() {
                super(null, null);
            }

            @Override
            protected void populateImpl() {
                Collection wks = Ide.getWorkspaces().workspaces();
                Iterator it = wks.iterator();
                while (it.hasNext()) {
                    WorkspaceNode node = new WorkspaceNode((TreeNode)this, (Workspace)it.next());
                    this.add(node);
                }
            }

            @Override
            protected String getDirectory() {
                return "";
            }

            public String toString() {
                return Resource.get("PATCH_ROOT_NODE_LABEL");
            }

            @Override
            public Icon getIcon() {
                return null;
            }
        }

        private class DirectoyNode
        extends BaseNode {
            DirectoyNode(TreeNode parent, ContentSetRoot user) {
                super(parent, user);
            }

            @Override
            protected void populateImpl() {
            }

            @Override
            protected String getDirectory() {
                ContentSetRoot root = (ContentSetRoot)this.getUserObject();
                return URLFileSystem.getPlatformPathName((URL)root.getURL());
            }

            public String toString() {
                ContentSetRoot root = (ContentSetRoot)this.getUserObject();
                return URLFileSystem.getName((URL)root.getURL());
            }

            @Override
            public Icon getIcon() {
                return OracleIcons.getIcon((String)"folder.png");
            }
        }

        private class ProjectNode
        extends BaseNode {
            ProjectNode(TreeNode parent, Project user) {
                super(parent, user);
            }

            @Override
            protected void populateImpl() {
                Project prj = (Project)this.getUserObject();
                Collection roots = ContentSetRoot.getContentSetRoots((Project)prj);
                for (ContentSetRoot root : roots) {
                    if (!URLFileSystem.exists((URL)root.getURL())) continue;
                    DirectoyNode dnode = new DirectoyNode((TreeNode)this, root);
                    this.add(dnode);
                }
            }

            @Override
            protected String getDirectory() {
                Project prj = (Project)this.getUserObject();
                return URLFileSystem.getParent((URL)prj.getURL()).getPath();
            }

            public String toString() {
                Project prj = (Project)this.getUserObject();
                int ind = prj.getShortLabel().indexOf(".jpr");
                if (ind > -1) {
                    return prj.getShortLabel().substring(0, ind);
                }
                return prj.getShortLabel();
            }

            @Override
            public Icon getIcon() {
                Project prj = (Project)this.getUserObject();
                return prj.getIcon();
            }
        }

        private class WorkspaceNode
        extends BaseNode {
            private WorkspaceNode(TreeNode parent, Workspace workspace) {
                super(parent, workspace);
            }

            @Override
            protected void populateImpl() {
                Workspace wk = (Workspace)this.getUserObject();
                Iterator it = wk.getChildren();
                while (it.hasNext()) {
                    Element elm = (Element)it.next();
                    if (!(elm instanceof Project)) continue;
                    ProjectNode node = new ProjectNode((TreeNode)this, (Project)elm);
                    this.add(node);
                }
            }

            @Override
            protected String getDirectory() {
                Workspace wk = (Workspace)this.getUserObject();
                return wk.getBaseDirectory();
            }

            public String toString() {
                Workspace wk = (Workspace)this.getUserObject();
                int wks = wk.getShortLabel().indexOf(".jws");
                if (wks > -1) {
                    return wk.getShortLabel().substring(0, wks);
                }
                return wk.getShortLabel();
            }

            @Override
            public Icon getIcon() {
                Workspace wk = (Workspace)this.getUserObject();
                return wk.getIcon();
            }
        }

        private abstract class BaseNode
        implements TreeNode {
            private List<TreeNode> _kids = null;
            private TreeNode _parent;
            private Object _userObject;

            BaseNode(TreeNode parent, Object userObject) {
                this._parent = parent;
                this._userObject = userObject;
            }

            @Override
            public TreeNode getChildAt(int childIndex) {
                if (this._kids == null) {
                    this.populate();
                }
                return this._kids.get(childIndex);
            }

            @Override
            public int getChildCount() {
                if (this._kids == null) {
                    this.populate();
                }
                return this._kids.size();
            }

            @Override
            public TreeNode getParent() {
                return this._parent;
            }

            @Override
            public int getIndex(TreeNode node) {
                if (this._kids == null) {
                    this.populate();
                }
                return this._kids.indexOf(node);
            }

            @Override
            public boolean getAllowsChildren() {
                return true;
            }

            @Override
            public boolean isLeaf() {
                return false;
            }

            public Enumeration children() {
                if (this._kids == null) {
                    this.populate();
                }
                return new Vector<TreeNode>(this._kids).elements();
            }

            protected void add(BaseNode node) {
                this._kids.add(node);
            }

            protected Object getUserObject() {
                return this._userObject;
            }

            private void populate() {
                if (this._kids == null) {
                    this._kids = new ArrayList<TreeNode>();
                }
                this.populateImpl();
            }

            protected abstract void populateImpl();

            protected abstract String getDirectory();

            public abstract Icon getIcon();
        }
    }
}

