/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.translation.api.prefs;

import java.util.HashMap;
import oracle.dbtools.migration.parser.Messages;
import oracle.dbtools.migration.translation.api.prefs.TranslationFormatPreferences;

public class TranslationPreferences {
    boolean m_convertToAnsiJoins = true;
    TranslationFormatPreferences m_formatPreferences = null;
    private boolean m_useCompoundTrigger = true;
    private String m_formatMask = null;
    private String m_queryAssignmentPreference = null;
    private boolean m_guessUnknownSchema = true;
    private boolean m_genEntireEmulationPkg = false;
    public static final String SELECTINTOASSIGNMENT = "SELECT INTO assignment";
    public static final String SELECTINTOEXCEPTIONASSIGNMENT = "SELECT INTO assignment with Exception Handling";
    public static final String CURSORLOOPASSIGNMENT = "FOR rec IN (SELECT...) LOOP assignment --best emulation";
    public static final String SELECTINTOASSIGNMENT_LABEL = Messages.getString("TranslationPreference.1");
    public static final String SELECTINTOEXCEPTIONASSIGNMENT_LABEL = Messages.getString("TranslationPreference.2");
    public static final String CURSORLOOPASSIGNMENT_LABEL = Messages.getString("TranslationPreference.3");
    private static HashMap<String, String> m_selectIntoLabelToValueMapping = new HashMap();
    private static HashMap<String, String> m_selectIntoValueToLabelMapping = new HashMap();
    public static final String FORMAT_MASK = "MM/DD/YY";
    public static final String VARPREFIX = "v_";
    public static final String INPARAM = "iv_";
    public static final boolean GENERATEENTIREEMULATIONPKG = true;
    public static final boolean ISQUOTEDIDENTIFIERONSQLSERVER = true;
    public boolean m_isQuotedIdentifierOnSQLServer = true;
    public static final boolean ISQUOTEDIDENTIFIERONSYBASE = false;
    public static final boolean USECOMPOUNDTRIGGER = false;
    public boolean m_isQuotedIdentifierOnSybase = false;
    public static final boolean ISORACLE128BYTEIDENTIFIER = false;
    public boolean m_isOracle128ByteIdentifier = false;
    private boolean _target12c = false;
    private boolean _nativeJoins = false;
    private boolean _char32k = false;
    private boolean _fetchFirst = false;
    private boolean _identityCols = false;
    private boolean _implicitResultSet = false;

    public boolean isGuessUnknownSchema() {
        return this.m_guessUnknownSchema;
    }

    public void setGuessUnknownSchema(boolean bl) {
        this.m_guessUnknownSchema = bl;
    }

    public void setUseCompoundTrigger(boolean bl) {
        this.m_useCompoundTrigger = bl;
    }

    public TranslationPreferences(TranslationFormatPreferences translationFormatPreferences) {
        this.m_formatPreferences = translationFormatPreferences;
    }

    public TranslationPreferences() {
    }

    public boolean isConvertToAnsiJoins() {
        return this.m_convertToAnsiJoins;
    }

    public void setConvertToAnsiJoins(boolean bl) {
        this.m_convertToAnsiJoins = bl;
    }

    public TranslationFormatPreferences getFormatPreferences() {
        return this.m_formatPreferences;
    }

    public void setFormatPreferences(TranslationFormatPreferences translationFormatPreferences) {
        this.m_formatPreferences = translationFormatPreferences;
    }

    public String getFormatMask() {
        return this.m_formatMask;
    }

    public void setFormatMask(String string) {
        this.m_formatMask = string;
    }

    public String getQueryAssignmentPreference() {
        return this.m_queryAssignmentPreference;
    }

    public void setQueryAssignmentPreference(String string) {
        this.m_queryAssignmentPreference = string;
    }

    public boolean getGenerateEntireEmulationPkg() {
        return this.m_genEntireEmulationPkg;
    }

    public void setGenerateEntireEmulationPkg(boolean bl) {
        this.m_genEntireEmulationPkg = bl;
    }

    public boolean isOracle128ByteIdentifier() {
        return this.m_isOracle128ByteIdentifier;
    }

    public void setIsOracle128ByteIdentifier(boolean bl) {
        this.m_isOracle128ByteIdentifier = bl;
    }

    public boolean isQuotedIdentifierOnSybase() {
        return this.m_isQuotedIdentifierOnSybase;
    }

    public void setIsQuotedIdentifierOnSybase(boolean bl) {
        this.m_isQuotedIdentifierOnSybase = bl;
    }

    public boolean isQuotedIdentifierOnSQLServer() {
        return this.m_isQuotedIdentifierOnSQLServer;
    }

    public void setIsQuotedIdentifierOnSQLServer(boolean bl) {
        this.m_isQuotedIdentifierOnSQLServer = bl;
    }

    public static String getSelectLabelFromValue(String string) {
        return m_selectIntoValueToLabelMapping.get(string);
    }

    public static String getSelectValueFromLabel(String string) {
        return m_selectIntoLabelToValueMapping.get(string);
    }

    public boolean getUseCompoundTrigger() {
        return this.m_useCompoundTrigger;
    }

    public void setTarget12c(boolean bl) {
        this._target12c = bl;
    }

    public void set32Chars(boolean bl) {
        this._char32k = bl;
    }

    public void setFetchFirst(boolean bl) {
        this._fetchFirst = bl;
    }

    public void setIdentityCols(boolean bl) {
        this._identityCols = bl;
    }

    public void setImplicitResultSets(boolean bl) {
        this._implicitResultSet = bl;
    }

    public void setNativeJoins(boolean bl) {
        this._nativeJoins = bl;
    }

    public boolean getTarget12c() {
        return this._target12c;
    }

    public boolean get32Chars() {
        return this._char32k;
    }

    public boolean getFetchFirst() {
        return this._fetchFirst;
    }

    public boolean getIdentityCols() {
        return this._identityCols;
    }

    public boolean getImplicitResultSets() {
        return this._implicitResultSet;
    }

    public boolean getNativeJoins() {
        return this._nativeJoins;
    }

    public void setAll12c(boolean bl) {
        this.setTarget12c(bl);
        this.set32Chars(bl);
        this.setFetchFirst(bl);
        this.setIdentityCols(bl);
        this.setImplicitResultSets(bl);
        this.setNativeJoins(bl);
    }

    static {
        m_selectIntoLabelToValueMapping.put(SELECTINTOASSIGNMENT_LABEL, SELECTINTOASSIGNMENT);
        m_selectIntoLabelToValueMapping.put(SELECTINTOEXCEPTIONASSIGNMENT_LABEL, SELECTINTOEXCEPTIONASSIGNMENT);
        m_selectIntoLabelToValueMapping.put(CURSORLOOPASSIGNMENT_LABEL, CURSORLOOPASSIGNMENT);
        m_selectIntoValueToLabelMapping.put(SELECTINTOASSIGNMENT, SELECTINTOASSIGNMENT_LABEL);
        m_selectIntoValueToLabelMapping.put(SELECTINTOEXCEPTIONASSIGNMENT, SELECTINTOEXCEPTIONASSIGNMENT_LABEL);
        m_selectIntoValueToLabelMapping.put(CURSORLOOPASSIGNMENT, CURSORLOOPASSIGNMENT_LABEL);
    }
}

