/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import oracle.dbtools.migration.parser.analysis.CrossTableQuery;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.ext.ExtStringTemplate;
import oracle.dbtools.migration.parser.helper.StatementLine;
import oracle.dbtools.migration.parser.helper.StatementLineComparator;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.translation.api.TranslationLimitation;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.components.SessionSetting;
import oracle.dbtools.migration.translation.api.components.TranslationDataType;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;
import oracle.dbtools.migration.translation.api.components.Var;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;

public class TranslationMetaData {
    private ArrayList<TranslationParameter> m_sourceParameters = new ArrayList();
    private ArrayList<TranslationParameter> m_targetParameters = new ArrayList();
    private ArrayList<Var> m_sourceDeclaredVariables = new ArrayList();
    private ArrayList<Var> m_targetDeclaredVariables = new ArrayList();
    private ArrayList<TranslationDBObject> m_sourceDependencies = new ArrayList();
    private ArrayList<TranslationDBObject> m_targetDependencies = new ArrayList();
    private final Hashtable<String, TranslationLimitation> m_translationLimitations = new Hashtable();
    private Var m_sysErrorVar = null;
    private Var m_sysTranstateVar = null;
    private ArrayList<AST> m_errorCodeRefs = new ArrayList();
    private LinkedHashMap<Block, Object> m_extraObjectMap = new LinkedHashMap();
    private ArrayList<SessionSetting> m_sessionSettings = new ArrayList();
    private TranslationHelper m_helper = null;
    private Hashtable<Block, CrossTableQuery> m_crossTableQueryMap = new Hashtable();
    private Hashtable<Block, TranslationDataType> m_objReturnTypeMap = new Hashtable();
    private Hashtable<Block, ArrayList<Pragma>> m_pragmaMap = new Hashtable();
    private ArrayList<StatementLine> m_stmtLines = new ArrayList();
    private boolean m_hasReturnParamBeingSet = false;

    public TranslationMetaData(TranslationHelper translationHelper) {
        this.m_helper = translationHelper;
    }

    public TranslationHelper getTranslationHelper() {
        return this.m_helper;
    }

    public void renameParameter(String string, String string2) {
        for (TranslationParameter translationParameter : this.m_targetParameters) {
            if (!translationParameter.getName().equalsIgnoreCase(string)) continue;
            translationParameter.setName("i" + translationParameter.getName());
            return;
        }
    }

    public void addVariable(Var var) {
        this.m_targetDeclaredVariables.add(var);
    }

    public Var[] getAllVariables() {
        int n = this.m_targetDeclaredVariables.size();
        Var[] varArray = new Var[n];
        for (int i = 0; i < n; ++i) {
            varArray[i] = this.m_targetDeclaredVariables.get(i);
        }
        return varArray;
    }

    public Var getVariable(Block block, String string) {
        return this.getVariable(block, string, false);
    }

    public Var getVariable(Block block, String string, boolean bl) {
        if (block == null) {
            return null;
        }
        for (Block block2 = block; block2 != null; block2 = block2.getParent()) {
            for (Var var : this.m_targetDeclaredVariables) {
                if (!var.getBlock().equals(block2)) continue;
                if (string == null) {
                    return var;
                }
                if (!var.getName().equalsIgnoreCase(string)) continue;
                return var;
            }
        }
        return null;
    }

    public Var getVariable(Block block, AST aST) {
        if (block == null) {
            return null;
        }
        for (Var var : this.m_targetDeclaredVariables) {
            if (!var.getBlock().equals(block)) continue;
            if (aST == null) {
                return var;
            }
            if (!var.getTreePosition().getText().equalsIgnoreCase(aST.getText())) continue;
            return var;
        }
        return null;
    }

    public Var[] getVariables(Block block, AST aST) {
        ArrayList<Var> arrayList = new ArrayList<Var>();
        if (block == null) {
            return null;
        }
        for (Var var : this.m_targetDeclaredVariables) {
            if (!var.getBlock().equals(block)) continue;
            if (aST == null) {
                arrayList.add(var);
                continue;
            }
            if (!var.getTreePosition().getText().equalsIgnoreCase(aST.getText())) continue;
            arrayList.add(var);
        }
        return arrayList.toArray(new Var[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addVariable(Block block, String string, AST aST) {
        int n = 0;
        int n2 = 1;
        Object object = string;
        ArrayList<Var> arrayList = this.m_targetDeclaredVariables;
        synchronized (arrayList) {
            ArrayList<Var> arrayList2 = this.getVariables(block);
            while (n < arrayList2.size()) {
                if (arrayList2.get(n).getName().equalsIgnoreCase((String)object)) {
                    object = string + "_" + n2++;
                    n = 0;
                    continue;
                }
                ++n;
            }
            this.m_targetDeclaredVariables.add(new Var((String)object, new TranslationDataType("NUMBER"), "0", block, aST));
        }
        return object;
    }

    public ArrayList<Var> getVariables(Block block) {
        ArrayList<Var> arrayList = new ArrayList<Var>();
        if (block != null) {
            for (Var var : this.m_targetDeclaredVariables) {
                if (!var.getBlock().equals(block)) continue;
                arrayList.add(var);
            }
        }
        return arrayList;
    }

    public boolean hasVariable(String string, Block block) {
        for (Var var : this.m_targetDeclaredVariables) {
            if (var.getBlock() != block || !var.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public String addGeneratedVariable(Block block, String string, String string2, String string3, AST aST, boolean bl) {
        if (block == null) {
            return null;
        }
        Object object = string;
        if (this.hasVariable((String)object, block) && !bl) {
            return object;
        }
        int n = 1;
        while (this.hasVariable((String)object, block)) {
            object = string + "_" + n++;
        }
        Var var = new Var((String)object, new TranslationDataType(string2), string3, block, aST);
        var.setGenerated(true);
        this.addVariable(var);
        return object;
    }

    public Var getVariable(AST aST) {
        Var var = null;
        int n = this.m_targetDeclaredVariables.size();
        for (int i = 0; i < n; ++i) {
            Var var2 = this.m_targetDeclaredVariables.get(i);
            if (!var2.getTreePosition().equals(aST)) continue;
            var = var2;
            break;
        }
        return var;
    }

    public void removeVariable(Var var) {
        this.m_targetDeclaredVariables.remove(var);
    }

    public void addTranslationParameter(TranslationParameter translationParameter) {
        boolean bl = false;
        int n = this.m_targetParameters.size();
        for (int i = 0; i < n; ++i) {
            TranslationParameter translationParameter2 = this.m_targetParameters.get(i);
            if (!translationParameter2.getName().equalsIgnoreCase(translationParameter.getName()) || !translationParameter2.getObjectBlock().equals(translationParameter.getObjectBlock())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            translationParameter.setParamPosition(n + 1);
            this.m_targetParameters.add(translationParameter);
        }
    }

    public void addReturnTranslationParameter(TranslationParameter translationParameter) {
        translationParameter.setParamPosition(0);
        if (!this.m_hasReturnParamBeingSet) {
            this.m_targetParameters.add(translationParameter);
            this.m_hasReturnParamBeingSet = true;
        }
    }

    public boolean hasReturnParamBeingSet() {
        return this.m_hasReturnParamBeingSet;
    }

    public TranslationParameter[] getTranslationParameters(Block block) {
        if (block == null) {
            return new TranslationParameter[0];
        }
        ArrayList<TranslationParameter> arrayList = new ArrayList<TranslationParameter>();
        for (TranslationParameter translationParameter : this.m_targetParameters) {
            if (!translationParameter.getObjectBlock().equals(block)) continue;
            arrayList.add(translationParameter);
        }
        return arrayList.toArray(new TranslationParameter[arrayList.size()]);
    }

    public boolean hasTranslationParameters(Block block) {
        if (block == null) {
            return false;
        }
        for (TranslationParameter translationParameter : this.m_targetParameters) {
            if (!translationParameter.getObjectBlock().equals(block)) continue;
            return true;
        }
        return false;
    }

    public boolean isSourceINParameter(String string) {
        for (TranslationParameter translationParameter : this.m_sourceParameters) {
            if (!translationParameter.getName().equalsIgnoreCase(string) || !translationParameter.getParamType().equalsIgnoreCase("TYPE_INPUT")) continue;
            return true;
        }
        return false;
    }

    public void addTranslationLimitation(TranslationLimitation translationLimitation) {
        String string = translationLimitation.getStartLine() + "," + translationLimitation.getStartColumn();
        this.addTranslationLimitation(translationLimitation, string);
    }

    public void addTranslationLimitation(TranslationLimitation translationLimitation, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object : this.m_translationLimitations.keySet()) {
            int string2 = Integer.parseInt(object.substring(0, object.indexOf(",")));
            int n = Integer.parseInt(object.substring(object.indexOf(",") + 1));
            if (string2 < translationLimitation.getStartLine() || string2 > translationLimitation.getEndLine() || string2 == translationLimitation.getStartLine() && n < translationLimitation.getStartColumn() || string2 == translationLimitation.getEndLine() && n > translationLimitation.getEndColumn()) continue;
            arrayList.add(object);
        }
        for (String string2 : arrayList) {
            this.m_translationLimitations.remove(string2);
        }
        if (!this.m_translationLimitations.containsKey(string)) {
            this.m_translationLimitations.put(string, translationLimitation);
        }
    }

    public TranslationLimitation getTranslationLimitation(int n, int n2) {
        return this.m_translationLimitations.get(n + "," + n2);
    }

    public void removeTranslationLimitation(int n, int n2) {
        TranslationLimitation translationLimitation = this.getTranslationLimitation(n, n2);
        if (translationLimitation != null) {
            this.m_translationLimitations.remove(translationLimitation.getStartLine() + "," + translationLimitation.getStartColumn());
        }
    }

    public void persist() {
    }

    public ArrayList<TranslationDBObject> getSourceDependencies() {
        return this.m_sourceDependencies;
    }

    public void setSourceDependencies(ArrayList<TranslationDBObject> arrayList) {
        this.m_sourceDependencies = arrayList;
    }

    public ArrayList<TranslationParameter> getSourceParameters() {
        return this.m_sourceParameters;
    }

    public void setSourceParameters(ArrayList<TranslationParameter> arrayList) {
        this.m_sourceParameters = arrayList;
    }

    public ArrayList<TranslationDBObject> getTargetDependencies() {
        return this.m_targetDependencies;
    }

    public void setTargetDependencies(ArrayList<TranslationDBObject> arrayList) {
        this.m_targetDependencies = arrayList;
    }

    public ArrayList<TranslationParameter> getTargetParameters() {
        return this.m_targetParameters;
    }

    public void setTargetParameters(ArrayList<TranslationParameter> arrayList) {
        this.m_targetParameters = arrayList;
    }

    public void addErrorCodeReference(AST aST) {
        if (!this.m_errorCodeRefs.contains(aST)) {
            this.m_errorCodeRefs.add(aST);
        }
    }

    public boolean hasErrorCodeReference(AST aST) {
        if (aST == null) {
            return false;
        }
        boolean bl = false;
        block2: for (AST aST2 : this.m_errorCodeRefs) {
            if (aST2 == aST) break;
            if (aST2.getLine() > aST.getLine()) {
                if (!(aST2 instanceof ExtAST) || !(aST instanceof ExtAST)) continue;
                try {
                    Block block = ((ExtAST)aST2).getBlock();
                    Block block2 = ((ExtAST)aST).getBlock();
                    if (block.getParent() == block2.getParent()) {
                        ArrayList<Block> arrayList = block2.getParent().getChildren();
                        for (int i = 0; i < arrayList.size(); ++i) {
                            Block block3 = arrayList.get(i);
                            if (block3 != block2) continue;
                            if (block != arrayList.get(i + 1)) continue block2;
                            return true;
                        }
                        continue;
                    }
                    bl = false;
                }
                catch (Exception exception) {}
                continue;
            }
            if (aST.getLine() >= aST2.getLine()) continue;
            bl = true;
        }
        return bl;
    }

    public void setSystemError(boolean bl) {
        String string = "v_sys_error";
        Object object = string;
        int n = 1;
        if (bl) {
            for (Var var : this.m_targetDeclaredVariables) {
                if (!var.getName().equalsIgnoreCase((String)object)) continue;
                object = string + "_" + n++;
            }
            this.m_sysErrorVar = new Var((String)object, new TranslationDataType("NUMBER"), "0", null, null);
        }
    }

    public void setSystemTranstate(boolean bl) {
        String string = "v_transtate";
        Object object = string;
        int n = 1;
        if (bl) {
            for (Var var : this.m_targetDeclaredVariables) {
                if (!var.getName().equalsIgnoreCase((String)object)) continue;
                object = string + "_" + n++;
            }
            this.m_sysTranstateVar = new Var((String)object, new TranslationDataType("NUMBER"), "1", null, null);
        }
    }

    public Var getSystemErrorVariable() {
        return this.m_sysErrorVar;
    }

    public Var getSystemTranstateVariable() {
        return this.m_sysTranstateVar;
    }

    public void addExtraObject(AST aST, TranslationDBObject translationDBObject) {
        Block block = ((ExtAST)aST).getBlock();
        if (!this.m_extraObjectMap.containsKey(block)) {
            this.m_extraObjectMap.put(block, translationDBObject);
        } else {
            ArrayList<TranslationDBObject> arrayList;
            Object object = this.m_extraObjectMap.get(block);
            if (object instanceof TranslationDBObject) {
                arrayList = new ArrayList<TranslationDBObject>();
                arrayList.add((TranslationDBObject)this.m_extraObjectMap.get(block));
            } else {
                arrayList = (ArrayList<TranslationDBObject>)object;
            }
            arrayList.add(translationDBObject);
            this.m_extraObjectMap.put(block, arrayList);
        }
    }

    public TranslationDBObject[] getExtraObject(AST aST) {
        Block block = ((ExtAST)aST).getBlock();
        Object object = this.m_extraObjectMap.get(block);
        if (object == null) {
            return null;
        }
        if (object instanceof TranslationDBObject) {
            return new TranslationDBObject[]{(TranslationDBObject)object};
        }
        return ((ArrayList)object).toArray(new TranslationDBObject[((ArrayList)object).size()]);
    }

    public TranslationDBObject getExtraObject(AST aST, TranslationObjectType translationObjectType) {
        Block block = ((ExtAST)aST).getBlock();
        Object object = this.m_extraObjectMap.get(block);
        if (object == null) {
            return null;
        }
        if (object instanceof TranslationDBObject) {
            TranslationDBObject translationDBObject = (TranslationDBObject)object;
            if (translationDBObject.getType().getObjectType().equalsIgnoreCase(translationObjectType.getObjectType())) {
                return translationDBObject;
            }
        } else {
            for (TranslationDBObject translationDBObject : (ArrayList)object) {
                if (!translationDBObject.getType().getObjectType().equalsIgnoreCase(translationObjectType.getObjectType())) continue;
                return translationDBObject;
            }
        }
        return null;
    }

    public ArrayList<TranslationDBObject> getExtraObjects() {
        ArrayList<TranslationDBObject> arrayList = new ArrayList<TranslationDBObject>();
        for (Object object : this.m_extraObjectMap.values()) {
            if (object instanceof TranslationDBObject) {
                arrayList.add((TranslationDBObject)object);
                continue;
            }
            arrayList.addAll((ArrayList)object);
        }
        return arrayList;
    }

    public Block[] getExtraObjectKeys() {
        Set<Block> set = this.m_extraObjectMap.keySet();
        Block[] blockArray = set.toArray(new Block[set.size()]);
        return blockArray;
    }

    public boolean hasExtraObject(AST aST) {
        Block block = ((ExtAST)aST).getBlock();
        return this.m_extraObjectMap.containsKey(block);
    }

    public void removeExtraObject(AST aST) {
        this.m_extraObjectMap.remove(aST);
    }

    public void setSessionSetting(AST aST, String string, String string2) {
        this.m_sessionSettings.add(new SessionSetting(aST, string, string2));
    }

    public SessionSetting getSessionSetting(AST aST, String string) {
        SessionSetting sessionSetting = null;
        for (SessionSetting sessionSetting2 : this.m_sessionSettings) {
            AST aST2;
            if (!sessionSetting2.getName().equalsIgnoreCase(string) || (aST2 = sessionSetting2.getAST()).getLine() >= aST.getLine() && (aST2.getLine() != aST.getLine() || aST2.getColumn() >= aST.getColumn())) continue;
            sessionSetting = sessionSetting2;
        }
        return sessionSetting;
    }

    public void addCrossTableQuery(Block block) {
        if (!this.m_crossTableQueryMap.containsKey(block)) {
            this.m_crossTableQueryMap.put(block, new CrossTableQuery(block.getAST(), block));
        }
    }

    public boolean isCrossTableQuery(Block block) {
        return this.m_crossTableQueryMap.contains(block);
    }

    public CrossTableQuery getCrossTableQuery(Block block) {
        return this.m_crossTableQueryMap.get(block);
    }

    public void addObjectReturnType(Block block, TranslationDataType translationDataType) {
        this.m_objReturnTypeMap.put(block, translationDataType);
    }

    public TranslationDataType getObjectReturnType(Block block) {
        return this.m_objReturnTypeMap.get(block);
    }

    public String getLastFetchCursor(AST aST) {
        Object var2_2 = null;
        int n = ((ExtAST)aST).getSourceStartLine();
        Collections.sort(this.m_stmtLines, new StatementLineComparator());
        StatementLine statementLine = null;
        for (StatementLine statementLine2 : this.m_stmtLines) {
            if (statementLine2.get_sourceLine() > n) {
                if (statementLine != null) {
                    return statementLine.get_name();
                }
                return null;
            }
            statementLine = statementLine2;
        }
        if (statementLine != null) {
            return statementLine.get_name();
        }
        return null;
    }

    public void addFetch(String string, AST aST) {
        int n = ((ExtAST)aST).getSourceStartLine();
        this.m_stmtLines.add(new StatementLine(string, n));
    }

    public void addPragma(Block block, Pragma pragma) {
        ArrayList<Pragma> arrayList = this.m_pragmaMap.containsKey(block) ? this.m_pragmaMap.get(block) : new ArrayList<Pragma>();
        arrayList.add(pragma);
        this.m_pragmaMap.put(block, arrayList);
    }

    public void removePragma(Block block, Pragma pragma) {
        if (this.m_pragmaMap.containsKey(block)) {
            this.m_pragmaMap.get(block).remove((Object)pragma);
        }
    }

    public List<Pragma> getPragmas(Block block) {
        if (this.m_pragmaMap.containsKey(block)) {
            return this.m_pragmaMap.get(block);
        }
        return null;
    }

    public Var getVariableInScope(String string, Block block) {
        if (block == null) {
            return null;
        }
        for (Var var : this.m_targetDeclaredVariables) {
            if (!var.getName().equalsIgnoreCase(string)) continue;
            while (block != null) {
                if (var.getBlock().equals(block)) {
                    return var;
                }
                block = block.getParent();
            }
        }
        return null;
    }

    public boolean isErrorCodeReference(ExtStringTemplate extStringTemplate) {
        String string = extStringTemplate.toString();
        return this.m_errorCodeRefs.size() > 0 && string.indexOf("v_sys_error := SQLCODE") == -1 && string.indexOf("v_sys_error") != -1;
    }

    public static enum Pragma {
        AUTONOMOUS_TRANSACTION;

    }
}

