/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.file.FileChange;
import oracle.ide.file.FileChangeListener;
import oracle.ide.file.FileChanges;
import oracle.ide.file.FileChangesExpiredException;
import oracle.ide.file.FileScope;
import oracle.ide.file.JarFileTable;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.persistence.Storage;
import oracle.ide.persistence.Storages;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Maps;
import oracle.javatools.util.NullArgumentException;

public abstract class FileTable
implements FileScope {
    public static final int FIRST_VERSION = 0;
    public static final int REMOVED_VERSION = -1;
    public static final int INVALID_FILE_ID = -1;
    protected static final Logger LOGGER = Logger.getLogger("oracle.ide.file");
    @GuardedBy(value="itself")
    private static final Set<FileTable> ACTIVE_TABLES = new HashSet<FileTable>();
    private static final int CACHE_SIZE = 100;
    @GuardedBy(value="ACTIVE_TABLES")
    private static final Map<URLKey, Set<FileTable>> ACTIVE_TABLE_CACHE = new Maps.CacheMap(100, Maps.CacheMap.NOT_CANONICAL);
    protected static final boolean IS_KAVA_TEST = Boolean.getBoolean("jbo.kava");
    private static final boolean REFRESH_AUTOMATICALLY = !IS_KAVA_TEST;
    @GuardedBy(value="FileTable.class")
    private static boolean refreshOnStartup;
    static final boolean VERIFY_FILE_TABLES;
    protected final Storage storage;
    protected final List<FileChangeListener> listeners = new CopyOnWriteArrayList<FileChangeListener>();
    @GuardedBy(value="activeTables")
    private int activationCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<FileTable> getActiveFileTablesContaining(URL url) {
        Set<FileTable> tables;
        Set<FileTable> set = ACTIVE_TABLES;
        synchronized (set) {
            URLKey key = URLKey.getInstance((URL)url);
            tables = ACTIVE_TABLE_CACHE.get(key);
            if (tables == null) {
                tables = new HashSet<FileTable>();
                for (FileTable table : ACTIVE_TABLES) {
                    if (!table.contains(url)) continue;
                    tables.add(table);
                }
                ACTIVE_TABLE_CACHE.put(key, tables);
            }
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<FileTable> getActiveFileTablesUsingJAR(URL jarFileURL) {
        HashSet<FileTable> tables = new HashSet<FileTable>();
        Set<FileTable> set = ACTIVE_TABLES;
        synchronized (set) {
            for (FileTable table : ACTIVE_TABLES) {
                JarFileTable jarTable;
                if (!(table instanceof JarFileTable) || !URLFileSystem.equals((URL)jarFileURL, (URL)(jarTable = (JarFileTable)table).getJarFileURL())) continue;
                tables.add(table);
            }
        }
        return tables;
    }

    public static void invalidateDirectory(@NotNull URL directory, boolean includeSubdirectories) {
        if (directory == null) {
            throw new NullArgumentException("null directory");
        }
        for (FileTable table : FileTable.getActiveFileTablesContaining(directory)) {
            table.invalidateDirectoryImpl(directory, includeSubdirectories, null, null);
        }
    }

    public static void invalidateDirectory(@NotNull URL directory, @NotNull URL renameHintOldURL, @NotNull URL renameHintNewURL) {
        if (directory == null) {
            throw new NullArgumentException("null directory");
        }
        if (renameHintOldURL == null) {
            throw new NullArgumentException("null renameHintOldURL");
        }
        if (renameHintNewURL == null) {
            throw new NullArgumentException("null renameHintNewURL");
        }
        for (FileTable table : FileTable.getActiveFileTablesContaining(directory)) {
            table.invalidateDirectoryImpl(directory, false, renameHintOldURL, renameHintNewURL);
        }
    }

    public static void invalidateFile(@NotNull URL file, boolean isBufferChange) {
        if (file == null) {
            throw new NullArgumentException("null file");
        }
        for (FileTable table : FileTable.getActiveFileTablesContaining(file)) {
            table.invalidateFileImpl(file, isBufferChange);
        }
    }

    public static void invalidateJar(@NotNull URL jar) {
        URL jarFileUrl = JarUtil.isJarURL((URL)jar) ? JarUtil.getJarFileURL((URL)jar) : jar;
        for (FileTable table : FileTable.getActiveFileTablesUsingJAR(jarFileUrl)) {
            table.invalidate();
        }
    }

    public static void invalidateAllJars() {
        JarFileTable.invalidateJarFileTables();
    }

    protected static boolean getRefreshAutomatically() {
        return REFRESH_AUTOMATICALLY;
    }

    protected static synchronized boolean getRefreshOnStartup() {
        return refreshOnStartup;
    }

    protected FileTable(Storage storage) {
        this.storage = storage;
    }

    @Override
    public void addFileChangeListener(FileChangeListener listener) {
        if (this.listeners.add(listener)) {
            this.activate();
        }
    }

    @Override
    public void removeFileChangeListener(FileChangeListener listener) {
        if (this.listeners.remove(listener)) {
            this.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        Set<FileTable> set = ACTIVE_TABLES;
        synchronized (set) {
            if (this.activationCount++ == 0) {
                LOGGER.fine("Activating " + this);
                ACTIVE_TABLES.add(this);
                ACTIVE_TABLE_CACHE.clear();
                this.activateImpl();
            }
        }
    }

    protected void activateImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Set<FileTable> set = ACTIVE_TABLES;
        synchronized (set) {
            if (--this.activationCount == 0) {
                LOGGER.fine("Deactivating " + this);
                this.deactivateImpl();
                ACTIVE_TABLES.remove(this);
                ACTIVE_TABLE_CACHE.clear();
            }
        }
    }

    protected void deactivateImpl() {
    }

    public Storage getStorage() {
        return this.storage;
    }

    public abstract String getStorageKey();

    public abstract void getChangesSince(int var1, long var2, @NotNull FileChangeListener var4) throws InterruptedException, FileChangesExpiredException, IOException;

    public abstract int getId(@NotNull URL var1) throws InterruptedException, IOException;

    public abstract URL getURL(int var1) throws InterruptedException, IOException;

    public abstract long getLength(int var1) throws InterruptedException, IOException;

    public abstract long getLastModified(int var1) throws InterruptedException, IOException;

    public abstract String getRelativePath(URL var1);

    public abstract void delete();

    @Override
    public void refresh() throws InterruptedException, IOException {
        this.refresh(null);
    }

    public abstract void invalidate();

    public abstract void adjustTimestamps() throws InterruptedException, IOException;

    protected abstract void invalidateFileImpl(URL var1, boolean var2);

    protected abstract void invalidateDirectoryImpl(URL var1, boolean var2, URL var3, URL var4);

    protected abstract void refreshFile(URL var1, boolean var2) throws InterruptedException, IOException;

    protected abstract void refreshDirectory(URL var1, boolean var2, URL var3, URL var4) throws InterruptedException, IOException;

    protected void invokeListeners(FileChanges changes) {
        for (FileChangeListener listener : this.listeners) {
            this.invokeListener(listener, changes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeListener(FileChangeListener listener, FileChanges changes) {
        String listenerClass = listener.getClass().getName();
        long start = System.nanoTime();
        try {
            listener.filesChanged(this, changes);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Exception in listener " + listenerClass, t);
        }
        finally {
            PerformanceLogger.get().log("FileTable.invokeListener", listenerClass, System.nanoTime() - start);
        }
    }

    @Override
    public Collection<FileTable> getFileTables() {
        return Collections.singleton(this);
    }

    @Override
    public FileTable getFileTable(URL url) {
        return this.contains(url) ? this : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void detachFileChangeListeners(Workspace workspace) {
        ArrayList<FileTable> activeTables;
        Storage storage = Storages.getApplicationStorage((Workspace)workspace);
        Set<FileTable> set = ACTIVE_TABLES;
        synchronized (set) {
            activeTables = new ArrayList<FileTable>(ACTIVE_TABLES);
        }
        for (FileTable table : activeTables) {
            if (table.getStorage() != storage) continue;
            for (FileChangeListener listener : table.listeners) {
                table.removeFileChangeListener(listener);
            }
        }
    }

    static {
        VERIFY_FILE_TABLES = Boolean.getBoolean("ide.file.table.verify");
        if (Ide.isRunning() && !VERIFY_FILE_TABLES) {
            EnvironOptions envOptions = EnvironOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            refreshOnStartup = envOptions == null || envOptions.getVerifyCachedFileData();
            envOptions.addChangeListener(new ChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void stateChanged(ChangeEvent e) {
                    Class<FileTable> clazz = FileTable.class;
                    synchronized (FileTable.class) {
                        EnvironOptions envOptions = EnvironOptions.getInstance((PropertyStorage)Preferences.getPreferences());
                        refreshOnStartup = envOptions == null || envOptions.getVerifyCachedFileData();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
        } else {
            refreshOnStartup = true;
        }
    }

    protected final class FileChangeImpl
    implements FileChange {
        private final int id;
        private final URL url;
        private final URL renameHint;
        private final long lastModified;
        private final FileChange.Type type;

        FileChangeImpl(FileChange change, FileChange.Type type) {
            this(change.getId(), change.getURL(), change.getRenameHint(), change.getLastModified(), type);
        }

        FileChangeImpl(int id, URL url, URL renameHint, long lastModified, FileChange.Type type) {
            this.id = id;
            this.url = url;
            this.renameHint = renameHint;
            this.lastModified = lastModified;
            this.type = type;
        }

        @Override
        public FileChange.Type getChangeType() {
            return this.type;
        }

        @Override
        public URL getRenameHint() {
            return this.renameHint;
        }

        @Override
        public URL getURL() {
            return this.url;
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public FileTable getFileTable() {
            return FileTable.this;
        }

        @Override
        public int getId() {
            return this.id;
        }

        public String toString() {
            return "FileChange[" + this.type + ":" + URLFileSystem.getPlatformPathName((URL)this.url) + "]";
        }
    }
}

