/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import net.jcip.annotations.GuardedBy;
import oracle.ide.file.DataStore;
import oracle.ide.file.FileChange;
import oracle.ide.file.FileChangeListener;
import oracle.ide.file.FileChanges;
import oracle.ide.file.FileChangesExpiredException;
import oracle.ide.file.FileSet;
import oracle.ide.file.FileSetFilter;
import oracle.ide.file.FileSetTable;
import oracle.ide.file.FileTable;
import oracle.ide.file.FileTableVisitor;
import oracle.ide.file.IdeEventListener;
import oracle.ide.file.InvalidFileTableException;
import oracle.ide.file.NameStore;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.Storage;
import oracle.javatools.annotations.Nullable;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.util.Executors;
import oracle.javatools.util.NullArgumentException;
import oracle.javatools.util.Pair;
import org.openide.util.RequestProcessor;

abstract class AbstractFileSetTable
extends FileSetTable {
    private static final int FORMAT = 5;
    private static final String HEADER_KEY = "header";
    private static final String INFO_KEY = "info";
    private static final AssemblyFactory HEADER_FACTORY = new HeaderAssemblyFactory();
    private static final AssemblyFactory INFO_FACTORY = new InfoAssemblyFactory();
    protected static final long IDE_SESSION_KEY = AbstractFileSetTable.getIdeSessionKey();
    protected static final int DELAY = 2;
    protected static final TimeUnit DELAY_UNIT = TimeUnit.SECONDS;
    protected static final ScheduledExecutorService SCHEDULER = new RequestProcessor("File Table Refresh", 1, true);
    private static final boolean FORCE_CACHED_LOCATE = Boolean.getBoolean("ide.file.table.locate.force.cached");
    protected static volatile boolean shutdown;
    protected final ReentrantLock lock = new ReentrantLock();
    @GuardedBy(value="lock")
    protected NameStore nameStore;

    private static long getIdeSessionKey() {
        return System.nanoTime();
    }

    static void shutdown() {
        try {
            shutdown = true;
            for (Runnable r : Executors.shutdownNow((ExecutorService)SCHEDULER)) {
                r.run();
            }
            SCHEDULER.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected AbstractFileSetTable(Storage storage, FileSet fileSet) {
        super(storage, fileSet);
    }

    @Override
    public void update() throws InterruptedException, IOException {
        try {
            this.run(new NameOperation<Void>(){

                @Override
                public Void run() {
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Collection<String> getFilePaths() throws IOException, InterruptedException {
        try {
            return this.run(new NameOperation<Collection<String>>(){

                @Override
                public Collection<String> run() throws Exception {
                    String[] paths = AbstractFileSetTable.this.nameStore.getFilePaths();
                    ArrayList<String> files = new ArrayList<String>(paths.length);
                    for (int i = 0; i < paths.length; ++i) {
                        if (AbstractFileSetTable.this.nameStore.getFileChangeType(i) == FileChange.Type.REMOVED) continue;
                        files.add(paths[i]);
                    }
                    return files;
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getRelativePath(final int id) throws InterruptedException, IOException {
        try {
            return this.run(new NameOperation<String>(){

                @Override
                public String run() throws Exception {
                    try {
                        return AbstractFileSetTable.this.nameStore.getFilePath(id);
                    }
                    catch (InvalidFileTableException e) {
                        return null;
                    }
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getParentPath(final int id) throws InterruptedException, IOException {
        try {
            return this.run(new NameOperation<String>(){

                @Override
                public String run() throws Exception {
                    try {
                        return AbstractFileSetTable.this.nameStore.getParentPath(id);
                    }
                    catch (InvalidFileTableException e) {
                        return null;
                    }
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getFileName(final int id) throws InterruptedException, IOException {
        try {
            return this.run(new NameOperation<String>(){

                @Override
                public String run() throws Exception {
                    try {
                        return AbstractFileSetTable.this.nameStore.getFileName(id);
                    }
                    catch (InvalidFileTableException e) {
                        return null;
                    }
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Collection<URL> getFiles() throws IOException, InterruptedException {
        try {
            return this.run(new NameOperation<Collection<URL>>(){

                @Override
                public Collection<URL> run() throws Exception {
                    ArrayList<URL> files = new ArrayList<URL>(500);
                    String[] paths = AbstractFileSetTable.this.nameStore.getFilePaths();
                    for (int i = 0; i < paths.length; ++i) {
                        if (AbstractFileSetTable.this.nameStore.getFileChangeType(i) == FileChange.Type.REMOVED) continue;
                        files.add(AbstractFileSetTable.this.getURL(paths[i]));
                    }
                    return files;
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Collection<String> getDirectoryPaths() throws IOException, InterruptedException {
        try {
            return this.run(new NameOperation<Collection<String>>(){

                @Override
                public Collection<String> run() throws Exception {
                    String[] paths = AbstractFileSetTable.this.nameStore.getDirectoryPaths();
                    ArrayList<String> directories = new ArrayList<String>(paths.length);
                    for (int i = 0; i < paths.length; ++i) {
                        if (AbstractFileSetTable.this.nameStore.isDirectoryRemoved(i + 1)) continue;
                        directories.add(paths[i]);
                    }
                    return directories;
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Collection<URL> getDirectories() throws IOException, InterruptedException {
        try {
            return this.run(new NameOperation<Collection<URL>>(){

                @Override
                public Collection<URL> run() throws Exception {
                    ArrayList<URL> directories = new ArrayList<URL>(500);
                    String[] paths = AbstractFileSetTable.this.nameStore.getDirectoryPaths();
                    for (int i = 0; i < paths.length; ++i) {
                        if (AbstractFileSetTable.this.nameStore.isDirectoryRemoved(i + 1)) continue;
                        directories.add(AbstractFileSetTable.this.getURL(paths[i]));
                    }
                    return directories;
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Collection<String> getSubdirectories(final String relativePath) throws IOException, InterruptedException {
        try {
            return this.run(new NameOperation<Collection<String>>(){

                @Override
                public Collection<String> run() throws Exception {
                    int id = AbstractFileSetTable.this.nameStore.getDirectoryId(relativePath);
                    if (id == -1) {
                        return Collections.emptySet();
                    }
                    return AbstractFileSetTable.this.nameStore.getSubdirectories(id);
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Collection<String> getFiles(final String relativePath) throws IOException, InterruptedException {
        try {
            return this.run(new NameOperation<Collection<String>>(){

                @Override
                public Collection<String> run() throws Exception {
                    return AbstractFileSetTable.this.getFilesImpl(null, relativePath, new FileConverter<String>(){

                        @Override
                        public String convert(Session session, int id, String parentPath, String fileName) throws InvalidFileTableException {
                            return fileName;
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Collection<URL> getFileUrls(final String relativePath) throws IOException, InterruptedException {
        try {
            return this.run(new NameOperation<Collection<URL>>(){

                @Override
                public Collection<URL> run() throws Exception {
                    return AbstractFileSetTable.this.getFilesImpl(null, relativePath, new FileConverter<URL>(){

                        @Override
                        public URL convert(Session session, int id, String parentPath, String fileName) throws InvalidFileTableException {
                            return AbstractFileSetTable.this.getURL(parentPath + fileName);
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Collection<Pair<URL, Long>> getFileUrlsAndTimestamps(final String relativePath) throws IOException, InterruptedException {
        try {
            return this.run(new Operation<Collection<Pair<URL, Long>>>(){

                @Override
                public Collection<Pair<URL, Long>> run(Session session) throws Exception {
                    return AbstractFileSetTable.this.getFilesImpl(session, relativePath, new FileConverter<Pair<URL, Long>>(){

                        @Override
                        public Pair<URL, Long> convert(Session session, int id, String parentPath, String fileName) throws InvalidFileTableException {
                            return new Pair((Object)AbstractFileSetTable.this.getURL(parentPath + fileName), (Object)session.dataStore.getLastModified(id));
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private <T> Collection<T> getFilesImpl(final Session session, String relativePath, final FileConverter<T> converter) throws InvalidFileTableException {
        int id = this.nameStore.getDirectoryId(relativePath);
        if (id == -1) {
            return Collections.emptySet();
        }
        final ArrayList result = new ArrayList(50);
        class GetFilesVisitor
        implements FileTableVisitor {
            private InvalidFileTableException e;

            GetFilesVisitor() {
            }

            public void throwIfInvalid() throws InvalidFileTableException {
                if (this.e != null) {
                    throw this.e;
                }
            }

            @Override
            public FileTableVisitor.Result visitFile(int id, String parentPath, String fileName, FileChange.Type type) {
                try {
                    if (type != FileChange.Type.REMOVED) {
                        result.add(converter.convert(session, id, parentPath, fileName));
                    }
                    return FileTableVisitor.Result.CONTINUE;
                }
                catch (InvalidFileTableException e) {
                    this.e = e;
                    return FileTableVisitor.Result.STOP;
                }
            }
        }
        GetFilesVisitor visitor = new GetFilesVisitor();
        this.nameStore.visitFiles(id, visitor);
        visitor.throwIfInvalid();
        return result;
    }

    @Override
    public void visitFiles(final FileTableVisitor visitor) throws IOException, InterruptedException {
        try {
            this.run(new NameOperation<Void>(){

                @Override
                public Void run() throws Exception {
                    AbstractFileSetTable.this.nameStore.visitFiles(visitor);
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void getChangesSince(int version, long cookie, FileChangeListener listener) throws IOException, FileChangesExpiredException, InterruptedException {
        if (version < 0 && version != -1) {
            throw new IllegalArgumentException("invalid file table version " + version);
        }
        if (listener == null) {
            throw new NullArgumentException("null listener");
        }
        this.getChangesSinceImpl(version, cookie, listener);
    }

    private void getChangesSinceImpl(final int version, final long cookie, final FileChangeListener listener) throws IOException, FileChangesExpiredException, InterruptedException {
        try {
            this.run(new Operation<Void>(){

                @Override
                public Void run(Session session) throws Exception {
                    int currentVersion;
                    if (version != 0 && cookie != -1L && cookie != session.info.cookie) {
                        throw new FileChangesExpiredException("Cookie mismatch: expected=" + cookie + ", actual=" + session.info.cookie);
                    }
                    if (version != 0 && version != -1 && version <= session.info.lastInvalidVersion) {
                        throw new FileChangesExpiredException(version, session.info.lastInvalidVersion);
                    }
                    int n = currentVersion = session.hasChanges ? session.version + 1 : session.version;
                    if (version > currentVersion) {
                        throw new FileChangesExpiredException("Version " + version + " is greater than file table version " + currentVersion + " for " + AbstractFileSetTable.this);
                    }
                    if (version != currentVersion) {
                        FileChanges delta = new FileChanges(currentVersion, session.info.cookie);
                        for (int i = 0; i < AbstractFileSetTable.this.nameStore.getSize(); ++i) {
                            AbstractFileSetTable.checkInterrupt();
                            if (session.dataStore.getVersion(i) <= version) continue;
                            FileChange change = AbstractFileSetTable.this.getFileChange(session, i);
                            if (version == 0) {
                                if (change.getChangeType() == FileChange.Type.REMOVED) continue;
                                delta.addImpl(new FileTable.FileChangeImpl(AbstractFileSetTable.this, change, FileChange.Type.ADDED));
                                continue;
                            }
                            if (version == -1) {
                                if (change.getChangeType() != FileChange.Type.REMOVED) {
                                    delta.addImpl(new FileTable.FileChangeImpl(AbstractFileSetTable.this, change, FileChange.Type.REMOVED));
                                    continue;
                                }
                                delta.addImpl(change);
                                continue;
                            }
                            delta.addImpl(change);
                        }
                        if (delta.size() > 0) {
                            AbstractFileSetTable.this.invokeListener(listener, delta);
                        }
                    }
                    return null;
                }
            });
        }
        catch (FileChangesExpiredException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        this.lock.lock();
        try {
            this.storage.open();
            try {
                String baseKey = this.getBaseNameSpaceKey();
                String nameKey = this.getNameNameSpaceKey(baseKey);
                String dataKey = this.getDataNameSpaceKey(baseKey);
                this.storage.deleteNameSpace(nameKey);
                this.storage.deleteNameSpace(dataKey);
                this.nameStore = null;
            }
            finally {
                this.storage.close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public URL locate(final String relativePath) throws IOException, InterruptedException {
        if (relativePath == null) {
            throw new NullArgumentException("null relative path");
        }
        if (!FORCE_CACHED_LOCATE) {
            boolean nameStoreBuilt = false;
            if (this.lock.tryLock()) {
                try {
                    nameStoreBuilt = this.nameStore != null;
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (!nameStoreBuilt) {
                URL url;
                if (this.fileSet.getFilter().acceptFile(relativePath) && URLFileSystem.exists((URL)(url = this.getURL(relativePath)))) {
                    return url;
                }
                return null;
            }
        }
        try {
            return this.run(new NameOperation<URL>(){

                @Override
                public URL run() throws Exception {
                    int id = AbstractFileSetTable.this.nameStore.getFileId(relativePath);
                    if (id != -1 && AbstractFileSetTable.this.nameStore.getFileChangeType(id) != FileChange.Type.REMOVED) {
                        return AbstractFileSetTable.this.getURL(relativePath);
                    }
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int getId(final URL url) throws IOException, InterruptedException {
        if (url == null) {
            throw new NullArgumentException("null url");
        }
        try {
            return this.run(new NameOperation<Integer>(){

                @Override
                public Integer run() throws Exception {
                    String relativePath = AbstractFileSetTable.this.getRelativePath(url);
                    return relativePath == null ? -1 : AbstractFileSetTable.this.nameStore.getFileId(relativePath);
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public URL getURL(final int id) throws IOException, InterruptedException {
        try {
            return this.run(new NameOperation<URL>(){

                @Override
                public URL run() throws Exception {
                    try {
                        return AbstractFileSetTable.this.getFileURL(id);
                    }
                    catch (InvalidFileTableException e) {
                        return null;
                    }
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public long getLength(final int id) throws IOException, InterruptedException {
        try {
            return this.run(new Operation<Long>(){

                @Override
                public Long run(Session session) throws Exception {
                    try {
                        return session.dataStore.getLength(id);
                    }
                    catch (InvalidFileTableException e) {
                        return -1L;
                    }
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public long getLastModified(final int id) throws IOException, InterruptedException {
        try {
            return this.run(new Operation<Long>(){

                @Override
                public Long run(Session session) throws Exception {
                    try {
                        return session.dataStore.getLastModified(id);
                    }
                    catch (InvalidFileTableException e) {
                        return -1L;
                    }
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void refresh(@Nullable FileChangeListener listener) throws InterruptedException, IOException {
        try {
            this.run(new FullRefreshOperation(listener), false, listener != null);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unexpected exception in file table " + this, e);
        }
    }

    @Override
    public void adjustTimestamps() throws InterruptedException, IOException {
        try {
            this.run(new Operation<Void>(){

                @Override
                public Void run(Session session) throws Exception {
                    String[] paths = AbstractFileSetTable.this.nameStore.getFilePaths();
                    for (int i = 0; i < paths.length; ++i) {
                        long storedValue;
                        URL url;
                        long lastModified;
                        if (AbstractFileSetTable.this.nameStore.getFileChangeType(i) == FileChange.Type.REMOVED || (lastModified = URLFileSystem.lastModified((URL)(url = AbstractFileSetTable.this.getURL(paths[i])))) == (storedValue = session.dataStore.getLastModified(i))) continue;
                        long length = session.dataStore.getLength(i);
                        session.dataStore.setLastModified(i, session.version, lastModified, length, false);
                        session.hasChanges = true;
                    }
                    return null;
                }
            }, true, false);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unexpected exception in file table " + this, e);
        }
    }

    protected String getNameNameSpaceKey(String baseKey) {
        return baseKey + "name";
    }

    protected String getDataNameSpaceKey(String baseKey) {
        return baseKey + "data";
    }

    protected abstract URL getFileURL(int var1) throws InvalidFileTableException;

    protected abstract URL getURL(String var1) throws InvalidFileTableException;

    protected int getOrCreateDirectoryId(Session session, int parentId, String name) throws InvalidFileTableException {
        int dirId = this.nameStore.getDirectoryId(parentId, name);
        if (dirId == -1) {
            dirId = this.nameStore.addDirectory(parentId, name);
            session.hasChanges = true;
        }
        return dirId;
    }

    private FileChange getFileChange(Session session, int id) throws InvalidFileTableException {
        URL url = this.getFileURL(id);
        long lastModified = session.dataStore.getLastModified(id);
        FileChange.Type type = this.nameStore.getFileChangeType(id);
        return new FileTable.FileChangeImpl(this, id, url, null, lastModified, type);
    }

    protected Session startSession() throws IOException, InterruptedException {
        this.storage.open();
        return new Session();
    }

    protected void endSession(Session session) {
        session.close();
        this.storage.close();
    }

    protected void recover(Session session) throws IOException, InterruptedException {
        session.close();
        String baseKey = this.getBaseNameSpaceKey();
        String nameKey = this.getNameNameSpaceKey(baseKey);
        String dataKey = this.getDataNameSpaceKey(baseKey);
        this.storage.deleteNameSpace(nameKey);
        this.storage.deleteNameSpace(dataKey);
        this.nameStore = null;
        session.info = null;
        session.open(session.delta != null);
        session.info.dirty = true;
        session.info.lastInvalidVersion = session.version;
        session.hasChanges = true;
        session.wasRefreshed = false;
    }

    protected abstract boolean hasPendingValidation();

    protected <T> T run(final NameOperation<T> operation) throws Exception {
        this.lock.lockInterruptibly();
        try {
            IdeEventListener.processBufferEvents(this);
            if (!IS_KAVA_TEST && this.nameStore != null && !this.hasPendingValidation()) {
                T t = operation.run();
                return t;
            }
        }
        catch (InvalidFileTableException invalidFileTableException) {
        }
        finally {
            this.lock.unlock();
        }
        return this.run(new Operation<T>(){

            @Override
            public T run(Session session) throws Exception {
                return operation.run();
            }
        });
    }

    protected <T> T run(Operation<T> operation) throws Exception {
        return this.run(operation, false, false);
    }

    protected <T> T run(Operation<T> operation, boolean runOnlyIfBuilt, boolean isDeltaRequired) throws Exception {
        return this.run(operation, runOnlyIfBuilt, isDeltaRequired, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T run(Operation<T> operation, boolean runOnlyIfBuilt, boolean isDeltaRequired, boolean doNotRefresh) throws Exception {
        FileChanges delta = null;
        this.lock.lockInterruptibly();
        try {
            T t;
            Session session = this.startSession();
            try {
                t = this.run(session, operation, runOnlyIfBuilt, isDeltaRequired, doNotRefresh);
                this.endSession(session);
                delta = session.delta;
            }
            catch (Throwable throwable) {
                this.endSession(session);
                delta = session.delta;
                throw throwable;
            }
            return t;
        }
        finally {
            this.lock.unlock();
            if (delta != null && delta.size() > 0) {
                this.logChanges(delta);
                this.invokeListenersLater(delta);
            }
        }
    }

    private void logChanges(FileChanges changes) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder builder = new StringBuilder();
            builder.append("Changes found in ");
            builder.append(this);
            builder.append(System.getProperty("line.separator"));
            builder.append(changes.getDiffString());
            LOGGER.finest(builder.toString());
        }
    }

    private void invokeListenersLater(final FileChanges changes) {
        if (!shutdown) {
            final ArrayList copy = new ArrayList(this.listeners);
            try {
                SCHEDULER.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (FileChangeListener listener : copy) {
                            AbstractFileSetTable.this.invokeListener(listener, changes);
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private <T> T run(Session session, Operation<T> operation, boolean runOnlyIfBuilt, boolean isDeltaRequired, boolean doNotRefresh) throws Exception {
        try {
            return this.runImpl(session, operation, runOnlyIfBuilt, isDeltaRequired, doNotRefresh);
        }
        catch (InvalidFileTableException e) {
            this.recover(session);
            try {
                return this.runImpl(session, operation, runOnlyIfBuilt, isDeltaRequired, doNotRefresh);
            }
            catch (InvalidFileTableException ee) {
                throw new IOException(ee);
            }
        }
    }

    private <T> T runImpl(Session session, Operation<T> operation, boolean runOnlyIfBuilt, boolean isDeltaRequired, boolean doNotRefresh) throws Exception {
        session.open(isDeltaRequired || this.isDeltaRequired());
        if (runOnlyIfBuilt && !this.isBuilt(session) && this.listeners.isEmpty()) {
            return null;
        }
        if (!(operation instanceof RefreshOperation)) {
            IdeEventListener.processBufferEvents(this);
        }
        if (!doNotRefresh) {
            this.refresh(session, operation);
        }
        boolean tableInvalid = false;
        try {
            T t = operation.run(session);
            return t;
        }
        catch (InvalidFileTableException e) {
            tableInvalid = true;
            throw e;
        }
        finally {
            if (!tableInvalid && session.hasChanges) {
                session.save();
            }
        }
    }

    private boolean isDeltaRequired() {
        return LOGGER.isLoggable(Level.FINEST) || !this.listeners.isEmpty();
    }

    private boolean isBuilt(Session session) {
        return session.version != 0 && !session.info.dirty;
    }

    protected abstract void refresh(Session var1, Operation var2) throws InvalidFileTableException, InterruptedException, IOException;

    private Header getHeader(NameSpace namespace) throws InvalidFileTableException {
        try {
            byte[] data = namespace.getRecord(HEADER_KEY);
            if (data != null) {
                return (Header)HEADER_FACTORY.assemble(data);
            }
            return new Header();
        }
        catch (AssemblyException e) {
            throw new InvalidFileTableException("Unable to read file table header record for " + this, (Throwable)e);
        }
    }

    private void saveHeader(NameSpace namespace, Header header) throws InvalidFileTableException {
        try {
            namespace.putRecord(HEADER_KEY, HEADER_FACTORY.disassemble((Object)header));
        }
        catch (AssemblyException e) {
            throw new InvalidFileTableException("Unable to save file table header record for " + this, (Throwable)e);
        }
    }

    private Info getInfo(NameSpace namespace) throws InvalidFileTableException {
        try {
            byte[] data = namespace.getRecord(INFO_KEY);
            if (data != null) {
                return (Info)INFO_FACTORY.assemble(data);
            }
            return new Info();
        }
        catch (AssemblyException e) {
            throw new InvalidFileTableException("Unable to read file table info record for " + this, (Throwable)e);
        }
    }

    private void saveInfo(NameSpace namespace, Info info) throws InvalidFileTableException {
        try {
            namespace.putRecord(INFO_KEY, INFO_FACTORY.disassemble((Object)info));
        }
        catch (AssemblyException e) {
            throw new InvalidFileTableException("Unable to save file table info record for " + this, (Throwable)e);
        }
    }

    protected boolean isFullRefreshRequired(Session session, Operation operation) {
        if (session.version == 0) {
            return true;
        }
        if (session.info.dirty) {
            return true;
        }
        if (operation instanceof FullRefreshOperation) {
            return true;
        }
        if (AbstractFileSetTable.getRefreshOnStartup() && session.info.ideSessionKey != IDE_SESSION_KEY) {
            return true;
        }
        return IS_KAVA_TEST;
    }

    protected final long getNodeLastModified(URL file) {
        long timestamp;
        Node node = NodeFactory.find((URL)file);
        if (node != null && (timestamp = node.getTimestampLoadedUnsafe()) > 0L) {
            return timestamp;
        }
        return -1L;
    }

    protected static void checkInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private static long generateCookie() {
        return System.nanoTime();
    }

    protected static interface NameOperation<V> {
        public V run() throws Exception;
    }

    protected static interface Operation<V> {
        public V run(Session var1) throws Exception;
    }

    private static interface FileConverter<V> {
        public V convert(Session var1, int var2, String var3, String var4) throws InvalidFileTableException;
    }

    protected class Session {
        protected NameSpace nameNameSpace;
        protected NameSpace dataNameSpace;
        protected Info info;
        protected DataStore dataStore;
        protected int version;
        protected FileChanges delta;
        protected boolean hasChanges;
        protected boolean wasRefreshed;
        protected final FileSetFilter filter;

        protected Session() {
            this.filter = AbstractFileSetTable.this.getFilter();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open(boolean isDeltaRequired) throws IOException {
            String baseKey = AbstractFileSetTable.this.getBaseNameSpaceKey();
            String nameKey = AbstractFileSetTable.this.getNameNameSpaceKey(baseKey);
            String dataKey = AbstractFileSetTable.this.getDataNameSpaceKey(baseKey);
            this.nameNameSpace = AbstractFileSetTable.this.storage.getNameSpace(nameKey);
            if (this.nameNameSpace == null) {
                throw new IOException("null namespace for " + nameKey);
            }
            this.dataNameSpace = AbstractFileSetTable.this.storage.getNameSpace(dataKey);
            if (this.dataNameSpace == null) {
                this.nameNameSpace.close();
                throw new IOException("null namespace for " + dataKey);
            }
            Header header = null;
            try {
                header = AbstractFileSetTable.this.getHeader(this.dataNameSpace);
                if (header.format != 5) {
                    throw new InvalidFileTableException(String.format("File table format mistmatch for %s.  Expected format version %d, actual format version %d.", AbstractFileSetTable.this.toString(), 5, header.format));
                }
                this.version = header.version;
                this.info = AbstractFileSetTable.this.getInfo(this.dataNameSpace);
                if (AbstractFileSetTable.this.nameStore != null && AbstractFileSetTable.this.nameStore.hasChangedOnDisk(this.nameNameSpace)) {
                    AbstractFileSetTable.this.nameStore = null;
                }
                if (AbstractFileSetTable.this.nameStore == null) {
                    AbstractFileSetTable.this.nameStore = NameStore.getInstance(AbstractFileSetTable.this, this.nameNameSpace);
                }
                this.dataStore = DataStore.getInstance(this.dataNameSpace, AbstractFileSetTable.this.nameStore.getSize());
                if (isDeltaRequired) {
                    this.delta = new FileChanges(this.version + 1, this.info.cookie);
                }
            }
            finally {
                if (header == null || this.info == null || AbstractFileSetTable.this.nameStore == null) {
                    this.dataNameSpace.close();
                    this.dataNameSpace = null;
                    this.nameNameSpace.close();
                    this.nameNameSpace = null;
                }
            }
        }

        void save() throws InvalidFileTableException {
            if (this.dataStore != null) {
                this.dataStore.save();
            }
            if (AbstractFileSetTable.this.nameStore != null) {
                AbstractFileSetTable.this.nameStore.save(this.nameNameSpace);
            }
            if (this.dataNameSpace != null) {
                AbstractFileSetTable.this.saveHeader(this.dataNameSpace, new Header(5, this.version + 1));
                this.info.dirty = false;
                AbstractFileSetTable.this.saveInfo(this.dataNameSpace, this.info);
            }
        }

        void saveInfo() throws InvalidFileTableException {
            AbstractFileSetTable.this.saveInfo(this.dataNameSpace, this.info);
        }

        void close() {
            if (AbstractFileSetTable.this.nameStore != null) {
                AbstractFileSetTable.this.nameStore.clearReverseMap();
            }
            if (this.nameNameSpace != null) {
                this.nameNameSpace.close();
                this.nameNameSpace = null;
            }
            if (this.dataNameSpace != null) {
                this.dataNameSpace.close();
                this.dataNameSpace = null;
            }
        }
    }

    protected final class FullRefreshOperation
    implements RefreshOperation {
        private final FileChangeListener listener;

        public FullRefreshOperation(FileChangeListener listener) {
            this.listener = listener;
        }

        @Override
        public Void run(Session session) throws Exception {
            if (this.listener != null && session.delta != null && session.delta.size() > 0) {
                AbstractFileSetTable.this.invokeListener(this.listener, session.delta);
            }
            return null;
        }
    }

    protected static final class Info {
        protected boolean dirty;
        protected boolean hasNodeTimestamps;
        protected long jarTimeStamp;
        protected long ideSessionKey;
        protected long cookie;
        protected int lastInvalidVersion;

        Info() {
            this(false, -1, -1L, IDE_SESSION_KEY, AbstractFileSetTable.generateCookie(), false);
        }

        Info(boolean dirty, int lastInvalidVersion, long jarTimeStamp, long ideSessionKey, long cookie, boolean hasNodeTimestamps) {
            this.dirty = dirty;
            this.lastInvalidVersion = lastInvalidVersion;
            this.jarTimeStamp = jarTimeStamp;
            this.ideSessionKey = ideSessionKey;
            this.cookie = cookie;
            this.hasNodeTimestamps = hasNodeTimestamps;
        }
    }

    protected static interface RefreshOperation
    extends Operation<Void> {
    }

    protected static final class Header {
        private int format;
        private int version;

        Header() {
            this(5, 0);
        }

        Header(int format, int version) {
            this.format = format;
            this.version = version;
        }
    }

    private static final class HeaderAssemblyFactory
    extends ObjectFactory {
        private HeaderAssemblyFactory() {
        }

        public byte getObjectCode() {
            return -69;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            int format = input.readInt();
            int version = input.readInt();
            return new Header(format, version);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            Header header = (Header)object;
            output.writeInt(header.format);
            output.writeInt(header.version);
        }
    }

    private static final class InfoAssemblyFactory
    extends ObjectFactory {
        private InfoAssemblyFactory() {
        }

        public byte getObjectCode() {
            return -73;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            boolean dirty = input.readBoolean();
            int lastInvalidVersion = input.readInt();
            long jarTimeStamp = input.readLong();
            long ideSessionKey = input.readLong();
            long cookie = input.readLong();
            boolean hasNodeTimestamps = input.readBoolean();
            return new Info(dirty, lastInvalidVersion, jarTimeStamp, ideSessionKey, cookie, hasNodeTimestamps);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            Info info = (Info)object;
            output.writeBoolean(info.dirty);
            output.writeInt(info.lastInvalidVersion);
            output.writeLong(info.jarTimeStamp);
            output.writeLong(info.ideSessionKey);
            output.writeLong(info.cookie);
            output.writeBoolean(info.hasNodeTimestamps);
        }
    }
}

