/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.init;

import java.util.HashMap;
import oracle.dbtools.extension.project.commands.init.InitMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;

public class ProjectName
implements VerifyServiceInterface {
    @Override
    public String getName() {
        return "VerifyProjectName";
    }

    @Override
    public String getGroup() {
        return "Init";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        try {
            boolean replaceWhitespace;
            boolean singleSpaces;
            String name;
            if (params != null && params.size() == 3) {
                name = params.get("projectName").toString();
                singleSpaces = (Boolean)params.get("singleSpaces");
                replaceWhitespace = (Boolean)params.get("replaceWhitespace");
            } else {
                name = ProjectSettings.getSettingAsString("project");
                singleSpaces = true;
                replaceWhitespace = true;
            }
            if (name == null || name.isEmpty()) {
                this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "Name can not be null, unable to determine name.");
                return false;
            }
            String safe = name.trim();
            safe = safe.replaceAll("[\\/|\\\\|\\*|\\:|\\||\"|'|\\<|\\>|\\{|\\}|\\?|\\%|@]", "");
            if (singleSpaces) {
                safe = safe.replaceAll(" {2,}", " ");
            }
            if (replaceWhitespace) {
                safe = safe.replaceAll("\\s+", "_");
            }
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, InitMessages.format("PROJECT_NAME_RESULT", safe));
            return true;
        }
        catch (Exception e) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "EXCEPTION", "exception", e);
            return false;
        }
    }
}

