/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.generators;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.apex.help.ApexMessages;
import oracle.dbtools.extension.project.commands.stage.utils.StageUtils;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import org.apache.commons.io.FileUtils;

public class ApexInstallScriptGenerator {
    public static String genApexController(String appId, String fileName, Connection conn) throws SQLException, IOException, NoSuchAlgorithmException {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String wsId = dbUtil.executeReturnOneCol("select workspace from apex_applications where application_id = " + appId);
        String user = conn.getSchema();
        StringBuilder sb = new StringBuilder();
        sb.append(ApexInstallScriptGenerator.genControllerHeader());
        sb.append(ApexInstallScriptGenerator.genControllerSetup(wsId, appId, user, fileName, null, null, null, null));
        sb.append(ApexInstallScriptGenerator.genControllerFooter());
        return sb.toString();
    }

    private static String genControllerHeader() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<databaseChangeLog\n        xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\"\n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xmlns:n0=\"http://www.oracle.com/xml/ns/dbchangelog-ext\"\n        xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog\n        http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-4.3.xsd\">\n";
    }

    protected static String genControllerSetup(String workspace, String appId, String user, String filename, String schema, String alias, String override_workspace, String override_appid) throws IOException, NoSuchAlgorithmException {
        StringBuilder setup = new StringBuilder();
        String label = null;
        String context = null;
        boolean fail = true;
        boolean runalways = true;
        setup.append("<changeSet id=\"INSTALL_").append(appId).append("\" author=\"SQLCL").append(user).append("\"  %FAILONERROR% %CONTEXTS% %LABELS% %RUNALWAYS% >\n");
        setup.append("    <n0:runApexScript objectName=\"install\" objectType=\"SCRIPT\" ownerName=\"ADMIN").append(user).append("\" sourceType=\"STRING\"  relativeToChangelogFile=\"true\" >\n");
        setup.append("        <n0:source><![CDATA[\n");
        setup.append(" declare \n");
        setup.append(" -- sqlcl version      = ").append(ApexMessages.getString((String)"SQLclVersion.VERSION")).append(" \n").append(" -- override_schema    = ${apex.").append(appId).append(".schema}\n").append(" -- override_alias     = ${apex.").append(appId).append(".alias}\n").append(" -- override_workspace = ${apex.").append(appId).append(".workspace}\n").append(" -- override_app_id    = ${apex.").append(appId).append(".appId}\n\n").append(" l_app_id varchar2(255) := q'[").append(appId).append("]';  \n");
        setup.append(" l_workspace varchar2(255) := q'[").append(workspace).append("]'; \n\n");
        setup.append(" l_override_workspace varchar2(255) := q'[${apex.").append(appId).append(".workspace}]'; \n");
        setup.append(" l_override_schema varchar2(255) := q'[${apex.").append(appId).append(".schema}]'; \n");
        setup.append(" l_override_alias varchar2(255) := q'[${apex.").append(appId).append(".alias}]'; \n");
        setup.append(" l_override_app_id varchar2(255) := q'[${apex.").append(appId).append(".appId}]'; \n");
        setup.append(" l_generate_offset boolean := false;\n");
        setup.append("\n function get_prop_default(p_prop_name varchar2)\n");
        setup.append(" return varchar2 is\n");
        setup.append(" begin  \n");
        setup.append("   return '${apex.").append(appId).append(".' || p_prop_name || '}';\n");
        setup.append(" end;  \n\n");
        setup.append(" begin  \n");
        setup.append("  apex_application_install.clear_all(); \n\n");
        setup.append("  -- set workspace \n ");
        setup.append("    if (l_override_workspace != l_workspace and l_override_workspace != get_prop_default('workspace')) then\n      apex_application_install.set_workspace(l_override_workspace);\n");
        setup.append("  else \n");
        setup.append("      apex_application_install.set_workspace(l_workspace);         \n");
        setup.append("  end if; \n");
        setup.append("  commit;  \n\n");
        setup.append("  -- set app id \n");
        setup.append("  if (l_override_app_id != l_app_id and l_override_app_id != get_prop_default('appId')) then\n     apex_application_install.set_application_id(l_override_app_id);");
        setup.append("\n    l_generate_offset := true;\n");
        setup.append("  else  \n");
        setup.append("      apex_application_install.set_application_id(l_app_id);\n");
        setup.append("  end if; \n\n");
        setup.append(" if (l_override_schema != get_prop_default('schema')) then\n    apex_application_install.set_schema(l_override_schema);\n  end if;\n\n");
        setup.append("  -- set alias \n");
        setup.append("  if (l_override_alias != get_prop_default('alias')) then\n    apex_application_install.set_application_alias(l_override_alias);\n   l_generate_offset := true;\n end if;\n");
        setup.append("\n  -- generate offset if necessary\n");
        setup.append(" if (l_generate_offset)  then\n    apex_application_install.generate_offset();\n end if;\n");
        setup.append("end;  \n");
        setup.append("/\n");
        String cleanFileName = filename;
        if (filename.contains(ProjectConfig.getCWD())) {
            cleanFileName = filename.replace(ProjectConfig.getCWD(), "");
        }
        String data = FileUtils.readFileToString((File)Paths.get(ProjectConfig.getCWD(), "dist/releases/apex/f" + appId + "/", cleanFileName).toFile(), (Charset)StandardCharsets.UTF_8);
        setup.append("-- sqlcl_checksum  ").append(StageUtils.getSha1fromString(data));
        setup.append("\n@").append(cleanFileName).append("\n");
        setup.append("        ]]></n0:source>\n");
        setup.append("    </n0:runApexScript>\n");
        setup.append("</changeSet>\n");
        String change = setup.toString();
        change = fail ? LiquibaseStringUtils.replaceVal((String)"%FAILONERROR%", (String)"failOnError=\"true\"", (String)change) : LiquibaseStringUtils.replaceVal((String)"%FAILONERROR%", null, (String)change);
        change = null != context && !context.isEmpty() ? LiquibaseStringUtils.replaceVal((String)"%CONTEXTS%", (String)("context=\"" + context + "\""), (String)change) : LiquibaseStringUtils.replaceVal((String)"%CONTEXTS%", null, (String)change);
        change = null != label && !label.isEmpty() ? LiquibaseStringUtils.replaceVal((String)"%LABELS%", (String)("labels=\"" + label + "\""), (String)change) : LiquibaseStringUtils.replaceVal((String)"%LABELS%", null, (String)change);
        change = runalways ? LiquibaseStringUtils.replaceVal((String)"%RUNALWAYS%", (String)"runOnChange=\"true\"", (String)change) : LiquibaseStringUtils.replaceVal((String)"%RUNALWAYS%", null, (String)change);
        return change;
    }

    private static String genControllerFooter() {
        return "</databaseChangeLog> \n";
    }

    private static String pad(String word, int newLength) {
        StringBuilder wordBuilder = new StringBuilder(word);
        while (wordBuilder.length() < newLength) {
            wordBuilder.append(" ");
        }
        return wordBuilder.toString();
    }

    public static enum Position {
        TOP,
        BOTTOM,
        SINGLE;

    }
}

