/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.KeyValuePair;
import oracle.olapi.metadata.MetadataMapModificationStep;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataObjectHolder;
import oracle.olapi.metadata.MetadataProperty;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.XMLTag;

final class MetadataMapProperty
extends MetadataProperty {
    private List m_Pairs = new ArrayList();
    private List m_Modifications = null;

    MetadataMapProperty(XMLTag xMLTag) {
        super(xMLTag);
    }

    private MetadataMapProperty(MetadataMapProperty metadataMapProperty, boolean bl) {
        super(metadataMapProperty);
        for (KeyValuePair keyValuePair : metadataMapProperty.getPairs()) {
            this.getPairs().add(keyValuePair.clone());
        }
        if (bl && metadataMapProperty.hasModifications()) {
            this.getModifications().addAll(metadataMapProperty.getModifications());
        }
    }

    KeyValuePair findPair(String string) {
        for (KeyValuePair keyValuePair : this.getPairs()) {
            if (!keyValuePair.getKeyHolder().getObjectID().equals(string)) continue;
            return keyValuePair;
        }
        return null;
    }

    private List getModifications() {
        if (null == this.m_Modifications) {
            this.m_Modifications = new ArrayList();
        }
        return this.m_Modifications;
    }

    private boolean hasModifications() {
        return null != this.m_Modifications;
    }

    MetadataObject getMetadataObjectValue(MetadataObject metadataObject, BaseMetadataProvider baseMetadataProvider) {
        if (!this.isMetadataObjectMap()) {
            return null;
        }
        KeyValuePair keyValuePair = this.findPair(metadataObject.getID());
        if (null == keyValuePair) {
            return null;
        }
        return baseMetadataProvider.fetchMetadataObject(keyValuePair.getValueHolder());
    }

    String getStringValue(MetadataObject metadataObject, BaseMetadataProvider baseMetadataProvider) {
        if (!this.isStringObjectMap()) {
            return null;
        }
        KeyValuePair keyValuePair = this.findPair(metadataObject.getID());
        if (null == keyValuePair) {
            return null;
        }
        return (String)keyValuePair.getValue();
    }

    Object getObjectValue(MetadataObject metadataObject, BaseMetadataProvider baseMetadataProvider) {
        KeyValuePair keyValuePair = this.findPair(metadataObject.getID());
        if (null == keyValuePair) {
            return null;
        }
        if (this.isMetadataObjectMap()) {
            return baseMetadataProvider.fetchMetadataObject(keyValuePair.getValueHolder());
        }
        return keyValuePair.getValue();
    }

    void putObject(MetadataObjectHolder metadataObjectHolder, Object object, BaseMetadataObject baseMetadataObject) {
        MetadataMapModificationStep metadataMapModificationStep = new MetadataMapModificationStep(metadataObjectHolder, object);
        this.getModifications().add(metadataMapModificationStep);
        metadataMapModificationStep.applyModification(this);
    }

    @Override
    boolean addChildrenToXMLWriter(MetadataToXMLConverter metadataToXMLConverter, List list) {
        boolean bl = false;
        for (KeyValuePair keyValuePair : this.getPairs()) {
            bl = metadataToXMLConverter.addMetadataObject(keyValuePair.getKeyHolder(), list);
            if (!this.isMetadataObjectMap()) continue;
            bl = metadataToXMLConverter.addMetadataObject(keyValuePair.getValueHolder(), list) || bl;
        }
        return bl;
    }

    @Override
    void gatherMetadataObjects(List<MetadataObjectHolder> list) {
        for (KeyValuePair keyValuePair : this.getPairs()) {
            list.add(keyValuePair.getKeyHolder());
            if (!this.isMetadataObjectMap()) continue;
            list.add(keyValuePair.getValueHolder());
        }
    }

    @Override
    void gatherReferencedSources(List list) {
    }

    @Override
    void appendXMLString(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        for (KeyValuePair keyValuePair : this.getPairs()) {
            this.appendKeyValuePairXMLString(metadataToXMLConverter, baseMetadataObject, keyValuePair);
        }
    }

    private void appendKeyValuePairXMLString(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject, KeyValuePair keyValuePair) {
        metadataToXMLConverter.beginElement(this.getPropertyTag());
        metadataToXMLConverter.appendAttribute(BaseMetadataXMLTags.PAIR_KEY, keyValuePair.getKeyHolder());
        if (this.isMetadataObjectMap()) {
            metadataToXMLConverter.appendAttribute(BaseMetadataXMLTags.PAIR_VALUE, keyValuePair.getValueHolder());
        } else if (this.isStringObjectMap()) {
            metadataToXMLConverter.appendAttribute(BaseMetadataXMLTags.PAIR_VALUE, (String)keyValuePair.getValue(), baseMetadataObject);
        }
        metadataToXMLConverter.endElement();
    }

    @Override
    void appendIncrementalXMLString(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        if (!this.isModification(metadataToXMLConverter, baseMetadataObject)) {
            return;
        }
        Iterator iterator = this.getModifications().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            MetadataMapModificationStep metadataMapModificationStep = (MetadataMapModificationStep)iterator.next();
            KeyValuePair keyValuePair = metadataMapModificationStep.getKeyValuePair();
            metadataToXMLConverter.appendAttributeToNextElement(BaseMetadataXMLTags.ACTION, metadataMapModificationStep.getActionString());
            this.appendKeyValuePairXMLString(metadataToXMLConverter, baseMetadataObject, keyValuePair);
            ++n;
        }
    }

    List getPairs() {
        return this.m_Pairs;
    }

    @Override
    boolean isAttribute(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        return false;
    }

    @Override
    MetadataProperty cloneProperty(boolean bl) {
        return new MetadataMapProperty(this, bl);
    }

    private void setPairs(List list) {
        this.m_Pairs = list;
    }

    @Override
    void updateFromChild(MetadataProperty metadataProperty) {
        MetadataMapProperty metadataMapProperty = (MetadataMapProperty)metadataProperty;
        this.setPairs(metadataMapProperty.getPairs());
        if (metadataMapProperty.hasModifications()) {
            this.getModifications().addAll(metadataMapProperty.getModifications());
        }
    }

    @Override
    void updateFromParent(MetadataProperty metadataProperty) {
        MetadataMapProperty metadataMapProperty = (MetadataMapProperty)metadataProperty;
        this.getPairs().clear();
        this.getPairs().addAll(metadataMapProperty.getPairs());
        if (!this.hasModifications()) {
            return;
        }
        for (MetadataMapModificationStep metadataMapModificationStep : this.getModifications()) {
            metadataMapModificationStep.applyModification(this);
        }
    }

    @Override
    boolean isModification(MetadataToXMLConverter metadataToXMLConverter, BaseMetadataObject baseMetadataObject) {
        return this.hasModifications() && super.isModification(metadataToXMLConverter, baseMetadataObject);
    }

    boolean isMetadataObjectMap() {
        return this.getDataType() == 0;
    }

    boolean isStringObjectMap() {
        return this.getDataType() == 4;
    }

    private int getDataType() {
        return this.getPropertyTag().getDataType();
    }

    @Override
    final boolean isServerSendable(MetadataProperty metadataProperty) {
        boolean bl = true;
        if (!this.hasModifications()) {
            bl = false;
        }
        return bl;
    }

    @Override
    void getAssociatedObjects(List list) {
        for (MetadataObjectHolder metadataObjectHolder : this.getPairs()) {
            if (null == metadataObjectHolder) continue;
            list.add(metadataObjectHolder.getMetadataObject());
        }
    }

    @Override
    void updatePersistentState(short s) {
        for (MetadataObjectHolder metadataObjectHolder : this.getPairs()) {
            if (null == metadataObjectHolder || !(metadataObjectHolder.getMetadataObject() instanceof BaseMetadataObject)) continue;
            ((BaseMetadataObject)metadataObjectHolder.getMetadataObject()).updatePersistentState(s);
        }
    }

    @Override
    boolean isLocal() {
        return this.hasModifications();
    }
}

