/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.olapi.OLAPIRuntimeException;

public class BatchedException
extends OLAPIRuntimeException {
    private List<Exception> m_Errors = null;
    private List<Exception> m_Warnings = null;
    private boolean m_IsWarning = false;

    public BatchedException(String string) {
        super(string);
    }

    public BatchedException(String string, String[] stringArray) {
        super(string, stringArray);
    }

    public BatchedException(String string, String[] stringArray, boolean bl) {
        super(string, stringArray);
        this.setIsWarning(bl);
    }

    public final void addException(BatchedException batchedException) {
        this.addException(batchedException, batchedException.isWarning());
    }

    public final void addException(Exception exception, boolean bl) {
        List<Exception> list = null;
        if (bl) {
            if (null == this.m_Warnings) {
                this.m_Warnings = new ArrayList<Exception>();
            }
            list = this.m_Warnings;
        } else {
            if (null == this.m_Errors) {
                this.m_Errors = new ArrayList<Exception>();
            }
            list = this.m_Errors;
            this.setIsWarning(false);
        }
        list.add(exception);
    }

    protected void setIsWarning(boolean bl) {
        this.m_IsWarning = bl;
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        String string = super.getLocalizedMessage(locale);
        List<Exception> list = this.getExceptions();
        for (Exception exception : list) {
            string = string + "\n" + exception.getLocalizedMessage();
        }
        return string;
    }

    public final boolean isWarning() {
        return this.m_IsWarning;
    }

    public final boolean isError() {
        return !this.m_IsWarning;
    }

    public final List<Exception> getExceptions() {
        int n = 0;
        if (null != this.m_Errors) {
            n += this.m_Errors.size();
        }
        if (null != this.m_Warnings) {
            n += this.m_Warnings.size();
        }
        ArrayList<Exception> arrayList = new ArrayList<Exception>(n);
        if (null != this.m_Errors) {
            arrayList.addAll(this.m_Errors);
        }
        if (null != this.m_Warnings) {
            arrayList.addAll(this.m_Warnings);
        }
        return arrayList;
    }

    public final List<Exception> getErrors() {
        ArrayList<Exception> arrayList = new ArrayList<Exception>(this.m_Errors.size());
        if (null != this.m_Errors) {
            arrayList.addAll(this.m_Errors);
        }
        return arrayList;
    }

    public final List<Exception> getWarnings() {
        ArrayList<Exception> arrayList = new ArrayList<Exception>(this.m_Warnings.size());
        if (null != this.m_Warnings) {
            arrayList.addAll(this.m_Warnings);
        }
        return arrayList;
    }
}

