/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.shell;

import oracle.aurora.util.tools.Options;

public class ShellClientOptions
extends Options {
    private static final String[] oneList = new String[]{"-help", "-batch", "-echo", "-debug", "-verbose", null};
    private static final String[] twoList = new String[]{"-command", "-fileout", "-oschema", "-runjava", "-jdwp", null};
    private static final String[] substList = new String[]{"-h", "-help", "-c", "-command", "-f", "-fileout", null};
    private static final Object[] expandList = new Object[]{null};

    ShellClientOptions() {
        this(null);
    }

    ShellClientOptions(Options defaultOpt) {
        super(oneList, twoList, substList, expandList, defaultOpt);
    }

    protected int parseArg(String[] argv, int xArg) {
        String option = argv[xArg];
        int incr = 0;
        if (option.equals("-runjava")) {
            if (xArg + 1 < argv.length && argv[xArg + 1].equalsIgnoreCase("server_file_system")) {
                incr = 2;
                this.set("-runjava", "server_file_system");
            } else {
                incr = 1;
                this.set("-runjava", "on");
            }
        } else if (option.equals("-jdwp")) {
            int lim = argv.length - xArg;
            if (lim > 3) {
                lim = 3;
            }
            for (incr = 1; incr < lim && argv[xArg + incr].charAt(0) != '-'; ++incr) {
            }
            String[] jdwpArgs = new String[incr];
            System.arraycopy(argv, xArg, jdwpArgs, 0, incr);
            this.set("-jdwp", jdwpArgs);
        }
        return incr;
    }
}

