/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.UnsupervisedBuildNode;
import oracle.dmt.dataminer.workflow.preferences.FeatureExtractionModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public final class FeatureExtractionBuildNode
extends UnsupervisedBuildNode {
    public static final String FEAT_NUM_FEATURES = "FEAT_NUM_FEATURES";
    public static final String NMFS_CONV_TOLERANCE = "NMFS_CONV_TOLERANCE";
    public static final String NMFS_NUM_ITERATIONS = "NMFS_NUM_ITERATIONS";
    public static final String NMFS_RANDOM_SEED = "NMFS_RANDOM_SEED";
    public static final String NMFS_NONNEGATIVE_SCORING = "NMFS_NONNEGATIVE_SCORING";
    private static Preferences _p = Preferences.getPreferences();
    private FeatureExtractionModelBuildPreferencesPanelSettings featureBuildPref = FeatureExtractionModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)_p);

    public FeatureExtractionBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        FeatureExtractionBuildNodeType.Models models = new FeatureExtractionBuildNodeType.Models();
        featureExtractionBuildNodeType.setModels(models);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.featureBuildPref.isNMF()) {
            arrayList.add("ALGO_NONNEGATIVE_MATRIX_FACTOR");
        }
        if (DbVersionHelper.isDB121Up((Version)this.dbVersion)) {
            if (this.featureBuildPref.isSVD()) {
                arrayList.add("ALGO_SINGULAR_VALUE_DECOMP");
            }
            if (this.featureBuildPref.isPCA()) {
                arrayList.add("ALGO_PRINCIPAL_COMPONENT_ANALYSIS");
            }
        }
        List<String> list = WorkflowUtils.getNewModelNames(context, "FEATURE_EXTRACTION", arrayList);
        int n = 0;
        ModelType modelType = null;
        if (this.featureBuildPref.isNMF()) {
            modelType = this.createNewModel(list.get(n), "", (String)arrayList.get(n++));
            modelType.setUseForOutput(true);
            this.addNMFModel((NonNegativeMatrixFactorModelType)modelType);
        }
        if (DbVersionHelper.isDB121Up((Version)this.dbVersion)) {
            if (this.featureBuildPref.isSVD()) {
                modelType = this.createNewModel(list.get(n), "", (String)arrayList.get(n++));
                modelType.setUseForOutput(true);
                this.addSVDModel((SVDModelType)modelType);
            }
            if (this.featureBuildPref.isPCA()) {
                modelType = this.createNewModel(list.get(n), "", (String)arrayList.get(n++));
                modelType.setUseForOutput(true);
                this.addPCAModel((PCAModelType)modelType);
            }
        }
        featureExtractionBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    public ModelType createNewModel(String string, String string2, String string3) {
        ModelType modelType = super.createNewModel(string, string2, "FEATURE_EXTRACTION", string3);
        return modelType;
    }

    public void addNMFModel(NonNegativeMatrixFactorModelType nonNegativeMatrixFactorModelType) {
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        FeatureExtractionBuildNodeType.Models models = featureExtractionBuildNodeType.getModels();
        List list = models.getNonNegativeMatrixFactorModel();
        list.add(nonNegativeMatrixFactorModelType);
    }

    public void addSVDModel(SVDModelType sVDModelType) {
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        FeatureExtractionBuildNodeType.Models models = featureExtractionBuildNodeType.getModels();
        List list = models.getSVDModel();
        list.add(sVDModelType);
    }

    public void addPCAModel(PCAModelType pCAModelType) {
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        FeatureExtractionBuildNodeType.Models models = featureExtractionBuildNodeType.getModels();
        List list = models.getPCAModel();
        list.add(pCAModelType);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_FEAT_BUILD_NODE_NAME");
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        FeatureExtractionBuildNodeType.Models models = featureExtractionBuildNodeType.getModels();
        if (models.getNonNegativeMatrixFactorModel().isEmpty() && models.getSVDModel().isEmpty() && models.getPCAModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            if (bl2) {
                this.setNodeReady();
            }
            if (!this.validateModels(models.getNonNegativeMatrixFactorModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getSVDModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getPCAModel())) {
                bl3 = false;
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    public void setProperty(String string, Object object) {
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list2 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)featureExtractionBuildNodeType, modelType);
                if (list2.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)featureExtractionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list3 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)featureExtractionBuildNodeType, modelType);
                if (!list3.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)featureExtractionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelsRerun")) {
            if (!(object instanceof Map)) {
                return;
            }
            Map map = (Map)object;
            FeatureExtractionBuildNodeType featureExtractionBuildNodeType2 = (FeatureExtractionBuildNodeType)this.getData();
            for (Map.Entry entry : map.entrySet()) {
                String string2 = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)featureExtractionBuildNodeType2, string2);
                modelType.setStatus((ModelStatusType)entry.getValue());
            }
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            FeatureExtractionBuildNodeType featureExtractionBuildNodeType3 = (FeatureExtractionBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)featureExtractionBuildNodeType3, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals("modelsRerun")) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)featureExtractionBuildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelUseForOutput")) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)featureExtractionBuildNodeType, string);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public Object getProperty(String string) {
        return super.getProperty(string);
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.FEATURE_EXTRACTION;
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.FEATURE_EXTRACTION;
    }

    @Override
    public String getHelpTopic() {
        return "feature_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_FEATURE_EXTRACTION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_FEATURE_EXTRACTION_ICON"));
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        if (!super.isVersionSupported(context, stringBuffer)) {
            return false;
        }
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        if (!DbVersionHelper.isDB121Up((Version)version)) {
            if (!featureExtractionBuildNodeType.getModels().getPCAModel().isEmpty()) {
                stringBuffer.append(CodeGenLrb.get("VALIDATE_PCA_BUILD_SETTING_NOT_SUPPORTED"));
                return false;
            }
            if (!featureExtractionBuildNodeType.getModels().getSVDModel().isEmpty()) {
                stringBuffer.append(CodeGenLrb.get("VALIDATE_SVD_BUILD_SETTING_NOT_SUPPORTED"));
                return false;
            }
        }
        return true;
    }

    @Override
    protected String generateSpecificModelSettingsCode(ModelType modelType, Version version) {
        StringBuilder stringBuilder = new StringBuilder();
        if (modelType instanceof NonNegativeMatrixFactorModelType) {
            NonNegativeMatrixFactorModelType nonNegativeMatrixFactorModelType = (NonNegativeMatrixFactorModelType)modelType;
            if (nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo().getFEATNUMFEATURES() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.FEAT_NUM_FEATURES||''', ''" + nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo().getFEATNUMFEATURES() + "'')'); \n");
            }
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.NMFS_CONV_TOLERANCE||''', ''" + nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo().getNMFSCONVTOLERANCE() + "'')'); \n");
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.NMFS_NUM_ITERATIONS||''', ''" + nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo().getNMFSNUMITERATIONS() + "'')'); \n");
            if (nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo().getNMFSRANDOMSEED() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.NMFS_RANDOM_SEED||''', ''" + nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo().getNMFSRANDOMSEED() + "'')'); \n");
            }
            if (!DbVersionHelper.isDB122Up((Version)version) && nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo().getNMFSNONNEGATIVESCORING() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.NMFS_NONNEGATIVE_SCORING||''', ''" + nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo().getNMFSNONNEGATIVESCORING() + "'')'); \n");
            }
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_NONNEGATIVE_MATRIX_FACTOR||''')'); \n");
        } else if (modelType instanceof PCAModelType) {
            PCAModelType pCAModelType = (PCAModelType)modelType;
            if (pCAModelType.getPCAAlgo().getFEATNUMFEATURES() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.FEAT_NUM_FEATURES||''', ''" + pCAModelType.getPCAAlgo().getFEATNUMFEATURES() + "'')'); \n");
            }
            if (pCAModelType.getPCAAlgo().getSVDSSCORINGMODE() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_SCORING_MODE||''', ''" + pCAModelType.getPCAAlgo().getSVDSSCORINGMODE() + "'')'); \n");
            }
            if (pCAModelType.getPCAAlgo().getSVDSUMATRIXOUTPUT() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_U_MATRIX_OUTPUT||''', ''" + pCAModelType.getPCAAlgo().getSVDSUMATRIXOUTPUT() + "'')'); \n");
            }
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_SINGULAR_VALUE_DECOMP||''')'); \n");
            if (DbVersionHelper.isDB122Up((Version)version)) {
                if (pCAModelType.getPCAAlgo().getSVDSSOLVER() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_SOLVER||''', ''" + pCAModelType.getPCAAlgo().getSVDSSOLVER() + "'')'); \n");
                }
                if (pCAModelType.getPCAAlgo().getSVDSTOLERANCE() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_TOLERANCE||''', ''" + pCAModelType.getPCAAlgo().getSVDSTOLERANCE() + "'')'); \n");
                }
                if (pCAModelType.getPCAAlgo().getSVDSOVERSAMPLING() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_OVER_SAMPLING||''', ''" + pCAModelType.getPCAAlgo().getSVDSOVERSAMPLING() + "'')'); \n");
                }
                if (pCAModelType.getPCAAlgo().getSVDSPOWERITERATIONS() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_POWER_ITERATIONS||''', ''" + pCAModelType.getPCAAlgo().getSVDSPOWERITERATIONS() + "'')'); \n");
                }
                if (pCAModelType.getPCAAlgo().getSVDSRANDOMSEED() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_RANDOM_SEED||''', ''" + pCAModelType.getPCAAlgo().getSVDSRANDOMSEED() + "'')'); \n");
                }
            } else if (pCAModelType.getPCAAlgo().getODMSAPPROXIMATECOMPUTATION() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_APPROXIMATE_COMPUTATION||''', ''" + pCAModelType.getPCAAlgo().getODMSAPPROXIMATECOMPUTATION() + "'')'); \n");
            }
        } else if (modelType instanceof SVDModelType) {
            SVDModelType sVDModelType = (SVDModelType)modelType;
            if (sVDModelType.getSVDAlgo().getFEATNUMFEATURES() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.FEAT_NUM_FEATURES||''', ''" + sVDModelType.getSVDAlgo().getFEATNUMFEATURES() + "'')'); \n");
            }
            if (sVDModelType.getSVDAlgo().getSVDSSCORINGMODE() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_SCORING_MODE||''', ''" + sVDModelType.getSVDAlgo().getSVDSSCORINGMODE() + "'')'); \n");
            }
            if (sVDModelType.getSVDAlgo().getSVDSUMATRIXOUTPUT() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_U_MATRIX_OUTPUT||''', ''" + sVDModelType.getSVDAlgo().getSVDSUMATRIXOUTPUT() + "'')'); \n");
            }
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_SINGULAR_VALUE_DECOMP||''')'); \n");
            if (DbVersionHelper.isDB122Up((Version)version)) {
                if (sVDModelType.getSVDAlgo().getSVDSSOLVER() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_SOLVER||''', ''" + sVDModelType.getSVDAlgo().getSVDSSOLVER() + "'')'); \n");
                }
                if (sVDModelType.getSVDAlgo().getSVDSTOLERANCE() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_TOLERANCE||''', ''" + sVDModelType.getSVDAlgo().getSVDSTOLERANCE() + "'')'); \n");
                }
                if (sVDModelType.getSVDAlgo().getSVDSOVERSAMPLING() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_OVER_SAMPLING||''', ''" + sVDModelType.getSVDAlgo().getSVDSOVERSAMPLING() + "'')'); \n");
                }
                if (sVDModelType.getSVDAlgo().getSVDSPOWERITERATIONS() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_POWER_ITERATIONS||''', ''" + sVDModelType.getSVDAlgo().getSVDSPOWERITERATIONS() + "'')'); \n");
                }
                if (sVDModelType.getSVDAlgo().getSVDSRANDOMSEED() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVDS_RANDOM_SEED||''', ''" + sVDModelType.getSVDAlgo().getSVDSRANDOMSEED() + "'')'); \n");
                }
            } else if (sVDModelType.getSVDAlgo().getODMSAPPROXIMATECOMPUTATION() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_APPROXIMATE_COMPUTATION||''', ''" + sVDModelType.getSVDAlgo().getODMSAPPROXIMATECOMPUTATION() + "'')'); \n");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public List<? extends ModelType> getModels() {
        ArrayList arrayList = new ArrayList();
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        FeatureExtractionBuildNodeType.Models models = featureExtractionBuildNodeType.getModels();
        if (models != null) {
            arrayList.addAll(models.getNonNegativeMatrixFactorModel());
            arrayList.addAll(models.getPCAModel());
            arrayList.addAll(models.getSVDModel());
        }
        return arrayList;
    }
}

