/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.common.build.ModelDescription;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.Compatibles;
import oracle.dmt.dataminer.server.model.Classification;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.server.model.MiningFunctionOptions;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.model.EditModelNodePartitionDefPanel;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingsODM;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.ide.Context;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.util.Version;

public class ModelDescriptionTableModel
extends ODMrTableModel<ModelDescription> {
    private static final Logger theLogger = Logger.getLogger(EditModelNodePartitionDefPanel.class.getName());
    private static final int COLUMN_COUNT = 8;
    public static final int SCHEMA_MODEL_NAME = 0;
    public static final int FUNCTION = 1;
    public static final int ALGORITHM = 2;
    public static final int PARTITION_KEY = 3;
    public static final int TARGET_ATTRIBUTE = 4;
    public static final int TARGET_DATA_TYPE = 5;
    public static final int CREATION_DATE = 6;
    public static final int COMMENTS = 7;
    public static final int SCHEMA = 8;
    public static final int MODEL_NAME = 9;
    private static String[] COLUMN_NAMES = new String[]{DialogsLrb.get("MODEL_NODE_MODEL_NAME"), DialogsLrb.get("MODEL_NODE_FUNCTION"), DialogsLrb.get("MODEL_NODE_MODEL_ALGORITHM"), DialogsLrb.get("MODEL_NODE_PARTITION_KEYS"), DialogsLrb.get("MODEL_NODE_TARGET"), DialogsLrb.get("MODEL_NODE_TARGET_DATA_TYPE"), DialogsLrb.get("MODEL_NODE_CREATION_DATE"), DialogsLrb.get("MODEL_NODE_COMMENTS")};
    private static final String QUERY_MODELS = "SELECT A.OWNER             ,\n  A.MODEL_NAME              ,\n  A.MINING_FUNCTION         ,\n  A.ALGORITHM               ,\n  A.CREATION_DATE             ,\n  A.COMMENTS                   ,\n  B.ATTRIBUTE_NAME AS TARGET,\n  B.DATA_TYPE      AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE\n   FROM ALL_MINING_MODELS A,\n  ALL_MINING_MODEL_ATTRIBUTES B\n  WHERE A.OWNER        = B.OWNER(+)\nAND A.MODEL_NAME       = B.MODEL_NAME(+)\nAND A.MINING_FUNCTION IN ('CLASSIFICATION', 'REGRESSION')\nAND A.ALGORITHM != 'ADAPTIVE_BAYES_NETWORK' \nAND B.TARGET           = 'YES'\n  \n  UNION\n \n SELECT A.OWNER    ,\n  A.MODEL_NAME     ,\n  A.MINING_FUNCTION,\n  A.ALGORITHM      ,\n A.CREATION_DATE             ,\n A.COMMENTS                   ,\n  NULL AS TARGET   ,\n  NULL AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE\n   FROM ALL_MINING_MODELS A\n  WHERE MINING_FUNCTION IN ('CLUSTERING', 'ASSOCIATION_RULES')\n  \n  UNION\n \n SELECT A.OWNER                           ,\n  A.MODEL_NAME                            ,\n  'ANOMALY_DETECTION' AS \"MINING_FUNCTION\",\n  A.ALGORITHM                             ,\n  A.CREATION_DATE             ,\n  A.COMMENTS                   ,\n  NULL AS TARGET                          ,\n  NULL AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE\n   FROM ALL_MINING_MODELS A,\n  ALL_MINING_MODEL_SETTINGS B\n  WHERE A.OWNER       = B.OWNER(+)\nAND A.MODEL_NAME      = B.MODEL_NAME(+)\nAND A.MINING_FUNCTION = 'CLASSIFICATION'\nAND A.ALGORITHM       = 'SUPPORT_VECTOR_MACHINES'\nAND B.SETTING_NAME    = 'SVMS_OUTLIER_RATE'\n\nUNION\n\n SELECT A.OWNER    ,\n  A.MODEL_NAME     ,\n  A.MINING_FUNCTION,\n  A.ALGORITHM      ,\n A.CREATION_DATE             ,\n A.COMMENTS                   ,\n  NULL AS TARGET   ,\n  NULL AS TARGET_DATA_TYPE,\n  B.SETTING_VALUE AS SVDS_SCORING_MODE\n   FROM ALL_MINING_MODELS A,\n   ALL_MINING_MODEL_SETTINGS B\n  WHERE A.OWNER       = B.OWNER(+)\n    AND A.MODEL_NAME      = B.MODEL_NAME(+)\n    AND A.MINING_FUNCTION = 'FEATURE_EXTRACTION'\n    AND A.ALGORITHM      = 'SINGULAR_VALUE_DECOMP'\n    AND B.SETTING_NAME   = 'SVDS_SCORING_MODE'\n  UNION\n\n SELECT A.OWNER    ,\n  A.MODEL_NAME     ,\n  A.MINING_FUNCTION,\n  A.ALGORITHM      ,\n A.CREATION_DATE             ,\n A.COMMENTS                   ,\n  NULL AS TARGET                          ,\n  NULL AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE\n   FROM ALL_MINING_MODELS A\n  WHERE  A.MINING_FUNCTION = 'FEATURE_EXTRACTION'\n         AND A.ALGORITHM      = 'NONNEGATIVE_MATRIX_FACTOR'";
    private static final String QUERY_MODELS_PARTITIONS = "WITH partition_keys as \n (SELECT DISTINCT model_name,column_name,position FROM ALL_MINING_MODEL_PARTITIONS),\n model_attributes as\n (SELECT model_name, attribute_name, data_type from ALL_MINING_MODEL_ATTRIBUTES)\nSELECT A.OWNER             ,\n  A.MODEL_NAME              ,\n  A.MINING_FUNCTION         ,\n  A.ALGORITHM               ,\n  A.CREATION_DATE             ,\n  A.COMMENTS                   ,\n  B.ATTRIBUTE_NAME AS TARGET,\n  B.DATA_TYPE      AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE,\n NVL((SELECT LISTAGG(column_name,',') \n WITHIN GROUP(order by position) \n FROM partition_keys \n WHERE model_name = a.model_name \n ),' ') as partition_key, \nNVL((SELECT LISTAGG(t.data_type,',')  \n WITHIN GROUP(order by k.position)  \n FROM partition_keys k, model_attributes t \n WHERE k.model_name = a.model_name AND \n       k.model_name = t.model_name AND \n       k.column_name = t.attribute_name \n ),' ') as data_types \n FROM ALL_MINING_MODELS A,\n ALL_MINING_MODEL_ATTRIBUTES B\n WHERE A.OWNER        = B.OWNER(+)\nAND A.MODEL_NAME       = B.MODEL_NAME(+)\nAND A.MINING_FUNCTION IN ('CLASSIFICATION', 'REGRESSION')\nAND A.ALGORITHM != 'ADAPTIVE_BAYES_NETWORK' \nAND B.TARGET           = 'YES'\n  \n  UNION\n \n SELECT A.OWNER    ,\n  A.MODEL_NAME     ,\n  A.MINING_FUNCTION,\n  A.ALGORITHM      ,\n A.CREATION_DATE             ,\n A.COMMENTS                   ,\n  NULL AS TARGET   ,\n  NULL AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE,\n NVL((SELECT LISTAGG(column_name,',') \n WITHIN GROUP(order by position) \n FROM partition_keys \n WHERE model_name = a.model_name \n ),' ') as partition_key, \nNVL((SELECT LISTAGG(t.data_type,',')  \n WITHIN GROUP(order by k.position)  \n FROM partition_keys k, model_attributes t \n WHERE k.model_name = a.model_name AND \n       k.model_name = t.model_name AND \n       k.column_name = t.attribute_name \n ),' ') as data_types \n  FROM ALL_MINING_MODELS A\n  WHERE MINING_FUNCTION IN ('CLUSTERING', 'ASSOCIATION_RULES')\n  \n  UNION\n \n SELECT A.OWNER                           ,\n  A.MODEL_NAME                            ,\n  'ANOMALY_DETECTION' AS \"MINING_FUNCTION\",\n  A.ALGORITHM                             ,\n  A.CREATION_DATE             ,\n  A.COMMENTS                   ,\n  NULL AS TARGET                          ,\n  NULL AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE,\n NVL((SELECT LISTAGG(column_name,',') \n WITHIN GROUP(order by position) \n FROM partition_keys \n WHERE model_name = a.model_name \n ),' ') as partition_key, \nNVL((SELECT LISTAGG(t.data_type,',')  \n WITHIN GROUP(order by k.position)  \n FROM partition_keys k, model_attributes t \n WHERE k.model_name = a.model_name AND \n       k.model_name = t.model_name AND \n       k.column_name = t.attribute_name \n ),' ') as data_types \n  FROM ALL_MINING_MODELS A,\n  ALL_MINING_MODEL_SETTINGS B\n  WHERE A.OWNER       = B.OWNER(+)\nAND A.MODEL_NAME      = B.MODEL_NAME(+)\nAND A.MINING_FUNCTION = 'CLASSIFICATION'\nAND A.ALGORITHM       = 'SUPPORT_VECTOR_MACHINES'\nAND B.SETTING_NAME    = 'SVMS_OUTLIER_RATE'\n\nUNION\n\n SELECT A.OWNER    ,\n  A.MODEL_NAME     ,\n  A.MINING_FUNCTION,\n  A.ALGORITHM      ,\n A.CREATION_DATE             ,\n A.COMMENTS                   ,\n  NULL AS TARGET   ,\n  NULL AS TARGET_DATA_TYPE,\n  B.SETTING_VALUE AS SVDS_SCORING_MODE,\n NVL((SELECT LISTAGG(column_name,',') \n WITHIN GROUP(order by position) \n FROM partition_keys \n WHERE model_name = a.model_name \n ),' ') as partition_key, \nNVL((SELECT LISTAGG(t.data_type,',')  \n WITHIN GROUP(order by k.position)  \n FROM partition_keys k, model_attributes t \n WHERE k.model_name = a.model_name AND \n       k.model_name = t.model_name AND \n       k.column_name = t.attribute_name \n ),' ') as data_types \n   FROM ALL_MINING_MODELS A,\n   ALL_MINING_MODEL_SETTINGS B\n  WHERE A.OWNER       = B.OWNER(+)\n    AND A.MODEL_NAME      = B.MODEL_NAME(+)\n    AND A.MINING_FUNCTION = 'FEATURE_EXTRACTION'\n    AND A.ALGORITHM      = 'SINGULAR_VALUE_DECOMP'\n    AND B.SETTING_NAME   = 'SVDS_SCORING_MODE'\n  UNION\n\n SELECT A.OWNER    ,\n  A.MODEL_NAME     ,\n  A.MINING_FUNCTION,\n  A.ALGORITHM      ,\n A.CREATION_DATE             ,\n A.COMMENTS                   ,\n  NULL AS TARGET                          ,\n  NULL AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE,\n NVL((SELECT LISTAGG(column_name,',') \n WITHIN GROUP(order by position) \n FROM partition_keys \n WHERE model_name = a.model_name \n ),' ') as partition_key, \nNVL((SELECT LISTAGG(t.data_type,',')  \n WITHIN GROUP(order by k.position)  \n FROM partition_keys k, model_attributes t \n WHERE k.model_name = a.model_name AND \n       k.model_name = t.model_name AND \n       k.column_name = t.attribute_name \n ),' ') as data_types \n FROM ALL_MINING_MODELS A\n  WHERE  A.MINING_FUNCTION = 'FEATURE_EXTRACTION'\n         AND A.ALGORITHM   = 'NONNEGATIVE_MATRIX_FACTOR'\n UNION\n\n SELECT A.OWNER    ,\n  A.MODEL_NAME     ,\n  A.MINING_FUNCTION,\n  A.ALGORITHM      ,\n A.CREATION_DATE             ,\n A.COMMENTS                   ,\n  NULL AS TARGET                          ,\n  NULL AS TARGET_DATA_TYPE,\n  NULL AS SVDS_SCORING_MODE,\n NVL((SELECT LISTAGG(column_name,',') \n WITHIN GROUP(order by position) \n FROM partition_keys \n WHERE model_name = a.model_name \n ),' ') as partition_key, \nNVL((SELECT LISTAGG(t.data_type,',')  \n WITHIN GROUP(order by k.position)  \n FROM partition_keys k, model_attributes t \n WHERE k.model_name = a.model_name AND \n       k.model_name = t.model_name AND \n       k.column_name = t.attribute_name \n ),' ') as data_types \n FROM ALL_MINING_MODELS A\n  WHERE  A.MINING_FUNCTION = 'FEATURE_EXTRACTION'\n         AND A.ALGORITHM   = 'EXPLICIT_SEMANTIC_ANALYS'";
    private Context _context;
    private boolean _ownerOnly;
    private String _ownerSchema;
    private boolean _filteredTableModel;

    public ModelDescriptionTableModel(Context context) {
        super(COLUMN_NAMES);
        assert (context != null) : "Can not pass a null context in to the constructor";
        this._ownerOnly = true;
        this._context = context;
        this.setColumnCount(8);
    }

    public ModelDescriptionTableModel(String string, Context context) {
        this(context);
        assert (string != null) : "Can not pass a null ownerSchema in to the constructor";
        this._ownerSchema = string;
    }

    public ModelDescriptionTableModel(String string, List<ModelDescription> list, Context context) {
        super(COLUMN_NAMES, list);
        assert (string != null) : "Can not pass a null ownerSchema in to the constructor";
        this._ownerOnly = true;
        this._context = context;
        this._ownerSchema = string;
        this.setColumnCount(8);
        this.isModelsFromOtherSchemas();
    }

    public boolean isModelsFromOtherSchemas() {
        boolean bl = this.srcData.stream().anyMatch(modelDescription -> !modelDescription.getSchema().equals(this._ownerSchema));
        this._ownerOnly = !bl;
        return bl;
    }

    public boolean areAllModelsValid() {
        boolean bl = this.srcData.stream().noneMatch(modelDescription -> RefModelStatusType.INVALID.equals((Object)modelDescription.getStatus()));
        return bl;
    }

    private void addDataItem(ModelDescription modelDescription) {
        this.srcData.add(modelDescription);
    }

    public void removeSelectedRows(int[] nArray) {
        ArrayList<ModelDescription> arrayList = new ArrayList<ModelDescription>();
        ModelDescription modelDescription = null;
        for (int i = 0; i < nArray.length; ++i) {
            modelDescription = (ModelDescription)this.srcData.get(nArray[i]);
            arrayList.add(modelDescription);
        }
        this.srcData.removeAll(arrayList);
        this.setRowCount(this.srcData.size());
        this.fireTableDataChanged();
    }

    public boolean partitionKeysCompatible(int[] nArray) {
        boolean bl = true;
        if (nArray.length > 1) {
            ModelDescription modelDescription = (ModelDescription)this.srcData.get(nArray[0]);
            String string = modelDescription.getPartitionKey();
            String string2 = modelDescription.getModelName();
            String string3 = modelDescription.getSchema();
            for (int i = 1; i < nArray.length && (bl = this.areKeysCompatible(string3, string2, string, (modelDescription = (ModelDescription)this.srcData.get(nArray[i])).getSchema(), modelDescription.getModelName(), modelDescription.getPartitionKey())); ++i) {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areKeysCompatible(String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WITH \n");
        stringBuilder.append("a AS (SELECT * FROM ALL_MINING_MODEL_ATTRIBUTES a), \n");
        stringBuilder.append("b AS (SELECT DISTINCT OWNER, MODEL_NAME, POSITION, COLUMN_NAME FROM ALL_MINING_MODEL_PARTITIONS b) \n");
        stringBuilder.append("SELECT b.OWNER, b.MODEL_NAME, b.COLUMN_NAME, b.POSITION, a.DATA_TYPE \n");
        stringBuilder.append("FROM a,b \n");
        stringBuilder.append("WHERE a.ATTRIBUTE_NAME=b.COLUMN_NAME AND a.OWNER=b.OWNER AND a.MODEL_NAME=b.MODEL_NAME \n");
        stringBuilder.append("and a.owner in (?,?) \n");
        stringBuilder.append("and a.model_name in (?,?) \n");
        stringBuilder.append("and a.ATTRIBUTE_NAME in (");
        Object[] objectArray = string3.split(",");
        Object[] objectArray2 = string6.split(",");
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        Arrays.sort(objectArray);
        Arrays.sort(objectArray2);
        if (Arrays.equals(objectArray, objectArray2)) {
            try (SQLHelper sQLHelper = new SQLHelper();){
                int n;
                for (n = 0; n < objectArray.length; ++n) {
                    if (n > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("?");
                }
                stringBuilder.append(") ORDER BY b.OWNER, b.COLUMN_NAME, b.MODEL_NAME \n");
                sQLHelper.conn = ConnectionFolder.getConnection(this._context);
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(stringBuilder.toString());
                sQLHelper.pstmt.setString(1, string);
                sQLHelper.pstmt.setString(2, string4);
                sQLHelper.pstmt.setString(3, string2);
                sQLHelper.pstmt.setString(4, string5);
                for (n = 0; n < objectArray.length; ++n) {
                    sQLHelper.pstmt.setString(5 + n, (String)objectArray[n]);
                }
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                String string7 = "";
                String string8 = "";
                String string9 = "";
                String string10 = "";
                while (sQLHelper.rs.next()) {
                    string7 = sQLHelper.rs.getString("column_name");
                    string8 = sQLHelper.rs.getString("data_type");
                    if (string9.equals(string7)) {
                        if (string8.equals(string10)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    string9 = string7;
                    string10 = string8;
                }
            }
            return true;
        }
        return false;
    }

    public boolean validateSelectionIsCompatible(int[] nArray, Context context, boolean bl) throws MisMatchedTargetValuesException, Exception {
        ModelDescription modelDescription = null;
        boolean bl2 = true;
        String string = "";
        String string2 = "";
        String string3 = "";
        if (nArray.length <= 1) {
            return true;
        }
        modelDescription = (ModelDescription)this.srcData.get(nArray[0]);
        string2 = modelDescription.getFunction();
        string = modelDescription.getTargetName();
        string3 = modelDescription.getTargetDataType();
        for (int i = 0; i < nArray.length; ++i) {
            modelDescription = (ModelDescription)this.srcData.get(nArray[i]);
            if (!modelDescription.getFunction().equals(string2)) {
                bl2 = false;
                break;
            }
            if (!MiningFunctions.CLASSIFICATION.toString().equals(string2) && !MiningFunctions.REGRESSION.toString().equals(string2)) continue;
            if (modelDescription.getTargetName().equals(string) && this.isDataTypeCompatible(string3, modelDescription.getTargetDataType())) {
                bl2 = true;
                continue;
            }
            bl2 = false;
            break;
        }
        if (bl2 && bl && MiningFunctions.CLASSIFICATION.toString().equals(string2)) {
            this.areTargetValuesTheSame(nArray, context, null);
        }
        return bl2;
    }

    public boolean areTargetValuesTheSame(int[] nArray, Context context, String string) throws MisMatchedTargetValuesException, SQLException {
        ModelDescription modelDescription = null;
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nArray.length; ++i) {
            modelDescription = (ModelDescription)this.srcData.get(nArray[i]);
            arrayList.add(Model.getCombinedUserNameModelName(modelDescription.getSchema(), modelDescription.getModelName(), false));
        }
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        if (!Classification.areTargetValuesTheSame(connectionFolder, arrayList, string)) {
            throw new MisMatchedTargetValuesException("Classification target values do not match across model selections");
        }
        return bl;
    }

    public boolean isDataTypeCompatible(String string, String string2) {
        boolean bl = false;
        if (string.equals(string2)) {
            bl = true;
        } else {
            List<String> list = Compatibles.COLUMN_DATA_TYPES.get(string);
            for (String string3 : list) {
                if (!string3.equals(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void addSelection(ModelDescriptionTableModel modelDescriptionTableModel, int[] nArray) {
        List list = modelDescriptionTableModel.getSrcData();
        ModelDescription modelDescription = null;
        for (int i = 0; i < nArray.length; ++i) {
            modelDescription = (ModelDescription)list.get(nArray[i]);
            this.srcData.add(modelDescription);
        }
        this.setRowCount(this.srcData.size());
        this.fireTableDataChanged();
    }

    public void setFailedStatus() {
        ModelDescription modelDescription = new ModelDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_FAILED_TO_LOAD"), "", "", "", "", "", null, "", null, "", null, false, "", "");
        this.clear();
        this.addDataItem(modelDescription);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public void setLoadingStatus() {
        ModelDescription modelDescription = new ModelDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_LOADING"), "", "", "", "", "", null, "", null, "", null, false, "", "");
        this.clear();
        this.addDataItem(modelDescription);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public ModelDescriptionTableModel getfilteredCopy(String string, int n, boolean bl, MiningFunctionOptions miningFunctionOptions, String string2, String string3) throws Exception {
        boolean bl2;
        Vector<ModelDescription> vector = null;
        assert (string != null) : "name filter must be non null";
        assert (miningFunctionOptions != null) : "function option must be non null";
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Object object2 = null;
        vector = new Vector<ModelDescription>(1000, 500);
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = true;
        boolean bl8 = bl2 = string.length() <= 0;
        if (string2 != null && string3 != null && string2.length() > 0 && string3.length() > 0) {
            bl4 = true;
        }
        for (Object object2 : this.srcData) {
            if (bl) {
                bl5 = true;
            } else {
                boolean bl9 = bl5 = object2.getSchema().equals(this._ownerSchema);
            }
            bl6 = miningFunctionOptions == MiningFunctionOptions.ALL ? true : object2.getFunction().equals(miningFunctionOptions.toString());
            if (bl4) {
                bl7 = object2.getTargetName().equals(string2) && this.isDataTypeCompatible(object2.getTargetDataType(), string3);
            }
            if (bl2) {
                bl3 = true;
            } else {
                bl3 = searchMatcher.matches((CharSequence)(switch (n) {
                    case 0 -> object2.getSchemaModelName();
                    case 1 -> object2.getModelName();
                    case 2 -> object2.getSchema();
                    case 4 -> object2.getAlgorithm();
                    case 3 -> object2.getFunction();
                    case 5 -> object2.getTargetName();
                    case 6 -> object2.getTargetDataType();
                    case 7 -> object2.getComments() == null ? "" : object2.getComments();
                    default -> object2.getSchemaModelName();
                }));
            }
            if (!bl5 || !bl3 || !bl6 || !bl7) continue;
            vector.add((ModelDescription)object2);
        }
        object2 = new ModelDescriptionTableModel(this._ownerSchema, vector, this._context);
        ((ModelDescriptionTableModel)((Object)object2)).setOwnerOnly(!bl);
        ((ModelDescriptionTableModel)((Object)object2)).setFilteredTableModel(true);
        return object2;
    }

    public void removeDuplicateRows(List<ModelDescription> list, int[] nArray) {
        ModelDescription modelDescription = null;
        for (int i = 0; i < nArray.length; ++i) {
            modelDescription = list.get(nArray[i]);
            this.srcData.remove(modelDescription);
        }
        this.setRowCount(this.srcData.size());
        this.fireTableDataChanged();
    }

    public void refreshModelStatus(List<ModelDescription> list) {
        HashMap<String, ModelDescription> hashMap = new HashMap<String, ModelDescription>();
        for (ModelDescription modelDescription : list) {
            hashMap.put(modelDescription.getSchemaModelName(), modelDescription);
        }
        for (ModelDescription modelDescription : this.srcData) {
            ModelDescription modelDescription2 = (ModelDescription)hashMap.get(modelDescription.getSchemaModelName());
            if (this.doModelsMatch(modelDescription2, modelDescription)) {
                modelDescription.setStatus(RefModelStatusType.INVALID);
                continue;
            }
            modelDescription.setStatus(RefModelStatusType.VALID);
        }
    }

    public List<ModelDescription> createMissingRowsBasedOnMatch(List<ModelDescription> list) {
        HashMap<String, ModelDescription> hashMap = new HashMap<String, ModelDescription>();
        ArrayList<ModelDescription> arrayList = new ArrayList<ModelDescription>();
        for (ModelDescription modelDescription : this.srcData) {
            hashMap.put(modelDescription.getSchemaModelName(), modelDescription);
        }
        for (ModelDescription modelDescription : list) {
            ModelDescription modelDescription2;
            if (this.doModelsMatch(modelDescription, modelDescription2 = (ModelDescription)hashMap.get(modelDescription.getSchemaModelName()))) continue;
            arrayList.add(modelDescription);
        }
        return arrayList;
    }

    public void removeDuplicateRowsBasedOnMatch(List<ModelDescription> list) {
        HashMap<String, ModelDescription> hashMap = new HashMap<String, ModelDescription>();
        for (ModelDescription modelDescription : list) {
            hashMap.put(modelDescription.getSchemaModelName(), modelDescription);
        }
        Iterator<Object> iterator = this.srcData.iterator();
        while (iterator.hasNext()) {
            ModelDescription modelDescription;
            modelDescription = (ModelDescription)iterator.next();
            ModelDescription modelDescription2 = (ModelDescription)hashMap.get(modelDescription.getSchemaModelName());
            if (!this.doModelsMatch(modelDescription2, modelDescription)) continue;
            iterator.remove();
        }
        this.setRowCount(this.srcData.size());
        this.fireTableDataChanged();
    }

    private boolean doModelsMatch(ModelDescription modelDescription, ModelDescription modelDescription2) {
        return modelDescription != null && modelDescription2 != null && modelDescription.getAlgorithm().equals(modelDescription2.getAlgorithm()) && modelDescription.getFunction().equals(modelDescription2.getFunction()) && modelDescription.getTargetDataType().equals(modelDescription2.getTargetDataType()) && modelDescription.getTargetName().equals(modelDescription2.getTargetName());
    }

    public void removeAvailableDuplicateRows(Vector<ModelDescription> vector) {
        this.srcData.removeAll(vector);
        this.setRowCount(this.srcData.size());
        this.fireTableDataChanged();
    }

    public void load(ConnectionManager connectionManager) throws ODMrDAOException {
        this.clear();
        this._ownerSchema = ConnectionFolder.getUserAccountName(this._context);
        this._ownerSchema = StringUtils.isDoubleQuotedString(this._ownerSchema) ? StringUtils.trimDoubleQuotes(this._ownerSchema) : this._ownerSchema.toUpperCase();
        this.loadModels(connectionManager);
        assert (this.srcData != null) : "Failed to load accessible models, received a null collection";
        this.setRowCount(this.srcData.size());
    }

    private void loadModels(ConnectionManager connectionManager) throws ODMrDAOException {
        Version version = ConnectionFolder.getConnectionFolder(this._context).getDbVersion();
        boolean bl = DbVersionHelper.isDB122Up((Version)version);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = bl ? sQLHelper.conn.prepareStatement(QUERY_MODELS_PARTITIONS) : sQLHelper.conn.prepareStatement(QUERY_MODELS);
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            ModelDescription modelDescription = null;
            String string = "";
            String string2 = "";
            while (sQLHelper.rs.next()) {
                String string3 = MiningFunctionOptions.translateFromODMServerFunction(sQLHelper.rs.getString("MINING_FUNCTION"));
                String string4 = MiningAlgorithms.translateFromODMServerAlgorithm(sQLHelper.rs.getString("ALGORITHM"), sQLHelper.rs.getString("SVDS_SCORING_MODE"));
                if (bl) {
                    string = sQLHelper.rs.getString("partition_key");
                    string2 = sQLHelper.rs.getString("data_types");
                }
                modelDescription = new ModelDescription(sQLHelper.rs.getString("OWNER"), sQLHelper.rs.getString("MODEL_NAME"), string3, string4, sQLHelper.rs.getString("TARGET"), sQLHelper.rs.getString("TARGET_DATA_TYPE"), sQLHelper.rs.getDate("CREATION_DATE"), sQLHelper.rs.getString("COMMENTS"), RefModelStatusType.VALID, "", new ModelSettingsODM(), true, string, string2);
                this.srcData.add(modelDescription);
            }
        }
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        ModelDescription modelDescription = (ModelDescription)this.srcData.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                if (this.isOwnerOnly()) {
                    if (this._ownerSchema != null) {
                        if (this._ownerSchema.equals(modelDescription.getSchema())) {
                            object = modelDescription.getModelName();
                            break;
                        }
                        object = modelDescription.getSchemaModelName();
                        break;
                    }
                    object = modelDescription.getModelName();
                    break;
                }
                object = modelDescription.getSchemaModelName();
                break;
            }
            case 8: {
                object = modelDescription.getSchema();
                break;
            }
            case 1: {
                object = modelDescription.getFunction();
                break;
            }
            case 2: {
                object = modelDescription.getAlgorithm();
                break;
            }
            case 4: {
                object = modelDescription.getTargetName();
                break;
            }
            case 5: {
                object = modelDescription.getTargetDataType();
                break;
            }
            case 9: {
                object = modelDescription.getModelName();
                break;
            }
            case 6: {
                object = modelDescription.getCreationDate();
                break;
            }
            case 7: {
                object = modelDescription.getComments();
                break;
            }
            case 3: {
                object = modelDescription.getPartitionKey();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing table";
                break;
            }
        }
        return object;
    }

    public void setOwnerOnly(boolean bl) {
        if (bl != this._ownerOnly) {
            this._ownerOnly = bl;
            this.fireTableDataChanged();
        }
    }

    public boolean isOwnerOnly() {
        return this._ownerOnly;
    }

    public boolean isFilteredTableModel() {
        return this._filteredTableModel;
    }

    public void setFilteredTableModel(boolean bl) {
        this._filteredTableModel = bl;
    }

    public static class MisMatchedTargetValuesException
    extends Exception {
        public MisMatchedTargetValuesException(String string) {
            super(string);
        }
    }
}

