/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.common.model.AttrTableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AttributeNameCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.AdditionalOutputPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.JSONQueryNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeExType;
import oracle.dmt.dataminer.workflow.xmlschema.RelationalAttributesType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;

public class SuppAttrsPanel
extends DialogDisplayer<JSONQueryNode> {
    private List<AttributeExType> availAttrsCache;
    private List<AttributeExType> selectedAttrsCache;
    private boolean _dirty = false;
    private DataMinerTable jAvailAttrs;
    private JScrollPane jAvailAttrsScrollPane;
    private JLabel jAvailableLabel;
    private JLabel jSelectedLabel;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private DataMinerTable jSelectedAttrs;
    private JScrollPane jSelectedAttrsScrollPane;

    public SuppAttrsPanel(Context context, AdditionalOutputPanel additionalOutputPanel, List<AttributeExType> list, RelationalAttributesType relationalAttributesType) {
        super(context, (JSONQueryNode)additionalOutputPanel.getData());
        this.availAttrsCache = list;
        RelationalAttributesType relationalAttributesType2 = (RelationalAttributesType)MetaDataHelper.copyMetadataObject(relationalAttributesType);
        this.selectedAttrsCache = relationalAttributesType2.getAttribute();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSelectedAttrsScrollPane = new JScrollPane();
        this.jSelectedAttrs = new DataMinerTable();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jAvailableLabel = new JLabel();
        this.jSelectedLabel = new JLabel();
        this.jAvailAttrsScrollPane = new JScrollPane();
        this.jAvailAttrs = new DataMinerTable();
        this.jSelectedAttrs.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jSelectedAttrsScrollPane.setViewportView((Component)((Object)this.jSelectedAttrs));
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        this.jAvailableLabel.setLabelFor(this.jAvailAttrsScrollPane);
        this.jAvailableLabel.setText("Available Attributes");
        this.jSelectedLabel.setLabelFor(this.jSelectedAttrsScrollPane);
        this.jSelectedLabel.setText("Selected Attributes");
        this.jAvailAttrs.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jAvailAttrsScrollPane.setViewportView((Component)((Object)this.jAvailAttrs));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAvailableLabel, -1, 277, Short.MAX_VALUE).addComponent(this.jAvailAttrsScrollPane, GroupLayout.Alignment.TRAILING, -1, 277, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -1, 49, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -1, 289, Short.MAX_VALUE).addComponent(this.jSelectedLabel, -1, 289, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSelectedLabel).addComponent(this.jAvailableLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -1, 210, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn)).addComponent(this.jAvailAttrsScrollPane, -1, 210, Short.MAX_VALUE)).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jAvailableLabel, (Component)((Object)this.jAvailAttrs), (String)DataDialogsLrb.get("AVAILABLE_LABEL"));
        ResourceUtils.resLabel((JLabel)this.jSelectedLabel, (Component)((Object)this.jSelectedAttrs), (String)DataDialogsLrb.get("SELECTED_LABEL"));
        this.initIcons();
    }

    private void initIcons() {
        this.jSelectBtn.setIcon(OracleIcons.getIcon((String)"shuttle_right.png"));
        this.jSelectAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_rightall.png"));
        this.jRemoveBtn.setIcon(OracleIcons.getIcon((String)"shuttle_left.png"));
        this.jRemoveAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_leftall.png"));
    }

    @Override
    public void initUI() {
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        this.removeSelectedAttrs(this.availAttrsCache, this.selectedAttrsCache);
        AttrTableModel<AttributeExType> attrTableModel = new AttrTableModel<AttributeExType>(this.availAttrsCache);
        this.jAvailAttrs.setModel((TableModel)((Object)attrTableModel));
        this.jAvailAttrs.setSorted(true);
        TableColumn tableColumn = this.jAvailAttrs.getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
        AttrTableModel<AttributeExType> attrTableModel2 = new AttrTableModel<AttributeExType>(this.selectedAttrsCache);
        this.jSelectedAttrs.setModel((TableModel)((Object)attrTableModel2));
        this.jSelectedAttrs.setSorted(true);
        tableColumn = this.jSelectedAttrs.getColumnModel().getColumn(0);
        attributeNameCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
        this.jAvailAttrs.getRowSorter().toggleSortOrder(0);
        this.jSelectedAttrs.getRowSorter().toggleSortOrder(0);
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuppAttrsPanel.this.moveItems(SuppAttrsPanel.this.jAvailAttrs, SuppAttrsPanel.this.jSelectedAttrs, false);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuppAttrsPanel.this.moveItems(SuppAttrsPanel.this.jAvailAttrs, SuppAttrsPanel.this.jSelectedAttrs, true);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuppAttrsPanel.this.moveItems(SuppAttrsPanel.this.jSelectedAttrs, SuppAttrsPanel.this.jAvailAttrs, false);
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuppAttrsPanel.this.moveItems(SuppAttrsPanel.this.jSelectedAttrs, SuppAttrsPanel.this.jAvailAttrs, true);
            }
        });
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        Object object2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List list = ((AttrTableModel)((Object)genericTable.getModel())).getSrcData();
        ArrayList<AttributeExType> arrayList = new ArrayList<AttributeExType>();
        if (!bl) {
            for (var7_7 = 0; var7_7 < nArray.length; ++var7_7) {
                object2 = (AttributeExType)list.get(nArray[var7_7]);
                arrayList.add((AttributeExType)object2);
            }
        } else {
            for (var7_7 = 0; var7_7 < list.size(); ++var7_7) {
                arrayList.add((AttributeExType)list.get(var7_7));
            }
        }
        for (Object object2 : arrayList) {
            n = list.indexOf(object2);
            if (n == -1) continue;
            list.remove(n);
        }
        List list2 = ((AttrTableModel)((Object)genericTable2.getModel())).getSrcData();
        list2.addAll(arrayList);
        ((AttrTableModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((AttrTableModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        object2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n2 = list2.indexOf(arrayList.get(n));
            assert (n2 != -1) : "Unexpected state - added item should be present and must have an index";
            object2[n] = (AttributeExType)n2;
        }
        genericTable2.setSelectedRowsInModel((int[])object2);
        this._dirty = true;
    }

    private void removeSelectedAttrs(List<AttributeExType> list, List<AttributeExType> list2) {
        HashMap<String, AttributeExType> hashMap = new HashMap<String, AttributeExType>();
        for (AttributeExType attributeExType : list2) {
            hashMap.put(attributeExType.getName(), attributeExType);
        }
        Iterator<AttributeExType> iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeExType attributeExType;
            attributeExType = iterator.next();
            AttributeExType attributeExType2 = (AttributeExType)hashMap.get(attributeExType.getName());
            if (attributeExType2 == null || !attributeExType2.getName().equals(attributeExType.getName()) || !attributeExType2.getDataType().equals(attributeExType.getDataType())) continue;
            iterator.remove();
        }
    }

    public List<AttributeExType> getSelectedAttrsCache() {
        return this.selectedAttrsCache;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("JSON_QUERY_ADDITIONAL_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "json_additional_output";
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setMinimumSize(new Dimension(650, 300));
    }
}

