/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.JSONDataGuideObserver;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.SimpleSearchListener;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.EditDataGuidePanel;
import oracle.dmt.dataminer.workflow.dialog.data.ImportDataGuidePanel;
import oracle.dmt.dataminer.workflow.dialog.data.JSONImportDataGuide;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideGenEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONColumnsType;
import oracle.ide.Context;
import oracle.ide.controls.DropDownMenuButton;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.ui.table.GenericTable;

public class JSONDataSourceDataPanel
extends AbstractPanel<AbstractDataNode>
implements JSONImportDataGuide {
    private JLabel jlblWhiteSpace;
    private DropDownMenuButton menuDatataGuideGen;
    private JButton removeBtn;
    private JButton exportBtn;
    protected JSONDataGuideObserver dataGuideObserver;
    protected JSONColumnsType.Attribute editedJSONColumn;
    protected static String LOADING = DataDialogsLrb.get("DATA_SOURCE_JSON_DATA_PANEL_LOADING");
    protected static String[] _colNames = new String[]{DataDialogsLrb.get("DATA_SOURCE_JSON_DATA_PANEL_PATH"), DataDialogsLrb.get("DATA_SOURCE_JSON_DATA_PANEL_TYPE")};
    protected static final int PATH_INDEX = 0;
    protected static final int DATA_TYPE_INDEX = 1;
    private boolean peerInvocation = false;
    private boolean readOnlyMode = false;
    private List<NameValuePair> dataGuideInfo;
    private JCheckBoxMenuItem previousMenuSelectedItem;
    private boolean busy = false;
    private DataMinerTablePanel dataMinerTablePanel;

    public JSONDataSourceDataPanel(Context context, AbstractDataNode abstractDataNode, JSONColumnsType.Attribute attribute, boolean bl) {
        super(context, abstractDataNode);
        this.readOnlyMode = bl;
        this.editedJSONColumn = attribute;
        this.initComponents();
        this.createComponents();
        this.initRes();
        this.initUI();
        this.previousMenuSelectedItem = EditDataGuidePanel.getMenuItemSelection(this.menuDatataGuideGen);
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, GroupLayout.Alignment.TRAILING, -1, 453, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, 409, Short.MAX_VALUE));
    }

    @Override
    public void initUI() {
        this.setupControlBar();
        if (this.dataGuideInfo == null) {
            this.dataMinerTablePanel.getTable().setShowHorizontalLines(false);
            this.dataMinerTablePanel.getTable().setShowGrid(false);
            this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)new DataGuideTableModel()));
            this.enableComponents(false);
        } else {
            this.loadDataGuideTable();
        }
        this.configureSearchField();
    }

    private void configureSearchField() {
        this.dataMinerTablePanel.getSearchField().setPrompt(DataDialogsLrb.get("JSON_DATA_GUDE_SEARCH_CATEGORY_PROMPT"));
        SearchCategory searchCategory = new SearchCategory(DataDialogsLrb.get("JSON_DATA_GUDE_SEARCH_CATEGORY_PATH"));
        this.dataMinerTablePanel.getSearchField().addCategory(searchCategory);
        this.dataMinerTablePanel.getSearchField().addCategory(new SearchCategory(DataDialogsLrb.get("JSON_DATA_GUDE_SEARCH_CATEGORY_TYPE")));
        this.dataMinerTablePanel.getSearchField().setSelectedCategory(searchCategory);
        RowFilter<DataGuideTableModel, Integer> rowFilter = new RowFilter<DataGuideTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends DataGuideTableModel, ? extends Integer> entry) {
                int n = -1;
                String string = JSONDataSourceDataPanel.this.dataMinerTablePanel.getSearchField().getSelectedCategory().getLabel();
                if (string.equals(DataDialogsLrb.get("JSON_DATA_GUDE_SEARCH_CATEGORY_PATH"))) {
                    n = 0;
                } else if (string.equals(DataDialogsLrb.get("JSON_DATA_GUDE_SEARCH_CATEGORY_TYPE"))) {
                    n = 1;
                }
                String string2 = JSONDataSourceDataPanel.this.dataMinerTablePanel.getSearchField().getText();
                SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string2, (boolean)true);
                boolean bl = false;
                boolean bl2 = string2.length() <= 0;
                boolean bl3 = false;
                boolean bl4 = false;
                Integer n2 = entry.getIdentifier();
                DataGuideTableModel dataGuideTableModel = entry.getModel();
                NameValuePair nameValuePair = dataGuideTableModel.getRowData(n2);
                bl4 = searchMatcher.matches((CharSequence)(switch (n) {
                    case 0 -> nameValuePair.getName();
                    case 1 -> {
                        NameValuePair var14_14 = (NameValuePair)nameValuePair.getValue();
                        yield (String)var14_14.getValue();
                    }
                    default -> nameValuePair.getName();
                }));
                bl = bl4;
                return bl;
            }
        };
        this.dataMinerTablePanel.getSearchField().addSearchListener((SearchListener)new SimpleSearchListener((GenericTable)this.dataMinerTablePanel.getTable(), rowFilter, 0));
    }

    public void registerDataGuideObserver(JSONDataGuideObserver jSONDataGuideObserver) {
        this.dataGuideObserver = jSONDataGuideObserver;
    }

    public void savePreviousMenuSelectionFromPeer(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.previousMenuSelectedItem = jCheckBoxMenuItem;
    }

    @Override
    public void setPeerMenuSelection(JCheckBoxMenuItem jCheckBoxMenuItem) {
        if (this.dataGuideObserver != null) {
            this.dataGuideObserver.setPeerMenuSelection(this, jCheckBoxMenuItem);
        }
    }

    public void setMenuSelectionFromPeer(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.setBusy(true);
        EditDataGuidePanel.setMenuItemSelection(this.menuDatataGuideGen, jCheckBoxMenuItem);
        this.setBusy(false);
    }

    public void resetMenuSelection() {
        this.previousMenuSelectedItem.setSelected(true);
    }

    @Override
    public void editDataGuide(ActionEvent actionEvent) {
        if (this.peerInvocation) {
            return;
        }
        boolean bl = false;
        String string = actionEvent.getActionCommand();
        if (string.equals(EditDataGuidePanel.import_from_workflow)) {
            ImportDataGuidePanel importDataGuidePanel = new ImportDataGuidePanel(this.getContext(), (AbstractDataNode)this.getData());
            if (importDataGuidePanel.showAsDialog(this)) {
                String string2 = importDataGuidePanel.getDataGuideTableName();
                this.dataGuideObserver.importDataGuide(string2);
                this.setComboSelection(EditDataGuidePanel.off_data_gen);
                bl = true;
            } else {
                this.dataGuideObserver.resetMenu();
            }
        } else if (string.equals(EditDataGuidePanel.import_from_file)) {
            if (this.dataGuideObserver.importDataGuideFromFile()) {
                this.setComboSelection(EditDataGuidePanel.off_data_gen);
                bl = true;
            } else {
                this.dataGuideObserver.resetMenu();
            }
        } else if (string.equals(EditDataGuidePanel.default_data_gen)) {
            boolean bl2 = EditDataGuidePanel.isCustom(this.editedJSONColumn.getDataGuideInfo());
            if (!EditDataGuidePanel.overwriteCustom(this.editedJSONColumn.getDataGuideInfo(), DataGuideGenEnumType.DEFAULT)) {
                this.dataGuideObserver.resetMenu();
            } else {
                if (bl2) {
                    this.dataGuideObserver.updateJsonStructureTree();
                    this.updateUI();
                }
                this.setComboSelection(EditDataGuidePanel.default_data_gen);
                this.editedJSONColumn.getDataGuideInfo().setGenerate(DataGuideGenEnumType.DEFAULT);
                bl = true;
            }
        } else if (string.equals(EditDataGuidePanel.off_data_gen)) {
            this.editedJSONColumn.getDataGuideInfo().setGenerate(DataGuideGenEnumType.OFF);
            bl = true;
        } else if (string.equals(EditDataGuidePanel.on_data_gen)) {
            boolean bl3 = EditDataGuidePanel.isCustom(this.editedJSONColumn.getDataGuideInfo());
            if (!EditDataGuidePanel.overwriteCustom(this.editedJSONColumn.getDataGuideInfo(), DataGuideGenEnumType.ON)) {
                this.dataGuideObserver.resetMenu();
            } else {
                if (bl3) {
                    this.dataGuideObserver.updateJsonStructureTree();
                    this.updateUI();
                }
                this.setComboSelection(EditDataGuidePanel.on_data_gen);
                this.editedJSONColumn.getDataGuideInfo().setGenerate(DataGuideGenEnumType.ON);
                bl = true;
            }
        }
        if (bl) {
            this.previousMenuSelectedItem = EditDataGuidePanel.getMenuItemSelection(this.menuDatataGuideGen);
        }
    }

    @Override
    public void setBusy(boolean bl) {
        this.busy = bl;
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    public void setLoadingStatus() {
        this.dataMinerTablePanel.getTable().setShowHorizontalLines(false);
        this.dataMinerTablePanel.getTable().setShowGrid(false);
        DataGuideTableModel dataGuideTableModel = (DataGuideTableModel)((Object)this.dataMinerTablePanel.getTable().getModel());
        dataGuideTableModel.setLoadingStatus();
        this.enableComponents(false);
    }

    public void clearLoadingStatus() {
        DataGuideTableModel dataGuideTableModel = (DataGuideTableModel)((Object)this.dataMinerTablePanel.getTable().getModel());
        dataGuideTableModel.clearLoadingStatus();
        boolean bl = !this.readOnlyMode;
        this.enableComponents(bl);
    }

    private void createComponents() {
        this.jlblWhiteSpace = new JLabel("          ");
        this.menuDatataGuideGen = new DropDownMenuButton();
        this.menuDatataGuideGen.setIcon((Icon)DataMinerIcons.get(Icons.GENERATE_DATA_GUIDE));
        this.menuDatataGuideGen.setToolTipText(ControlsLrb.get("JSON_DATA_GUIDE_GENERATION_LABEL"));
        this.menuDatataGuideGen.setEnabled(false);
        this.removeBtn = new JButton();
        this.exportBtn = new JButton();
    }

    public void loadDataGuideTable() {
        this.dataMinerTablePanel.getTable().setFillsViewportHeight(true);
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
        this.dataMinerTablePanel.getTable().setShowGrid(true);
        this.dataMinerTablePanel.getTable().setShowHorizontalLines(true);
        this.dataMinerTablePanel.getTable().setShowVerticalLines(true);
        this.dataMinerTablePanel.getTable().setFixedColumns(0, new int[0]);
        DataGuideTableModel dataGuideTableModel = new DataGuideTableModel(this.dataGuideInfo);
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)dataGuideTableModel));
        this.dataMinerTablePanel.getTable().setSorted(true);
        this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
        this.dataMinerTablePanel.getTable().setAutoResizeMode(4);
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getFullColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(90);
        this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        this.enableComponents(true);
    }

    @Override
    public void initRes() {
        this.removeBtn.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.removeBtn.setToolTipText(ControlsLrb.get("JSON_TOOLBAR_REMOVE_DATA_GUIDE_TOOLTIP"));
        this.exportBtn.setIcon(OracleIcons.getIcon((String)"export.png"));
        this.exportBtn.setToolTipText(ControlsLrb.get("JSON_TOOLBAR_EXPORT_DATA_GUIDE_TOOLTIP"));
    }

    public void dataGuideAvailable(List<NameValuePair> list) {
        this.dataGuideInfo = list;
        if (null != list) {
            this.loadDataGuideTable();
        } else {
            this.clearLoadingStatus();
        }
    }

    public void setComboSelectionFromPeer(String string) {
        this.peerInvocation = false;
    }

    public void setComboSelection(String string) {
        this.dataGuideObserver.setPeerComboSelection(this, string);
    }

    public void setupControlBar() {
        this.setUpDataGenerationCombo();
        this.removeBtn.setEnabled(false);
        this.dataMinerTablePanel.addControlBarComponents(new Component[]{this.jlblWhiteSpace, this.menuDatataGuideGen, this.removeBtn, this.exportBtn});
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSONDataSourceDataPanel.this.dataGuideObserver.removeDataGuide();
                JSONDataSourceDataPanel.this.editedJSONColumn.getDataGuideInfo().setGenerate(DataGuideGenEnumType.ON);
                JSONDataSourceDataPanel.this.peerInvocation = true;
                JSONDataSourceDataPanel.this.setComboSelection(EditDataGuidePanel.on_data_gen);
                JSONDataSourceDataPanel.this.peerInvocation = false;
            }
        });
        this.exportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSONDataSourceDataPanel.this.dataGuideObserver.exportDataGuide(JSONDataSourceDataPanel.this.dataGuideInfo);
            }
        });
    }

    protected void enableComponents(boolean bl) {
        if (this.readOnlyMode) {
            this.exportBtn.setEnabled(bl);
            this.removeBtn.setEnabled(false);
            this.dataMinerTablePanel.getSearchField().setEnabled(bl);
        } else {
            boolean bl2 = this.enableRemoveButton();
            this.exportBtn.setEnabled(bl && bl2);
            this.removeBtn.setEnabled(bl2);
            this.dataMinerTablePanel.getSearchField().setEnabled(bl && bl2);
        }
        this.menuDatataGuideGen.setEnabled(bl);
    }

    private boolean enableRemoveButton() {
        if (this.readOnlyMode) {
            return false;
        }
        DataGuideInfoType dataGuideInfoType = this.editedJSONColumn.getDataGuideInfo();
        if (dataGuideInfoType == null) {
            return false;
        }
        if (null == dataGuideInfoType.getCustom() && null == dataGuideInfoType.getSystem()) {
            return false;
        }
        boolean bl = dataGuideInfoType.getMessages() == null || dataGuideInfoType.getMessages().getMessage().isEmpty();
        return bl;
    }

    private void setUpDataGenerationCombo() {
        EditDataGuidePanel.setUpDataGenerationControl(this.menuDatataGuideGen, this.editedJSONColumn, this);
    }

    class DataGuideTableModel
    extends SimpleBaseTableModel {
        private List<NameValuePair> dataGuideInfoData;

        DataGuideTableModel() {
            this.setColumnIdentifiers(new String[]{""});
            this.setRowCount(1);
        }

        public NameValuePair getRowData(int n) {
            if (this.dataGuideInfoData != null) {
                return this.dataGuideInfoData.get(n);
            }
            return null;
        }

        public void setLoadingStatus() {
            this.dataGuideInfoData.clear();
            this.dataGuideInfoData = null;
            this.setColumnIdentifiers(new String[]{""});
            this.setRowCount(1);
            this.fireTableStructureChanged();
        }

        public void clearLoadingStatus() {
            if (this.dataGuideInfoData != null) {
                this.dataGuideInfoData.clear();
            } else {
                this.dataGuideInfoData = new ArrayList<NameValuePair>();
            }
            this.dataGuideInfoData.add(new NameValuePair("", (Object)new NameValuePair("", (Object)"")));
            this.fireTableStructureChanged();
        }

        DataGuideTableModel(List<NameValuePair> list) {
            this.setColumnIdentifiers(_colNames);
            this.setRowCount(list != null ? list.size() : 1);
            this.dataGuideInfoData = new ArrayList<NameValuePair>();
            for (NameValuePair nameValuePair : list) {
                NameValuePair nameValuePair2 = new NameValuePair(nameValuePair.getName(), nameValuePair.getValue());
                this.dataGuideInfoData.add(nameValuePair2);
            }
        }

        public String getColumnName(int n) {
            return _colNames[n];
        }

        public Object getValueAt(int n, int n2) {
            if (this.dataGuideInfoData == null) {
                if (n2 == 0) {
                    return LOADING;
                }
                return null;
            }
            NameValuePair nameValuePair = this.dataGuideInfoData.get(n);
            if (n2 == 0) {
                return nameValuePair.getName();
            }
            NameValuePair nameValuePair2 = (NameValuePair)nameValuePair.getValue();
            return nameValuePair2.getValue();
        }
    }
}

