/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONColumnsType;

public class ImportDataGuideTableModel
extends SimpleBaseTableModel {
    public static String LOADING_WORKFLOWS = DataDialogsLrb.get("IMPORT_DATAGUIDE_LOADING_WORKFLOWS");
    public static String LOADING_WORKFLOW = DataDialogsLrb.get("IMPORT_DATAGUIDE_LOADING_WORKFLOW");
    public static String COLUMN_NODE = DataDialogsLrb.get("IMPORT_DATAGUIDE_TABLE_NODE_NAME_COL");
    public static String COLUMN_WORKFLOW = DataDialogsLrb.get("IMPORT_DATAGUIDE_WORKFLOW_NAME_COL");
    public static String COLUMN_TYPE = DataDialogsLrb.get("IMPORT_DATAGUIDE_TABLE_NODE_TYPE_COL");
    public static String COLUMN_COLUMN = DataDialogsLrb.get("IMPORT_DATAGUIDE_TABLE_NODE_COLUMN_COL");
    protected List<RowData> dataGuideData = new ArrayList<RowData>();
    private static String[] _columnNames = new String[]{COLUMN_NODE, COLUMN_WORKFLOW, COLUMN_TYPE, COLUMN_COLUMN};

    public int getColumnNodeIdx() {
        return 0;
    }

    public int getColumnWorkflowIdx() {
        return 1;
    }

    public int getColumnProjectIdx() {
        return -1;
    }

    public int getColumnTypeIdx() {
        return 2;
    }

    public int getColumnJSONColumnIdx() {
        return 3;
    }

    protected String[] getColumnNames() {
        return _columnNames;
    }

    public ImportDataGuideTableModel(String string) {
        this.dataGuideData.add(new RowData(string));
        this.setColumnIdentifiers(new String[]{COLUMN_NODE});
        this.setColumnCount(1);
        this.setRowCount(this.dataGuideData.size());
    }

    public ImportDataGuideTableModel(Map<ImportDataHelper, List<JSONColumnsType.Attribute>> map) {
        this.covertToArray(map);
        this.setColumnIdentifiers(this.getColumnNames());
        this.setColumnCount(this.getColumnNames().length);
        this.setRowCount(this.dataGuideData.size());
    }

    private void covertToArray(Map<ImportDataHelper, List<JSONColumnsType.Attribute>> map) {
        for (ImportDataHelper importDataHelper : map.keySet()) {
            List<JSONColumnsType.Attribute> list = map.get(importDataHelper);
            String string = importDataHelper.nodeType instanceof DataSourceNodeType ? "Data Source" : "Create Table";
            for (JSONColumnsType.Attribute attribute : list) {
                String string2 = attribute.getName();
                RowData rowData = new RowData(importDataHelper.nodeType.getName(), importDataHelper.getProjectName(), importDataHelper.getWorkFlowName(), string, string2, importDataHelper.nodeType);
                this.dataGuideData.add(rowData);
            }
        }
    }

    public Object getValueAt(int n, int n2) {
        String string = null;
        if (this.dataGuideData == null || this.dataGuideData.isEmpty()) {
            return "";
        }
        RowData rowData = this.dataGuideData.get(n);
        if (n2 == this.getColumnNodeIdx()) {
            string = rowData.nodeName;
        } else if (n2 == this.getColumnWorkflowIdx()) {
            string = rowData.getWorkflowName();
        } else if (n2 == this.getColumnProjectIdx()) {
            string = rowData.getProjectName();
        } else if (n2 == this.getColumnTypeIdx()) {
            string = rowData.nodeType;
        } else if (n2 == this.getColumnJSONColumnIdx()) {
            string = rowData.jsonColumnName;
        } else assert (false) : "Out of bounds column";
        return string;
    }

    public RowData getDataGuideInfo(int n) {
        return this.dataGuideData.get(n);
    }

    public static class RowData {
        private String nodeName;
        private String projectName;
        private String workflowName;
        private String nodeType;
        private String jsonColumnName;
        private DataNodeType nodeData;

        public String getNodeName() {
            return this.nodeName;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getWorkflowName() {
            return this.workflowName;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public String getJsonColumnName() {
            return this.jsonColumnName;
        }

        public DataNodeType getNodeData() {
            return this.nodeData;
        }

        public RowData(String string, String string2, String string3, String string4, String string5, DataNodeType dataNodeType) {
            this.nodeName = string;
            this.projectName = string2;
            this.workflowName = string3;
            this.nodeType = string4;
            this.jsonColumnName = string5;
            this.nodeData = dataNodeType;
        }

        public RowData(String string) {
            this.nodeName = string;
        }
    }

    public static class ImportDataHelper {
        public DataNodeType nodeType;
        public String workflowName;
        public String projectName;

        public ImportDataHelper(DataNodeType dataNodeType, String string, String string2) {
            this.nodeType = dataNodeType;
            this.projectName = string;
            this.workflowName = string2;
        }

        public String getWorkFlowName() {
            return this.workflowName;
        }

        public String getProjectName() {
            return this.projectName;
        }
    }
}

