/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.dmt.dataminer.repository.StringUtils;

public class ModelNameValidationDocument
extends PlainDocument {
    private boolean forceUpper;
    private int limit;

    public ModelNameValidationDocument(int n) {
        this.limit = n;
        this.forceUpper = false;
    }

    public ModelNameValidationDocument(int n, boolean bl) {
        this(n);
        this.forceUpper = bl;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        int n2;
        if (this.forceUpper) {
            string = string.toUpperCase();
        }
        if ((n2 = this.getLength() + string.length()) <= this.limit) {
            String string2 = this.stripInvalidChars(n, string);
            if (string.length() != string2.length()) {
                Toolkit.getDefaultToolkit().beep();
            }
            super.insertString(n, string2, attributeSet);
        }
    }

    private String stripInvalidChars(int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = ' ';
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (StringUtils.isMultibyteChar(c)) continue;
            if (stringBuilder.length() == 0 && n == 0) {
                if (!Character.isLetter(c)) continue;
                stringBuilder.append(c);
                continue;
            }
            if (!StringUtils.isValidDBNameCharacter(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

