/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.profit;

import java.awt.Component;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.profit.ProfitTabState;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;

public class ProfitInputPanel
extends DialogDisplayer {
    private ProfitInputState state;
    private ProfitTabState tabState;
    private JTextField jBudgetFld;
    private JLabel jBudgetLbl;
    private JTextField jIncCostFld;
    private JLabel jIncCostLbl;
    private JTextField jIncRevenueFld;
    private JLabel jIncRevenueLbl;
    private JTextField jPopulationFld;
    private JLabel jPopulationLbl;
    private JTextField jStartupCostFld;
    private JLabel jStartupCostLbl;

    public ProfitInputPanel(Context context, ProfitTabState profitTabState) {
        super(context, null);
        this.tabState = profitTabState;
        this.state = new ProfitInputState(profitTabState.getStartupCost(), profitTabState.getIncRevenue(), profitTabState.getIncCost(), profitTabState.getPopulation(), profitTabState.getBudget());
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jStartupCostLbl, (Component)this.jStartupCostFld, (String)StringUtils.stripMnemonic((String)TestViewerLrb.get("STARTUP_COST")));
        this.jStartupCostLbl.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)TestViewerLrb.get("STARTUP_COST")));
        this.jStartupCostLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("STARTUP_COST_ADA"));
        this.jStartupCostFld.setToolTipText(TestViewerLrb.get("STARTUP_COST_VALID_RANGE"));
        ResourceUtils.resLabel((JLabel)this.jIncCostLbl, (Component)this.jIncCostFld, (String)StringUtils.stripMnemonic((String)TestViewerLrb.get("INCREMENTAL_COST")));
        this.jIncCostLbl.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)TestViewerLrb.get("INCREMENTAL_COST")));
        this.jIncCostLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("INCREMENTAL_COST_ADA"));
        this.jIncCostFld.setToolTipText(TestViewerLrb.get("INCREMENTAL_COST_VALID_RANGE"));
        ResourceUtils.resLabel((JLabel)this.jIncRevenueLbl, (Component)this.jIncRevenueFld, (String)StringUtils.stripMnemonic((String)TestViewerLrb.get("INCREMENTAL_REVENUE")));
        this.jIncRevenueLbl.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)TestViewerLrb.get("INCREMENTAL_REVENUE")));
        this.jIncRevenueLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("INCREMENTAL_REVENUE_ADA"));
        this.jIncRevenueFld.setToolTipText(TestViewerLrb.get("INCREMENTAL_REVENUE_VALID_RANGE"));
        ResourceUtils.resLabel((JLabel)this.jBudgetLbl, (Component)this.jBudgetFld, (String)StringUtils.stripMnemonic((String)TestViewerLrb.get("BUDGET")));
        this.jBudgetLbl.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)TestViewerLrb.get("BUDGET")));
        this.jBudgetLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("BUDGET_ADA"));
        this.jBudgetFld.setToolTipText(TestViewerLrb.get("BUDGET_VALID_RANGE"));
        ResourceUtils.resLabel((JLabel)this.jPopulationLbl, (Component)this.jPopulationFld, (String)StringUtils.stripMnemonic((String)TestViewerLrb.get("POPULATION")));
        this.jPopulationLbl.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)TestViewerLrb.get("POPULATION")));
        this.jPopulationLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("POPULATION_ADA"));
        this.jPopulationFld.setToolTipText(TestViewerLrb.get("POPULATION_VALID_RANGE"));
    }

    private void setNumber(JTextField jTextField, Number number) {
        ((NumberTextField)jTextField).setNumber(number);
    }

    private void setDataType(JTextField jTextField, Class clazz) {
        ((NumberTextField)jTextField).setDataType(clazz);
    }

    private void setSigned(JTextField jTextField, boolean bl) {
        ((NumberTextField)jTextField).setSigned(bl);
    }

    private void setLocale(JTextField jTextField, Locale locale) {
        jTextField.setLocale(locale);
    }

    private Number getNumber(JTextField jTextField) {
        return ((NumberTextField)jTextField).getNumber();
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        this.initializeControls();
    }

    private void enableControls() {
    }

    private void initializeControls() {
        this.setDataType(this.jStartupCostFld, Double.class);
        this.setSigned(this.jStartupCostFld, false);
        this.setLocale(this.jStartupCostFld, this.getLocale());
        this.setNumber(this.jStartupCostFld, this.state.getStartup_cost());
        this.setDataType(this.jIncCostFld, Double.class);
        this.setSigned(this.jIncCostFld, false);
        this.setLocale(this.jIncCostFld, this.getLocale());
        this.setNumber(this.jIncCostFld, this.state.getInc_cost());
        this.setDataType(this.jIncRevenueFld, Double.class);
        this.setSigned(this.jIncRevenueFld, false);
        this.setLocale(this.jIncRevenueFld, this.getLocale());
        this.setNumber(this.jIncRevenueFld, this.state.getInc_revenue());
        this.setDataType(this.jBudgetFld, Double.class);
        this.setSigned(this.jBudgetFld, false);
        this.setLocale(this.jBudgetFld, this.getLocale());
        this.setNumber(this.jBudgetFld, this.state.getBudget());
        this.setDataType(this.jPopulationFld, Double.class);
        this.setSigned(this.jPopulationFld, false);
        this.setLocale(this.jPopulationFld, this.getLocale());
        this.setNumber(this.jPopulationFld, this.state.getPopulation());
        this.enableControls();
    }

    private void initComponents() {
        this.jStartupCostLbl = new JLabel();
        this.jStartupCostFld = new NumberTextField();
        this.jIncCostLbl = new JLabel();
        this.jIncCostFld = new NumberTextField();
        this.jIncRevenueLbl = new JLabel();
        this.jIncRevenueFld = new NumberTextField();
        this.jBudgetLbl = new JLabel();
        this.jBudgetFld = new NumberTextField();
        this.jPopulationLbl = new JLabel();
        this.jPopulationFld = new NumberTextField();
        this.jStartupCostLbl.setText("Startup Cost:");
        this.jIncCostLbl.setText("Incremental Revenue:");
        this.jIncRevenueLbl.setText("Incremental Cost:");
        this.jBudgetLbl.setText("Budget:");
        this.jPopulationLbl.setText("Population:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jStartupCostLbl).addComponent(this.jBudgetLbl).addComponent(this.jPopulationLbl).addComponent(this.jIncRevenueLbl).addComponent(this.jIncCostLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jStartupCostFld, GroupLayout.Alignment.TRAILING, -1, 59, Short.MAX_VALUE).addComponent(this.jIncRevenueFld, GroupLayout.Alignment.TRAILING, -1, 59, Short.MAX_VALUE).addComponent(this.jIncCostFld, GroupLayout.Alignment.TRAILING, -1, 59, Short.MAX_VALUE).addComponent(this.jBudgetFld, GroupLayout.Alignment.TRAILING, -1, 59, Short.MAX_VALUE).addComponent(this.jPopulationFld, GroupLayout.Alignment.TRAILING, -1, 59, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jStartupCostLbl).addComponent(this.jStartupCostFld, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jIncRevenueLbl).addComponent(this.jIncRevenueFld, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jIncCostLbl).addComponent(this.jIncCostFld, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBudgetLbl).addComponent(this.jBudgetFld, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPopulationLbl).addComponent(this.jPopulationFld, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public boolean validateAndWriteToState(ProfitTabState profitTabState) throws ValidationException {
        Number number = this.getNumber(this.jStartupCostFld);
        if (null == number || number.doubleValue() <= 0.0) {
            throw new ValidationException(TestViewerLrb.get("STARTUP_COST_VALID_RANGE"));
        }
        profitTabState.setStartupCost(number.doubleValue());
        number = this.getNumber(this.jIncCostFld);
        if (null == number || number.doubleValue() <= 0.0) {
            throw new ValidationException(TestViewerLrb.get("INCREMENTAL_COST_VALID_RANGE"));
        }
        profitTabState.setIncCost(number.doubleValue());
        number = this.getNumber(this.jIncRevenueFld);
        if (null == number || number.doubleValue() <= 0.0) {
            throw new ValidationException(TestViewerLrb.get("INCREMENTAL_REVENUE_VALID_RANGE"));
        }
        profitTabState.setIncRevenue(number.doubleValue());
        number = this.getNumber(this.jBudgetFld);
        if (null == number || number.doubleValue() <= 0.0) {
            throw new ValidationException(TestViewerLrb.get("BUDGET_VALID_RANGE"));
        }
        profitTabState.setBudget(number.doubleValue());
        number = this.getNumber(this.jPopulationFld);
        if (null == number || number.doubleValue() <= 0.0) {
            throw new ValidationException(TestViewerLrb.get("POPULATION_VALID_RANGE"));
        }
        profitTabState.setPopulation(number.doubleValue());
        return true;
    }

    @Override
    protected String getDialogTitle() {
        return TestViewerLrb.get("PROFIT_INPUT_DIALOG");
    }

    @Override
    protected String getHelpTopic() {
        return "class_tune_profit_setting";
    }

    @Override
    protected boolean doWork() {
        try {
            this.validateAndWriteToState(this.tabState);
        }
        catch (ValidationException validationException) {
            throw new RuntimeException(validationException);
        }
        return true;
    }

    public static class ProfitInputState {
        private double startup_cost;
        private double inc_revenue;
        private double inc_cost;
        private double population;
        private double budget;

        public ProfitInputState(double d, double d2, double d3, double d4, double d5) {
            this.startup_cost = d;
            this.inc_revenue = d2;
            this.inc_cost = d3;
            this.population = d4;
            this.budget = d5;
        }

        public void setStartup_cost(double d) {
            this.startup_cost = d;
        }

        public double getStartup_cost() {
            return this.startup_cost;
        }

        public void setInc_revenue(double d) {
            this.inc_revenue = d;
        }

        public double getInc_revenue() {
            return this.inc_revenue;
        }

        public void setInc_cost(double d) {
            this.inc_cost = d;
        }

        public double getInc_cost() {
            return this.inc_cost;
        }

        public void setPopulation(double d) {
            this.population = d;
        }

        public double getPopulation() {
            return this.population;
        }

        public void setBudget(double d) {
            this.budget = d;
        }

        public double getBudget() {
            return this.budget;
        }
    }
}

