/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.partitions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.mapping.clas.common.GetModelPartitionsMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.GetBuildRowsCountQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.GetModelPartitionsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.GetTestRowsCountQuery;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionColumn;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionTestResult;
import oracle.dmt.dataminer.core.model.common.build.partition.RulesPartitionFilterData;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataMinerNode;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.ide.Context;
import oracle.ide.model.Node;

public class ModelPartitionsState {
    private boolean isClassification;
    private double testRowCount;
    private double buildRowCount;
    private Context context;
    private String[] models;
    private String quotedModelsList;
    private Map<String, String> mapPerformanceTables;
    private Map<String, Date> mapModelDates;
    private Map<String, String> mapModelAlgo;
    private SharedTestEditorState parentTestViewerState;
    private List<String> testResultsColumns;
    private SqlDataAccessObject dao;
    private ConnectionManager connManager;

    public ModelPartitionsState(Context context) {
        this.context = context;
        this.connManager = ConnectionFolder.getConnectionFolder(context);
        this.dao = new SqlDataAccessObject(this.connManager);
    }

    public void setSharedTestEditorState(SharedTestEditorState sharedTestEditorState) {
        this.parentTestViewerState = sharedTestEditorState;
        this.mapPerformanceTables = new HashMap<String, String>();
        this.mapModelDates = new HashMap<String, Date>();
        this.mapModelAlgo = new HashMap<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        List<TestResult> list = sharedTestEditorState.getAllTestResults();
        ArrayList<String> arrayList = new ArrayList<String>(4);
        for (TestResult testResult : list) {
            if (testResult.getResult().getStatus() != ModelStatusType.COMPLETE) continue;
            this.mapPerformanceTables.put(testResult.getModelName(), testResult.getPerformanceMatrixTable());
            this.mapModelDates.put(testResult.getModelName(), testResult.getCreationTime());
            this.mapModelAlgo.put(testResult.getModelName(), testResult.getMiningAlgorithm());
            arrayList.add(testResult.getModelName());
            stringBuilder.append("'");
            stringBuilder.append(testResult.getModelName());
            stringBuilder.append("',");
            this.isClassification = "CLASSIFICATION".equalsIgnoreCase(testResult.getMiningFunction());
        }
        this.models = arrayList.toArray(new String[arrayList.size()]);
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        this.quotedModelsList = stringBuilder.toString();
    }

    public List<PartitionTestResult> load(RulesPartitionFilterData rulesPartitionFilterData) throws ODMrDAOException {
        if (this.buildNodeHasPartitions()) {
            this.testRowCount = this.getTestRowsCount();
            this.buildRowCount = this.getBuildRowsCount();
            return this.loadPartitionInformation(rulesPartitionFilterData, this.testRowCount, this.buildRowCount);
        }
        return new ArrayList<PartitionTestResult>();
    }

    private boolean buildNodeHasPartitions() {
        boolean bl = false;
        Node node = this.context.getNode();
        Object object = null;
        if (node instanceof DataMinerNode) {
            if (node instanceof TestCompareNode) {
                TestCompareNode testCompareNode = (TestCompareNode)node;
                object = testCompareNode.getTestResults().get(0);
            } else {
                object = ((DataMinerNode)node).getRepositoryData();
            }
            if (object instanceof TestResult) {
                bl = MetaDataHelper.hasPartitionExpressions(((TestResult)object).getBuild());
            }
        }
        return bl;
    }

    public List<PartitionTestResult> query(RulesPartitionFilterData rulesPartitionFilterData) throws ODMrDAOException {
        return this.loadPartitionInformation(rulesPartitionFilterData, this.testRowCount, this.buildRowCount);
    }

    private double getTestRowsCount() throws ODMrDAOException {
        String string = this.mapPerformanceTables.entrySet().iterator().next().getValue();
        GetTestRowsCountQuery getTestRowsCountQuery = new GetTestRowsCountQuery(this.connManager.getDbVersion(), string);
        return this.dao.readItem((Query)getTestRowsCountQuery).orElse(0.0);
    }

    private double getBuildRowsCount() throws ODMrDAOException {
        ModelDescriptor modelDescriptor = new ModelDescriptor(null, this.models[0]);
        GetBuildRowsCountQuery getBuildRowsCountQuery = new GetBuildRowsCountQuery(this.connManager.getDbVersion(), modelDescriptor);
        return this.dao.readItem((Query)getBuildRowsCountQuery).orElse(0).intValue();
    }

    private List<PartitionTestResult> loadPartitionInformation(RulesPartitionFilterData rulesPartitionFilterData, double d, double d2) throws ODMrDAOException {
        GetModelPartitionsMapper getModelPartitionsMapper = new GetModelPartitionsMapper(d, d2, this.mapModelDates, this.mapModelAlgo);
        GetModelPartitionsQuery getModelPartitionsQuery = new GetModelPartitionsQuery(this.connManager.getDbVersion(), this.models, this.quotedModelsList, rulesPartitionFilterData, this.mapPerformanceTables, getModelPartitionsMapper);
        List list = this.dao.readItems((Query)getModelPartitionsQuery);
        String[] stringArray = new String[((PartitionTestResult)list.get(0)).getPartitionInfo().getColumns().size()];
        for (int i = 0; i < ((PartitionTestResult)list.get(0)).getPartitionInfo().getColumns().size(); ++i) {
            PartitionColumn partitionColumn = (PartitionColumn)((PartitionTestResult)list.get(0)).getPartitionInfo().getColumns().get(i);
            stringArray[i] = partitionColumn.getColumnName();
        }
        this.testResultsColumns = Arrays.asList(stringArray);
        return list;
    }

    public String[] getModels() {
        return this.models;
    }

    public void setModels(String[] stringArray) {
        this.models = stringArray;
    }

    public String getDiagramNodeName() {
        return this.parentTestViewerState.getAllTestResults().get(0).getBuild().getName();
    }

    public List<String> getTestResultsColumns() {
        return this.testResultsColumns;
    }

    public SharedTestEditorState getParentState() {
        return this.parentTestViewerState;
    }

    public boolean isClassification() {
        return this.isClassification;
    }
}

