/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator.wflownodes;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ARModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.EMClusterModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ESAModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.KMModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NMFModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.OCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.PCAModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.RModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVDModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMRModelNode;
import oracle.dmt.dataminer.navigator.net.DMURLFileSystemHelper;
import oracle.dmt.dataminer.navigator.wflownodes.ModelRefNavNode;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;

public class ModelRefNavNodeFilter
extends BaseDeferredFilter {
    private static final String CURRENT_SCHEMA_FORMAT = "%s/%s";
    private static final String ANOTHER_SCHEMA_FORMAT = "%s/%s.%s";

    @Override
    protected List<Element> loadChildrenImpl(TNode tNode) throws Exception {
        ModelRefNavNode modelRefNavNode = (ModelRefNavNode)tNode.getData();
        ConnectionFolder connectionFolder = modelRefNavNode.getConnectionFolder();
        modelRefNavNode.open();
        ModelNodeType modelNodeType = (ModelNodeType)modelRefNavNode.getRepositoryData();
        List list = modelNodeType.getModels().getModel();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        String string = connectionFolder.getUserAccountName();
        String string2 = null;
        for (ModelNodeType.Models.Model model : list) {
            string2 = string.equals(model.getSchema()) ? String.format(CURRENT_SCHEMA_FORMAT, modelRefNavNode.getURL().getPath(), model.getName()) : String.format(ANOTHER_SCHEMA_FORMAT, modelRefNavNode.getURL().getPath(), model.getSchema(), model.getName());
            BaseTreeNode baseTreeNode = ModelRefNavNodeFilter.getChildNode(string2, model);
            baseTreeNode.setParent(this.getOwner());
            baseTreeNode.setConnectionFolder(connectionFolder);
            arrayList.add((Element)baseTreeNode);
        }
        return arrayList;
    }

    public static BaseTreeNode getChildNode(String string, ModelNodeType.Models.Model model) throws Exception {
        MiningAlgorithmType miningAlgorithmType = model.getMiningAlgorithm();
        Class clazz = null;
        switch (miningAlgorithmType) {
            case NAIVE_BAYES: {
                clazz = NBModelNode.class;
                break;
            }
            case DECISION_TREE: {
                clazz = DTModelNode.class;
                break;
            }
            case GENERALIZED_LINEAR_MODEL: {
                if (MiningFunctionType.CLASSIFICATION.equals((Object)model.getMiningFunction())) {
                    clazz = GLMCModelNode.class;
                    break;
                }
                if (!MiningFunctionType.REGRESSION.equals((Object)model.getMiningFunction())) break;
                clazz = GLMRModelNode.class;
                break;
            }
            case SUPPORT_VECTOR_MACHINES: {
                if (MiningFunctionType.CLASSIFICATION.equals((Object)model.getMiningFunction())) {
                    clazz = SVMCModelNode.class;
                    break;
                }
                if (MiningFunctionType.REGRESSION.equals((Object)model.getMiningFunction())) {
                    clazz = SVMRModelNode.class;
                    break;
                }
                if (!MiningFunctionType.ANOMALY_DETECTION.equals((Object)model.getMiningFunction())) break;
                clazz = ANModelNode.class;
                break;
            }
            case KMEANS: {
                clazz = KMModelNode.class;
                break;
            }
            case O_CLUSTER: {
                clazz = OCModelNode.class;
                break;
            }
            case EXPECTATION_MAXIMIZATION: {
                clazz = EMClusterModelNode.class;
                break;
            }
            case NONNEGATIVE_MATRIX_FACTOR: {
                clazz = NMFModelNode.class;
                break;
            }
            case SINGULAR_VALUE_DECOMP: {
                clazz = SVDModelNode.class;
                break;
            }
            case PRINCIPAL_COMPONENT_ANALYSIS: {
                clazz = PCAModelNode.class;
                break;
            }
            case APRIORI_ASSOCIATION_RULES: {
                clazz = ARModelNode.class;
                break;
            }
            case EXPLICIT_SEMANTIC_ANALYSIS: {
                clazz = ESAModelNode.class;
                break;
            }
            case R_EXTENSIBLE: {
                clazz = RModelNode.class;
                break;
            }
            default: {
                assert (false) : "Unrecognized Algorithm Type";
                break;
            }
        }
        String string2 = model.getName();
        String string3 = model.getSchema();
        BaseTreeNode baseTreeNode = null;
        if (string2 != null) {
            URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)string);
            ModelNode modelNode = (ModelNode)NodeFactory.findOrCreate(clazz, (URL)uRL);
            modelNode.setURL(uRL);
            modelNode.setSchema(string3);
            modelNode.setRepositoryData(model);
            baseTreeNode = (BaseTreeNode)((Object)modelNode);
        }
        return baseTreeNode;
    }
}

