/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.svd;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.core.model.fe.svd.SVDCoefficient;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.svd.RenameFeaturePanel;
import oracle.dmt.dataminer.mviewer.svd.SVDLrb;
import oracle.dmt.dataminer.mviewer.svd.SingularValuesEditor;
import oracle.dmt.dataminer.mviewer.svd.SingularValuesState;
import oracle.dmt.dataminer.mviewer.svd.SingularValuesTableModel;
import oracle.dmt.dataminer.navigator.RefreshController;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.help.HelpInfo;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class SingularValuesPanel
extends DataMinerViewGUI {
    private SingularValuesTableModel tableModel;
    private SingularValuesState state;
    private JButton _renameBtn;
    private DataMinerTablePanel dataMinerTablePanel;
    private ModelViewerPartitionToolbar modelViewerPartitionToolbar1;

    public SingularValuesPanel(SingularValuesEditor singularValuesEditor, Context context) {
        super(singularValuesEditor, context);
        this.state = new SingularValuesState(context);
        this.tableModel = new SingularValuesTableModel();
        this.initComponents();
        this.initUI();
    }

    @Override
    public HelpInfo getHelpInfo() {
        String string = "svd_viewer_singular";
        return new HelpInfo(string);
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.modelViewerPartitionToolbar1 = new ModelViewerPartitionToolbar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modelViewerPartitionToolbar1, -1, -1, Short.MAX_VALUE).addComponent(this.dataMinerTablePanel, -1, 575, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.modelViewerPartitionToolbar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataMinerTablePanel, -1, 330, Short.MAX_VALUE).addContainerGap()));
    }

    private void initUI() {
        this.modelViewerPartitionToolbar1.setVisible(false);
        this.initTable();
        this.addCustomButons();
    }

    private void initTable() {
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        this.dataMinerTablePanel.setup((TableModel)((Object)this.tableModel), SVDLrb.get("COMPONENT_TITLE"), 0);
        dataMinerTable.setSortColumn(0, true);
        dataMinerTable.setAutoResizeMode(0);
        dataMinerTable.autoSizeColumnsToFit();
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getModelViewerNumericRenderer();
        dataMinerTable.getColumnModel().getColumn(1).setCellRenderer(tableCellRenderer);
        ListSelectionModel listSelectionModel = dataMinerTable.getSelectionModel();
        dataMinerTable.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                SingularValuesPanel.this._renameBtn.setEnabled(-1 != listSelectionEvent.getFirstIndex());
            }
        });
        dataMinerTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SingularValuesPanel.this.rename();
                }
            }
        });
    }

    private void addCustomButons() {
        this._renameBtn = new JButton(SVDLrb.get("RENAME_FEATURE_BUTTON"));
        this._renameBtn.setToolTipText(SVDLrb.get("RENAME_FEATURE_BUTTON_TOOL_TIP"));
        this._renameBtn.setEnabled(true);
        this._renameBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingularValuesPanel.this.rename();
            }
        });
        this._renameBtn.setEnabled(false);
        this.dataMinerTablePanel.addControlBarComponents(this._renameBtn);
    }

    @Override
    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public void reload(String string, String string2) {
        if (string.equals(this.state.getUserName()) && string2.equals(this.state.getModelName())) {
            ((DataMinerEditor)this.getEditor()).setNeedsRefresh(true);
        }
    }

    private void rename() {
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        int[] nArray = dataMinerTable.getSelectedRowsInModel();
        String string = ((SVDCoefficient)this.tableModel.getSrcData().get(nArray[0])).getAttributeName();
        RenameFeaturePanel renameFeaturePanel = new RenameFeaturePanel(this.state, string);
        DialogHelper dialogHelper = new DialogHelper(renameFeaturePanel);
        if (dialogHelper.showAsDialog(this)) {
            try {
                this.state.renameFeature(renameFeaturePanel.getCurrentName(), string);
                ((SingularValuesTableModel)((Object)dataMinerTable.getModel())).updateFeatureID(renameFeaturePanel.getCurrentName(), string);
                SingularValuesEditor singularValuesEditor = (SingularValuesEditor)this.getEditor();
                RefreshController.getInstance().forceRefreshInSiblingEditors(singularValuesEditor.getParentNodeId(), singularValuesEditor);
            }
            catch (Exception exception) {
                if (exception.getMessage().equals(SVDLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"))) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)SVDLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"), (String)SVDLrb.get("FEATURE_RENAME_FAILURE_TITLE"), null);
                }
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)SVDLrb.get("FEATURE_RENAME_FAILURE_TITLE"), (String)SVDLrb.get("FEATURE_RENAME_FAILURE_MESG"), null);
            }
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        private LoadUI() {
            super(SingularValuesPanel.this, SingularValuesPanel.this.overLayPanel, SingularValuesPanel.this.dataMinerTablePanel.getTable());
        }

        @Override
        protected Void doInBackground() throws Exception {
            SingularValuesPanel.this.modelViewerPartitionToolbar1.load(SingularValuesPanel.this.getEditor());
            SingularValuesPanel.this.state.load(SingularValuesPanel.this.modelViewerPartitionToolbar1.getSelectedPartitionID());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            SingularValuesPanel.this.tableModel.setSrcData(SingularValuesPanel.this.state.getSingularValues());
        }

        @Override
        protected void onFailure(Throwable throwable) {
            SingularValuesPanel.this.dataMinerTablePanel.getTable().setNoEntryInstructionText(SVDLrb.get("SINGULAR_VALUES_FAILURE"));
            DataMinerEditor.handleEditorException(SingularValuesPanel.this.getEditor().getContext(), throwable, SVDLrb.get("SINGULAR_VALUES_VIEWER_FAILURE_TITLE"), SVDLrb.get("SINGULAR_VALUES_VIEWER_FAILURE_MESG"));
        }
    }
}

