/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.extensible.r;

import javax.swing.Icon;
import oracle.dmt.dataminer.DataMinerEditorAddin;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.navigator.modelnodes.RModelNode;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.teditor.data.DataEditor;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RModelType;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.model.Element;
import oracle.ide.util.MenuSpec;

public class RDetailsEditorAddin
extends DataMinerEditorAddin {
    private static final float DEFAULT_WEIGHT = 1.0f;
    private MenuSpec menuSpec;

    public void initialize() {
        EditorManager editorManager = EditorManager.getEditorManager();
        editorManager.registerDynamic((EditorAddin)this);
        editorManager.registerPreferredLayoutListener(RModelNode.class, DataEditor.class, "dataminer.rextensible", (PreferredLayoutListener)new DataMinerEditorAddin.MyPreferredLayoutListener());
    }

    public Class getEditorClass() {
        return DataEditor.class;
    }

    public MenuSpec getMenuSpecification() {
        if (this.menuSpec == null) {
            this.menuSpec = new MenuSpec(ModelViewerLrb.get("MODEL_VIEWER_DETAILS"), Integer.valueOf(68), (Icon)DataMinerIcons.get(Icons.BATMAN));
        }
        return this.menuSpec;
    }

    @Override
    public float getEditorWeight(Element element) {
        super.getEditorWeight(element);
        if (element instanceof RModelNode && this.isDetailsFunctionPresent((RModelNode)element)) {
            return 1.0f;
        }
        return Float.NaN;
    }

    private boolean isDetailsFunctionPresent(RModelNode rModelNode) {
        boolean bl = false;
        Object object = rModelNode.getRepositoryData();
        if (object instanceof RModelType) {
            RModelType rModelType = (RModelType)object;
            bl = rModelType.getDetailFunction() != null && StringUtils.isNotEmpty((String)rModelType.getDetailFunction().getPrimaryFunction());
        } else if (object instanceof ModelNodeType.Models.Model) {
            ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)object;
            bl = MetaDataHelper.isODMSettingPresent(model.getModelSettingsODM().getModelSettingODM(), "RALG_DETAILS_FUNCTION");
        }
        return bl;
    }
}

