/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import javax.swing.Icon;
import oracle.dmt.dataminer.DataMinerEditorAddin;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientEditor;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ESAModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NMFModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.PCAModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVDModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMRModelNode;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.model.Element;
import oracle.ide.util.MenuSpec;

public class CoefficientEditorAddin
extends DataMinerEditorAddin {
    private static float SVMC_WEIGHT = 0.9f;
    private static float GLMC_WEIGHT = 0.9f;
    private static float NMF_WEIGHT = 0.9f;
    private static float ESA_WEIGHT = 0.9f;
    private static float NB_WEIGHT = 0.7f;
    private static float SVD_WEIGHT = 0.9f;
    private static float PCA_WEIGHT = 0.9f;
    private MenuSpec menuSpec;
    private float weight;

    public Class getEditorClass() {
        return CoefficientEditor.class;
    }

    public synchronized MenuSpec getMenuSpecification() {
        String string = this.isNB() ? CoefficientsLrb.get("EDITOR_PANEL_NAME_NB") : CoefficientsLrb.get("EDITOR_PANEL_NAME");
        this.menuSpec = new MenuSpec(string, Integer.valueOf(67), (Icon)DataMinerIcons.get(Icons.BATMAN));
        return this.menuSpec;
    }

    public void initialize() {
        EditorManager editorManager = EditorManager.getEditorManager();
        editorManager.registerDynamic((EditorAddin)this);
        editorManager.registerPreferredLayoutListener(SVMCModelNode.class, CoefficientEditor.class, "dataminer.svmclassification", (PreferredLayoutListener)new DataMinerEditorAddin.MyPreferredLayoutListener());
        editorManager.registerPreferredLayoutListener(GLMCModelNode.class, CoefficientEditor.class, "dataminer.glmclassification", (PreferredLayoutListener)new DataMinerEditorAddin.MyPreferredLayoutListener());
        editorManager.registerPreferredLayoutListener(NBModelNode.class, CoefficientEditor.class, "dataminer.nbclassification", (PreferredLayoutListener)new DataMinerEditorAddin.MyPreferredLayoutListener());
        editorManager.registerPreferredLayoutListener(SVMRModelNode.class, CoefficientEditor.class, "dataminer.svmregression", (PreferredLayoutListener)new DataMinerEditorAddin.MyPreferredLayoutListener());
        editorManager.registerPreferredLayoutListener(GLMRModelNode.class, CoefficientEditor.class, "dataminer.glmregression", (PreferredLayoutListener)new DataMinerEditorAddin.MyPreferredLayoutListener());
        editorManager.registerPreferredLayoutListener(ANModelNode.class, CoefficientEditor.class, "dataminer.anomalydetection", (PreferredLayoutListener)new DataMinerEditorAddin.MyPreferredLayoutListener());
        editorManager.registerPreferredLayoutListener(NMFModelNode.class, CoefficientEditor.class, "dataminer.featureextraction", (PreferredLayoutListener)new DataMinerEditorAddin.MyPreferredLayoutListener());
        editorManager.registerPreferredLayoutListener(SVDModelNode.class, CoefficientEditor.class, "dataminer.singularvaluesdecomp", (PreferredLayoutListener)new DataMinerEditorAddin.MyPreferredLayoutListener());
        editorManager.registerPreferredLayoutListener(PCAModelNode.class, CoefficientEditor.class, "dataminer.principalcomponentanalysis", (PreferredLayoutListener)new DataMinerEditorAddin.MyPreferredLayoutListener());
        editorManager.registerPreferredLayoutListener(ESAModelNode.class, CoefficientEditor.class, "dataminer.explicitfeatureextraction", (PreferredLayoutListener)new DataMinerEditorAddin.MyPreferredLayoutListener());
    }

    @Override
    public float getEditorWeight(Element element) {
        super.getEditorWeight(element);
        if (element instanceof SVMCModelNode) {
            SVMCModelNode sVMCModelNode = (SVMCModelNode)element;
            if (!sVMCModelNode.exists()) {
                return Float.NaN;
            }
            Boolean bl = sVMCModelNode.isLinearKernel();
            this.weight = bl != null && bl.booleanValue() ? SVMC_WEIGHT : Float.NaN;
        } else if (element instanceof ANModelNode) {
            ANModelNode aNModelNode = (ANModelNode)element;
            if (!aNModelNode.exists()) {
                return Float.NaN;
            }
            Boolean bl = aNModelNode.isLinearKernel();
            this.weight = bl != null && bl.booleanValue() ? SVMC_WEIGHT : Float.NaN;
        } else if (element instanceof GLMCModelNode) {
            this.weight = GLMC_WEIGHT;
        } else if (element instanceof NBModelNode) {
            this.weight = NB_WEIGHT;
        } else if (element instanceof SVMRModelNode) {
            SVMRModelNode sVMRModelNode = (SVMRModelNode)element;
            if (!sVMRModelNode.exists()) {
                return Float.NaN;
            }
            Boolean bl = sVMRModelNode.isLinearKernel();
            this.weight = bl != null && bl.booleanValue() ? SVMC_WEIGHT : Float.NaN;
        } else if (element instanceof GLMRModelNode) {
            this.weight = GLMC_WEIGHT;
        } else if (element instanceof NMFModelNode) {
            NMFModelNode nMFModelNode = (NMFModelNode)element;
            if (!nMFModelNode.exists()) {
                return Float.NaN;
            }
            this.weight = NMF_WEIGHT;
        } else if (element instanceof SVDModelNode) {
            this.weight = SVD_WEIGHT;
        } else if (element instanceof PCAModelNode) {
            this.weight = PCA_WEIGHT;
        } else if (element instanceof ESAModelNode) {
            ESAModelNode eSAModelNode = (ESAModelNode)element;
            if (!eSAModelNode.exists()) {
                return Float.NaN;
            }
            this.weight = ESA_WEIGHT;
        } else {
            this.weight = Float.NaN;
        }
        return this.weight;
    }

    private boolean isNB() {
        return this.element instanceof NBModelNode;
    }

    @Override
    public boolean isDefault() {
        if (this.element instanceof GLMCModelNode || this.element instanceof GLMRModelNode || this.element instanceof ESAModelNode) {
            return true;
        }
        return super.isDefault();
    }
}

