/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.component;

import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.model.graph.GraphDataModel;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentDataTableModel;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentModelRow;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentProjectionItem;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentProjectionsTableModel;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentTableModel;
import oracle.dmt.dataminer.mviewer.clustering.component.ComponentLrb;
import oracle.dmt.dataminer.server.model.ClusteringEM;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ClusterComponentViewerState
extends BaseViewerState
implements GraphModelProvider {
    private static final int INITIAL_FETCH_SIZE = 2000;
    private static final int NUMERIC_NUMBER_OF_POINTS = 20;
    private static final Color BASE_CHART_COLOR = new Color(255, 255, 153);
    private boolean _loaded;
    private ClusteringFilterSetting _filterSetting;
    private Map<Integer, List<ClusterComponentModelRow>> _allComponentData = new HashMap<Integer, List<ClusterComponentModelRow>>();
    private List<Integer> _componentList;
    private Map<String, String> modelProjectionsMap;
    private ClusterComponentTableModel _tableComponentModel;
    private Integer _selectedComponent;
    private int _totalComponents = 0;
    private String _attributeNameFilter;
    private ClusterComponentProjectionsTableModel _tableProjectionModel;
    private ClusterComponentDataTableModel _tableDataModel;
    private int _depthRadius = 0;
    private String _styleSelection = DefaultGraphDataModel.DEFAULT_GRAPH_STYLE;

    public ClusterComponentViewerState(Context context) {
        super(context);
        this._tableComponentModel = new ClusterComponentTableModel((List<ClusterComponentModelRow>)new ArrayList<ClusterComponentModelRow>());
        this._tableProjectionModel = new ClusterComponentProjectionsTableModel();
        this._tableDataModel = new ClusterComponentDataTableModel((List<NameValuePair>)new ArrayList<NameValuePair>());
        this._componentList = new ArrayList<Integer>();
        this._filterSetting = new ClusteringFilterSetting();
        this._filterSetting.setFetchSize(2000);
    }

    public HelpInfo getHelpInfo() {
        String string = "em_model_view_component";
        return new HelpInfo(string);
    }

    public int getInitialFetchSize() {
        return 2000;
    }

    public Double getSelectedPrior() {
        ClusterComponentModelRow clusterComponentModelRow;
        if (this._selectedComponent == null) {
            return null;
        }
        Double d = null;
        List<ClusterComponentModelRow> list = this._allComponentData.get(this._selectedComponent);
        if (list == null) {
            return null;
        }
        Iterator<ClusterComponentModelRow> iterator = list.iterator();
        while (iterator.hasNext() && (d = (clusterComponentModelRow = iterator.next()).getPriorValue()) == null) {
        }
        return d;
    }

    public List<NameValuePair> getSelectedFrequency(String string) {
        if (this._selectedComponent == null) {
            return new ArrayList<NameValuePair>(0);
        }
        List<NameValuePair> list = null;
        List<ClusterComponentModelRow> list2 = this._allComponentData.get(this._selectedComponent);
        for (ClusterComponentModelRow clusterComponentModelRow : list2) {
            if (!clusterComponentModelRow.getAttributeName().equals(string)) continue;
            list = clusterComponentModelRow.getFrequencyValues();
            break;
        }
        return list;
    }

    @Override
    public GraphDataModel getGraphDataModel(int n) {
        if (this._tableComponentModel == null) {
            return null;
        }
        List list = this._tableComponentModel.getSrcData();
        ClusterComponentModelRow clusterComponentModelRow = (ClusterComponentModelRow)list.get(n);
        GraphDataModel graphDataModel = clusterComponentModelRow.getGraphDataModel();
        return graphDataModel;
    }

    @Override
    public String getStyleSelection() {
        return this._styleSelection;
    }

    public GenericBaseTableModel getComponentTableModel() {
        return this._tableComponentModel;
    }

    public GenericBaseTableModel getProjectionTableModel() {
        return this._tableProjectionModel;
    }

    public void setSelectedComponent(Integer n) {
        this._selectedComponent = n;
    }

    public Integer getSelectedComponent() {
        return this._selectedComponent;
    }

    public void setTotalComponents(Integer n) {
        this._totalComponents = n;
    }

    public int getTotalComponents() {
        return this._totalComponents;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public ClusterComponentViewerState load(String string) throws ODMrDAOException, SQLException {
        this._loaded = false;
        this.loadData(string);
        this._loaded = true;
        return this;
    }

    public void loadProjectionStatus() {
        this._tableProjectionModel.loadStatus();
    }

    private void loadData(String string) throws ODMrDAOException {
        if (!this._allComponentData.isEmpty()) {
            this._allComponentData.clear();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.getModel().setPartitionId(string);
        this.getModel().getModelDetailsComp(this._filterSetting.getFetchSize(), this.getAttributeNameFilter(), this._allComponentData, arrayList, this._selectedComponent);
        if (this._componentList.isEmpty()) {
            this._componentList.addAll(arrayList);
        }
        if (this._selectedComponent == null && !this._componentList.isEmpty()) {
            this._selectedComponent = this._componentList.get(0);
        }
        this.setTotalComponents(this._componentList.size());
        this.modelProjectionsMap = this.getModel().getEMModelProjectionFeatureNameMap(this._filterSetting.getFetchSize());
    }

    public void loadTableModel() throws Exception {
        List<ClusterComponentModelRow> list = this._allComponentData.get(this._selectedComponent);
        if (list == null) {
            list = new ArrayList<ClusterComponentModelRow>();
        }
        this._tableComponentModel.setSrcData(list);
        this.createAllGraphDataModelsTotalPopulation();
    }

    public void loadProjectionData(List<ClusterComponentProjectionItem> list) {
        this._tableProjectionModel.loadData(list);
    }

    public void loadProjectionErrorStatus() {
        this._tableProjectionModel.loadErrorStatus();
    }

    public void setFilterSetting(ClusteringFilterSetting clusteringFilterSetting) {
        this._filterSetting = clusteringFilterSetting;
    }

    public ClusteringFilterSetting getFilterSetting() {
        return this._filterSetting;
    }

    public List<Integer> getComponentList() {
        return this._componentList;
    }

    private void createAllGraphDataModelsTotalPopulation() throws Exception {
        List list = this._tableComponentModel.getSrcData();
        for (ClusterComponentModelRow clusterComponentModelRow : list) {
            GraphDataModel graphDataModel = this.createGraphDataModelComponent(clusterComponentModelRow, false);
            graphDataModel.setTitle(null);
            graphDataModel.setLegendVisible(false);
            graphDataModel.setDepthRadius(Integer.valueOf(0));
            graphDataModel.setLineDataLineDisplayed(false);
            clusterComponentModelRow.setGraphDataModel(graphDataModel);
        }
    }

    public GraphDataModel createGraphDataModelForAttribute(ClusterComponentModelRow clusterComponentModelRow) throws Exception {
        return this.createGraphDataModelComponent(clusterComponentModelRow, true);
    }

    private GraphDataModel createGraphDataModelComponent(ClusterComponentModelRow clusterComponentModelRow, boolean bl) throws Exception {
        List<NameValuePair> list = clusterComponentModelRow.getFrequencyValues();
        Double d = clusterComponentModelRow.getMeanValue();
        Double d2 = clusterComponentModelRow.getCovarianceValue();
        Object object = null;
        object = (list == null || list.isEmpty()) && d != null && d2 != null ? this.createGraphDataModelComponentNumeric(clusterComponentModelRow, bl) : (list != null && !list.isEmpty() && d == null && d2 == null ? this.createGraphDataModelComponentCategoric(clusterComponentModelRow, bl) : new DefaultGraphDataModel(null, 20, null, null, null));
        return object;
    }

    private GraphDataModel createGraphDataModelComponentCategoric(ClusterComponentModelRow clusterComponentModelRow, boolean bl) throws Exception {
        DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 20, null, null, null);
        List<NameValuePair> list = clusterComponentModelRow.getFrequencyValues();
        int n = list.size();
        Object[][] objectArray = new Object[n][1];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[]{ComponentLrb.get("CLUSTER_COMPONENT_SERIES")};
        for (int i = 0; i < n; ++i) {
            NameValuePair nameValuePair = list.get(i);
            String string = nameValuePair.getName();
            Double d = (Double)nameValuePair.getValue();
            objectArray[i][0] = d;
            objectArray2[i] = string;
        }
        defaultGraphDataModel.addRowColors(new Color[]{BASE_CHART_COLOR});
        defaultGraphDataModel.addColumnLabels(objectArray2);
        defaultGraphDataModel.addRowLabels(objectArray3);
        defaultGraphDataModel.addGraphData(objectArray);
        if (bl) {
            defaultGraphDataModel.setDepthRadius(this._depthRadius);
        }
        defaultGraphDataModel.setLineDataLineDisplayed(false);
        defaultGraphDataModel.setTitle(clusterComponentModelRow.getAttributeName());
        return defaultGraphDataModel;
    }

    private GraphDataModel createGraphDataModelComponentNumeric(ClusterComponentModelRow clusterComponentModelRow, boolean bl) throws Exception {
        DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 31, null, null, null);
        Double d = clusterComponentModelRow.getMeanValue();
        Double d2 = clusterComponentModelRow.getCovarianceValue();
        int n = 20;
        Double d3 = d / 2.0;
        Double d4 = d / 20.0;
        Object[][] objectArray = new Object[n][1];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[]{ComponentLrb.get("CLUSTER_COMPONENT_SERIES")};
        for (int i = 0; i < n; ++i) {
            Double d5 = d3 + d4 * (double)i;
            String string = String.valueOf(d5);
            Double d6 = this.getGaussionValue(d5, d, d2);
            objectArray[i][0] = d6;
            objectArray2[i] = string;
        }
        defaultGraphDataModel.addRowColors(new Color[]{BASE_CHART_COLOR});
        defaultGraphDataModel.addColumnLabels(objectArray2);
        defaultGraphDataModel.addRowLabels(objectArray3);
        defaultGraphDataModel.addGraphData(objectArray);
        if (bl) {
            defaultGraphDataModel.setDepthRadius(this._depthRadius);
        }
        defaultGraphDataModel.setLineDataLineDisplayed(false);
        defaultGraphDataModel.setTitle(clusterComponentModelRow.getAttributeName());
        return defaultGraphDataModel;
    }

    public double getGaussionValue(double d, double d2, double d3) {
        double d4 = Math.exp(-((d - d2) * (d - d2) / (2.0 * d3)));
        double d5 = 1.0 / Math.sqrt(Math.PI * 2 * d3) * d4;
        return d5;
    }

    public int getDepthRadius() {
        return this._depthRadius;
    }

    public void setAttributeNameFilter(String string) {
        this._attributeNameFilter = string;
    }

    public String getAttributeNameFilter() {
        return this._attributeNameFilter;
    }

    public String getEMModelNestedAttributeName(String string) {
        String string2 = null;
        if (this.modelProjectionsMap != null) {
            string2 = this.modelProjectionsMap.get(string);
        }
        return string2;
    }

    public List<ClusterComponentProjectionItem> getModelDetailsProjDetails(String string, String string2, String string3) throws ODMrDAOException {
        this.getModel().setPartitionId(string3);
        List<ClusterComponentProjectionItem> list = this.getModel().getModelDetailsProjDetails(string, string2);
        return list;
    }

    public ClusterComponentDataTableModel getTableDataModel() {
        return this._tableDataModel;
    }

    public void setClusterComponentDataTableModel(ClusterComponentDataTableModel clusterComponentDataTableModel) {
        this._tableDataModel = clusterComponentDataTableModel;
    }

    public void loadFrequencyTable(String string) {
        List<NameValuePair> list = this.getSelectedFrequency(string);
        this._tableDataModel.setSrcData(list);
    }

    @Override
    public ClusteringEM getModel() {
        return (ClusteringEM)this.modelViewerState.getOdmModel();
    }
}

