/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer;

import java.awt.Component;
import java.awt.Window;
import java.util.List;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public abstract class AbstractModelEditor
extends DataMinerEditor {
    protected BaseTreeNode _projectFolder;
    protected BaseTreeNode _connectionFolder;
    protected BaseTreeNode _connectionsFolder;
    protected WorkflowNode _wfNode;
    protected BaseTreeNode _modelNode;

    @Override
    public void open() throws OpenAbortedException {
        Object object;
        super.open();
        Node node = this.getContext().getNode();
        if (!(node instanceof ModelNode)) {
            object = new DataMinerException("Unexpected node type encountered");
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)object, (String)CommonLrb.get("MSG_EXCEPTION"));
            this.abortOpen(node, (Exception)object);
        }
        if (!((object = (ModelNode)node) instanceof ANModelNode) && !object.exists()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)ModelViewerLrb.get("LOAD_MODEL_MISSING"), (String)ModelViewerLrb.get("MODEL_MISSING_TITLE"), null);
            this.abortOpen(node, ModelViewerLrb.get("MODEL_DOES_NOT_EXIST"));
        }
        this.attach(true);
    }

    @Override
    public void close() {
        super.close();
        this.attach(false);
    }

    private void attach(boolean bl) {
        Context context = this.getContext();
        if (bl) {
            this._modelNode = (BaseTreeNode)context.getNode();
            TNode tNode = this._modelNode.getParent();
            this._wfNode = (WorkflowNode)tNode.getAncestor(WorkflowNode.class);
            this._projectFolder = (BaseTreeNode)tNode.getAncestor(ProjectFolder.class, true);
            this._connectionFolder = (BaseTreeNode)tNode.getAncestor(ConnectionFolder.class, true);
            this._connectionsFolder = (BaseTreeNode)tNode.getAncestor(Connections.class, true);
            this._modelNode.attach((Observer)this);
            this._wfNode.attach((Observer)this);
            this._projectFolder.attach((Observer)this);
            this._connectionFolder.attach((Observer)this);
            this._connectionsFolder.attach((Observer)this);
        } else {
            if (this._modelNode != null) {
                this._modelNode.detach((Observer)this);
                this._modelNode = null;
            }
            if (this._wfNode != null) {
                this._wfNode.detach((Observer)this);
                this._wfNode = null;
            }
            if (this._projectFolder != null) {
                this._projectFolder.detach((Observer)this);
                this._projectFolder = null;
            }
            if (this._connectionFolder != null) {
                this._connectionFolder.detach((Observer)this);
                this._connectionFolder = null;
            }
            if (this._connectionsFolder != null) {
                this._connectionsFolder.detach((Observer)this);
                this._connectionsFolder = null;
            }
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() == UpdateMessage.CHILD_REMOVED) {
            List list = updateMessage.getRemoveObjects();
            if (list.contains(this._wfNode) || list.contains(this._modelNode) || list.contains(this._connectionFolder) || list.contains(this._projectFolder) || list.contains(this._connectionsFolder)) {
                this.closeEditor();
            }
        } else if (updateMessage.getMessageID() == UpdateMessage.OBJECT_CLOSED) {
            if (object == this._connectionFolder) {
                this.closeEditor();
            }
        } else if (updateMessage.getMessageID() == UpdateMessage.CONTENT_MODIFIED) {
            this.refreshEditor(object);
        }
    }

    private void refreshEditor(Object object) {
        boolean bl;
        boolean bl2 = bl = object == this.getContext().getNode();
        if (bl) {
            if (this.getGUI().isShowing()) {
                this.refresh();
            } else {
                this.setNeedsRefresh(true);
            }
        }
    }
}

