/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import oracle.adfdtinternal.model.dvt.util.gui.ShortcutIcon;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphTypeAndSubtype;
import oracle.dss.graph.GraphTypeConverter;
import oracle.dss.graph.Subtype;
import oracle.dss.graph.Type;
import oracle.dss.graph.UIGraphType;
import oracle.dss.graph.gui.GraphTypeConverterAdapter;

public class GraphTypeTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_GRAPH_TYPE = "GraphType";
    Object m_selectedObject = null;
    protected UIView m_currentDataView = null;
    protected ToolBar m_toolBar = null;
    protected boolean m_enable = true;
    protected boolean m_bRolloverIconEnabled = false;
    private Vector m_types = null;
    private GraphTypeConverter m_graphTypeConverter;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle = null;
    private boolean updateEnabled = true;
    private JToggleButton[] typeButtons;
    private GraphTypePopup popup;
    private ButtonGroup buttonGroup;
    private int oldType;
    private boolean m_bTypeChangedByTool = false;
    private MouseListener m_mouseListener;
    private ImageIcon[] graphTypeIcons;
    private int typeNumber;
    private String[] tooltips = new String[]{"BarGraph", "HorizontalBarGraph", "PieGraph", "LineGraph", "AreaGraph", "CombinationGraph", "ScatterBubbleGraph", "StockGraph", "CircularGraph", "ParetoGraph", "ThreeDGraph", "Funnel"};

    public GraphTypeTool() {
        ImageIcon icon = this.makeImage("images/es_bar_vert_clust18t.gif");
        this.setIcon(this.getArrowIcon(icon));
        this.setDisabledIcon(new ShortcutIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())), this.makeImage("images/arrow_disabled.gif")));
        this.addActionListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (GraphTypeTool.this.isEnabled()) {
                    GraphTypeTool.this.setBorderPainted(!GraphTypeTool.this.isBorderPainted());
                    GraphTypeTool.this.setDropDownVisible(!GraphTypeTool.this.isDropDownVisible());
                    GraphTypeTool.this.requestFocus();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (GraphTypeTool.this.isDropDownVisible()) {
                    GraphTypeTool.this.setSelected(true);
                } else {
                    GraphTypeTool.this.setSelected(false);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                GraphTypeTool.this.internalKeyPressed(e);
            }
        });
        this.setModel(new Model());
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString(PROPERTY_GRAPH_TYPE));
        this.setEnabled(false);
        this.setBorderPainted(false);
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.setPreferredSize(new Dimension(24, 24));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!GraphTypeTool.this.isRolloverIconEnabled()) {
                        ((JToggleButton)e.getSource()).setBorderPainted(true);
                    }
                    if (!GraphTypeTool.this.isEnabled()) {
                        ((JToggleButton)e.getSource()).setBorderPainted(GraphTypeTool.this.isSelected());
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!GraphTypeTool.this.isRolloverIconEnabled()) {
                        ((JToggleButton)e.getSource()).setBorderPainted(((JToggleButton)e.getSource()).isSelected());
                    }
                }
            };
            this.addMouseListener(this.m_mouseListener);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 9) {
            if (this.isDropDownVisible()) {
                e.consume();
            } else {
                super.processKeyEvent(e);
            }
        } else {
            super.processKeyEvent(e);
        }
    }

    private int findGraphType(Vector types, int type) {
        int index = -1;
        for (int j = 0; j < types.size(); ++j) {
            if (types.elementAt(j) == null || ((Type)types.elementAt((int)j)).id != type) continue;
            index = j;
            return index;
        }
        return index;
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
        this.setToolTipText(this.rBundle.getString(PROPERTY_GRAPH_TYPE));
    }

    @Override
    public void selectedAction(ControllerEvent e, UIView currentDataView, ToolBar toolBar) {
        if (this.m_bTypeChangedByTool) {
            this.m_bTypeChangedByTool = false;
            return;
        }
        if (currentDataView instanceof Graph) {
            GraphTypeConverter typeConverter = ((Graph)currentDataView).getGraphTypeConverter();
            if (typeConverter == null) {
                typeConverter = new GraphTypeConverterAdapter();
            }
            typeConverter.setLocale(((Graph)currentDataView).getLocale());
            ((Graph)currentDataView).setGraphTypeConverter(typeConverter);
            if (typeConverter.getTypes() == null) {
                return;
            }
            this.m_types = typeConverter.getTypes();
            this.typeNumber = typeConverter.getTypes().size();
            if (this.typeNumber < 1) {
                return;
            }
            this.m_graphTypeConverter = typeConverter;
            this.m_enable = false;
            if (this.m_currentDataView != currentDataView) {
                int i;
                this.graphTypeIcons = new ImageIcon[this.typeNumber * 3];
                for (i = 0; i < this.typeNumber; ++i) {
                    StringBuilder filename = new StringBuilder(((Type)this.m_types.elementAt((int)i)).sFileName);
                    filename.insert(((Type)this.m_types.elementAt((int)i)).sFileName.indexOf(".gif"), "18t");
                    this.graphTypeIcons[i] = this.makeImage(filename.toString());
                    this.graphTypeIcons[i].setDescription(((Type)this.m_types.elementAt((int)i)).name);
                    this.graphTypeIcons[this.typeNumber + i] = this.makeImage(((Type)this.m_types.elementAt((int)i)).fileName);
                    this.graphTypeIcons[this.typeNumber + i].setDescription(((Type)this.m_types.elementAt((int)i)).name);
                    this.graphTypeIcons[this.typeNumber * 2 + i] = this.makeImage(((Type)this.m_types.elementAt((int)i)).fileName);
                    this.graphTypeIcons[this.typeNumber * 2 + i].setDescription(((Type)this.m_types.elementAt((int)i)).name);
                }
                if (this.typeButtons != null) {
                    for (i = 0; i < this.typeButtons.length; ++i) {
                        this.typeButtons[i].removeActionListener(this);
                        this.typeButtons[i].removeMouseListener(this.m_mouseListener);
                    }
                }
                this.typeButtons = new JToggleButton[this.typeNumber];
                this.buttonGroup = new ButtonGroup();
                for (i = 0; i < this.typeNumber; ++i) {
                    this.typeButtons[i] = new JToggleButton();
                    this.typeButtons[i].setIcon(this.graphTypeIcons[i]);
                    this.typeButtons[i].addActionListener(this);
                    this.typeButtons[i].addMouseListener(this.m_mouseListener);
                    this.typeButtons[i].setBorderPainted(false);
                    this.typeButtons[i].setSelected(false);
                    this.typeButtons[i].setToolTipText(this.rBundle.getString(this.tooltips[i]));
                    if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
                        this.typeButtons[i].setPreferredSize(new Dimension(24, 24));
                        this.typeButtons[i].setMinimumSize(this.typeButtons[i].getPreferredSize());
                        this.typeButtons[i].setMaximumSize(this.typeButtons[i].getPreferredSize());
                    }
                    this.buttonGroup.add(this.typeButtons[i]);
                }
            }
            this.popup = new GraphTypePopup();
            this.setEnabled(true);
            this.m_currentDataView = currentDataView;
            if (toolBar != null) {
                this.m_toolBar = toolBar;
            }
            int type = -1;
            for (int j = 0; j < this.m_graphTypeConverter.getTypes().size(); ++j) {
                if (((Type)this.m_graphTypeConverter.getTypes().elementAt((int)j)).id != this.m_graphTypeConverter.getTypeAndSubtype((UIGraphType)((Graph)this.m_currentDataView)).type) continue;
                type = j;
            }
            if (type != -1) {
                this.typeButtons[type].setSelected(true);
                this.typeButtons[type].setBorderPainted(true);
                this.oldType = type;
                this.setIcon(this.getArrowIcon(this.typeButtons[type].getIcon()));
                this.setDisabledIcon(new ShortcutIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())), this.makeImage("images/arrow_disabled.gif")));
            }
            this.setRolloverIconEnabled(this.isRolloverIconEnabled());
        } else {
            this.m_currentDataView = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_currentDataView == null) {
            return;
        }
        if (this.m_graphTypeConverter == null) {
            return;
        }
        for (int i = 0; i < this.typeButtons.length; ++i) {
            if (e.getSource() != this.typeButtons[i]) continue;
            if (this.typeButtons[i].isSelected()) {
                this.typeButtons[i].setBorderPainted(true);
                if (this.oldType != i) {
                    this.m_bTypeChangedByTool = true;
                }
            } else {
                this.typeButtons[i].setBorderPainted(false);
            }
            Type type = (Type)this.m_graphTypeConverter.getTypes().elementAt(i);
            Subtype subtype = (Subtype)type.subtypes.elementAt(0);
            this.m_graphTypeConverter.setTypeAndSubtype((UIGraphType)((Graph)this.m_currentDataView), new GraphTypeAndSubtype(type.id, subtype.id));
            this.setDropDownVisible(false);
            this.setIcon(this.getArrowIcon(this.typeButtons[i].getIcon()));
            this.setDisabledIcon(new ShortcutIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())), this.makeImage("images/arrow_disabled.gif")));
            if (this.isRolloverIconEnabled()) {
                this.setRolloverIcon(this.getArrowIcon(this.graphTypeIcons[i + this.typeNumber]));
                this.setRolloverSelectedIcon(this.getArrowIcon(this.graphTypeIcons[i + this.typeNumber]));
            } else {
                this.setRolloverIcon(null);
                this.setRolloverSelectedIcon(null);
            }
            this.setBorderPainted(false);
            if (this.tooltips[i].equals("Funnel")) {
                ((Graph)this.m_currentDataView).setGraphicAntialiasing(true);
            }
            this.firePropertyChange(PROPERTY_GRAPH_TYPE, this.oldType, i);
            this.oldType = i;
            this.requestFocus();
            this.setSelected(false);
            return;
        }
    }

    @Override
    public void update() {
        if (!this.updateEnabled) {
            return;
        }
        this.selectedAction(null, this.m_currentDataView, null);
    }

    private ImageIcon makeImage(String fileName) {
        return new ImageIcon(ImageUtils.getImageResource(GraphTypeTool.class, (String)fileName));
    }

    private ImageIcon getArrowIcon(Icon icon) {
        if (icon != null) {
            return new ShortcutIcon((ImageIcon)icon, this.makeImage("images/arrow.gif"));
        }
        return null;
    }

    public boolean isPointType() {
        if (this.m_currentDataView == null) {
            return false;
        }
        return !((Graph)this.m_currentDataView).isLineDataLineDisplayed();
    }

    private boolean isDropDownVisible() {
        return this.popup == null ? false : this.popup.isVisible();
    }

    private void setDropDownVisible(boolean visible) {
        if (this.popup == null) {
            this.popup = new GraphTypePopup();
            this.popup.setBackground(this.getBackground());
        }
        if (visible) {
            this.popup.show(this, 0, this.getHeight());
        } else {
            this.popup.setVisible(false);
            this.popup = null;
            this.requestFocus();
        }
        this.repaint();
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    @Override
    public void cleanUp() {
        this.removeMouseListener(this.m_mouseListener);
        this.removeActionListener(this);
        if (this.popup != null) {
            this.popup.cleanUp();
        }
    }

    @Override
    public void setRolloverIconEnabled(boolean bEnabled) {
        this.m_bRolloverIconEnabled = bEnabled;
        if (bEnabled) {
            if (this.typeButtons != null) {
                for (int i = 0; i < this.typeButtons.length; ++i) {
                    this.typeButtons[i].setIcon(this.graphTypeIcons[i + this.typeNumber * 2]);
                    this.typeButtons[i].setRolloverIcon(this.graphTypeIcons[i + this.typeNumber]);
                    this.typeButtons[i].setRolloverSelectedIcon(this.graphTypeIcons[i + this.typeNumber]);
                    if (!this.typeButtons[i].isSelected()) continue;
                    this.setIcon(this.getArrowIcon(this.typeButtons[i].getIcon()));
                    this.setRolloverIcon(this.getArrowIcon(this.typeButtons[i].getRolloverIcon()));
                    this.setRolloverSelectedIcon(this.getArrowIcon(this.typeButtons[i].getRolloverSelectedIcon()));
                }
            }
        } else {
            this.setRolloverIcon(null);
            this.setRolloverSelectedIcon(null);
            if (this.typeButtons != null) {
                for (int i = 0; i < this.typeButtons.length; ++i) {
                    this.typeButtons[i].setIcon(this.graphTypeIcons[i]);
                    this.typeButtons[i].setRolloverIcon(null);
                    this.typeButtons[i].setRolloverSelectedIcon(null);
                    if (!this.typeButtons[i].isSelected()) continue;
                    this.setIcon(this.getArrowIcon(this.typeButtons[i].getIcon()));
                    this.setRolloverIcon(this.getArrowIcon(this.typeButtons[i].getRolloverIcon()));
                    this.setRolloverSelectedIcon(this.getArrowIcon(this.typeButtons[i].getRolloverSelectedIcon()));
                }
            }
        }
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
    }

    @Override
    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private boolean isAnySelected() {
        boolean bReturn = false;
        for (int i = 0; i < this.typeButtons.length; ++i) {
            if (!this.typeButtons[i].isSelected()) continue;
            bReturn = true;
            break;
        }
        return bReturn;
    }

    private void internalKeyPressed(KeyEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        boolean consume = false;
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 37: 
            case 38: {
                if (!this.isDropDownVisible()) break;
                if (!this.isAnySelected()) {
                    this.typeButtons[this.typeButtons.length - 1].setBorderPainted(true);
                    this.typeButtons[this.typeButtons.length - 1].setSelected(true);
                } else {
                    for (int i = 0; i < this.typeButtons.length; ++i) {
                        if (!this.typeButtons[i].isSelected()) continue;
                        this.typeButtons[i].setBorderPainted(false);
                        this.typeButtons[i].setSelected(false);
                        if (--i < 0) {
                            i = this.typeButtons.length - 1;
                        }
                        this.typeButtons[i].setBorderPainted(true);
                        this.typeButtons[i].setSelected(true);
                        this.popup.sendAccessibleEvent(((ImageIcon)this.typeButtons[i].getIcon()).getDescription());
                        break;
                    }
                }
                consume = true;
                break;
            }
            case 39: 
            case 40: {
                if (!this.isDropDownVisible()) break;
                if (!this.isAnySelected()) {
                    this.typeButtons[0].setBorderPainted(true);
                    this.typeButtons[0].setSelected(true);
                } else {
                    for (int i = 0; i < this.typeButtons.length; ++i) {
                        if (!this.typeButtons[i].isSelected()) continue;
                        this.typeButtons[i].setBorderPainted(false);
                        this.typeButtons[i].setSelected(false);
                        if (++i == this.typeButtons.length) {
                            i = 0;
                        }
                        this.typeButtons[i].setBorderPainted(true);
                        this.typeButtons[i].setSelected(true);
                        this.popup.sendAccessibleEvent(((ImageIcon)this.typeButtons[i].getIcon()).getDescription());
                        break;
                    }
                }
                consume = true;
                break;
            }
            case 10: {
                if (!this.isDropDownVisible()) break;
                this.doEnter();
                this.setDropDownVisible(false);
                this.repaint();
                consume = true;
                break;
            }
            case 27: {
                if (!this.isDropDownVisible()) break;
                this.setDropDownVisible(false);
                this.repaint();
                break;
            }
            case 32: {
                if (!this.isDropDownVisible()) {
                    this.setDropDownVisible(true);
                    this.setBorderPainted(true);
                    break;
                }
                this.setDropDownVisible(false);
                this.repaint();
                break;
            }
        }
        if (consume) {
            e.consume();
        }
    }

    private void doEnter() {
        if (this.m_currentDataView == null) {
            return;
        }
        if (this.m_graphTypeConverter == null) {
            return;
        }
        for (int i = 0; i < this.typeButtons.length; ++i) {
            if (!this.typeButtons[i].isSelected()) continue;
            Type type = (Type)this.m_graphTypeConverter.getTypes().elementAt(i);
            Subtype subtype = (Subtype)type.subtypes.elementAt(0);
            this.m_graphTypeConverter.setTypeAndSubtype((UIGraphType)((Graph)this.m_currentDataView), new GraphTypeAndSubtype(type.id, subtype.id));
            this.setIcon(this.typeButtons[i].getIcon());
            this.setDropDownVisible(false);
            this.setBorderPainted(false);
            this.requestFocus();
            return;
        }
    }

    private class Model
    extends JToggleButton.ToggleButtonModel {
        private Model() {
        }

        @Override
        public boolean isPressed() {
            return GraphTypeTool.this.isDropDownVisible();
        }
    }

    class GraphTypePopup
    extends JPopupMenu {
        private JToolBar toolbar;
        private JLabel _statusBarLabel;
        private StatusBar _statusBar;

        public GraphTypePopup() {
            this.setLayout(new BoxLayout(this, 1));
            this.toolbar = new JToolBar();
            for (int i = 0; i < GraphTypeTool.this.typeButtons.length; ++i) {
                this.toolbar.add(GraphTypeTool.this.typeButtons[i]);
                if (!GraphTypeTool.this.typeButtons[i].isSelected()) {
                    GraphTypeTool.this.typeButtons[i].setBorderPainted(false);
                    continue;
                }
                GraphTypeTool.this.typeButtons[i].setBorderPainted(true);
            }
            this._statusBar = new StatusBar();
            this._statusBarLabel = new JLabel(){

                @Override
                public void setText(String text) {
                    String oldName = this.getText();
                    super.setText(text);
                    if (this.accessibleContext != null) {
                        this.accessibleContext.firePropertyChange("AccessibleName", oldName, text);
                    }
                }
            };
            this._statusBar.add((Component)this._statusBarLabel);
            this._statusBar.setVisible(false);
            this.add((Component)this._statusBar);
            this.toolbar.setOrientation(1);
            this.toolbar.setBorderPainted(false);
            if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                this.toolbar.setBorder(null);
            }
            this.add(this.toolbar);
        }

        public void sendAccessibleEvent(String text) {
            if (this._statusBarLabel != null) {
                this._statusBarLabel.setText(text);
            }
        }

        public void cleanUp() {
            this._statusBar.remove((Component)this._statusBarLabel);
            this._statusBarLabel = null;
        }

        @Override
        protected void firePopupMenuWillBecomeInvisible() {
            super.firePopupMenuWillBecomeInvisible();
            GraphTypeTool.this.repaint();
        }

        @Override
        protected void firePopupMenuCanceled() {
            super.firePopupMenuCanceled();
            GraphTypeTool.this.repaint();
        }
    }
}

