/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab.managers;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabSizingManager;
import oracle.dss.dataView.managers.ViewSizing;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.managers.GridViewRuleSizing;
import oracle.dss.rules.DiscriminatorRule;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.ResolutionService;
import oracle.dss.rules.Rule;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.RuleContext;
import oracle.dss.rules.RuleException;
import oracle.dss.rules.discriminator.CompositeDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.DiscriminatorXML;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.rules.discriminator.TotalsDiscriminator;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.RowComponentInfo;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class CrosstabRuleSizing
extends GridViewRuleSizing
implements CrosstabSizingManager {
    protected Crosstab m_crosstab = null;
    protected transient int[] m_calculatedColumnHeaderRowHeights = null;
    protected transient int[] m_calculatedRowHeaderColumnWidths = null;
    protected RuleBundle m_preferredRowHeaderColumnWidths = null;
    protected RuleBundle m_preferredColumnHeaderRowHeights = null;
    protected transient int[] m_preferredColumnHeaderRowHeightsCache = null;
    protected transient int[] m_preferredRowHeaderColumnWidthsCache = null;
    private TotalsDiscriminator m_totalsDisc = null;
    private CompositeDiscriminator m_compNotTotalsDisc = null;
    private RuleBundle m_defNonTotalColWidthBundle = null;
    protected Hashtable m_context = null;
    protected static final String COLUMN_HEADER_BUNDLE_NAME = "ColHdrBundle";
    protected static final String ROW_HEADER_BUNDLE_NAME = "RowHdrBundle";
    private static final String a_defNonTotColW = "defNonTotColW";
    private static final String m_method_setPreferredColumnWidth = "setPreferredColumnWidth(int column, int width)";
    private static final String m_method_getPreferredColumnWidth = "getPreferredColumnWidth(int column)";
    private static final String m_method_setPreferredRowHeight = "setPreferredRowHeight(int row, int height)";
    private static final String m_method_getPreferredRowHeight = "getPreferredRowHeight(int row)";
    private static final String m_method_setCalculatedColumnHeaderRowHeight = "setCalculatedColumnHeaderRowHeight(int row, int height)";
    private static final String m_method_getCalculatedColumnHeaderRowHeight = "getCalculatedColumnHeaderRowHeight(int row)";
    private static final String m_method_setCalculatedRowHeaderColumnWidth = "setCalculatedRowHeaderColumnWidth(int column, int width)";
    private static final String m_method_getCalculatedRowHeaderColumnWidth = "getCalculatedRowHeaderColumnWidth(int column)";
    private static final String m_method_setPreferredColumnHeaderRowHeight = "setPreferredColumnHeaderRowHeight(int row, int height)";
    private static final String m_method_getPreferredColumnHeaderRowHeight = "getPreferredColumnHeaderRowHeight(int row)";
    private static final String m_method_setPreferredRowHeaderColumnWidth = "setPreferredRowHeaderColumnWidth(int column, int width)";
    private static final String m_method_getPreferredRowHeaderColumnWidth = "getPreferredRowHeaderColumnWidth(int column)";
    private static final String m_method_createMeasureBasedRowHeightRule = "createMeasureBasedRowHeightRule(String measureDim, Object measureDimMember, int height)";
    private static final String m_method_createMeasureBasedColumnWidthRule = "createMeasureBasedColumnWidthRule(String measureDim, Object measureDimMember, int width)";
    private static final String m_method__createRule = "_createRule(QDR ruleQDR, RuleBundle bundle, int size, int ruleApplication, int qdrDiscSetOperator)";
    private static final String m_method__getSize = "_getSize(QDR qdr, RuleBundle bundle, ViewSizing vs, int application)";
    private static final String m_method_createPreferredColumnHeaderRowHeightsCache = "createPreferredColumnHeaderRowHeightsCache()";
    private static final String m_method_createPreferredRowHeaderColumnWidthsCache = "createPreferredRowHeaderColumnWidthsCache()";

    public CrosstabRuleSizing(GridViewCommon gv) {
        super(gv);
        if (gv instanceof Crosstab) {
            this.m_crosstab = (Crosstab)gv;
        }
    }

    @Override
    public void dataSourceChanged() {
        super.dataSourceChanged();
        this.clearPreferredColumnHeaderRowHeightsCache();
        this.clearPreferredRowHeaderColumnWidthsCache();
    }

    @Override
    public void setPreferredRowHeight(int row, int height) {
        if (this.m_gridView.getModel() == null) {
            this.m_gridView.getErrorHandler().log("null Model", this.getClass().getName(), m_method_setPreferredRowHeight);
            return;
        }
        int rowCount = 0;
        try {
            rowCount = this.m_gridView.getModel().getDataAccess().getEdgeExtent(1);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_gridView.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_setPreferredRowHeight);
        }
        if (row < 0 || row >= rowCount) {
            this.m_gridView.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_setPreferredRowHeight);
            return;
        }
        if (height < 0 && height != -1) {
            this.m_gridView.getErrorHandler().log("invalid row height", this.getClass().getName(), m_method_setPreferredRowHeight);
            return;
        }
        DataAccess dataAccess = null;
        dataAccess = this.m_gridView.getModel().getDataAccess();
        if (dataAccess == null) {
            this.m_gridView.getErrorHandler().log("null DataAccess", this.getClass().getName(), m_method_setPreferredRowHeight);
            return;
        }
        if (this.rci == null) {
            this.rci = new RowComponentInfo(row);
        } else {
            this.rci.setRow(row);
        }
        QDR rowQDR = this.rci.getQDR(dataAccess, 0);
        if (rowQDR == null) {
            this.m_gridView.getErrorHandler().log("null QDR", this.getClass().getName(), m_method_setPreferredRowHeight);
            this.setCalculatedRowHeight(row, height);
            return;
        }
        this.getPreferredRowHeightsCache()[row] = height;
        this.createIndividualRowHeightRule(rowQDR, height);
    }

    @Override
    public int getPreferredRowHeight(int row) {
        if (this.m_gridView.getModel() == null) {
            this.m_gridView.getErrorHandler().log("null Model", this.getClass().getName(), m_method_getPreferredRowHeight);
            return -1;
        }
        int rowCount = 0;
        try {
            rowCount = this.m_gridView.getModel().getDataAccess().getEdgeExtent(1);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_gridView.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_getPreferredRowHeight);
        }
        if (row < 0 || row >= rowCount) {
            this.m_gridView.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getPreferredRowHeight);
            return -1;
        }
        if (this.m_preferredRowHeightsCache != null && this.m_preferredRowHeightsCache[row] != -2) {
            return this.m_preferredRowHeightsCache[row];
        }
        if (this.m_gridView.getWaitDataForRow(row) != null) {
            return -1;
        }
        int height = -1;
        if (this.m_preferredRowHeights != null && this.m_preferredRowHeights.getCount() > 0) {
            DataAccess dataAccess = null;
            dataAccess = this.m_gridView.getModel().getDataAccess();
            if (dataAccess == null) {
                this.m_gridView.getErrorHandler().log("null DataAccess", this.getClass().getName(), m_method_getPreferredRowHeight);
                return -1;
            }
            if (this.rci == null) {
                this.rci = new RowComponentInfo(row);
            } else {
                this.rci.setRow(row);
            }
            QDR rowQDR = this.rci.getQDR(dataAccess, 0);
            if (rowQDR == null) {
                this.m_gridView.getErrorHandler().log("null QDR", this.getClass().getName(), m_method_getPreferredRowHeight);
                return -1;
            }
            height = this._getSize(rowQDR, this.getPreferredRowHeights(), 0);
        }
        this.getPreferredRowHeightsCache()[row] = height;
        return height;
    }

    @Override
    public void setPreferredColumnWidth(int column, int width) {
        if (this.m_gridView.getModel() == null) {
            this.m_gridView.getErrorHandler().log("null Model", this.getClass().getName(), m_method_setPreferredColumnWidth);
            return;
        }
        int colCount = 0;
        try {
            colCount = this.m_gridView.getModel().getDataAccess().getEdgeExtent(0);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_gridView.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_setPreferredColumnWidth);
        }
        if (column < 0 || column >= colCount) {
            this.m_gridView.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_setPreferredColumnWidth);
            return;
        }
        if (width < 0 && width != -1) {
            this.m_gridView.getErrorHandler().log("invalid column height", this.getClass().getName(), m_method_setPreferredColumnWidth);
            return;
        }
        DataAccess dataAccess = null;
        dataAccess = this.m_gridView.getModel().getDataAccess();
        if (dataAccess == null) {
            this.m_gridView.getErrorHandler().log("null DataAccess", this.getClass().getName(), m_method_setPreferredColumnWidth);
            return;
        }
        if (this.cci == null) {
            this.cci = new ColumnComponentInfo(column);
        } else {
            this.cci.setColumn(column);
        }
        QDR qdr = this.cci.getQDR(dataAccess, 1);
        if (qdr == null) {
            this.m_gridView.getErrorHandler().log("null QDR", this.getClass().getName(), m_method_setPreferredColumnWidth);
            this.setDefaultColumnWidth(width);
            return;
        }
        this.createPreferredColumnWidthsCache();
        this.getPreferredColumnWidthsCache()[column] = width;
        if (this.m_crosstab != null && this.m_crosstab.isTotalSlice(0, column)) {
            CompositeDiscriminator compDisc = new CompositeDiscriminator((Discriminator)new TotalsDiscriminator(), null, 2);
            this._createRule(qdr, this.getPreferredColumnWidths(), width, 1, 4, (Discriminator)this.getCompNotTotalsDiscriminator(), true);
            return;
        }
        QDRMember measureMember = qdr.getDimMember(qdr.getMeasureDim());
        if (measureMember == null) {
            this.setDefaultNonTotalColumnWidth(width);
            return;
        }
        this.createMeasureBasedColumnWidthRule(qdr.getMeasureDim(), measureMember, width);
    }

    @Override
    public int getPreferredColumnWidth(int column) {
        if (this.m_gridView.getModel() == null) {
            this.m_gridView.getErrorHandler().log("null Model", this.getClass().getName(), m_method_getPreferredColumnWidth);
            return -1;
        }
        int colCount = 0;
        try {
            colCount = this.m_gridView.getModel().getDataAccess().getEdgeExtent(0);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_gridView.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_getPreferredColumnWidth);
        }
        if (column < 0 || column >= colCount) {
            this.m_gridView.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getPreferredColumnWidth);
            return -1;
        }
        if (this.m_preferredColumnWidthsCache != null && this.m_preferredColumnWidthsCache[column] != -2) {
            return this.m_preferredColumnWidthsCache[column];
        }
        int width = -1;
        if (this.m_preferredColumnWidths != null && this.m_preferredColumnWidths.getCount() > 0 || this.m_defNonTotalColWidthBundle != null) {
            DataAccess dataAccess = null;
            dataAccess = this.m_gridView.getModel().getDataAccess();
            if (dataAccess == null) {
                this.m_gridView.getErrorHandler().log("null DataAccess", this.getClass().getName(), m_method_getPreferredColumnWidth);
                return -1;
            }
            if (this.cci == null) {
                this.cci = new ColumnComponentInfo(column);
            } else {
                this.cci.setColumn(column);
            }
            QDR qdr = this.cci.getQDR(dataAccess, 1);
            if (qdr == null) {
                this.m_gridView.getErrorHandler().log("null QDR", this.getClass().getName(), m_method_getPreferredColumnWidth);
                return -1;
            }
            RuleContext context = new RuleContext();
            if (this.m_crosstab != null && this.m_crosstab.isTotalSlice(0, column)) {
                context.put((Object)"TOTALS_RELATION", (Object)1);
            } else {
                context.put((Object)"TOTALS_RELATION", (Object)0);
            }
            width = this._getSize(qdr, this.getPreferredColumnWidths(), 1, context);
        }
        this.getPreferredColumnWidthsCache()[column] = width;
        return width;
    }

    @Override
    public void setDefaultColumnWidth(int width) {
        this.m_defNonTotalColWidthBundle = null;
        super.setDefaultColumnWidth(width);
    }

    protected void setDefaultNonTotalColumnWidth(int width) {
        ViewSizing vs = new ViewSizing(-1, -1);
        vs.setColumnWidth(width);
        DiscriminatorRule discRule = new DiscriminatorRule((Discriminator)this.getTotalsDiscriminator(), (Mergeable)vs);
        this.m_defNonTotalColWidthBundle = new RuleBundle();
        this.m_defNonTotalColWidthBundle.addRule((Rule)discRule);
        this.m_gridView.updateSizes(1);
    }

    protected int getDefaultNonTotalColumnWidth() {
        ViewSizing vs;
        Mergeable m;
        Rule rule;
        if (this.m_defNonTotalColWidthBundle != null && this.m_defNonTotalColWidthBundle.getCount() > 0 && (rule = this.m_defNonTotalColWidthBundle.getRule(0)) != null && (m = rule.getFixedMergeable()) != null && m instanceof ViewSizing && (vs = (ViewSizing)m).isColumnWidthUsed()) {
            return vs.getColumnWidth();
        }
        return -1;
    }

    @Override
    public void clearCalculatedSizes() {
        super.clearCalculatedSizes();
        this.m_calculatedColumnHeaderRowHeights = null;
        this.m_calculatedRowHeaderColumnWidths = null;
    }

    @Override
    public void clearPreferredSizes() {
        super.clearPreferredSizes();
        this.m_preferredColumnHeaderRowHeights = null;
        this.m_preferredRowHeaderColumnWidths = null;
        this.clearPreferredColumnHeaderRowHeightsCache();
        this.clearPreferredRowHeaderColumnWidthsCache();
    }

    @Override
    public void dataChanged() {
        super.dataChanged();
        this.clearPreferredColumnHeaderRowHeightsCache();
        this.clearPreferredRowHeaderColumnWidthsCache();
    }

    @Override
    public Object clone() {
        CrosstabRuleSizing crs = new CrosstabRuleSizing(this.m_gridView);
        CrosstabRuleSizing.copyMembersForClone(this, crs);
        return crs;
    }

    @Override
    public void setCalculatedColumnHeaderRowHeight(int row, int height) {
        if (this.m_calculatedColumnHeaderRowHeights == null) {
            int layerCount = 0;
            try {
                layerCount = this.m_gridView.getModel().getDataAccess().getLayerCount(0);
            }
            catch (EdgeOutOfRangeException e) {
                this.m_gridView.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_setCalculatedColumnHeaderRowHeight);
            }
            this.m_calculatedColumnHeaderRowHeights = new int[layerCount];
            for (int i = 0; i < this.m_calculatedColumnHeaderRowHeights.length; ++i) {
                this.m_calculatedColumnHeaderRowHeights[i] = -1;
            }
        }
        if (row < 0 || row > this.m_calculatedColumnHeaderRowHeights.length - 1) {
            this.m_gridView.getErrorHandler().log("row out of range", this.getClass().getName(), m_method_setCalculatedColumnHeaderRowHeight);
            return;
        }
        if (height < 0 && height != -1) {
            this.m_gridView.getErrorHandler().log("invalid height", this.getClass().getName(), m_method_setCalculatedColumnHeaderRowHeight);
            return;
        }
        this.m_calculatedColumnHeaderRowHeights[row] = height;
    }

    @Override
    public int getCalculatedColumnHeaderRowHeight(int row) {
        if (this.m_calculatedColumnHeaderRowHeights != null) {
            if (row < 0 || row > this.m_calculatedColumnHeaderRowHeights.length - 1) {
                this.m_gridView.getErrorHandler().log("row out of range", this.getClass().getName(), m_method_setCalculatedColumnHeaderRowHeight);
                return -1;
            }
            return this.m_calculatedColumnHeaderRowHeights[row];
        }
        return -1;
    }

    @Override
    public void setCalculatedRowHeaderColumnWidth(int column, int width) {
        if (this.m_calculatedRowHeaderColumnWidths == null) {
            int layerCount = 0;
            try {
                layerCount = this.m_gridView.getModel().getDataAccess().getLayerCount(1);
            }
            catch (EdgeOutOfRangeException e) {
                this.m_gridView.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_setCalculatedRowHeaderColumnWidth);
            }
            this.m_calculatedRowHeaderColumnWidths = new int[layerCount];
            for (int i = 0; i < this.m_calculatedRowHeaderColumnWidths.length; ++i) {
                this.m_calculatedRowHeaderColumnWidths[i] = -1;
            }
        }
        if (column < 0 || column > this.m_calculatedRowHeaderColumnWidths.length - 1) {
            this.m_gridView.getErrorHandler().log("column out of range", this.getClass().getName(), m_method_setCalculatedRowHeaderColumnWidth);
            return;
        }
        if (width < 0 && width != -1) {
            this.m_gridView.getErrorHandler().log("invalid width", this.getClass().getName(), m_method_setCalculatedRowHeaderColumnWidth);
            return;
        }
        this.m_calculatedRowHeaderColumnWidths[column] = width;
    }

    @Override
    public int getCalculatedRowHeaderColumnWidth(int column) {
        if (this.m_calculatedRowHeaderColumnWidths != null) {
            if (column < 0 || column > this.m_calculatedRowHeaderColumnWidths.length - 1) {
                this.m_gridView.getErrorHandler().log("column out of range", this.getClass().getName(), m_method_setCalculatedRowHeaderColumnWidth);
                return -1;
            }
            return this.m_calculatedRowHeaderColumnWidths[column];
        }
        return -1;
    }

    @Override
    public void setPreferredColumnHeaderRowHeight(int row, int height) {
        if (this.m_gridView.getModel() == null) {
            this.m_gridView.getErrorHandler().log("null Model", this.getClass().getName(), m_method_setPreferredColumnHeaderRowHeight);
            return;
        }
        int layerCount = 0;
        try {
            layerCount = this.m_gridView.getModel().getDataAccess().getLayerCount(0);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_gridView.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_setPreferredColumnHeaderRowHeight);
        }
        if (row < 0 || row >= layerCount) {
            this.m_gridView.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_setPreferredColumnHeaderRowHeight);
            return;
        }
        if (height < 0 && height != -1) {
            this.m_gridView.getErrorHandler().log("invalid row height", this.getClass().getName(), m_method_setPreferredColumnHeaderRowHeight);
            return;
        }
        DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
        if (dataAccess == null) {
            this.m_gridView.getErrorHandler().log("null DataAccess", this.getClass().getName(), m_method_setPreferredColumnHeaderRowHeight);
            return;
        }
        QDR rowQDR = null;
        try {
            rowQDR = dataAccess.getLayerQDR(0, row, 0);
        }
        catch (EdgeOutOfRangeException eoore) {
            this.m_gridView.getErrorHandler().error((Throwable)eoore, this.getClass().getName(), m_method_setPreferredColumnHeaderRowHeight);
            return;
        }
        catch (LayerOutOfRangeException loore) {
            this.m_gridView.getErrorHandler().error((Throwable)loore, this.getClass().getName(), m_method_setPreferredColumnHeaderRowHeight);
            return;
        }
        if (rowQDR == null) {
            this.m_gridView.getErrorHandler().log("null QDR", this.getClass().getName(), m_method_setPreferredColumnHeaderRowHeight);
            return;
        }
        this.getPreferredColumnHeaderRowHeightsCache()[row] = height;
        this.createLayerBasedColumnHeaderRowHeightRule(rowQDR, height);
    }

    @Override
    public int getPreferredColumnHeaderRowHeight(int row) {
        if (this.m_gridView.getModel() == null) {
            this.m_gridView.getErrorHandler().log("null Model", this.getClass().getName(), m_method_getPreferredColumnHeaderRowHeight);
            return -1;
        }
        int layerCount = 0;
        try {
            layerCount = this.m_gridView.getModel().getDataAccess().getLayerCount(0);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_gridView.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_getPreferredColumnHeaderRowHeight);
        }
        if (row < 0 || row >= layerCount) {
            this.m_gridView.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getPreferredColumnHeaderRowHeight);
            return -1;
        }
        if (this.m_preferredColumnHeaderRowHeightsCache != null && this.m_preferredColumnHeaderRowHeightsCache[row] != -2) {
            return this.m_preferredColumnHeaderRowHeightsCache[row];
        }
        int height = -1;
        if (this.m_preferredColumnHeaderRowHeights != null && this.m_preferredColumnHeaderRowHeights.getCount() > 0) {
            DataAccess dataAccess = null;
            dataAccess = this.m_gridView.getModel().getDataAccess();
            if (dataAccess == null) {
                this.m_gridView.getErrorHandler().log("null DataAccess", this.getClass().getName(), m_method_getPreferredColumnHeaderRowHeight);
                return -1;
            }
            QDR rowQDR = null;
            try {
                rowQDR = dataAccess.getLayerQDR(0, row, 0);
            }
            catch (EdgeOutOfRangeException eoore) {
                this.m_gridView.getErrorHandler().error((Throwable)eoore, this.getClass().getName(), m_method_getPreferredColumnHeaderRowHeight);
                return -1;
            }
            catch (LayerOutOfRangeException loore) {
                this.m_gridView.getErrorHandler().error((Throwable)loore, this.getClass().getName(), m_method_getPreferredColumnHeaderRowHeight);
                return -1;
            }
            if (rowQDR == null) {
                this.m_gridView.getErrorHandler().log("null QDR", this.getClass().getName(), m_method_getPreferredColumnHeaderRowHeight);
                return -1;
            }
            height = this._getSize(rowQDR, this.getPreferredColumnHeaderRowHeights(), 2);
        }
        this.getPreferredColumnHeaderRowHeightsCache()[row] = height;
        return height;
    }

    @Override
    public void setPreferredRowHeaderColumnWidth(int column, int width) {
        if (this.m_gridView.getModel() == null) {
            this.m_gridView.getErrorHandler().log("null Model", this.getClass().getName(), m_method_setPreferredRowHeaderColumnWidth);
            return;
        }
        int layerCount = 0;
        try {
            layerCount = this.m_gridView.getModel().getDataAccess().getLayerCount(1);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_gridView.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_setPreferredRowHeaderColumnWidth);
        }
        if (column < 0 || column >= layerCount) {
            this.m_gridView.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_setPreferredRowHeaderColumnWidth);
            return;
        }
        if (width < 0 && width != -1) {
            this.m_gridView.getErrorHandler().log("invalid column width", this.getClass().getName(), m_method_setPreferredRowHeaderColumnWidth);
            return;
        }
        DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
        if (dataAccess == null) {
            this.m_gridView.getErrorHandler().log("null DataAccess", this.getClass().getName(), m_method_setPreferredRowHeaderColumnWidth);
            return;
        }
        QDR columnQDR = null;
        try {
            columnQDR = dataAccess.getLayerQDR(1, column, 0);
        }
        catch (EdgeOutOfRangeException eoore) {
            this.m_gridView.getErrorHandler().error((Throwable)eoore, this.getClass().getName(), m_method_setPreferredRowHeaderColumnWidth);
            return;
        }
        catch (LayerOutOfRangeException loore) {
            this.m_gridView.getErrorHandler().error((Throwable)loore, this.getClass().getName(), m_method_setPreferredRowHeaderColumnWidth);
            return;
        }
        if (columnQDR == null) {
            this.m_gridView.getErrorHandler().log("null QDR", this.getClass().getName(), m_method_setPreferredRowHeaderColumnWidth);
            return;
        }
        this.getPreferredRowHeaderColumnWidthsCache()[column] = width;
        this.createLayerBasedRowHeaderColumnWidthRule(columnQDR, width);
    }

    @Override
    public int getPreferredRowHeaderColumnWidth(int column) {
        if (this.m_gridView.getModel() == null) {
            this.m_gridView.getErrorHandler().log("null Model", this.getClass().getName(), m_method_getPreferredRowHeaderColumnWidth);
            return -1;
        }
        int layerCount = 0;
        try {
            layerCount = this.m_gridView.getModel().getDataAccess().getLayerCount(1);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_gridView.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_getPreferredRowHeaderColumnWidth);
        }
        if (column < 0 || column >= layerCount) {
            this.m_gridView.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getPreferredRowHeaderColumnWidth);
            return -1;
        }
        if (this.m_preferredRowHeaderColumnWidthsCache != null && this.m_preferredRowHeaderColumnWidthsCache[column] != -2) {
            return this.m_preferredRowHeaderColumnWidthsCache[column];
        }
        int width = -1;
        if (this.m_preferredRowHeaderColumnWidths != null && this.m_preferredRowHeaderColumnWidths.getCount() > 0) {
            DataAccess dataAccess = null;
            dataAccess = this.m_gridView.getModel().getDataAccess();
            if (dataAccess == null) {
                this.m_gridView.getErrorHandler().log("null DataAccess", this.getClass().getName(), m_method_getPreferredRowHeaderColumnWidth);
                return -1;
            }
            QDR columnQDR = null;
            try {
                columnQDR = dataAccess.getLayerQDR(1, column, 0);
            }
            catch (EdgeOutOfRangeException eoore) {
                this.m_gridView.getErrorHandler().error((Throwable)eoore, this.getClass().getName(), m_method_getPreferredRowHeaderColumnWidth);
                return -1;
            }
            catch (LayerOutOfRangeException loore) {
                this.m_gridView.getErrorHandler().error((Throwable)loore, this.getClass().getName(), m_method_getPreferredRowHeaderColumnWidth);
                return -1;
            }
            if (columnQDR == null) {
                this.m_gridView.getErrorHandler().log("null QDR", this.getClass().getName(), m_method_getPreferredRowHeaderColumnWidth);
                return -1;
            }
            width = this._getSize(columnQDR, this.getPreferredRowHeaderColumnWidths(), 3);
        }
        this.getPreferredRowHeaderColumnWidthsCache()[column] = width;
        return width;
    }

    @Override
    public int getColumnHeaderRowHeight(int row) {
        int desiredHeight = this.getPreferredColumnHeaderRowHeight(row);
        if (desiredHeight == -1 && (desiredHeight = this.getCalculatedColumnHeaderRowHeight(row)) == -1) {
            desiredHeight = this.getDefaultColumnHeaderRowHeight();
        }
        if (desiredHeight < this.m_gridView.getCellMinHeight()) {
            desiredHeight = this.m_gridView.getCellMinHeight();
        }
        if (desiredHeight > this.m_gridView.getCellMaxHeight()) {
            desiredHeight = this.m_gridView.getCellMaxHeight();
        }
        return desiredHeight;
    }

    @Override
    public int getRowHeaderColumnWidth(int column) {
        int desiredWidth = this.getPreferredRowHeaderColumnWidth(column);
        if (desiredWidth == -1 && (desiredWidth = this.getCalculatedRowHeaderColumnWidth(column)) == -1) {
            desiredWidth = this.getDefaultRowHeaderColumnWidth();
        }
        if (desiredWidth < this.m_gridView.getCellMinWidth()) {
            desiredWidth = this.m_gridView.getCellMinWidth();
        }
        if (desiredWidth > this.m_gridView.getCellMaxWidth()) {
            desiredWidth = this.m_gridView.getCellMaxWidth();
        }
        return desiredWidth;
    }

    public void setContext(Hashtable context) {
        this.m_context = context;
    }

    public ObjectNode getXML(boolean allProperties) {
        int width;
        ObjectNode node = new ObjectNode("SizingManager");
        boolean nodeExists = false;
        if (allProperties || this.getDefaultColumnWidth() != this.d_defaultColumnWidth) {
            node.addProperty("defColW", this.getDefaultColumnWidth());
            nodeExists = true;
        }
        if (allProperties || this.getDefaultRowHeight() != this.d_defaultRowHeight) {
            node.addProperty("defRowH", this.getDefaultRowHeight());
            nodeExists = true;
        }
        if (allProperties || this.getDefaultColumnHeaderRowHeight() != this.d_defaultColumnHeaderRowHeight) {
            node.addProperty("defColHdrRowH", this.getDefaultColumnHeaderRowHeight());
            nodeExists = true;
        }
        if (allProperties || this.getDefaultRowHeaderColumnWidth() != this.d_defaultRowHeaderColumnWidth) {
            node.addProperty("defRowHdrColW", this.getDefaultRowHeaderColumnWidth());
            nodeExists = true;
        }
        if ((allProperties || this.m_defNonTotalColWidthBundle != null) && this.m_defNonTotalColWidthBundle != null && (width = this.getDefaultNonTotalColumnWidth()) != -1) {
            node.addProperty(a_defNonTotColW, this.getDefaultNonTotalColumnWidth());
            nodeExists = true;
        }
        ContainerNode columnBundleXML = new ContainerNode("ColBundle");
        boolean colXMLExists = false;
        if (this.m_preferredColumnWidths != null) {
            for (int i = 0; i < this.m_preferredColumnWidths.getCount(); ++i) {
                ObjectNode descRuleXML = new ObjectNode("SizingDiscRule");
                DiscriminatorRule rule = (DiscriminatorRule)this.m_preferredColumnWidths.getRule(i);
                if (this.m_context != null) {
                    rule.setContext(this.m_context);
                }
                if (rule.getDiscriminator() instanceof DiscriminatorXML) {
                    ObjectNode discXML = ((DiscriminatorXML)rule.getDiscriminator()).getXML(allProperties, null, true);
                    descRuleXML.addProperty(discXML);
                    descRuleXML.addProperty("ColW", ((ViewSizing)rule.getFixedMergeable()).getColumnWidth(), false);
                    if (rule == null) continue;
                    columnBundleXML.addContainedObject((BaseNode)descRuleXML);
                    colXMLExists = true;
                    continue;
                }
                this.m_gridView.getErrorHandler().log("could not save discriminator XML", this.getClass().getName(), "getXML(boolean allProperties)");
            }
        }
        if (colXMLExists) {
            node.addContainer(columnBundleXML);
            nodeExists = true;
        }
        ContainerNode rowBundleXML = new ContainerNode("RowBundle");
        boolean rowXMLExists = false;
        if (this.m_preferredRowHeights != null) {
            for (int i = 0; i < this.m_preferredRowHeights.getCount(); ++i) {
                ObjectNode descRuleXML = new ObjectNode("SizingDiscRule");
                DiscriminatorRule rule = (DiscriminatorRule)this.m_preferredRowHeights.getRule(i);
                if (this.m_context != null) {
                    rule.setContext(this.m_context);
                }
                ObjectNode qdrXML = ((QDRDiscriminator)rule.getDiscriminator()).getXML(allProperties, null, true);
                descRuleXML.addProperty(qdrXML);
                descRuleXML.addProperty("RowH", ((ViewSizing)rule.getFixedMergeable()).getRowHeight(), false);
                if (rule == null) continue;
                rowBundleXML.addContainedObject((BaseNode)descRuleXML);
                rowXMLExists = true;
            }
        }
        if (rowXMLExists) {
            node.addContainer(rowBundleXML);
            nodeExists = true;
        }
        ContainerNode colHdrBundleXML = new ContainerNode(COLUMN_HEADER_BUNDLE_NAME);
        boolean colHrdXMLExists = false;
        if (this.m_preferredColumnHeaderRowHeights != null) {
            for (int i = 0; i < this.m_preferredColumnHeaderRowHeights.getCount(); ++i) {
                ObjectNode descRuleXML = new ObjectNode("SizingDiscRule");
                DiscriminatorRule rule = (DiscriminatorRule)this.m_preferredColumnHeaderRowHeights.getRule(i);
                if (this.m_context != null) {
                    rule.setContext(this.m_context);
                }
                ObjectNode qdrXML = ((QDRDiscriminator)rule.getDiscriminator()).getXML(allProperties, null, true);
                descRuleXML.addProperty(qdrXML);
                descRuleXML.addProperty("RowH", ((ViewSizing)rule.getFixedMergeable()).getRowHeight(), false);
                if (rule == null) continue;
                colHdrBundleXML.addContainedObject((BaseNode)descRuleXML);
                colHrdXMLExists = true;
            }
        }
        if (colHrdXMLExists) {
            node.addContainer(colHdrBundleXML);
            nodeExists = true;
        }
        ContainerNode rowHdrBundleXML = new ContainerNode(ROW_HEADER_BUNDLE_NAME);
        boolean rowHrdXMLExists = false;
        if (this.m_preferredRowHeaderColumnWidths != null) {
            for (int i = 0; i < this.m_preferredRowHeaderColumnWidths.getCount(); ++i) {
                ObjectNode descRuleXML = new ObjectNode("SizingDiscRule");
                DiscriminatorRule rule = (DiscriminatorRule)this.m_preferredRowHeaderColumnWidths.getRule(i);
                if (this.m_context != null) {
                    rule.setContext(this.m_context);
                }
                ObjectNode qdrXML = ((QDRDiscriminator)rule.getDiscriminator()).getXML(allProperties, null, true);
                descRuleXML.addProperty(qdrXML);
                descRuleXML.addProperty("ColW", ((ViewSizing)rule.getFixedMergeable()).getColumnWidth(), false);
                if (rule == null) continue;
                rowHdrBundleXML.addContainedObject((BaseNode)descRuleXML);
                rowHrdXMLExists = true;
            }
        }
        if (rowHrdXMLExists) {
            node.addContainer(rowHdrBundleXML);
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    public void setXML(ObjectNode node) {
        ContainerNode rowHdrBundleXML;
        ContainerNode colHdrBundleXML;
        ContainerNode rowBundleXML;
        ContainerNode columnBundleXML;
        PropertyNode pNode;
        XMLContext xmlContext = this.m_context != null && this.m_context.containsKey("xml_context") ? (XMLContext)this.m_context.get("xml_context") : new XMLContext(new ObjectScope(), false);
        if (xmlContext.getScope() == null) {
            xmlContext.setScope(new ObjectScope());
        }
        if ((pNode = node.getProperty("defColW")) != null) {
            this.setDefaultColumnWidth(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("defRowH")) != null) {
            this.setDefaultRowHeight(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("defColHdrRowH")) != null) {
            this.setDefaultColumnHeaderRowHeight(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("defRowHdrColW")) != null) {
            this.setDefaultRowHeaderColumnWidth(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_defNonTotColW)) != null) {
            this.setDefaultNonTotalColumnWidth(pNode.getValueAsInteger());
        }
        if ((columnBundleXML = node.getContainer("ColBundle")) != null) {
            if (this.m_preferredColumnWidths == null) {
                this.m_preferredColumnWidths = new RuleBundle();
            }
            Enumeration e = columnBundleXML.getContainedObject();
            while (e.hasMoreElements()) {
                PropertyNode columnWidthNode;
                ObjectNode discriminatorRuleNode = (ObjectNode)e.nextElement();
                if (discriminatorRuleNode == null) continue;
                ObjectNode discXML = discriminatorRuleNode.getPropertyValueAsObjectNode();
                if (discXML.getName() == "QDRDisc") {
                    QDRDiscriminator qdrDisc = new QDRDiscriminator();
                    qdrDisc.setXML(discXML, null, null, 0);
                    QDR qdr = qdrDisc.getQDR();
                    columnWidthNode = discriminatorRuleNode.getProperty("ColW");
                    if (columnWidthNode == null) continue;
                    this._createRule(qdr, this.getPreferredColumnWidths(), columnWidthNode.getValueAsInteger(), 1, 4);
                    continue;
                }
                if (!discXML.getName().equals("ComposDisc")) continue;
                CompositeDiscriminator composDisc = new CompositeDiscriminator();
                if (this.m_context != null) {
                    composDisc.setContext(this.m_context);
                }
                boolean result = composDisc.setXML(discXML, null, null, 0);
                columnWidthNode = discriminatorRuleNode.getProperty("ColW");
                if (columnWidthNode == null) continue;
                ViewSizing vs = new ViewSizing(-1, -1);
                vs.setColumnWidth(columnWidthNode.getValueAsInteger());
                this.getPreferredColumnWidths().addRule((Rule)new DiscriminatorRule((Discriminator)composDisc, (Mergeable)vs));
            }
        }
        if ((rowBundleXML = node.getContainer("RowBundle")) != null) {
            if (this.m_preferredRowHeights == null) {
                this.m_preferredRowHeights = new RuleBundle();
            }
            Enumeration e = rowBundleXML.getContainedObject();
            while (e.hasMoreElements()) {
                ObjectNode discriminatorRuleNode = (ObjectNode)e.nextElement();
                if (discriminatorRuleNode == null) continue;
                ObjectNode QDRDiscXML = discriminatorRuleNode.getPropertyValueAsObjectNode("QDRDisc", true);
                QDRDiscriminator qdrDisc = new QDRDiscriminator();
                qdrDisc.setXML(QDRDiscXML, null, null, 0);
                QDR qdr = qdrDisc.getQDR();
                PropertyNode rowHeightNode = discriminatorRuleNode.getProperty("RowH");
                if (rowHeightNode == null) continue;
                this._createRule(qdr, this.getPreferredRowHeights(), rowHeightNode.getValueAsInteger(), 0, 3);
            }
        }
        if ((colHdrBundleXML = node.getContainer(COLUMN_HEADER_BUNDLE_NAME)) != null) {
            if (this.m_preferredColumnHeaderRowHeights == null) {
                this.m_preferredColumnHeaderRowHeights = new RuleBundle();
            }
            Enumeration e = colHdrBundleXML.getContainedObject();
            while (e.hasMoreElements()) {
                ObjectNode discriminatorRuleNode = (ObjectNode)e.nextElement();
                if (discriminatorRuleNode == null) continue;
                ObjectNode QDRDiscXML = discriminatorRuleNode.getPropertyValueAsObjectNode("QDRDisc", true);
                QDRDiscriminator qdrDisc = new QDRDiscriminator();
                qdrDisc.setXML(QDRDiscXML, null, null, 0);
                QDR qdr = qdrDisc.getQDR();
                PropertyNode rowHeightNode = discriminatorRuleNode.getProperty("RowH");
                if (rowHeightNode == null) continue;
                this._createRule(qdr, this.getPreferredColumnHeaderRowHeights(), rowHeightNode.getValueAsInteger(), 2, 3);
            }
        }
        if ((rowHdrBundleXML = node.getContainer(ROW_HEADER_BUNDLE_NAME)) != null) {
            if (this.m_preferredRowHeaderColumnWidths == null) {
                this.m_preferredRowHeaderColumnWidths = new RuleBundle();
            }
            Enumeration e = rowHdrBundleXML.getContainedObject();
            while (e.hasMoreElements()) {
                ObjectNode discriminatorRuleNode = (ObjectNode)e.nextElement();
                if (discriminatorRuleNode == null) continue;
                ObjectNode QDRDiscXML = discriminatorRuleNode.getPropertyValueAsObjectNode("QDRDisc", true);
                QDRDiscriminator qdrDisc = new QDRDiscriminator();
                qdrDisc.setXML(QDRDiscXML, null, null, 0);
                QDR qdr = qdrDisc.getQDR();
                PropertyNode colWidthNode = discriminatorRuleNode.getProperty("ColW");
                if (colWidthNode == null) continue;
                this._createRule(qdr, this.getPreferredRowHeaderColumnWidths(), colWidthNode.getValueAsInteger(), 3, 3);
            }
        }
        this.clearPreferredRowHeightsCache();
        this.clearPreferredColumnWidthsCache();
        this.clearPreferredColumnHeaderRowHeightsCache();
        this.clearPreferredRowHeaderColumnWidthsCache();
        this.m_gridView.doSizing();
    }

    protected void createLayerBasedColumnHeaderRowHeightRule(QDR layerQDR, int height) {
        this._createRule(layerQDR, this.getPreferredColumnHeaderRowHeights(), height, 2, 3);
    }

    protected void createLayerBasedRowHeaderColumnWidthRule(QDR layerQDR, int width) {
        this._createRule(layerQDR, this.getPreferredRowHeaderColumnWidths(), width, 3, 3);
    }

    protected void createMeasureBasedColumnWidthRule(String measureDim, Object measureDimMember, int width) {
        QDR ruleQDR = null;
        if (measureDimMember instanceof QDRMember) {
            QDRMember measDimMem = (QDRMember)measureDimMember;
            QDRMember newMeasDimMem = new QDRMember(measDimMem.getType(), measDimMem.getData());
            ruleQDR = new QDR(measureDim, measureDim, newMeasDimMem);
        } else if (measureDimMember instanceof String) {
            ruleQDR = new QDR(measureDim, measureDim, (String)measureDimMember);
        } else {
            this.m_gridView.getErrorHandler().log("invalid type for measureDimMember", this.getClass().getName(), m_method_createMeasureBasedColumnWidthRule);
            return;
        }
        this._createRule(ruleQDR, this.getPreferredColumnWidths(), width, 1, 4, (Discriminator)this.getTotalsDiscriminator(), false);
    }

    protected void createMeasureBasedRowHeightRule(String measureDim, Object measureDimMember, int height) {
        QDR ruleQDR = null;
        if (measureDimMember instanceof QDRMember) {
            QDRMember measDimMem = (QDRMember)measureDimMember;
            QDRMember newMeasDimMem = new QDRMember(measDimMem.getType(), measDimMem.getData());
            ruleQDR = new QDR(measureDim, measureDim, newMeasDimMem);
        } else if (measureDimMember instanceof String) {
            ruleQDR = new QDR(measureDim, measureDim, (String)measureDimMember);
        } else {
            this.m_gridView.getErrorHandler().log("invalid type for measureDimMember", this.getClass().getName(), m_method_createMeasureBasedRowHeightRule);
            return;
        }
        this._createRule(ruleQDR, this.getPreferredRowHeights(), height, 0, 4);
    }

    protected void createIndividualRowHeightRule(QDR rowQDR, int height) {
        this._createRule(rowQDR, this.getPreferredRowHeights(), height, 0, 3);
    }

    private int _getSize(QDR qdr, RuleBundle bundle, int application) {
        return this._getSize(qdr, bundle, application, null);
    }

    private int _getSize(QDR qdr, RuleBundle bundle, int application, RuleContext context) {
        if (context == null) {
            context = new RuleContext();
        }
        context.put((Object)"QDR", (Object)qdr);
        ViewSizing result = null;
        ViewSizing defaultVS = new ViewSizing(-1, -1);
        if (application == 1 && this.m_defNonTotalColWidthBundle != null) {
            Vector<RuleBundle> v = new Vector<RuleBundle>();
            v.add(this.m_defNonTotalColWidthBundle);
            v.add(bundle);
            result = (ViewSizing)ResolutionService.resolveRules((RuleContext)context, (Mergeable)defaultVS, v);
        } else {
            result = (ViewSizing)ResolutionService.resolveRules((RuleContext)context, (Mergeable)defaultVS, (RuleBundle)bundle);
        }
        if (result == null) {
            this.m_gridView.getErrorHandler().log("RuleException when resolving rules", this.getClass().getName(), m_method__getSize);
            return -1;
        }
        switch (application) {
            case 1: 
            case 3: {
                if (!result.isColumnWidthUsed()) break;
                return result.getColumnWidth();
            }
            case 0: 
            case 2: {
                if (!result.isRowHeightUsed()) break;
                return result.getRowHeight();
            }
            default: {
                this.m_gridView.getErrorHandler().log("invalid argument - application", this.getClass().getName(), m_method__getSize);
                return -1;
            }
        }
        return -1;
    }

    private void _createRule(QDR ruleQDR, RuleBundle bundle, int size, int ruleApplication, int qdrDiscSetOperator) {
        this._createRule(ruleQDR, bundle, size, ruleApplication, qdrDiscSetOperator, null, false);
    }

    private void _createRule(QDR ruleQDR, RuleBundle bundle, int size, int ruleApplication, int qdrDiscSetOperator, Discriminator additionalDisc, boolean bIsTotal) {
        RuleContext context = new RuleContext();
        context.put((Object)"QDR", (Object)ruleQDR);
        if (bIsTotal) {
            context.put((Object)"TOTALS_RELATION", (Object)1);
        } else {
            context.put((Object)"TOTALS_RELATION", (Object)0);
        }
        try {
            bundle.removeRulesThatApply(context, null);
        }
        catch (RuleException re) {
            this.m_gridView.getErrorHandler().log("RuleException when removing previous rule", this.getClass().getName(), m_method__createRule);
        }
        ViewSizing vs = new ViewSizing();
        QDRDiscriminator disc = new QDRDiscriminator();
        disc.setQDR(ruleQDR);
        switch (ruleApplication) {
            case 0: 
            case 2: {
                vs.setRowHeight(size);
                break;
            }
            case 1: 
            case 3: {
                vs.setColumnWidth(size);
                break;
            }
            default: {
                this.m_gridView.getErrorHandler().log("invalid ruleApplication", this.getClass().getName(), m_method__createRule);
                return;
            }
        }
        disc.setSetOperator(qdrDiscSetOperator);
        if (additionalDisc != null) {
            CompositeDiscriminator compDisc = new CompositeDiscriminator((Discriminator)disc, additionalDisc, 0);
            bundle.addRule((Rule)new DiscriminatorRule((Discriminator)compDisc, (Mergeable)vs));
        } else {
            bundle.addRule((Rule)new DiscriminatorRule((Discriminator)disc, (Mergeable)vs));
        }
        this.m_gridView.updateSizes(ruleApplication);
    }

    protected static void copyMembersForClone(CrosstabRuleSizing from, CrosstabRuleSizing to) {
        GridViewRuleSizing.copyMembersForClone(from, to);
        if (from.m_preferredRowHeaderColumnWidths != null) {
            to.m_preferredRowHeaderColumnWidths = (RuleBundle)from.m_preferredRowHeaderColumnWidths.clone();
        }
        if (from.m_preferredColumnHeaderRowHeights != null) {
            to.m_preferredColumnHeaderRowHeights = (RuleBundle)from.m_preferredColumnHeaderRowHeights.clone();
        }
    }

    protected RuleBundle getPreferredRowHeaderColumnWidths() {
        if (this.m_preferredRowHeaderColumnWidths == null) {
            this.m_preferredRowHeaderColumnWidths = new RuleBundle();
        }
        return this.m_preferredRowHeaderColumnWidths;
    }

    protected RuleBundle getPreferredColumnHeaderRowHeights() {
        if (this.m_preferredColumnHeaderRowHeights == null) {
            this.m_preferredColumnHeaderRowHeights = new RuleBundle();
        }
        return this.m_preferredColumnHeaderRowHeights;
    }

    protected int[] getPreferredColumnHeaderRowHeightsCache() {
        if (this.m_preferredColumnHeaderRowHeightsCache == null) {
            this.createPreferredColumnHeaderRowHeightsCache();
        }
        return this.m_preferredColumnHeaderRowHeightsCache;
    }

    protected void createPreferredColumnHeaderRowHeightsCache() {
        int rowCount = 0;
        try {
            rowCount = this.m_gridView.getModel().getDataAccess().getLayerCount(0);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_gridView.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_createPreferredColumnHeaderRowHeightsCache);
        }
        this.m_preferredColumnHeaderRowHeightsCache = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            this.m_preferredColumnHeaderRowHeightsCache[i] = -2;
        }
    }

    protected void clearPreferredColumnHeaderRowHeightsCache() {
        this.m_preferredColumnHeaderRowHeightsCache = null;
    }

    protected int[] getPreferredRowHeaderColumnWidthsCache() {
        if (this.m_preferredRowHeaderColumnWidthsCache == null) {
            this.createPreferredRowHeaderColumnWidthsCache();
        }
        return this.m_preferredRowHeaderColumnWidthsCache;
    }

    protected void createPreferredRowHeaderColumnWidthsCache() {
        int colCount = 0;
        try {
            colCount = this.m_gridView.getModel().getDataAccess().getLayerCount(1);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_gridView.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_createPreferredRowHeaderColumnWidthsCache);
        }
        this.m_preferredRowHeaderColumnWidthsCache = new int[colCount];
        for (int i = 0; i < colCount; ++i) {
            this.m_preferredRowHeaderColumnWidthsCache[i] = -2;
        }
    }

    protected void clearPreferredRowHeaderColumnWidthsCache() {
        this.m_preferredRowHeaderColumnWidthsCache = null;
    }

    private TotalsDiscriminator getTotalsDiscriminator() {
        if (this.m_totalsDisc == null) {
            this.m_totalsDisc = new TotalsDiscriminator();
        }
        return this.m_totalsDisc;
    }

    private CompositeDiscriminator getCompNotTotalsDiscriminator() {
        if (this.m_compNotTotalsDisc == null) {
            this.m_compNotTotalsDisc = new CompositeDiscriminator((Discriminator)this.getTotalsDiscriminator(), null, 2);
        }
        return this.m_compNotTotalsDisc;
    }
}

