/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui.component.qdr.impl;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ListModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import oracle.adfdtinternal.model.dvt.util.gui.component.DimensionMemberComponentNode;
import oracle.adfdtinternal.model.dvt.util.gui.component.comboBox.DefaultTreeListComboModel;
import oracle.adfdtinternal.model.dvt.util.gui.component.comboBox.TreeListComboModel;
import oracle.adfdtinternal.model.dvt.util.gui.component.qdr.QDRPanelModel;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.HierarchicalQDR;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;

public class QDRPanelModelImpl
implements QDRPanelModel {
    private HierarchicalQDR m_qdr;
    private DataAccess m_dataAccess;
    private Hashtable m_items = new Hashtable();
    private String m_labelType = "layerLabel";
    private String m_memberLabelType = "label";

    public QDRPanelModelImpl(QDR qdr, DataAccess dataAccess) {
        this(new HierarchicalQDR(qdr), dataAccess);
    }

    public QDRPanelModelImpl(HierarchicalQDR qdr, DataAccess dataAccess) {
        this.setQDR(qdr);
        this.setDataAccess(dataAccess);
        this.updateItems();
    }

    @Override
    public HierarchicalQDR getQDR() {
        return this.m_qdr;
    }

    public void setQDR(HierarchicalQDR qdr) {
        this.m_qdr = qdr;
    }

    public void setDataAccess(DataAccess dataAccess) {
        this.m_dataAccess = dataAccess;
    }

    public DataAccess getDataAccess() {
        return this.m_dataAccess;
    }

    @Override
    public TreeListComboModel getMembers(String item) {
        String[] types = new String[]{"value", this.m_memberLabelType, "hierarchy", "level", "levelName"};
        List members = null;
        try {
            members = this.m_dataAccess.getUniqueMemberMetadata(item, types, 0, -1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Vector<DimensionMemberComponentNode> v = new Vector<DimensionMemberComponentNode>();
        if (members != null) {
            for (int i = 0; i < members.size(); ++i) {
                Object[] member = (Object[])members.get(i);
                String hierarchy = QDRPanelModelImpl.makeString(member[2]);
                String memberID = QDRPanelModelImpl.makeString(member[0]);
                String memberLabel = QDRPanelModelImpl.makeString(member[1]);
                String levelID = QDRPanelModelImpl.makeString(member[3]);
                String levelName = QDRPanelModelImpl.makeString(member[4]);
                DimensionMemberComponentNode cn = new DimensionMemberComponentNode(item, hierarchy, memberID, memberLabel, levelID, levelName);
                v.add(cn);
            }
        }
        return new QDRTreeListComboModel(v);
    }

    private static String makeString(Object value) {
        return value == null ? null : value.toString();
    }

    @Override
    public boolean isAddRemoveSupported() {
        return false;
    }

    @Override
    public String getNewItem() {
        return null;
    }

    @Override
    public String getLabel(String item) {
        return (String)this.m_items.get(item);
    }

    public void updateItems() {
        this.m_items.clear();
        for (int edge = 0; edge < this.m_dataAccess.getEdgeCount(); ++edge) {
            try {
                for (int layer = 0; layer < this.m_dataAccess.getLayerCount(edge); ++layer) {
                    try {
                        String label = this.m_dataAccess.getLayerMetadata(edge, layer, this.m_labelType).toString();
                        String id = this.m_dataAccess.getLayerMetadata(edge, layer, "layerName").toString();
                        this.m_items.put(id, label);
                        continue;
                    }
                    catch (LayerOutOfRangeException layerOutOfRangeException) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                // empty catch block
            }
        }
    }

    public void setDisplayLabelType(String strDisplayLabelType) {
        this.m_labelType = strDisplayLabelType;
    }

    public String getDisplayLabelType() {
        return this.m_labelType;
    }

    public void setDisplayMemberLabelType(String strDisplayMemberLabelType) {
        this.m_memberLabelType = strDisplayMemberLabelType;
    }

    public String getDisplayMemberLabelType() {
        return this.m_memberLabelType;
    }

    private class QDRTreeListComboModel
    extends DefaultTreeListComboModel {
        DefaultTreeModel m_treeModel;

        public QDRTreeListComboModel(Vector v) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            for (int i = 0; i < v.size(); ++i) {
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(v.get(i), false);
                root.add(child);
            }
            this.m_treeModel = new DefaultTreeModel(root);
        }

        @Override
        public TreeModel getTreeModel() {
            return this.m_treeModel;
        }

        @Override
        public ListModel[] getListModels() {
            return new ListModel[0];
        }

        @Override
        public boolean isMultiSelect() {
            return true;
        }
    }
}

