/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.dimensionList;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DataAccessDimensionModel;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DefaultListDataItem;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DefaultListDataModel;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DefaultListSelection;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DimFindEvent;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DimFindEventListener;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DimFindHistory;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DimFindTool;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DimListDataModel;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DimListSelectionModel;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DimensionList;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DimensionListListener;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DimensionUtil;
import oracle.adfdtinternal.model.dvt.util.gui.LazyScrollPane;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.util.DataAccess;
import oracle.dss.util.MemberListAccess;

public class DimensionListPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ListDataListener,
DimFindEventListener,
Serializable {
    protected DimensionList m_jlist = null;
    private LazyScrollPane m_jscrolllist = null;
    private JPanel m_pnlDescription = null;
    protected JLabel m_lblMembers = null;
    protected JLabel m_countLabel = null;
    protected JPanel m_toolbar = null;
    private JButton m_btnCollapse = null;
    private JButton m_btnExpand = null;
    private JButton m_btnFind = null;
    private Icon m_collapseAllIcon = null;
    private Icon m_expandAllIcon = null;
    private Icon m_findIcon = null;
    private boolean m_showCount = true;
    private boolean m_showToolbar = true;
    private boolean m_showHierarchy = true;
    private JDialog m_dlg = null;
    private DimFindTool m_findTool = null;
    private DimFindHistory m_fh = null;
    private String m_textFound = null;
    private String m_textNotFound = null;
    private static ResourceBundle m_localStrings = null;
    protected Locale m_locale = null;
    private Vector m_listeners = null;
    protected HelpProvider m_helpProvider = null;
    private DefaultListDataModel m_dataModel = null;
    private DefaultListSelection m_selectionModel = null;
    private String m_dimName = "";
    private String m_labelType = "shortName";
    private String m_closeText = null;
    private String m_findNextText = null;
    private String m_findHelpText = null;
    private PushButton m_findNextButton = null;
    private PushButton m_closeButton = null;
    private PushButton m_findHelpButton = null;
    private JPanel m_content = null;
    private transient DataAccessDimensionModel m_listModel = null;
    private transient boolean m_internalLayout = false;
    private transient int m_debugLevel = 0;
    protected String m_strDimension;
    protected String m_strHierarchy;
    protected boolean m_blnIsHierarchical = true;
    protected Window m_parent;
    private Icon m_iconExpanded;
    private Icon m_iconCollapsed;
    private static final int TOP_INSET = 0;
    private static final int BOTTOM_INSET = 0;
    private static final int LEFT_INSET = 2;
    private static final int RIGHT_INSET = 2;
    private boolean m_blnFromMouseEvent = false;
    protected boolean m_bSuperCalled = true;

    public DimensionListPanel() {
        this((Frame)null);
    }

    public DimensionListPanel(Frame parent) {
        this.m_parent = parent;
        this.init();
    }

    public DimensionListPanel(Dialog parent) {
        this.m_parent = parent;
        this.init();
    }

    public DimensionListPanel(DataAccess dataAccess, MemberListAccess memberAccess, String dimension, String type, boolean isTable) {
        this();
        this.initPanel(dataAccess, memberAccess, dimension, type, isTable);
    }

    public DimensionListPanel(Frame parent, DataAccess dataAccess, MemberListAccess memberAccess, String dimension, String type, boolean isTable) {
        this(parent);
        this.initPanel(dataAccess, memberAccess, dimension, type, isTable);
    }

    public DimensionListPanel(Dialog parent, DataAccess dataAccess, MemberListAccess memberAccess, String dimension, String type, boolean isTable) {
        this(parent);
        this.initPanel(dataAccess, memberAccess, dimension, type, isTable);
    }

    private void initPanel(DataAccess dataAccess, MemberListAccess memberAccess, String dimension, String type, boolean isTable) {
        DataAccessDimensionModel model = new DataAccessDimensionModel(dataAccess, memberAccess, dimension, isTable);
        this.setLabelType(type);
        this.initDimensionListPanel(dimension, model, true);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
        this.m_jlist.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        super.removePropertyChangeListener(l);
        this.m_jlist.removePropertyChangeListener(l);
    }

    public synchronized void addDimensionListListener(DimensionListListener l) {
        if (this.m_jlist != null) {
            this.m_jlist.addDimensionListListener(l);
        }
    }

    public synchronized void removeDimensionListListener(DimensionListListener l) {
        if (this.m_jlist != null) {
            this.m_jlist.removeDimensionListListener(l);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.m_jlist != null) {
            return this.m_jlist.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    public DimensionList getDimensionList() {
        return this.m_jlist;
    }

    public void setCountLabelVisible(boolean visible) {
        this.m_showCount = visible;
        this.addCountLabel();
    }

    public boolean isCountLabelVisible() {
        return this.m_showCount;
    }

    public void setLabelType(String type) {
        if (type != null) {
            this.m_labelType = type;
        }
    }

    public String getLabelType() {
        return this.m_labelType;
    }

    public void setToolbarVisible(boolean visible) {
        this.m_showToolbar = visible;
        this.addToolbar();
    }

    public boolean isToolbarVisible() {
        return this.m_showToolbar;
    }

    public void setHierarchyVisible(boolean visible) {
        this.m_showHierarchy = visible;
        this.updateToolbar();
    }

    public boolean isHierarchyVisible() {
        return this.m_showHierarchy;
    }

    public synchronized void setDimensionName(String dimName) {
        if (this.m_listModel == null) {
            this.initDataAccessDataSource();
        }
        if (this.m_listModel != null) {
            this.m_listModel.setDimensionName(dimName);
        }
    }

    public String getDimensionName() {
        if (this.m_listModel != null) {
            return this.m_listModel.getDimensionName();
        }
        return "";
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.updateCountLabel();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.updateCountLabel();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.updateCountLabel();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.updateCountLabel();
    }

    public int doFind(String value, int flags, int index, boolean showModalDialog) {
        int result = -1;
        return result;
    }

    public void doFindDialog(String text) {
        if (this.m_dlg == null) {
            Object sizeOfDialog = null;
            GrayPane grayPane = null;
            this.m_dlg = this.m_parent instanceof Frame ? new JDialog((Frame)this.m_parent, this.getIntlString("findDlgTitle")) : (this.m_parent instanceof Dialog ? new JDialog((Dialog)this.m_parent, this.getIntlString("findDlgTitle")) : new JDialog((Frame)null, this.getIntlString("findDlgTitle")));
            this.m_dlg.setModal(true);
            JComponent content = (JComponent)this.m_dlg.getContentPane();
            content.setLayout(new BorderLayout());
            content.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
            int intChildWidth = this.m_dlg.getSize().width;
            int intChildHeight = this.m_dlg.getSize().height;
            int intFrameWidth = this.getSize().width;
            int intFrameHeight = this.getSize().height;
            int intFrameLeft = this.getLocationOnScreen().x;
            int intFrameTop = this.getLocationOnScreen().y;
            int centerX = intFrameLeft + intFrameWidth / 2 - intChildWidth / 2;
            int centerY = intFrameTop + intFrameHeight / 2 - intChildHeight / 2;
            this.m_dlg.setLocation(centerX, centerY);
            if (this.m_findTool == null) {
                this.m_findTool = new DimFindTool();
                this.m_findTool.setLocale(this.getLocale());
                this.m_findTool.addDimFindEventListener(this);
            }
            grayPane = new GrayPane((Component)this.m_findTool);
            this.m_closeText = new String(this.getIntlString("btnClose"));
            this.m_findNextText = new String(this.getIntlString("btnNext"));
            this.m_findHelpText = new String(this.getIntlString("btnHelp"));
            JPanel jpEast = new JPanel();
            jpEast.setBorder(new EmptyBorder(3, 3, 3, 3));
            jpEast.setLayout(new BorderLayout());
            JPanel jpTopArea = new JPanel(new BorderLayout(2, 2));
            JLabel jpButtonPadLabel = new JLabel(" ");
            this.m_findNextButton = new PushButton(StringUtils.stripMnemonic((String)this.m_findNextText));
            this.m_findNextButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_findNextText));
            this.m_findNextButton.setLeftmost(true);
            this.m_findNextButton.setRightmost(true);
            this.m_findNextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DimensionListPanel.this.m_findTool.processFindNextButton();
                }
            });
            this.m_closeButton = new PushButton(StringUtils.stripMnemonic((String)this.m_closeText));
            this.m_closeButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_closeText));
            this.m_closeButton.setLeftmost(true);
            this.m_closeButton.setRightmost(true);
            this.m_closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DimensionListPanel.this.m_findTool.processCloseButton();
                }
            });
            this.m_findHelpButton = new PushButton(StringUtils.stripMnemonic((String)this.m_findHelpText));
            this.m_findHelpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_findHelpText));
            this.m_findHelpButton.setLeftmost(true);
            this.m_findHelpButton.setRightmost(true);
            ActionListener helpAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    HelpProvider helpProvider = DimensionListPanel.this.getHelpProvider();
                    if (helpProvider != null) {
                        try {
                            helpProvider.showHelp((Component)DimensionListPanel.this.m_findTool);
                        }
                        catch (HelpUnavailableException helpUnavailableException) {
                            // empty catch block
                        }
                    }
                }
            };
            ActionListener disposeAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DimensionListPanel.this.m_dlg.dispose();
                }
            };
            this.m_findHelpButton.addActionListener(helpAction);
            this.m_dlg.getRootPane().registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(112, 0), 2);
            this.m_dlg.getRootPane().registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(156, 0), 2);
            this.m_dlg.getRootPane().registerKeyboardAction(disposeAction, KeyStroke.getKeyStroke(27, 0), 2);
            jpTopArea.add((Component)this.m_findNextButton, "North");
            jpTopArea.add((Component)this.m_closeButton, "South");
            jpEast.add((Component)jpTopArea, "North");
            jpEast.add((Component)jpButtonPadLabel, "Center");
            jpEast.add((Component)this.m_findHelpButton, "South");
            content.add(Box.createRigidArea(new Dimension(0, 5)), "North");
            content.add(Box.createRigidArea(new Dimension(5, 0)), "West");
            content.add((Component)grayPane, "Center");
            content.add((Component)jpEast, "East");
            content.add(Box.createRigidArea(new Dimension(0, 5)), "South");
        }
        this.m_dlg.pack();
        WindowUtils.registerWindow((Window)this.m_dlg);
        this.m_dlg.show();
        this.m_dlg.requestFocus();
        WindowUtils.unregisterWindow((Window)this.m_dlg);
    }

    public DimListSelectionModel getSelectionModel() {
        return (DimListSelectionModel)((Object)this.m_jlist.getSelectionModel());
    }

    public synchronized void setSelectionModel(DimListSelectionModel selectionModel) {
        this.m_jlist.setSelectionModel((ListSelectionModel)((Object)selectionModel));
    }

    public boolean clearSelection() {
        if (this.m_jlist != null) {
            this.m_jlist.clearSelection();
            return true;
        }
        return false;
    }

    public boolean isSelectionEmpty() {
        return this.m_jlist.isSelectionEmpty();
    }

    public int getCount() {
        DimListDataModel dm;
        ListModel model = this.m_jlist.getModel();
        if (model instanceof DimListDataModel && (dm = (DimListDataModel)model) != null) {
            return dm.size();
        }
        return 0;
    }

    public void setSelectedIndex(int index) {
        if (this.m_jlist != null && index > -1 && index < this.getCount()) {
            this.m_jlist.setSelectedIndex(index);
        }
    }

    public int getSelectedIndex() {
        if (this.m_jlist != null) {
            return this.m_jlist.getSelectedIndex();
        }
        return -1;
    }

    public void setSelectedItems(Vector items) {
        if (items == null) {
            return;
        }
        Vector<Integer> selectedIndices = new Vector<Integer>();
        if (this.m_jlist != null) {
            for (int i = 0; i < this.m_jlist.getModel().getSize(); ++i) {
                DefaultListDataItem listData = (DefaultListDataItem)((DimListDataModel)this.m_jlist.getModel()).elementAt(i);
                if (items.indexOf(listData.getValue()) == -1) continue;
                selectedIndices.addElement(i);
            }
        }
        if (selectedIndices.size() > 0) {
            int[] indices = new int[selectedIndices.size()];
            for (int i = 0; i < selectedIndices.size(); ++i) {
                indices[i] = (Integer)selectedIndices.elementAt(i);
            }
            this.m_jlist.setSelectedIndices(indices);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_btnExpand) {
            if (this.m_jlist != null) {
                this.m_jlist.doExpandAll();
                this.requestDefaultFocus();
                this.m_jlist.requestFocus();
            }
        } else if (src == this.m_btnCollapse) {
            if (this.m_jlist != null) {
                this.m_jlist.doCollapseAll();
                this.requestDefaultFocus();
                this.m_jlist.requestFocus();
            }
        } else if (src == this.m_btnFind) {
            this.doFindDialog(null);
        }
    }

    @Override
    public void processDimFindEvent(DimFindEvent e) {
        boolean m_searchDescendants = e.getSearchDescendants();
        boolean m_matchCase = e.getMatchCase();
        int m_searchChoice = e.getSearchChoice();
        int iChoice = 0;
        switch (m_searchChoice) {
            case 0: {
                iChoice = 2;
                break;
            }
            case 1: {
                iChoice = 1;
                break;
            }
            case 2: {
                iChoice = 4;
                break;
            }
            case 3: {
                iChoice = 8;
            }
        }
        int flags = 0;
        flags = m_matchCase ? flags & 0xFFFFFF7F : 128;
        flags |= iChoice;
        if (e.getId() == 1) {
            this.m_dlg.dispose();
            this.m_btnFind.setEnabled(true);
            this.requestDefaultFocus();
            this.m_jlist.requestFocus();
        } else if (e.getId() == 2 && this.m_jlist != null) {
            int index;
            Object strFound = e.getText();
            int result = this.m_jlist.doFind((String)strFound, flags, index = this.m_jlist.getSelectedIndex() + 1, false);
            strFound = result > -1 ? (String)strFound + this.m_textFound : (String)strFound + this.m_textNotFound;
            this.m_findTool.setStatusText((String)strFound);
        }
    }

    public synchronized void setExpandedIcon(Icon icon) {
        Icon oldIcon;
        if (this.m_jlist != null && (oldIcon = this.m_jlist.getExpandedIcon()) != icon) {
            this.m_jlist.setExpandedIcon(icon);
            this.firePropertyChange("ExpandedIcon", oldIcon, icon);
        }
    }

    public Icon getExpandedIcon() {
        Icon icon = null;
        if (this.m_jlist != null) {
            icon = this.m_jlist.getExpandedIcon();
        }
        return icon;
    }

    public synchronized void setCollapsedIcon(Icon icon) {
        Icon oldIcon;
        if (this.m_jlist != null && (oldIcon = this.m_jlist.getCollapsedIcon()) != icon) {
            this.m_jlist.setCollapsedIcon(icon);
            this.firePropertyChange("CollapsedIcon", oldIcon, icon);
        }
    }

    public Icon getCollapsedIcon() {
        Icon icon = null;
        if (this.m_jlist != null) {
            icon = this.m_jlist.getCollapsedIcon();
        }
        return icon;
    }

    public synchronized void setOpenedIcon(Icon icon) {
        Icon oldIcon;
        if (this.m_jlist != null && (oldIcon = this.m_jlist.getOpenedIcon()) != icon) {
            this.m_jlist.setOpenedIcon(icon);
            this.firePropertyChange("OpenedIcon", oldIcon, icon);
        }
    }

    public Icon getOpenedIcon() {
        Icon icon = null;
        if (this.m_jlist != null) {
            icon = this.m_jlist.getOpenedIcon();
        }
        return icon;
    }

    public synchronized void setClosedIcon(Icon icon) {
        Icon oldIcon;
        if (this.m_jlist != null && (oldIcon = this.m_jlist.getClosedIcon()) != icon) {
            this.m_jlist.setClosedIcon(icon);
            this.firePropertyChange("ClosedIcon", oldIcon, icon);
        }
    }

    public Icon getClosedIcon() {
        Icon icon = null;
        if (this.m_jlist != null) {
            icon = this.m_jlist.getClosedIcon();
        }
        return icon;
    }

    public synchronized void setNodeIcon(Icon icon) {
        Icon oldIcon;
        if (this.m_jlist != null && (oldIcon = this.m_jlist.getNodeIcon()) != icon) {
            this.m_jlist.setNodeIcon(icon);
            this.firePropertyChange("NodeIcon", oldIcon, icon);
        }
    }

    public Icon getNodeIcon() {
        Icon icon = null;
        if (this.m_jlist != null) {
            icon = this.m_jlist.getNodeIcon();
        }
        return icon;
    }

    public synchronized void setExpandAllIcon(Icon icon) {
        DimensionUtil du = new DimensionUtil();
        Icon oldIcon = this.m_expandAllIcon;
        try {
            this.m_expandAllIcon = icon != null ? icon : new ImageIcon(du.getImageResource("images/minuses.gif", true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (oldIcon != this.m_expandAllIcon) {
            this.firePropertyChange("ExpandAllIcon", oldIcon, this.m_expandAllIcon);
            this.updateToolbar();
        }
    }

    public Icon getExpandAllIcon() {
        return this.m_expandAllIcon;
    }

    public synchronized void setCollapseAllIcon(Icon icon) {
        DimensionUtil du = new DimensionUtil();
        Icon oldIcon = this.m_collapseAllIcon;
        try {
            this.m_collapseAllIcon = icon != null ? icon : new ImageIcon(du.getImageResource("images/pluses.gif", true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (oldIcon != this.m_collapseAllIcon) {
            this.firePropertyChange("CollapseAllIcon", oldIcon, this.m_collapseAllIcon);
            this.updateToolbar();
        }
    }

    public Icon getCollapseAllIcon() {
        return this.m_collapseAllIcon;
    }

    public synchronized void setFindIcon(Icon icon) {
        DimensionUtil du = new DimensionUtil();
        Icon oldIcon = this.m_findIcon;
        try {
            this.m_findIcon = icon != null ? icon : new ImageIcon(du.getImageResource("images/find.gif", true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (oldIcon != this.m_findIcon) {
            this.firePropertyChange("FindIcon", oldIcon, this.m_findIcon);
            this.updateToolbar();
        }
    }

    public Icon getFindIcon() {
        return this.m_findIcon;
    }

    protected synchronized void setDataModel(DimListDataModel model) {
        this.m_dataModel.removeListDataListener(this);
        if (model == null) {
            this.m_jlist.setModel(this.m_dataModel);
            this.m_jlist.setPrototypeCellValue("RSTLENWy");
            this.m_dataModel.addListDataListener(this);
        } else {
            this.m_jlist.setModel(model);
            model.addListDataListener(this);
        }
        this.updateCountLabel();
    }

    protected DimListDataModel getDataModel() {
        return (DimListDataModel)this.m_jlist.getModel();
    }

    protected String getIntlString(String key) {
        String strTemp;
        if (m_localStrings == null) {
            return key;
        }
        try {
            strTemp = m_localStrings.getString(key);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            return key;
        }
        return strTemp;
    }

    protected void updateCountLabel() {
        int[] indices = this.m_jlist.getSelectedIndices();
        int index = indices == null ? 0 : indices.length;
        int count = this.getCount();
        if (count < 1) {
            index = 0;
        }
        String s1 = Integer.toString(index);
        String s2 = Integer.toString(count);
        String[] args = new String[]{s1, s2};
        MessageFormat countLabel = new MessageFormat(this.getIntlString("countLabel"));
        this.m_countLabel.setText(countLabel.format(args));
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.m_content = new JPanel();
        if (m_localStrings == null) {
            try {
                m_localStrings = ResourceBundle.getBundle("oracle.dss.util.dimensionList.resource.DimensionListBundle");
            }
            catch (MissingResourceException e) {
                e.printStackTrace();
                m_localStrings = null;
            }
        }
        this.m_textFound = new String(this.getIntlString("foundText"));
        this.m_textNotFound = new String(this.getIntlString("notFoundText"));
        this.m_pnlDescription = new JPanel(new BorderLayout());
        this.m_lblMembers = new JLabel();
        this.m_countLabel = new JLabel(this.getIntlString("itemsNbr"));
        this.m_dataModel = new DefaultListDataModel();
        this.m_jlist = new DimensionList();
        this.m_jscrolllist = new LazyScrollPane(this.m_jlist);
        this.m_jlist.addListSelectionListener(this);
        this.m_jlist.requestDefaultFocus();
        this.setDataModel(null);
        this.createToolbar();
        this.m_internalLayout = true;
        this.m_content.setLayout(new BorderLayout());
        this.m_internalLayout = false;
        this.m_content.add((Component)this.m_jscrolllist, "Center");
        this.add((Component)this.m_content, "Center");
    }

    private boolean initDataAccessDataSource() {
        boolean rc = false;
        this.m_listModel = new DataAccessDimensionModel();
        if (this.m_listModel != null && this.m_jlist != null) {
            this.m_jlist.setModel(this.m_listModel);
            rc = true;
        }
        return rc;
    }

    private void createToolbar() {
        Insets insets = new Insets(0, 2, 0, 2);
        this.setExpandAllIcon(null);
        this.setCollapseAllIcon(null);
        this.setFindIcon(null);
        this.m_btnCollapse = new JButton();
        this.m_btnExpand = new JButton();
        this.m_btnFind = new JButton();
        this.m_btnCollapse.setMargin(insets);
        this.m_btnExpand.setMargin(insets);
        this.m_btnFind.setMargin(insets);
        this.m_btnCollapse.setToolTipText(this.getIntlString("collapseAllTip"));
        this.m_btnExpand.setToolTipText(this.getIntlString("expandAllTip"));
        this.m_btnFind.setToolTipText(this.getIntlString("findTip"));
        this.m_btnCollapse.addActionListener(this);
        this.m_btnExpand.addActionListener(this);
        this.m_btnFind.addActionListener(this);
        JPanel pnlButtons = new JPanel();
        pnlButtons.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        pnlButtons.setLayout(new BoxLayout(pnlButtons, 0));
        pnlButtons.add(this.m_btnCollapse);
        pnlButtons.add(this.m_btnExpand);
        pnlButtons.add(this.m_btnFind);
        this.m_toolbar = new JPanel();
        this.m_toolbar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_toolbar.setLayout(new BorderLayout());
        this.m_toolbar.add((Component)pnlButtons, "West");
        this.updateToolbar();
    }

    protected void updateToolbar() {
        if (this.m_toolbar != null) {
            this.m_btnCollapse.setIcon(this.m_expandAllIcon);
            this.m_btnExpand.setIcon(this.m_collapseAllIcon);
            this.m_btnFind.setIcon(this.m_findIcon);
            this.m_toolbar.repaint();
        }
    }

    private void addToolbar() {
        this.m_content.remove(this.m_toolbar);
        if (this.m_showToolbar) {
            this.m_content.add((Component)this.m_toolbar, "South");
        }
        this.revalidate();
    }

    protected String getMemberLabel() {
        return this.getIntlString("membersLabel");
    }

    private void addCountLabel() {
        this.m_pnlDescription.remove(this.m_lblMembers);
        this.m_pnlDescription.remove(this.m_countLabel);
        this.m_content.remove(this.m_pnlDescription);
        if (this.m_showCount) {
            this.m_lblMembers.setText(StringUtils.stripMnemonic((String)this.getMemberLabel()));
            this.m_lblMembers.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.getMemberLabel()));
            this.m_lblMembers.setLabelFor(this.m_jlist);
            this.m_pnlDescription.add((Component)this.m_lblMembers, "Center");
            this.m_pnlDescription.add((Component)this.m_countLabel, "East");
            this.m_content.add((Component)this.m_pnlDescription, "North");
        }
        this.revalidate();
    }

    public void setModel(DataAccessDimensionModel dataAccessDimensionModel) {
        this.m_listModel = dataAccessDimensionModel;
        if (this.m_labelType != null) {
            this.m_listModel.setLabelType(this.m_labelType);
        }
    }

    public String getDimension() {
        return this.m_strDimension;
    }

    public void setDimension(String strDimension) {
        this.m_strDimension = strDimension;
    }

    public String getHierarchy() {
        return this.m_strHierarchy;
    }

    public void setHierarchy(String strHierarchy) {
        this.m_strHierarchy = strHierarchy;
    }

    public boolean isHierarchical() {
        return this.m_blnIsHierarchical;
    }

    public void setHierarchical(boolean blnIsHierarchical) {
        this.m_blnIsHierarchical = blnIsHierarchical;
    }

    public void initDimensionListPanel(String strDimension, DataAccessDimensionModel dataAccessDimensionModel, boolean isHierarchical) {
        this.setDimension(strDimension);
        this.setHierarchical(isHierarchical);
        this.setModel(dataAccessDimensionModel);
        this.setCountLabelVisible(true);
        this.setToolbarVisible(false);
        this.getDimensionList().setContextIconVisible(true);
        this.updateDimensionListModel();
        this.getDimensionList().doExpandAll();
    }

    public Vector getSelectedMembers(boolean getDescription) {
        Vector<String> members = new Vector<String>();
        Object[] value = this.getDimensionList().getSelectedValues();
        for (int i = 0; i < value.length; ++i) {
            DefaultListDataItem item = (DefaultListDataItem)value[i];
            members.addElement(getDescription ? item.getDescription() : item.getValue());
        }
        if (members.size() > 0) {
            return members;
        }
        return null;
    }

    public Vector getSelectedMembers() {
        return this.getSelectedMembers(false);
    }

    public String getSelectedMember() {
        String strMember = null;
        Vector members = this.getSelectedMembers();
        if (members != null && members.size() > 0) {
            strMember = members.firstElement().toString();
        }
        return strMember;
    }

    public void updateDimensionListModel() {
        if (this.m_strDimension != null) {
            if (this.m_listModel == null) {
                this.m_listModel = new DataAccessDimensionModel();
                this.m_listModel.setHierarchical(this.m_blnIsHierarchical);
            }
            this.m_listModel.setDimensionName(this.m_strDimension);
            this.getDimensionList().setModel(this.m_listModel);
            this.setDimListDrillIcons();
        }
    }

    @Override
    public Locale getLocale() {
        return this.m_locale;
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.m_locale = locale;
        m_localStrings = ResourceBundle.getBundle("oracle.dss.util.dimensionList.resource.DimensionListBundle", locale);
        this.updateResources();
    }

    private void updateResources() {
        this.m_btnCollapse.setToolTipText(this.getIntlString("collapseAllTip"));
        this.m_btnExpand.setToolTipText(this.getIntlString("expandAllTip"));
        this.m_btnFind.setToolTipText(this.getIntlString("findTip"));
        this.m_textFound = new String(this.getIntlString("foundText"));
        this.m_textNotFound = new String(this.getIntlString("notFoundText"));
        this.addCountLabel();
        this.updateCountLabel();
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setSelectionMode(int selectionMode) {
        this.m_jlist.setSelectionMode(selectionMode);
    }

    public LazyScrollPane getScrollPane() {
        return this.m_jscrolllist;
    }

    public JPanel getToolbar() {
        return this.m_toolbar;
    }

    protected void setDimListDrillIcons() {
        if (this.getDimensionList() != null) {
            this.getDimensionList().setExpandedIcon(this.m_iconExpanded);
            this.getDimensionList().setCollapsedIcon(this.m_iconCollapsed);
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004 && !this.m_blnFromMouseEvent) {
            this.getDimensionList().requestFocus();
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        this.m_blnFromMouseEvent = true;
        super.processMouseEvent(mouseEvent);
        this.m_blnFromMouseEvent = false;
    }
}

