/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.engine;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import java.util.Enumeration;
import oracle.diagram.framework.graphic.Edge2EdgeLinkShapePolicy;
import oracle.diagram.framework.graphic.GraphicConnector;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.sdm.undo.SDMEngineAdjustingCommand;
import oracle.diagram.sdm.undo.SDMUndoUtil;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.javatools.util.Holder;

public final class SDMEngineUtil {
    private SDMEngineUtil() {
    }

    public static final void ensureLinkConnections(IlvSDMEngine engine) {
        IlvSDMModel model = engine.getModel();
        Enumeration allObjects = engine.getAllObjects();
        while (allObjects.hasMoreElements()) {
            IlvLinkImage link;
            Object obj = allObjects.nextElement();
            if (!model.isLink(obj) || !model.isLink(model.getTo(obj))) continue;
            Object toObj = model.getTo(obj);
            IlvGraphic realToGraphic = engine.getGraphic(toObj, false);
            if (realToGraphic == null) {
                Enumeration allObjects2 = engine.getAllObjects();
                while (allObjects2.hasMoreElements()) {
                    Object obj2 = allObjects2.nextElement();
                    if (!obj2.equals(toObj)) continue;
                    model.setTo(obj, obj2);
                    realToGraphic = engine.getGraphic(obj2, false);
                    break;
                }
            }
            if ((link = (IlvLinkImage)engine.getGraphic(obj, false)) == null) continue;
            if (realToGraphic == null) {
                link.setVisible(false);
                continue;
            }
            GraphicConnector.findOrCreateConnector(realToGraphic);
            Edge2EdgeLinkShapePolicy policy = Edge2EdgeLinkShapePolicy.findPolicy(realToGraphic);
            policy.ensureConnection(link, false);
        }
    }

    public static final void setSelected(IlvSDMEngine engine, Object object, boolean selected) {
        IlvManager mgr;
        IlvGraphic graphic;
        engine.setSelected(object, selected);
        if (!selected && (graphic = engine.getGraphic(object, false)) != null && (mgr = ManagerUtil.getManager(graphic)) != null) {
            mgr.setSelected(graphic, false, true);
            if (graphic instanceof IlvCompositeGraphic) {
                IlvGraphic[] children;
                for (IlvGraphic child : children = ((IlvCompositeGraphic)graphic).getChildren()) {
                    IlvGraphic managed;
                    if (child == null || (managed = ManagerUtil.getManagedAncestor(child)) == null) continue;
                    ManagerUtil.getManager(managed).setSelected(managed, false, true);
                }
            }
        }
    }

    public static final void setStyleSheetsWithUndo(Context context, final IlvSDMEngine engine, String taskName, final String[] css, final boolean reload, final boolean recreate, final boolean layoutNodes, final boolean layoutLinks) throws Exception {
        String[] oldCSS;
        String[] tmp = engine.getStyleSheets();
        String[] stringArray = oldCSS = tmp != null ? new String[tmp.length] : null;
        if (oldCSS != null && oldCSS.length > 0) {
            System.arraycopy(tmp, 0, oldCSS, 0, tmp.length);
        }
        CommandProcessor cp = CommandProcessor.getInstance();
        cp.beginTrans(taskName);
        Command cmd = new SDMEngineAdjustingCommand(engine, true);
        cmd.setContext(context);
        cp.invoke(cmd);
        cmd = new Command(Ide.findOrCreateCmdID((String)"oracle.diagram.sdm.util.setStyleSheets1"), 0){
            private boolean first;
            {
                super(arg0, arg1);
                this.first = true;
            }

            public int doit() throws Exception {
                if (!this.first) {
                    engine.setStyleSheets(css, reload, recreate);
                } else {
                    this.first = false;
                }
                return 0;
            }

            public int undo() throws Exception {
                return 0;
            }
        };
        cmd.setContext(context);
        cp.invoke(cmd);
        final Holder h = new Holder();
        SDMUndoUtil.captureModelUndo(context, engine.getModel(), new Runnable(){

            @Override
            public void run() {
                try {
                    engine.setStyleSheets(css, reload, recreate);
                    if (layoutNodes) {
                        engine.performNodeLayout();
                    }
                    if (layoutLinks) {
                        engine.performLinkLayout();
                    }
                }
                catch (Exception ex) {
                    h.set((Object)ex);
                }
            }
        });
        if (h.get() != null) {
            throw (Exception)h.get();
        }
        cmd = new Command(Ide.findOrCreateCmdID((String)"oracle.diagram.sdm.util.setStyleSheets2"), 0){

            public int doit() throws Exception {
                return 0;
            }

            public int undo() throws Exception {
                engine.setStyleSheets(oldCSS, reload, recreate);
                return 0;
            }
        };
        cmd.setContext(context);
        cp.invoke(cmd);
        cmd = new SDMEngineAdjustingCommand(engine, false);
        cmd.setContext(context);
        cp.invoke(cmd);
        cp.getInstance().endTrans();
    }
}

