/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.oppparse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.diagram.oppparse.OPPContainer;
import oracle.diagram.oppparse.OPPDiagramShape;
import oracle.diagram.oppparse.OPPDiagramVisitor;
import oracle.diagram.oppparse.OPPEdgeRoute;
import oracle.diagram.oppparse.OPPElementReference;
import oracle.diagram.oppparse.OPPGlyph;
import oracle.diagram.oppparse.OPPParseUtil;
import oracle.diagram.oppparse.OPPTopLevelShape;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NodeList;

public final class OPPDiagramEdge
extends OPPTopLevelShape {
    private final long _srcDruid;
    private final long _dstDruid;
    private final OPPEdgeRoute _activeRoute;
    private final List<OPPEdgeRoute> _allRoutes;
    private final OPPEdgeRoute _originalRoute;
    private final OPPGlyph _startGlyph;
    private final OPPGlyph _midGlyph;
    private final OPPGlyph _endGlyph;
    private final Map<String, OPPGlyph> _customGlyphs = new HashMap<String, OPPGlyph>();

    OPPDiagramEdge(OPPContainer parent, XMLElement xmlSource) {
        super(parent, xmlSource);
        XMLElement srcDruid = OPPParseUtil.getNamedChild(xmlSource, "long", "sourceShapeDrUID");
        Long d = (Long)OPPParseUtil.parseTypedProperty(srcDruid);
        this._srcDruid = d != null ? d : -1L;
        XMLElement dstDruid = OPPParseUtil.getNamedChild(xmlSource, "long", "destinationShapeDrUID");
        d = (Long)OPPParseUtil.parseTypedProperty(dstDruid);
        this._dstDruid = d != null ? d : -1L;
        this._activeRoute = new OPPEdgeRoute(this, xmlSource, false);
        XMLElement gd = OPPParseUtil.getNamedChild(xmlSource, "infoMap", "graphicalData");
        XMLElement se = OPPParseUtil.getNamedChild(gd, "infoList", "surrogateEdges");
        if (se != null) {
            NodeList surrogates = se.getChildrenByTagName("infoMap");
            this._allRoutes = new ArrayList<OPPEdgeRoute>(surrogates.getLength() + 1);
            this._allRoutes.add(this._activeRoute);
            int isize = surrogates.getLength();
            for (int i = 0; i < isize; ++i) {
                this._allRoutes.add(new OPPEdgeRoute(this, (XMLElement)surrogates.item(i), true));
            }
        } else {
            this._allRoutes = new ArrayList<OPPEdgeRoute>(1);
            this._allRoutes.add(this._activeRoute);
        }
        XMLElement origSrcRef = OPPParseUtil.getNamedChild(gd, "elemRef", "surrogateOriginalSrcRef");
        OPPElementReference origSrcElemRef = origSrcRef != null ? (OPPElementReference)OPPParseUtil.parseTypedProperty(origSrcRef) : null;
        XMLElement origDstRef = OPPParseUtil.getNamedChild(gd, "elemRef", "surrogateOriginalDstRef");
        OPPElementReference origDstElemRef = origDstRef != null ? (OPPElementReference)OPPParseUtil.parseTypedProperty(origDstRef) : null;
        OPPEdgeRoute found = null;
        if (origSrcElemRef != null && origDstElemRef != null && this._allRoutes.size() > 1) {
            for (OPPEdgeRoute r : this._allRoutes) {
                OPPElementReference src = r.getSourceElementReference();
                OPPElementReference dst = r.getDestinationElementReference();
                if (!origSrcElemRef.equals(src) || !origDstElemRef.equals(dst)) continue;
                found = r;
                r.setOriginalRoute(true);
                break;
            }
            if (found == null) {
                String warning = "original edge route not found, src=" + origSrcElemRef + ", dst=" + origDstElemRef;
                Logger.getLogger("oracle.diagram.oppparse").log(Level.WARNING, warning);
                this._allRoutes.clear();
                this._allRoutes.add(this._activeRoute);
            }
        }
        if (found != null) {
            this._originalRoute = found;
        } else {
            this._originalRoute = this._activeRoute;
            this._originalRoute.setOriginalRoute(true);
        }
        XMLElement startGlyph = OPPParseUtil.getNamedChild(gd, "array", "firstGlyph");
        this._startGlyph = startGlyph != null ? new OPPGlyph(this, startGlyph) : null;
        XMLElement midGlyph = OPPParseUtil.getNamedChild(gd, "array", "midGlyph");
        this._midGlyph = midGlyph != null ? new OPPGlyph(this, midGlyph) : null;
        XMLElement endGlyph = OPPParseUtil.getNamedChild(gd, "array", "lastGlyph");
        this._endGlyph = endGlyph != null ? new OPPGlyph(this, endGlyph) : null;
    }

    public final OPPGlyph getStartGlyph() {
        return this._startGlyph;
    }

    public final OPPGlyph getMidGlyph() {
        return this._midGlyph;
    }

    public final OPPGlyph getEndGlyph() {
        return this._endGlyph;
    }

    public final OPPGlyph getCustomGlyph(String name) {
        OPPGlyph found = this._customGlyphs.get(name);
        if (found != null) {
            return found;
        }
        XMLElement gd = OPPParseUtil.getNamedChild(this.getXMLSource(), "infoMap", "graphicalData");
        XMLElement glyph = OPPParseUtil.getNamedChild(gd, "array", name);
        found = glyph != null ? new OPPGlyph(this, glyph) : null;
        this._customGlyphs.put(name, found);
        return found;
    }

    public final OPPEdgeRoute getCurrentRoute() {
        return this._activeRoute;
    }

    public final long getCurrentSourceDrUID() {
        return this._srcDruid;
    }

    public final long getCurrentDestinationDrUID() {
        return this._dstDruid;
    }

    public final OPPEdgeRoute getOriginalRoute() {
        return this._originalRoute;
    }

    public final List<OPPEdgeRoute> getRoutes() {
        return Collections.unmodifiableList(this._allRoutes);
    }

    @Override
    void resolveShapeReferences() {
        super.resolveShapeReferences();
        OPPEdgeRoute current = this.getCurrentRoute();
        current.setSourceDrUID(this.getCurrentSourceDrUID());
        current.setDestinationDrUID(this.getCurrentDestinationDrUID());
        LinkedList<OPPEdgeRoute> badRoutes = new LinkedList<OPPEdgeRoute>();
        for (OPPEdgeRoute route : this.getRoutes()) {
            try {
                route.resolveShapeReferences();
            }
            catch (IllegalStateException ex) {
                badRoutes.add(route);
                Logger.getLogger("oracle.diagram.oppparse").log(Level.WARNING, "Migration error migrating document", ex);
            }
        }
        for (OPPEdgeRoute route : badRoutes) {
            this._allRoutes.remove(route);
        }
        if (this._allRoutes.isEmpty()) {
            throw new IllegalStateException("no edge routes found for OPPDiagramEdge");
        }
    }

    @Override
    void visit(OPPDiagramVisitor visitor, boolean nodePass) {
        if (!nodePass) {
            visitor.visitEdgeShape(this);
            for (OPPDiagramShape s : this.getInternalShapes()) {
                s.visit(visitor, nodePass);
            }
        }
    }
}

