/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.view;

import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import oracle.diagram.core.manager.CoreManagerLayer;

public class DiagramViewProgress {
    private static final String DISABLED_LAYER_KEY = "disabledLayer";
    private IlvManager m_grapher;
    private Timer m_delayDisableTimer = new Timer();
    private static final NullInteractor NULL_INTERACTOR = new NullInteractor();
    private boolean m_disabled;
    private ManagerLayerState m_layerStates;
    private volatile boolean m_running;

    public DiagramViewProgress(IlvManager mgr) {
        if (mgr == null) {
            throw new IllegalArgumentException("Manager is null");
        }
        this.m_grapher = mgr;
    }

    public void start(String startMessage, long delay) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("DiagramViewProgress.start must be called from AWT Thread");
        }
        if (this.m_running) {
            throw new IllegalStateException("DiagramViewProgress already started");
        }
        this.m_running = true;
        this.disable(this.m_grapher);
        this.m_delayDisableTimer.schedule((TimerTask)new ShowDelayedProgressTask(startMessage), delay);
    }

    public void stop() {
        if (!this.m_running) {
            throw new IllegalStateException("DiagramViewProgress already stopped");
        }
        this.m_running = false;
        this.m_delayDisableTimer.cancel();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DiagramViewProgress.this.removeProgress();
                    DiagramViewProgress.this.enable(DiagramViewProgress.this.m_grapher);
                }
            });
        } else {
            this.removeProgress();
            this.enable(this.m_grapher);
        }
    }

    public void setMessage(String aMessage) {
        InfiniteProgressLayer layer = this.getProgressLayer(this.m_grapher);
        if (layer != null) {
            layer.setMessage(aMessage);
        }
    }

    private void disable(IlvManager mgr) {
        if (this.m_disabled) {
            return;
        }
        this.m_disabled = true;
        this.m_layerStates = new ManagerLayerState();
        this.m_layerStates.save(mgr);
        int numLayers = mgr.getLayersCount();
        for (int i = 0; i < numLayers; ++i) {
            mgr.setVisible(i, false, true);
            mgr.setSelectable(i, false);
        }
        Enumeration views = mgr.getViews();
        while (views.hasMoreElements()) {
            IlvManagerView view = (IlvManagerView)views.nextElement();
            view.pushInteractor((IlvManagerViewInteractor)NULL_INTERACTOR);
        }
    }

    private void enable(IlvManager mgr) {
        if (!this.m_disabled) {
            return;
        }
        this.m_disabled = false;
        if (this.m_layerStates != null) {
            this.m_layerStates.restore();
            this.m_layerStates = null;
        }
        Enumeration views = mgr.getViews();
        while (views.hasMoreElements()) {
            IlvManagerView view = (IlvManagerView)views.nextElement();
            IlvManagerViewInteractor interactor = view.getInteractor();
            if (interactor != NULL_INTERACTOR) continue;
            view.popInteractor();
        }
    }

    private InfiniteProgressLayer getProgressLayer(IlvManager grapher) {
        int layerIndex = grapher.getLayer(DISABLED_LAYER_KEY);
        if (layerIndex == -1) {
            return null;
        }
        InfiniteProgressLayer progressLayer = (InfiniteProgressLayer)grapher.getManagerLayer(layerIndex);
        return progressLayer;
    }

    private void showProgress(String message) {
        if (!this.m_running) {
            return;
        }
        IlvManager grapher = this.m_grapher;
        InfiniteProgressLayer progressLayer = new InfiniteProgressLayer(message);
        grapher.addLayer((IlvManagerLayer)progressLayer, grapher.getLayersCount());
        progressLayer.setName(DISABLED_LAYER_KEY);
        int layerIndex = grapher.getLayer(DISABLED_LAYER_KEY);
        grapher.setVisible(layerIndex, true, true);
        progressLayer.start();
    }

    private void removeProgress() {
        IlvManager grapher = this.m_grapher;
        InfiniteProgressLayer progressLayer = this.getProgressLayer(grapher);
        if (progressLayer != null) {
            progressLayer.stop();
            grapher.removeLayer(progressLayer.getIndex(), true);
        }
    }

    private class ShowDelayedProgressTask
    extends TimerTask {
        private String _message;

        ShowDelayedProgressTask(String message) {
            this._message = message;
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DiagramViewProgress.this.showProgress(ShowDelayedProgressTask.this._message);
                }
            });
        }
    }

    private static class InfiniteProgressLayer
    extends CoreManagerLayer
    implements Runnable {
        private static final int FADE_FPS = 12;
        private static final int PROGRESS_FPS = 12;
        private static final float MESSAGE_FONT_SIZE = 24.0f;
        private static final Color SPIN_RECT_COLOR = new Color(6, 76, 161);
        private static final Color FADE_IN_COLOR = new Color(0.8f, 0.8f, 0.8f);
        private static final float[][] _OFF = new float[][]{{0.0f, 0.0f}, {0.5f, 0.0f}, {1.0f, 0.0f}, {1.0f, 0.5f}, {1.0f, 1.0f}, {0.5f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.5f}};
        private static final int SPIN_AREA_SIZE = 20;
        private static final int SPIN_RECT_SIZE = 4;
        private volatile Phase _phase;
        private volatile float _alpha;
        private volatile int _fadeFrame;
        private volatile String _message = "";
        private int _spinRectCount;
        private AlphaComposite[] _alphas;
        private Rectangle _bounds = new Rectangle();
        private Rectangle _progressRect = new Rectangle();
        private Rectangle _spinningRect = new Rectangle();
        private Rectangle2D _messageRect;
        private Font _messageFont;
        private Thread _animator;

        InfiniteProgressLayer(String message) {
            if (message != null) {
                this._message = message;
            }
        }

        private void drawSpinningRect(Graphics2D g, Rectangle spinningRect) {
            int x = spinningRect.x;
            int y = spinningRect.y;
            int i = this._spinRectCount;
            g.setColor(SPIN_RECT_COLOR);
            for (int count = 0; count < _OFF.length; ++count) {
                AlphaComposite ac;
                float[] off = _OFF[i];
                int _x = x + (int)(20.0f * off[0]);
                int _y = y + (int)(20.0f * off[1]);
                if (this._alphas == null) {
                    this._alphas = new AlphaComposite[_OFF.length];
                }
                if ((ac = this._alphas[count]) == null) {
                    float alpha = 1.0f - 0.1f * (float)count;
                    this._alphas[count] = ac = AlphaComposite.getInstance(3, alpha);
                }
                g.setComposite(ac);
                g.fillRect(_x, _y, 4, 4);
                if (--i >= 0) continue;
                i = _OFF.length - 1;
            }
        }

        private void setMessage(String aMessage) {
            this._message = aMessage;
        }

        private void drawMessage(Graphics2D g, Rectangle2D messageRect) {
            FontMetrics fontMetrics = g.getFontMetrics(this._messageFont);
            int descent = fontMetrics.getDescent();
            g.setColor(Color.GRAY);
            g.drawString(this._message, (int)messageRect.getX(), (int)messageRect.getY() + descent);
        }

        protected void drawImpl(Graphics dst, IlvManagerView view) {
            Rectangle bounds = view.getBounds(this._bounds);
            Graphics2D g2d = (Graphics2D)dst;
            Color savedColor = g2d.getColor();
            Composite savedComposite = g2d.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this._alpha);
            g2d.setComposite(alphaComposite);
            g2d.setColor(FADE_IN_COLOR);
            g2d.fill(bounds);
            if (this._phase == Phase.PROGRESS) {
                Object textANtiAliasValue = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                if (this._messageFont == null) {
                    Font font = view.getFont();
                    this._messageFont = font.deriveFont(24.0f);
                }
                Font savedFont = g2d.getFont();
                g2d.setFont(this._messageFont);
                if (this._messageRect == null) {
                    FontRenderContext fontContext = g2d.getFontRenderContext();
                    this._messageRect = this._messageFont.getStringBounds(this._message, fontContext);
                }
                int width = Math.max((int)this._messageRect.getWidth(), 20);
                int height = (int)this._messageRect.getHeight() + 20 + 8;
                this._progressRect.setBounds(bounds.x + (bounds.width - width) / 2, bounds.y + (bounds.height - height) / 2, width, height);
                this._messageRect.setFrame((double)this._progressRect.x + ((double)this._progressRect.width - this._messageRect.getWidth()) / 2.0, (double)this._progressRect.y + ((double)this._progressRect.height - this._messageRect.getHeight()) / 2.0, this._messageRect.getWidth(), this._messageRect.getHeight());
                this._spinningRect.setBounds(this._progressRect.x + (this._progressRect.width - 20) / 2, this._progressRect.y + (int)this._messageRect.getHeight() + 8, 20, 20);
                this.drawMessage(g2d, this._messageRect);
                this.drawSpinningRect(g2d, this._spinningRect);
                g2d.setFont(savedFont);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, textANtiAliasValue);
            }
            g2d.setColor(savedColor);
            g2d.setComposite(savedComposite);
        }

        public void start() {
            this._animator = new Thread(this);
            this._phase = Phase.FADE_IN;
            this._animator.start();
        }

        public void stop() {
            this._animator.interrupt();
        }

        @Override
        public void run() {
            int MAX_NUM_OF_NO_SLEEP = 16;
            this._fadeFrame = 0;
            long overSleep = 0L;
            long before = System.nanoTime();
            while (!this._animator.isInterrupted()) {
                this.updateAnimation();
                this.repaintViews();
                if (this._animator.isInterrupted()) break;
                long after = System.nanoTime();
                long period = 1000L / (long)(this._phase == Phase.PROGRESS ? 12 : 12) * 1000000L;
                long elapsed = after - before;
                long sleep = period - elapsed - overSleep;
                int numOfNoSleep = 0;
                if (sleep > 0L) {
                    try {
                        Thread.sleep(sleep / 1000000L);
                    }
                    catch (InterruptedException swallowed) {
                        break;
                    }
                    overSleep = System.nanoTime() - after - sleep;
                } else {
                    overSleep = 0L;
                    if (++numOfNoSleep >= 16) {
                        numOfNoSleep = 0;
                        Thread.yield();
                    }
                }
                before = System.nanoTime();
            }
        }

        private void updateAnimation() {
            if (this._phase == Phase.FADE_IN) {
                this.updateFadeIn();
            } else {
                this.updateProgress();
            }
        }

        private void updateFadeIn() {
            if (++this._fadeFrame <= 12) {
                this._alpha = 0.5f * ((float)this._fadeFrame / 12.0f);
                if (this._fadeFrame == 12) {
                    this._phase = Phase.PROGRESS;
                }
            }
        }

        private void updateProgress() {
            ++this._spinRectCount;
            if (this._spinRectCount >= _OFF.length) {
                this._spinRectCount = 0;
            }
        }

        private void repaintViews() {
            IlvManager mgr = this.getManager();
            Enumeration views = mgr.getViews();
            while (views.hasMoreElements()) {
                IlvManagerView view = (IlvManagerView)views.nextElement();
                view.repaint();
            }
        }

        private static enum Phase {
            FADE_IN,
            PROGRESS;

        }
    }

    private static class ManagerLayerState {
        Collection<LayerState> _layerStates;

        private ManagerLayerState() {
        }

        void save(IlvManager mgr) {
            int numLayers = mgr.getLayersCount();
            if (numLayers > 0) {
                ArrayList<LayerState> states = new ArrayList<LayerState>(mgr.getLayersCount());
                for (int i = 0; i < numLayers; ++i) {
                    IlvManagerLayer layer = mgr.getManagerLayer(i);
                    if (layer == null) continue;
                    LayerState s = new LayerState();
                    s.save(layer);
                    states.add(s);
                }
                this._layerStates = states;
            }
        }

        void restore() {
            if (this._layerStates != null) {
                for (LayerState s : this._layerStates) {
                    s.restore();
                }
                this._layerStates = null;
            }
        }

        private static class LayerState {
            IlvManagerLayer _layer;
            private boolean _visible;
            private boolean _selectable;

            private LayerState() {
            }

            void save(IlvManagerLayer layer) {
                this._layer = layer;
                this._visible = layer.isVisible();
                this._selectable = layer.isSelectable();
            }

            void restore() {
                IlvManager mgr = this._layer.getManager();
                int index = this._layer.getIndex();
                mgr.setVisible(index, this._visible, true);
                mgr.setSelectable(index, this._selectable);
            }
        }
    }

    private static class NullInteractor
    extends IlvManagerViewInteractor {
        private NullInteractor() {
        }

        public void processMouseEvent(MouseEvent event) {
        }

        public void processMouseMotionEvent(MouseEvent event) {
        }
    }
}

