/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.readonly;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import java.awt.datatransfer.Transferable;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.readonly.DiagramReadOnlyPlugin;
import oracle.diagram.framework.readonly.ModificationContext;

public abstract class ReadOnlyUtil {
    protected ReadOnlyUtil() {
    }

    public static boolean isPermanentReadOnlyContext(DiagramContext context) {
        DiagramReadOnlyPlugin erop = ReadOnlyUtil.getReadOnlyPlugin(context);
        if (erop != null) {
            return erop.isPermanentReadOnly();
        }
        return false;
    }

    public static boolean checkWritable(DiagramContext context) {
        return ReadOnlyUtil.checkWritable(context, (Object)ModificationContext.OperationCode.EditorOnly, null);
    }

    public static boolean checkWritable(DiagramContext context, Object opcode, ModificationContext params) {
        DiagramReadOnlyPlugin erop = ReadOnlyUtil.getReadOnlyPlugin(context);
        if (erop != null) {
            return erop.checkWritable(opcode, params);
        }
        return true;
    }

    public static boolean checkWritableLayout(DiagramContext context) {
        return ReadOnlyUtil.checkWritable(context, (Object)ModificationContext.OperationCode.Layout, null);
    }

    public static boolean checkWritableAddToDiagram(DiagramContext context) {
        return ReadOnlyUtil.checkWritable(context, (Object)ModificationContext.OperationCode.AddToDiagram, null);
    }

    public static boolean checkWritableDrop(DiagramContext context, IlvGraphic target, Transferable transferable) {
        ModificationContext.DropContext c = new ModificationContext.DropContext(target, transferable);
        return ReadOnlyUtil.checkWritable(context, (Object)ModificationContext.OperationCode.Drop, c);
    }

    public static boolean checkWritableCut(DiagramContext context, IlvGraphic[] graphics) {
        ModificationContext.CutContext c = new ModificationContext.CutContext(graphics);
        return ReadOnlyUtil.checkWritable(context, (Object)ModificationContext.OperationCode.Cut, c);
    }

    public static boolean checkWritablePaste(DiagramContext context, Transferable transferable) {
        ModificationContext.PasteContext c = new ModificationContext.PasteContext(transferable);
        return ReadOnlyUtil.checkWritable(context, (Object)ModificationContext.OperationCode.Paste, c);
    }

    public static boolean checkWritableMoveGraphics(DiagramContext context, IlvGraphic[] graphics) {
        ModificationContext.MoveGraphicsContext c = new ModificationContext.MoveGraphicsContext(graphics);
        return ReadOnlyUtil.checkWritable(context, (Object)ModificationContext.OperationCode.MoveGraphics, c);
    }

    public static boolean checkWritableResizeNode(DiagramContext context, IlvGraphic graphic) {
        ModificationContext.ResizeNodeContext c = new ModificationContext.ResizeNodeContext(graphic);
        return ReadOnlyUtil.checkWritable(context, (Object)ModificationContext.OperationCode.ResizeNode, c);
    }

    public static boolean checkWritableReshapeLink(DiagramContext context, IlvLinkImage link) {
        ModificationContext.ReshapeLinkContext c = new ModificationContext.ReshapeLinkContext(link);
        return ReadOnlyUtil.checkWritable(context, (Object)ModificationContext.OperationCode.ReshapeLink, c);
    }

    public static boolean checkWritableEdit(DiagramContext context, IlvGraphic graphic) {
        ModificationContext.EditContext c = new ModificationContext.EditContext(graphic);
        return ReadOnlyUtil.checkWritable(context, (Object)ModificationContext.OperationCode.Edit, c);
    }

    public static boolean checkWritableEdit(DiagramContext context, IlvGraphic graphic, IlvGraphic subGraphic) {
        ModificationContext.EditContext c = new ModificationContext.EditContext(graphic, subGraphic);
        return ReadOnlyUtil.checkWritable(context, (Object)ModificationContext.OperationCode.Edit, c);
    }

    public static boolean checkWritableCreateNode(DiagramContext context, IlvGraphic parent) {
        ModificationContext.CreateNodeContext c = new ModificationContext.CreateNodeContext(parent);
        return ReadOnlyUtil.checkWritable(context, (Object)ModificationContext.OperationCode.CreateNode, c);
    }

    public static boolean checkWritableCreateLink(DiagramContext context, IlvGraphic parent, IlvGraphic link, IlvGraphic from, IlvGraphic to) {
        ModificationContext.CreateLinkContext c = new ModificationContext.CreateLinkContext(parent, link, from, to);
        return ReadOnlyUtil.checkWritable(context, (Object)ModificationContext.OperationCode.CreateLink, c);
    }

    public static boolean checkWritableReconnectLink(DiagramContext context, IlvLinkImage link, IlvGraphic oldTarget, IlvGraphic newTarget, boolean isSourceReconnect) {
        ModificationContext.ReconnectLinkContext c = new ModificationContext.ReconnectLinkContext(link, oldTarget, newTarget, isSourceReconnect);
        return ReadOnlyUtil.checkWritable(context, (Object)ModificationContext.OperationCode.ReconnectLink, c);
    }

    public static boolean checkWritableDelete(DiagramContext context, IlvGraphic graphic) {
        ModificationContext.DeleteContext c = new ModificationContext.DeleteContext(graphic);
        return ReadOnlyUtil.checkWritable(context, (Object)ModificationContext.OperationCode.Delete, c);
    }

    private static final DiagramReadOnlyPlugin getReadOnlyPlugin(DiagramContext context) {
        return context.getPlugin(DiagramReadOnlyPlugin.class);
    }
}

