/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.menu;

import java.awt.Component;
import java.awt.Container;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JMenu;
import oracle.diagram.core.plugin.RefCountedPlugin;
import oracle.diagram.framework.menu.DiagramMainMenuPlugin;
import oracle.diagram.res.MenuResource;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Menubar;

public abstract class AbstractDiagramMainMenuPlugin
extends RefCountedPlugin
implements DiagramMainMenuPlugin {
    protected static final ResourceBundle RB = MenuResource.getBundle();
    private static final String NOSORT_PROPERTY = "noSort";
    private boolean _cache = false;
    private JComponent[] _itemCache = null;

    public AbstractDiagramMainMenuPlugin() {
        this(true);
    }

    public AbstractDiagramMainMenuPlugin(boolean cache) {
        this._cache = cache;
    }

    public final boolean isCaching() {
        return this._cache;
    }

    public final void setCaching(boolean cache) {
        if (this._cache != cache) {
            this._itemCache = null;
            this._cache = cache;
        }
    }

    @Override
    public String getDiagramMenuName() {
        return RB.getString("DiagramMenu.text");
    }

    @Override
    public JComponent[] getDiagramMenuItems(Context context) {
        if (!this.isCaching() || this._itemCache == null) {
            Menubar mb = Ide.getMenubar();
            JMenu menu = new JMenu();
            this.addMenuItems(mb, menu);
            this.sort(mb, menu);
            JComponent[] items = AbstractDiagramMainMenuPlugin.getItems(menu);
            if (this.isCaching()) {
                this._itemCache = items;
            } else {
                return items;
            }
        }
        return this._itemCache;
    }

    @Override
    protected void cleanup() {
        this._itemCache = null;
    }

    protected void sort(Menubar mb, JMenu menu) {
        for (Component item : menu.getMenuComponents()) {
            if (!(item instanceof JMenu)) continue;
            this.sort(mb, (JMenu)item);
        }
        if (this.shouldSort(menu)) {
            mb.sortContainer((Container)menu);
            if (menu.getParent() == null) {
                Component[] components = menu.getMenuComponents();
                for (int i = components.length - 1; i >= 0; --i) {
                    Component component = components[i];
                    if (!(component instanceof JComponent)) continue;
                    JComponent c = (JComponent)component;
                    c.putClientProperty("menu-weight", Float.valueOf(i));
                }
            }
        }
    }

    protected boolean shouldSort(JMenu menu) {
        return !AbstractDiagramMainMenuPlugin.hasNoSortTag(menu);
    }

    protected abstract void addMenuItems(Menubar var1, JMenu var2);

    protected static boolean hasNoSortTag(JMenu menu) {
        return menu.getClientProperty(NOSORT_PROPERTY) != null;
    }

    protected static void tagNoSort(JMenu menu) {
        menu.putClientProperty(NOSORT_PROPERTY, Boolean.TRUE);
    }

    protected static JComponent[] getItems(JMenu menu) {
        Component[] items = menu.getMenuComponents();
        JComponent[] result = new JComponent[items.length];
        for (int i = 0; i < items.length; ++i) {
            result[i] = (JComponent)items[i];
        }
        return result;
    }

    protected static Integer makeMnemonic(String mnemonic) {
        return AbstractDiagramMainMenuPlugin.makeMnemonic(mnemonic.charAt(0));
    }

    protected static Integer makeMnemonic(char mnemonic) {
        return mnemonic;
    }
}

