/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.thumbnail;

import ilog.views.IlvGrid;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.event.ManagerChangedEvent;
import ilog.views.event.ManagerChangedListener;
import ilog.views.event.ManagerViewsChangedEvent;
import ilog.views.event.ManagerViewsChangedListener;
import ilog.views.swing.IlvJManagerViewPanel;
import ilog.views.swing.IlvToolTipManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import oracle.diagram.core.thumbnail.ThumbnailManagerViewMarker;
import oracle.diagram.core.thumbnail.ThumbnailViewInteractor;
import oracle.diagram.framework.accessibility.HCGraphics2D;
import oracle.diagram.framework.graphic.DiagramRenderingHints;

public class ThumbnailView
extends IlvJManagerViewPanel {
    private final ManagerChangedListener _mcl = new MyManagerChangedListener();
    private final ViewListener _viewListener = new ViewListener();
    private final IlvManagerView _srcView;

    public ThumbnailView(IlvManagerView mgrView) {
        super((IlvManagerView)new ThumbnailManagerView(mgrView.getManager()));
        this._srcView = mgrView;
    }

    protected void initialize() {
        IlvManagerView view = this.getManagerView();
        view.addManagerChangedListener(this._mcl);
        IlvManager mgr = view.getManager();
        view.setVisible(mgr.getLayersCount(), false);
        this.managerChanging(null, mgr);
    }

    protected void dispose() {
        IlvManagerView view = this.getManagerView();
        view.removeManagerChangedListener(this._mcl);
        this.managerChanging(view.getManager(), null);
        IlvToolTipManager.unregisterView((IlvManagerView)view);
        view.removeAllInteractors();
    }

    protected void managerChanging(IlvManager oldMgr, IlvManager newMgr) {
        if (oldMgr != null) {
            oldMgr.removeManagerViewsListener((ManagerViewsChangedListener)this._viewListener);
        }
        if (newMgr != null) {
            newMgr.addManagerViewsListener((ManagerViewsChangedListener)this._viewListener);
        }
    }

    public void addNotify() {
        super.addNotify();
        IlvManagerView view = this.getManagerView();
        IlvToolTipManager.registerView((IlvManagerView)view);
        view.setDoubleBuffering(false);
        view.setAntialiasing(false);
        view.setAutoFitToContents(false);
        view.setKeepingAspectRatio(true);
        view.setBackground(Color.WHITE);
        view.setWheelZoomingEnabled(false);
        this.initialize();
        this.installControlInteractor(this._srcView);
    }

    public void removeNotify() {
        super.removeNotify();
        this.dispose();
    }

    protected void installControlInteractor(IlvManagerView targetView) {
        ThumbnailViewInteractor i = new ThumbnailViewInteractor(false);
        this.getManagerView().setInteractor((IlvManagerViewInteractor)i);
        i.setTarget(targetView);
    }

    private static class ThumbnailManagerView
    extends IlvManagerView
    implements ThumbnailManagerViewMarker {
        public ThumbnailManagerView(IlvManager mgr) {
            super(mgr);
            this.setRedrawMode(0);
            this.setFocusable(false);
        }

        public void setGrid(IlvGrid grid) {
        }

        public void paint(Graphics graphics) {
            Graphics2D g2d = (Graphics2D)graphics.create();
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g2d.setRenderingHint(DiagramRenderingHints.KEY_SHAPE_SHADOW, DiagramRenderingHints.VALUE_SHAPE_SHADOW_OFF);
            Graphics g = HCGraphics2D.get(g2d);
            super.paint(g);
            g.dispose();
        }
    }

    private final class MyManagerChangedListener
    implements ManagerChangedListener {
        private MyManagerChangedListener() {
        }

        public void managerChanged(ManagerChangedEvent event) {
            ThumbnailView.this.managerChanging(event.getOldValue(), event.getNewValue());
        }
    }

    private final class ViewListener
    implements ManagerViewsChangedListener {
        private ViewListener() {
        }

        public void viewChanged(ManagerViewsChangedEvent event) {
            if (event.getType() == 2 && event.getManagerView() == ThumbnailView.this.getManagerView()) {
                ThumbnailView.this.dispose();
            }
        }
    }
}

