/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ide.util.MetaClass;
import oracle.ide.index.IndexManager;
import oracle.ide.index.Indexer;
import oracle.ide.model.Node;
import oracle.ideimpl.index.IndexManagerImpl;
import oracle.ideimpl.index.extension.IndexerInfo;
import oracle.ideimpl.index.extension.IndexingInfo;
import oracle.ideimpl.index.extension.IndexingInfoListener;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectArrayFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.util.MultiMap;

public final class IndexInfo {
    public static final AssemblyFactory INDEX_INFO_FACTORY = new IndexInfoFactory();
    public static final AssemblyFactory INDEXER_RECORD_FACTORY = new IndexerRecordFactory();
    private static final AssemblyFactory INDEXER_RECORD_ARRAY_FACTORY = new ObjectArrayFactory(INDEXER_RECORD_FACTORY);
    private static final int INDEX_INFO_VERSION = 8;
    private static final byte STORAGE_CODE = -22;
    private static final Set<IndexerRecord> INDEXER_RECORDS = IndexInfo.getIndexerRecords();
    private final int indexInfoVersion;
    protected final long version;
    protected final long cookie;
    protected final long lastCleanup;
    protected final IndexerRecord[] indexerRecords;

    private static Set<IndexerRecord> getIndexerRecords() {
        final HashSet<IndexerRecord> records = new HashSet<IndexerRecord>();
        IndexingInfo ii = IndexingInfo.getInstance();
        ii.addIndexingInfoListener(new IndexingInfoListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void indexersAdded(List<IndexerInfo> indexers) {
                HashSet hashSet = records;
                synchronized (hashSet) {
                    records.addAll(IndexInfo.getIndexerRecords(indexers));
                }
            }
        });
        IndexManagerImpl manager = (IndexManagerImpl)IndexManager.getIndexManager();
        for (Class<? extends Indexer> clazz : manager.getIndexers()) {
            records.add(new IndexerRecord(clazz));
        }
        MultiMap<Class<? extends Node>, Class<? extends Indexer>> classMap = manager.getIndexerMap();
        for (Collection classes : classMap.values()) {
            for (Class clazz : classes) {
                records.add(new IndexerRecord(clazz));
            }
        }
        return records;
    }

    private static Collection<IndexerRecord> getIndexerRecords(List<IndexerInfo> infos) {
        ArrayList<IndexerRecord> records = new ArrayList<IndexerRecord>(infos.size());
        for (IndexerInfo info : infos) {
            MetaClass metaClass = info.getIndexerMetaClass();
            if (metaClass == null) continue;
            records.add(new IndexerRecord(metaClass.getClassName(), info.getIndexerVersion()));
        }
        return records;
    }

    public IndexInfo(long version, long lastCleanup, long cookie) {
        this(8, version, lastCleanup, cookie, INDEXER_RECORDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexInfo(int indexInfoVersion, long version, long lastCleanup, long cookie, Set<IndexerRecord> indexerRecords) {
        this.indexInfoVersion = indexInfoVersion;
        this.version = version;
        this.lastCleanup = lastCleanup;
        this.cookie = cookie;
        Set<IndexerRecord> set = indexerRecords;
        synchronized (set) {
            this.indexerRecords = indexerRecords.toArray(new IndexerRecord[indexerRecords.size()]);
        }
    }

    private static final class IndexerRecord {
        private final String className;
        private final String version;

        IndexerRecord(Class<? extends Indexer> clazz) {
            this(clazz.getName(), IndexerInfo.getIndexerVersion(clazz));
        }

        IndexerRecord(String className, String version) {
            this.className = className;
            this.version = version;
        }

        String getClassName() {
            return this.className;
        }

        String getVersion() {
            return this.version;
        }

        public int hashCode() {
            int hashCode = this.className.hashCode();
            if (this.version != null) {
                hashCode = 31 * hashCode + this.version.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IndexerRecord)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            IndexerRecord other = (IndexerRecord)o;
            return this.className.equals(other.className) && (this.version == null ? other.version == null : this.version.equals(other.version));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.className);
            if (this.version == null) {
                builder.append(" (no version information)");
            } else {
                builder.append(" (");
                builder.append(this.version);
                builder.append(")");
            }
            return builder.toString();
        }
    }

    private static final class IndexInfoFactory
    extends ObjectFactory {
        private IndexInfoFactory() {
        }

        public byte getObjectCode() {
            return -22;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            int indexInfoVersion = input.readInt();
            if (indexInfoVersion != 8) {
                throw new AssemblyException("Obsolete index info.  IndexInfo version: " + indexInfoVersion + "  Current version: 8", (AssemblyFactory)this);
            }
            long version = input.readLong();
            long lastCleanup = input.readLong();
            long cookie = input.readLong();
            Object[] array = (Object[])INDEXER_RECORD_ARRAY_FACTORY.assemble(input);
            HashSet<IndexerRecord> indexerRecords = new HashSet<IndexerRecord>(array.length);
            for (Object o : array) {
                indexerRecords.add((IndexerRecord)o);
            }
            Set<IndexerRecord> set = INDEXER_RECORDS;
            synchronized (set) {
                for (IndexerRecord record : INDEXER_RECORDS) {
                    if (indexerRecords.contains(record)) continue;
                    throw new AssemblyException("Missing index data for " + record, (AssemblyFactory)this);
                }
            }
            return new IndexInfo(indexInfoVersion, version, lastCleanup, cookie, indexerRecords);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            IndexInfo indexInfo = (IndexInfo)object;
            output.writeInt(indexInfo.indexInfoVersion);
            output.writeLong(indexInfo.version);
            output.writeLong(indexInfo.lastCleanup);
            output.writeLong(indexInfo.cookie);
            INDEXER_RECORD_ARRAY_FACTORY.disassemble((Object)indexInfo.indexerRecords, output);
        }
    }

    private static final class IndexerRecordFactory
    extends ObjectFactory {
        private IndexerRecordFactory() {
        }

        public byte getObjectCode() {
            return -21;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            String className = input.readUTF();
            boolean hasVersion = input.readBoolean();
            return new IndexerRecord(className, hasVersion ? input.readUTF() : null);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            IndexerRecord record = (IndexerRecord)object;
            output.writeUTF(record.getClassName());
            String version = record.getVersion();
            output.writeBoolean(version != null);
            if (version != null) {
                output.writeUTF(record.getVersion());
            }
        }
    }
}

