/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import oracle.jpub.reflect.Client;
import oracle.jpub.reflect.RClass;
import oracle.jpub.reflect.RObject;

public class RConstructor {
    private RClass m_declaringClass;
    private int m_modifiers;
    private RClass[] m_parameterTypes;
    private Constructor m_constructor;
    private boolean m_isDeclared;

    private RConstructor() {
    }

    static RConstructor[] map(RClass jc, int[] modifiers, String[][] parameterTypes) throws ClassNotFoundException {
        RConstructor[] ca = new RConstructor[modifiers.length];
        for (int i = 0; i < ca.length; ++i) {
            ca[i] = RConstructor.newRConstructor(jc, modifiers[i], parameterTypes[i]);
        }
        return ca;
    }

    static RConstructor[] map(RClass jc, Constructor[] constructors) {
        RConstructor[] ca = new RConstructor[constructors.length];
        for (int i = 0; i < ca.length; ++i) {
            ca[i] = RConstructor.newRConstructor(jc, constructors[i]);
        }
        return ca;
    }

    static RConstructor newRConstructor(RClass jc, RClass[] parameterTypes, boolean isDeclared) throws ClassNotFoundException {
        RConstructor c = new RConstructor();
        c.m_declaringClass = jc;
        c.m_parameterTypes = parameterTypes;
        c.m_isDeclared = isDeclared;
        return c;
    }

    static RConstructor newRConstructor(RClass jc, Constructor c) {
        RConstructor co = new RConstructor();
        co.m_declaringClass = jc;
        co.m_constructor = c;
        return co;
    }

    private static RConstructor newRConstructor(RClass jc, int modif, String[] args) throws ClassNotFoundException {
        RConstructor co = new RConstructor();
        co.m_declaringClass = jc;
        co.m_modifiers = modif;
        co.m_parameterTypes = new RClass[args.length];
        for (int i = 0; i < args.length; ++i) {
            co.m_parameterTypes[i] = RClass.newRClass(jc, args[i]);
        }
        return co;
    }

    public String toString() {
        if (this.m_constructor == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(Modifier.toString(this.m_modifiers));
            sb.append(" ");
            sb.append(this.m_declaringClass.toString());
            sb.append("(");
            for (int i = 0; i < this.m_parameterTypes.length; ++i) {
                sb.append(this.m_parameterTypes[i]);
                if (i >= this.m_parameterTypes.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            return sb.toString();
        }
        return this.m_constructor.toString();
    }

    public RClass getDeclaringClass() {
        if (this.m_declaringClass == null) {
            this.m_declaringClass = RClass.newRClass(this.m_constructor.getDeclaringClass());
        }
        return this.m_declaringClass;
    }

    public String getName() {
        return this.getDeclaringClass().getName();
    }

    public int getModifiers() {
        return this.m_constructor == null ? this.m_modifiers : this.m_constructor.getModifiers();
    }

    public RClass[] getParameterTypes() {
        if (this.m_parameterTypes == null) {
            Class<?>[] pt = this.m_constructor.getParameterTypes();
            this.m_parameterTypes = new RClass[pt.length];
            for (int i = 0; i < pt.length; ++i) {
                this.m_parameterTypes[i] = RClass.newRClass(pt[i]);
            }
        }
        return this.m_parameterTypes;
    }

    public RClass[] getExceptionTypes() {
        throw new IllegalArgumentException("getExceptionTypes(): not implemented");
    }

    public RObject newInstance(Object[] args) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (this.m_constructor == null || this.isRemote(args)) {
            return new RObject(this.m_declaringClass.getDefaultContext(), this.m_declaringClass.getName(), Client.getSignature(this.getParameterTypes()), args, this.m_isDeclared);
        }
        return new RObject(this.m_constructor.newInstance(args), true, true);
    }

    private boolean isRemote(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || !(args[i] instanceof RObject)) continue;
            return true;
        }
        return false;
    }
}

