/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

public final class CharArrayCharSequence
implements CharSequence {
    private final char[] array;
    private final int offset;
    private final int length;

    public CharArrayCharSequence(char[] array) {
        this.array = array;
        this.offset = 0;
        this.length = array.length;
    }

    public CharArrayCharSequence(char[] array, int offset, int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException("length negative");
        }
        if (offset + length > array.length) {
            throw new IndexOutOfBoundsException("offset + length (" + (offset + length) + ") > array length (" + array.length + ")");
        }
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    public CharArrayCharSequence(CharArrayCharSequence sequence, int start, int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("start negative");
        }
        if (end < 0) {
            throw new IndexOutOfBoundsException("end negative");
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start (" + start + ") > end (" + end + ")");
        }
        if (end > sequence.length) {
            throw new IndexOutOfBoundsException("end (" + end + ") > sequence length (" + sequence.length + ")");
        }
        this.array = sequence.array;
        this.offset = sequence.offset + start;
        this.length = end - start;
    }

    public CharArrayCharSequence(char c) {
        this.array = new char[]{c};
        this.offset = 0;
        this.length = 1;
    }

    @Override
    public char charAt(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException("index (" + index + ") >= length (" + this.length + ")");
        }
        return this.array[this.offset + index];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CharArrayCharSequence(this, start, end);
    }

    @Override
    public String toString() {
        return String.valueOf(this.array, this.offset, this.length);
    }
}

