/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.util;

import oracle.javatools.buffer.ReadTextBuffer;

public final class KeywordTable {
    private int tableSize = 16;
    private int tableSizeMask;
    private boolean isCaseSensitive;
    private Keyword[] hashTable;

    public KeywordTable(int numKeywords) {
        while (this.tableSize < numKeywords) {
            this.tableSize <<= 1;
        }
        this.tableSizeMask = this.tableSize - 1;
        this.isCaseSensitive = true;
        this.hashTable = new Keyword[this.tableSize];
    }

    public void setCaseSensitivity(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public void addKeyword(String keyword, int token) {
        Keyword key = new Keyword(keyword, token, this.isCaseSensitive);
        int hash = key.getHash();
        int bucket = hash & this.tableSizeMask;
        Keyword nextKey = this.hashTable[bucket];
        this.hashTable[bucket] = key;
        key.setNext(nextKey);
    }

    public int lookupKeyword(ReadTextBuffer buffer, int startOffset, int endOffset, int precomputedHash) {
        int bucket = precomputedHash & this.tableSizeMask;
        if (this.isCaseSensitive) {
            for (Keyword key = this.hashTable[bucket]; key != null; key = key.getNext()) {
                if (key.getHash() != precomputedHash || !key.matches(buffer, startOffset, endOffset)) continue;
                return key.getToken();
            }
        } else {
            for (Keyword key = this.hashTable[bucket]; key != null; key = key.getNext()) {
                if (key.getHash() != precomputedHash || !key.matchesInsensitive(buffer, startOffset, endOffset)) continue;
                return key.getToken();
            }
        }
        return -1;
    }

    public static int computeHash(char[] keyword) {
        int hash = 0;
        int length = keyword.length;
        for (int i = 0; i < length; ++i) {
            hash += keyword[i];
        }
        return hash;
    }

    public static int computeInsensitiveHash(char[] keyword) {
        int hash = 0;
        int length = keyword.length;
        for (int i = 0; i < length; ++i) {
            hash += Character.toLowerCase(keyword[i]);
        }
        return hash;
    }

    public static int computePartialHash(char nextChar, int lastHash) {
        return lastHash + nextChar;
    }

    public static int computeInsensitivePartialHash(char nextChar, int lastHash) {
        return lastHash + Character.toLowerCase(nextChar);
    }

    private static final class Keyword {
        private char[] keyword;
        private int token;
        private int hash;
        private Keyword next;

        private Keyword(String keywordStr, int token, boolean isCaseSensitive) {
            this.keyword = keywordStr.toCharArray();
            this.token = token;
            this.hash = isCaseSensitive ? KeywordTable.computeHash(this.keyword) : KeywordTable.computeInsensitiveHash(this.keyword);
            this.next = null;
        }

        private int getHash() {
            return this.hash;
        }

        private int getToken() {
            return this.token;
        }

        private char[] getKeyword() {
            return this.keyword;
        }

        private Keyword getNext() {
            return this.next;
        }

        private void setNext(Keyword next) {
            this.next = next;
        }

        private boolean matches(ReadTextBuffer textBuffer, int startOffset, int endOffset) {
            int keywordLength = this.keyword.length;
            if (keywordLength == endOffset - startOffset) {
                int i = 0;
                while (i < keywordLength) {
                    if (this.keyword[i++] == textBuffer.getChar(startOffset++)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean matchesInsensitive(ReadTextBuffer textBuffer, int startOffset, int endOffset) {
            int keywordLength = this.keyword.length;
            if (keywordLength == endOffset - startOffset) {
                int i = 0;
                while (i < keywordLength) {
                    char t;
                    char k;
                    if ((k = this.keyword[i++]) == (t = textBuffer.getChar(startOffset++)) || Character.toLowerCase(k) == Character.toLowerCase(t)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

