/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import javax.tools.Diagnostic;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceError;

public final class ErrorSym
extends Sym
implements SourceError {
    @CodeSharingSafe(value="StaticField")
    public static final ErrorSym[] EMPTY_ARRAY = new ErrorSym[0];
    public short errorCode;
    public short errorToken;
    public int errorIntData0;
    public int errorIntData1;
    public Object[] errorRefData = EMPTY_OBJECT_ARRAY;
    private String[] errorMessageArguments;
    private String errorMessagePrefix;
    private String errorMessageOverride;
    public Sym errorSymbol;
    private int errorStartOffset = -1;
    private int errorEndOffset = -1;

    @Override
    public short getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String[] getErrorArguments() {
        return this.errorMessageArguments;
    }

    @Override
    public short getErrorToken() {
        return this.errorToken;
    }

    @Override
    public int getErrorSeverity() {
        return ErrorSym.errorToSeverity(this.getErrorCode());
    }

    @Override
    public int getErrorCategory() {
        return ErrorSym.errorToCategory(this.getErrorCode());
    }

    @Override
    public String getErrorMessage() {
        Object errorMessage = this.errorMessagePrefix != null ? this.errorMessagePrefix : "";
        errorMessage = this.errorMessageOverride != null ? (String)errorMessage + this.errorMessageOverride : (String)errorMessage + ErrorSym.errorToMessage(this.errorCode);
        if (this.errorMessageArguments != null) {
            if (this.errorMessageArguments.length == 1) {
                errorMessage = CommonUtilities.format((String)errorMessage, this.errorMessageArguments[0]);
            } else if (this.errorMessageArguments.length == 2) {
                errorMessage = CommonUtilities.format((String)errorMessage, this.errorMessageArguments[0], this.errorMessageArguments[1]);
            }
        }
        return errorMessage;
    }

    @Override
    public SourceElement getErrorSymbol() {
        return this.errorSymbol;
    }

    @Override
    @Deprecated
    public int getErrorData0() {
        return this.getErrorIntData0();
    }

    @Override
    @Deprecated
    public int getErrorData1() {
        return this.getErrorIntData1();
    }

    @Override
    public int getErrorIntData0() {
        return this.errorIntData0;
    }

    @Override
    public int getErrorIntData1() {
        return this.errorIntData1;
    }

    @Override
    public Object getErrorRefData0() {
        return this.getErrorRefData(0);
    }

    @Override
    public Object getErrorRefData1() {
        return this.getErrorRefData(1);
    }

    @Override
    public Object getErrorRefData(int n) {
        if (0 <= n && n < this.errorRefData.length) {
            return this.errorRefData[n];
        }
        return null;
    }

    @Override
    public Diagnostic getOriginalDiagnostic() {
        Object object;
        if (this.errorRefData.length > 0 && (object = this.errorRefData[this.errorRefData.length - 1]) instanceof Diagnostic) {
            return (Diagnostic)object;
        }
        return null;
    }

    @Override
    public int getStartOffset() {
        if (this.errorStartOffset >= 0) {
            return this.errorStartOffset;
        }
        int start = super.getStartOffset();
        if (start >= 0) {
            return start;
        }
        if (this.errorSymbol != null) {
            return this.errorSymbol.getStartOffset();
        }
        return -1;
    }

    @Override
    public int getEndOffset() {
        if (this.errorEndOffset >= 0) {
            return this.errorEndOffset;
        }
        int end = super.getEndOffset();
        if (end >= 0) {
            return end;
        }
        if (this.errorSymbol != null) {
            return this.errorSymbol.getEndOffset();
        }
        return this.getStartOffset();
    }

    @Override
    public int compareTo(Sym o) {
        int startCompare = super.compareTo(o);
        if (startCompare != 0) {
            return startCompare;
        }
        if (o.symKind == 8) {
            ErrorSym other = (ErrorSym)o;
            short error1 = this.errorCode;
            short error2 = other.errorCode;
            return error1 - error2;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof SourceError) {
            return this.equals((SourceError)o);
        }
        return super.equals(o);
    }

    public boolean equals(SourceError otherSym) {
        if (this == otherSym) {
            return true;
        }
        if (this.errorCode != otherSym.getErrorCode()) {
            return false;
        }
        int thisStart = this.getStartOffset();
        if (thisStart < 0) {
            return false;
        }
        int otherStart = otherSym.getStartOffset();
        if (otherStart < 0) {
            return false;
        }
        if (thisStart != otherStart || this.getEndOffset() != otherSym.getEndOffset()) {
            return false;
        }
        String thisMessage = this.getErrorMessage();
        String otherMessage = otherSym.getErrorMessage();
        return thisMessage.equals(otherMessage);
    }

    public int hashCode() {
        int hashCode = this.errorCode;
        hashCode = hashCode * 31 + this.errorEndOffset;
        hashCode = hashCode * 31 + this.errorIntData0;
        hashCode = hashCode * 31 + this.errorIntData1;
        hashCode = hashCode * 31 + this.errorStartOffset;
        hashCode = hashCode * 31 + this.errorToken;
        if (this.errorMessageArguments != null) {
            for (String str : this.errorMessageArguments) {
                if (str == null) continue;
                hashCode = hashCode * 31 + str.hashCode();
            }
        }
        if (this.errorMessageOverride != null) {
            hashCode = hashCode * 31 + this.errorMessageOverride.hashCode();
        }
        if (this.errorMessagePrefix != null) {
            hashCode = hashCode * 31 + this.errorMessagePrefix.hashCode();
        }
        if (this.errorRefData != null) {
            for (Object object : this.errorRefData) {
                if (object == null) continue;
                hashCode = hashCode * 31 + object.hashCode();
            }
        }
        return hashCode;
    }

    @Override
    protected void checkCloneable() {
        ErrorSym.unsupported("May not clone errors.");
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        ErrorSym sym = (ErrorSym)super.cloneSelf(targetFile);
        sym.symStart = this.symStart;
        sym.symEnd = this.symEnd;
        sym.errorCode = this.errorCode;
        sym.errorToken = this.errorToken;
        sym.errorIntData0 = this.errorIntData0;
        sym.errorIntData1 = this.errorIntData1;
        sym.errorRefData = (Object[])this.errorRefData.clone();
        sym.errorMessagePrefix = this.errorMessagePrefix;
        sym.errorMessageArguments = this.errorMessageArguments == null ? null : (String[])this.errorMessageArguments.clone();
        sym.errorMessageOverride = this.errorMessageOverride;
        sym.errorStartOffset = this.errorStartOffset;
        sym.errorEndOffset = this.errorEndOffset;
        if (this.errorSymbol != null) {
            Sym mappedSym = this.errorSymbol.getMapping();
            if (mappedSym == null) {
                ErrorSym.panic("Failed to map the error Sym");
            }
            sym.errorSymbol = mappedSym;
        }
        return sym;
    }

    @Override
    protected void verboseSelf(StringBuilder buffer) {
        buffer.append(" \"");
        buffer.append(this.getErrorMessage());
        buffer.append("\" (");
        buffer.append(this.errorCode);
        buffer.append(')');
    }

    public void setErrorMessageArguments(String[] arguments) {
        this.errorMessageArguments = arguments;
    }

    public void setErrorMessagePrefix(String prefix) {
        this.errorMessagePrefix = prefix;
    }

    public void setErrorMessage(String errorMessageOverride) {
        this.errorMessageOverride = errorMessageOverride;
    }

    public void setStartOffset(int startOffset) {
        this.errorStartOffset = startOffset;
    }

    public void setEndOffset(int endOffset) {
        this.errorEndOffset = endOffset;
    }
}

