/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.common.AnnotationComponents;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickComponent;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.ContextImageC;
import oracle.javatools.parser.java.v2.internal.compiler.InputImpl;
import oracle.javatools.parser.java.v2.internal.compiler.OutputImpl;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.BindingPatternSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.LabelSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.RootSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.CatchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ForStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.SwitchStmt;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceTryResourcesElement;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;

abstract class ContextImageD
extends ContextImageC
implements CallerContext.Constants {
    ContextImageD(CompilerDriver compiler, Sym cookie) {
        super(compiler, cookie);
    }

    protected final void listMembers(JavaType targetClass, InputImpl options, OutputImpl output) {
        if (targetClass == null) {
            return;
        }
        if ("<init>".equals(options.name)) {
            this.listMembersDeclared(targetClass, options, output);
            return;
        }
        output.processed().clear();
        this.listMembersRecursive(targetClass, options, output);
    }

    protected final void listNames(JavaPackage lhs, InputImpl options, OutputImpl output) {
        boolean addTypes = options.input(4);
        boolean addPackages = options.input(2);
        if (addTypes) {
            for (JavaClass type : lhs.getDeclaredClasses()) {
                this.processElement(type, options, output);
            }
        }
        if (addPackages) {
            for (JavaPackage packag : lhs.getPackages()) {
                this.processElement(packag, options, output);
            }
        }
    }

    protected final void listNames(Sym scope, InputImpl options, OutputImpl output) {
        boolean addVariables = options.input(8);
        boolean addTypes = options.input(4);
        boolean addLabels = options.input(16);
        boolean addMethods = options.input(1);
        boolean addPrimitiveTypes = addTypes && !options.squash(128);
        byte scopeType = scope.symKind;
        block0 : switch (scopeType) {
            case 6: 
            case 19: {
                MethodSym methodSym = (MethodSym)scope;
                if (!addVariables || !methodSym.hasFormalParameterList()) break;
                for (SourceVariable sourceVariable : methodSym.getSourceParameters()) {
                    FormalParameterSym parameter = (FormalParameterSym)sourceVariable;
                    this.processElement(parameter, options, output);
                }
                break;
            }
            case 2: {
                BlockSym blockSym = (BlockSym)scope;
                if (addVariables) {
                    SourceTryStatement tryStmt;
                    Sym blockGrandParent;
                    for (SourceLocalVariable sourceLocalVariable : blockSym.getLocalVariables()) {
                        LocalVariableSym variable = (LocalVariableSym)sourceLocalVariable;
                        this.processElement(variable, options, output);
                    }
                    Sym blockParent = blockSym.getParentSym();
                    Sym sym = blockGrandParent = blockParent != null ? blockParent.getParentSym() : null;
                    if (blockGrandParent != null && blockGrandParent.getSymbolKind() == 63 && (tryStmt = (SourceTryStatement)((Object)blockGrandParent)).hasTryResourcesElements()) {
                        List<SourceTryResourcesElement> tryResourceElements = tryStmt.getTryResourcesElements();
                        for (SourceTryResourcesElement elem : tryResourceElements) {
                            if (elem.getSymbolKind() != 18) continue;
                            List<SourceVariable> tryResourceVars = ((SourceLocalVariableDeclaration)elem).getVariables();
                            for (SourceVariable tryResourceVar : tryResourceVars) {
                                this.processElement(tryResourceVar, options, output);
                            }
                        }
                    }
                }
                if (!addTypes) break;
                for (SourceClass sourceClass : blockSym.getLocalClasses()) {
                    ClassSym type = (ClassSym)sourceClass;
                    this.processElement((JavaHasName)type, options, output);
                }
                break;
            }
            case 57: {
                ForStmt forStmt = (ForStmt)scope;
                if (!addVariables) break;
                for (SourceLocalVariable sourceLocalVariable : forStmt.getForVariables()) {
                    LocalVariableSym variable = (LocalVariableSym)sourceLocalVariable;
                    this.processElement(variable, options, output);
                }
                break;
            }
            case 50: {
                PrimitiveType[] variable;
                CatchStmt catchClause = (CatchStmt)scope;
                if (!addVariables || (variable = catchClause.getCatchVariable()) == null) break;
                this.processElement((JavaHasName)variable, options, output);
                break;
            }
            case 98: {
                PrimitiveType[] primitiveTypes;
                if (!addTypes && !addMethods) break;
                if (addTypes) {
                    RootSym rootSym = (RootSym)scope;
                    for (SourceClass sourceClass : rootSym.getSourceClasses()) {
                        ClassSym type = (ClassSym)sourceClass;
                        this.processElement((JavaHasName)type, options, output);
                    }
                }
                this.listImports(options, output);
                if (!addPrimitiveTypes) break;
                for (PrimitiveType primitiveType : primitiveTypes = PrimitiveType.PRIMITIVE_objects) {
                    this.processElement(primitiveType, options, output);
                }
                break;
            }
            case 1: {
                Collection<JavaMethod> methods;
                boolean addAnnotations = options.input(32);
                if (!addVariables || !addAnnotations || !this.flag_collect_annotation_element_names) break;
                this.flag_collect_annotation_element_names = false;
                AnnotateSym annotateSym = (AnnotateSym)scope;
                AnnotationComponents components = annotateSym.getComponents();
                JavaType javaType = annotateSym.getAnnotationType();
                if (javaType == null || (methods = javaType.getMethods()) == null) break;
                for (JavaMethod method : methods) {
                    if (!components.containsKey(method.getName())) continue;
                    QuickComponent annotationElement = QuickComponent.createComponent(method);
                    annotationElement.setOwner(annotateSym);
                    this.processElement(annotationElement, options, output);
                }
                break;
            }
            case 60: {
                this.processSwitchStmt((SwitchStmt)scope, options, output);
                break;
            }
            case 23: {
                if (!options.input(64)) break;
                for (Sym sym = scope; sym != null; sym = sym.getParentSym()) {
                    if (sym.symKind != 60) continue;
                    this.processSwitchStmt((SwitchStmt)sym, options, output);
                    break block0;
                }
                break;
            }
            case 83: {
                SourceLambdaExpression expr;
                if (!addVariables || !(expr = (SourceLambdaExpression)((Object)scope)).hasFormalParameters()) break;
                List<SourceLambdaParameter> formalParameters = expr.getFormalParameters();
                for (SourceLambdaParameter param : formalParameters) {
                    this.processElement(param, options, output);
                }
                break;
            }
            case 87: {
                BindingPatternSym variable = (BindingPatternSym)scope;
                if (!addVariables) break;
                this.processElement(variable, options, output);
                break;
            }
        }
        if (addLabels) {
            Sym nextScope = scope.getScope();
            for (Sym sym = scope; sym != null && sym != nextScope; sym = sym.getParentSym()) {
                byte kind = sym.symKind;
                if (47 <= kind && kind < 66) {
                    List<SourceElement> labels = sym.getChildren(16);
                    if (labels.isEmpty()) continue;
                    for (SourceElement element : labels) {
                        LabelSym label = (LabelSym)element;
                        this.processElement(label, options, output);
                    }
                    continue;
                }
                if (!sym.isFilter((byte)104)) continue;
                options.input &= 0xFFFFFFEF;
                break;
            }
        }
    }

    private void processSwitchStmt(SwitchStmt switchStmt, InputImpl options, OutputImpl output) {
        JavaType javaType;
        SourceExpression expr = switchStmt.getControlExpression();
        if (expr != null && (javaType = expr.getResolvedType()) != null) {
            this.processElement(javaType, options, output);
        }
    }

    private void listMembersRecursive(JavaType targetClass, InputImpl options, OutputImpl output) {
        if (targetClass == null) {
            return;
        }
        if (ContextImageD.classProcessed(output.processed(), targetClass)) {
            return;
        }
        this.listMembersDeclared(targetClass, options, output);
        JavaType baseClass = targetClass.getSuperclass();
        if (baseClass != null) {
            this.listMembersRecursive(baseClass, options, output);
        }
        for (JavaType baseInterface : targetClass.getInterfaces()) {
            this.listMembersRecursive(baseInterface, options, output);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void listMembersDeclared(JavaType targetClass, InputImpl options, OutputImpl output) {
        boolean addVariables = options.input(8);
        boolean addTypes = options.input(4);
        boolean addMethods = options.input(1);
        if (addVariables) {
            for (JavaField javaField : targetClass.getDeclaredFields()) {
                this.processElement(javaField, options, output);
            }
        }
        if (addTypes) {
            for (JavaClass javaClass : targetClass.getDeclaredClasses()) {
                if (!javaClass.isExported()) continue;
                this.processElement(javaClass, options, output);
            }
        }
        if (addMethods) {
            void var8_14;
            boolean isConstructor = "<init>".equals(options.name);
            if (isConstructor) {
                Iterator<JavaMethod> iterator = targetClass.getDeclaredConstructors().iterator();
            } else {
                Iterator<JavaMethod> iterator = targetClass.getDeclaredMethods().iterator();
            }
            while (var8_14.hasNext()) {
                JavaMethod thing = (JavaMethod)var8_14.next();
                this.processElement(thing, options, output);
            }
        }
    }

    private final void listImports(InputImpl options, OutputImpl output) {
        if (options.squash(1)) {
            return;
        }
        FileSym sourceFile = this.symCookie.symFile;
        List<SourceImport> importSyms = sourceFile.getSourceImports();
        for (ImportSym importSym : importSyms) {
            if (!importSym.isNarrow() || importSym.isInvalid()) continue;
            this.processImportedNarrow(importSym, options, output);
        }
        String string = sourceFile.getPackageName();
        if (string.length() > 0) {
            this.processImportedPackage(string, options, output);
        }
        for (ImportSym importSym : importSyms) {
            if (importSym.isNarrow() || importSym.isInvalid()) continue;
            if (importSym.isStatic()) {
                this.processImportedMembers(importSym.getQualifyingType(), options, output);
                continue;
            }
            this.processImportedPackage(importSym.getName(), options, output);
        }
        this.processImportedPackage("java.lang.*", options, output);
    }

    private void processImportedNarrow(ImportSym importSym, InputImpl options, OutputImpl output) {
        JavaClass qualifying;
        String fqname = importSym.getName();
        int lastDot = fqname.lastIndexOf(46);
        String importedName = lastDot == -1 ? fqname : fqname.substring(lastDot + 1);
        if (options.name != null && !options.name.equals(importedName)) {
            return;
        }
        if (importSym.isStatic() && (qualifying = importSym.getQualifyingType()) != null) {
            JavaField thing;
            Collection<JavaMethod> things;
            if (options.input(1) && !(things = qualifying.getMethods(importedName)).isEmpty()) {
                for (JavaMethod thing2 : things) {
                    this.processElement(thing2, options, output);
                }
            }
            if (options.input(8) && (thing = qualifying.getField(importedName)) != null) {
                this.processElement(thing, options, output);
            }
        }
        if (options.input(4)) {
            JavaClass result;
            if (options.input(128) && !importSym.isStatic() && lastDot > 0) {
                String packageName = fqname.substring(0, lastDot);
                this.processImportedPackage(packageName, options, output);
            }
            if ((result = this.compiler.provider.getClass(fqname)) != null) {
                this.processElement(result, options, output);
            }
        }
    }

    private void processImportedPackage(String nameDotStar, InputImpl options, OutputImpl output) {
        if (options.input(4)) {
            String name = nameDotStar.endsWith(".*") ? nameDotStar.substring(0, nameDotStar.length() - 2) : nameDotStar;
            if (output.containsKey(name)) {
                return;
            }
            output.keys().add(name);
            JavaPackage p = this.compiler.provider.getPackage(name);
            Collection<JavaClass> things = p.getDeclaredClasses();
            if (!things.isEmpty()) {
                for (JavaType javaType : things) {
                    this.processElement(javaType, options, output);
                }
            }
        }
    }

    private void processImportedMembers(JavaType qualifying, InputImpl options, OutputImpl output) {
        Collection<JavaMember> things;
        if (qualifying == null) {
            return;
        }
        if (options.input(1) && !(things = qualifying.getMethods()).isEmpty()) {
            for (JavaMember thing : things) {
                this.processElement(thing, options, output);
            }
        }
        if (options.input(8) && !(things = qualifying.getFields()).isEmpty()) {
            for (JavaMember thing : things) {
                this.processElement(thing, options, output);
            }
        }
        if (options.input(4) && !(things = qualifying.getClasses()).isEmpty()) {
            for (JavaMember thing : things) {
                this.processElement(thing, options, output);
            }
        }
    }

    private void processElement(JavaHasName thing, InputImpl options, OutputImpl output) {
        String key;
        if (options.input(64)) {
            this.processEnumConstants(thing, options, output);
        }
        if (output.containsKey(key = thing.getName())) {
            return;
        }
        if (!this.checkFilter(thing, options)) {
            return;
        }
        if (this.allowAccess(thing)) {
            output.add(key, thing);
        } else {
            output.add(key, null);
        }
    }

    private void processEnumConstants(JavaHasName thing, InputImpl options, OutputImpl output) {
        if (thing instanceof JavaClass && ((JavaClass)thing).isEnum()) {
            for (JavaField javaField : ((JavaClass)thing).getDeclaredFields()) {
                if (!javaField.isEnumConstant()) continue;
                this.processElement(javaField, options, output);
            }
        }
    }

    private void processElement(JavaMethod thing, InputImpl options, OutputImpl output) {
        Object key = thing.getName() + thing.getDescriptor();
        key = ((String)key).substring(0, ((String)key).indexOf(41) + 1);
        if (!options.match(thing) || output.containsKey((String)key)) {
            return;
        }
        if (!this.processVisible(thing) || !this.checkFilter(thing, options)) {
            return;
        }
        if (this.allowAccess(thing)) {
            output.add((String)key, thing);
        } else {
            output.add((String)key, null);
        }
    }

    private void processElement(JavaMember thing, InputImpl options, OutputImpl output) {
        if (options.input(64)) {
            this.processEnumConstants(thing, options, output);
        }
        String key = thing.getName();
        if (!options.match(thing) || output.containsKey(key)) {
            return;
        }
        if (!this.processVisible(thing) || !this.checkFilter(thing, options)) {
            return;
        }
        if (this.allowAccess(thing)) {
            output.add(key, thing);
        } else {
            output.add(key, null);
        }
    }

    private boolean checkFilter(JavaMember thing, InputImpl options) {
        JavaClass javaClass;
        if (!this.flag_static && options.squash(4) && (thing.getElementKind() == 3 || thing.isStatic())) {
            return false;
        }
        if (options.squash(16) && thing.isDeprecated()) {
            return false;
        }
        if (options.squash(32) && thing.isHidden()) {
            return false;
        }
        if (options.squash(8) && (javaClass = thing.getOwningClass()) != null && "java.lang.Object".equals(javaClass.getRawName())) {
            return false;
        }
        return this.checkFilter((JavaElement)thing, options);
    }

    private boolean checkFilter(JavaElement thing, InputImpl options) {
        return options.filter == null || options.filter.accepts(thing);
    }
}

