/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.parser.java.v2.common.AbstractElement;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.WildcardType;
import oracle.javatools.parser.java.v2.internal.model.AnnotatedJavaWildcardType;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

public final class SignatureHasType
extends AbstractElement
implements JavaHasType,
UnresolvedType {
    private final JavaProvider provider;
    private final byte ellTeeOrStar;
    protected byte bound = 0;
    private JavaIsGeneric owningGeneric;
    private final String name;
    protected short array = 0;
    protected List<JavaHasType> arguments = Collections.emptyList();
    protected List<InnerType> inners = Collections.emptyList();
    private Collection<JavaAnnotation> unresolvedTypeAnnotations;
    private Collection<JavaAnnotation> unresolvedBoundTypeAnnotations;
    private Collection<UnresolvedType> unresolvedTypeArguments;
    private SignatureHasType qualifyingType;
    private SignatureHasType componentType;

    public SignatureHasType(char ellTeeOrStar, String name, JavaProvider provider) {
        this.ellTeeOrStar = (byte)ellTeeOrStar;
        this.name = name;
        this.owningGeneric = null;
        this.provider = provider;
    }

    public SignatureHasType(char ltstar, JavaProvider provider) {
        this.ellTeeOrStar = (byte)ltstar;
        this.name = null;
        this.owningGeneric = null;
        this.provider = provider;
    }

    SignatureHasType(String name, JavaIsGeneric owner, JavaProvider provider) {
        this.ellTeeOrStar = (byte)84;
        this.name = name;
        this.owningGeneric = owner;
        this.provider = provider;
    }

    private SignatureHasType(SignatureHasType other) {
        this.arguments = other.arguments;
        this.array = other.array;
        this.bound = other.bound;
        this.ellTeeOrStar = other.ellTeeOrStar;
        this.componentType = other.componentType;
        this.inners = other.inners;
        this.name = other.name;
        this.owningGeneric = other.owningGeneric;
        this.provider = other.provider;
        this.qualifyingType = other.qualifyingType;
        this.unresolvedBoundTypeAnnotations = other.unresolvedBoundTypeAnnotations;
        this.unresolvedTypeAnnotations = other.unresolvedTypeAnnotations;
        this.unresolvedTypeArguments = other.unresolvedTypeArguments;
    }

    public void pushTypeArgument(SignatureHasType argument) {
        if (this.inners.isEmpty()) {
            if (this.arguments.isEmpty()) {
                this.arguments = new ArrayList<JavaHasType>();
            }
            this.arguments.add(argument);
        } else {
            int innerLength = this.inners.size();
            InnerType inner = this.inners.get(innerLength - 1);
            if (inner.arguments.isEmpty()) {
                inner.arguments = new ArrayList<JavaHasType>();
            }
            inner.arguments.add(argument);
        }
    }

    public void pushInnerType(String name) {
        if (this.inners.isEmpty()) {
            this.inners = new ArrayList<InnerType>();
        }
        InnerType type = new InnerType(name);
        this.inners.add(type);
    }

    @Override
    public JavaFile getFile() {
        return null;
    }

    @Override
    public int getElementKind() {
        return 1;
    }

    @Override
    public int getModifiers() {
        return 4096;
    }

    @Override
    public JavaElement getOwner() {
        return null;
    }

    @Override
    public JavaType getResolvedType() {
        return this.getResolvedType(null, null, null);
    }

    public JavaType getResolvedType(List<JavaAnnotation> actualTypeAnnotations, Collection<ClassFile.TypeAnnotation> typeAnnotations) {
        return this.getResolvedType(actualTypeAnnotations, typeAnnotations, new ArrayList<ClassFile.TargetInfoPath>());
    }

    private JavaType getResolvedType(List<JavaAnnotation> actualTypeAnnotations, Collection<ClassFile.TypeAnnotation> typeAnnotations, List<ClassFile.TargetInfoPath> typeAnnotationLocation) {
        JavaType result = this.getResolvedTypeImpl(actualTypeAnnotations, typeAnnotations, typeAnnotationLocation);
        if (result != null && result.hasTypeParameters() && !result.hasActualTypeArguments()) {
            result = CommonUtilities.createTypeErasedClass(this.provider, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JavaType getResolvedTypeImpl(List<JavaAnnotation> actualTypeAnnotations, Collection<ClassFile.TypeAnnotation> typeAnnotations, List<ClassFile.TargetInfoPath> typeAnnotationLocation) {
        int typeAnnotationLocationAtStart = typeAnnotationLocation != null ? typeAnnotationLocation.size() : 0;
        try {
            Object object;
            JavaType type;
            List<JavaAnnotation> boundTypeAnnotations = null;
            ArrayList<List<JavaAnnotation>> allDimensionsAnnotations = null;
            if (typeAnnotations != null && this.bound != 0) {
                if (typeAnnotations != null) {
                    boundTypeAnnotations = this.getCurrentTypeAnnotations(actualTypeAnnotations, typeAnnotations, typeAnnotationLocation);
                }
                typeAnnotationLocation.add(new ClassFile.TargetInfoPath(2, 0));
            }
            if (this.array > 0 && typeAnnotations != null) {
                allDimensionsAnnotations = new ArrayList<List<JavaAnnotation>>();
                for (int i = 0; i < this.array; ++i) {
                    List<JavaAnnotation> oneDimensionAnnotations = this.getCurrentTypeAnnotations(actualTypeAnnotations, typeAnnotations, typeAnnotationLocation);
                    allDimensionsAnnotations.add(oneDimensionAnnotations);
                    typeAnnotationLocation.add(new ClassFile.TargetInfoPath(0, 0));
                }
            }
            switch (this.ellTeeOrStar) {
                case 84: {
                    type = this.resolveTypeVariable(this.name);
                    type = this.attachTypeAnnotations(type, actualTypeAnnotations, typeAnnotations, typeAnnotationLocation);
                    break;
                }
                case 42: {
                    type = new WildcardType(null, null, this.provider);
                    break;
                }
                default: {
                    if (this.name == null) {
                        type = PrimitiveType.PRIMITIVE_alpha[this.ellTeeOrStar - 65];
                    } else {
                        type = this.provider.getClassByVMName(this.name);
                        type = this.resolveTypeArguments(type, this.arguments, actualTypeAnnotations, typeAnnotations, typeAnnotationLocation);
                        type = this.attachTypeAnnotations(type, actualTypeAnnotations, typeAnnotations, typeAnnotationLocation);
                        for (InnerType inner : this.inners) {
                            if (type == null) break;
                            if (typeAnnotationLocation != null) {
                                typeAnnotationLocation.add(new ClassFile.TargetInfoPath(1, 0));
                            }
                            JavaClass genericInner = type.getClass(inner.name);
                            JavaType innerType = this.resolveTypeArguments(genericInner, inner.arguments, actualTypeAnnotations, typeAnnotations, typeAnnotationLocation);
                            if ((innerType = this.attachTypeAnnotations(innerType, actualTypeAnnotations, typeAnnotations, typeAnnotationLocation)) != null) {
                                innerType.setQualifyingType(type);
                            }
                            type = innerType;
                        }
                    }
                    if (type != null) break;
                    object = null;
                    return object;
                }
            }
            if (this.array > 0 && type != null) {
                type = typeAnnotations != null && allDimensionsAnnotations != null ? CommonUtilities.createArrayType(this.provider, type, this.array, allDimensionsAnnotations) : CommonUtilities.createArrayType(this.provider, type, this.array);
            }
            if (this.bound != 0) {
                type = CommonUtilities.createWildcardType(this.bound, this.bound == 3 ? null : type, this.provider);
                if (typeAnnotations != null) {
                    if (boundTypeAnnotations != null && !boundTypeAnnotations.isEmpty()) {
                        type = new AnnotatedJavaWildcardType((JavaWildcardType)type, boundTypeAnnotations);
                    } else if (!type.getTypeAnnotations().isEmpty()) {
                        type = new AnnotatedJavaWildcardType((JavaWildcardType)type, Collections.emptyList());
                    }
                }
            }
            object = type;
            return object;
        }
        finally {
            if (typeAnnotationLocation != null) {
                while (typeAnnotationLocation.size() > typeAnnotationLocationAtStart) {
                    typeAnnotationLocation.remove(typeAnnotationLocation.size() - 1);
                }
            }
        }
    }

    private JavaType attachTypeAnnotations(JavaType type, List<JavaAnnotation> actualTypeAnnotations, Collection<ClassFile.TypeAnnotation> typeAnnotations, List<ClassFile.TargetInfoPath> typeAnnotationLocation) {
        if (type != null && typeAnnotations != null) {
            List<JavaAnnotation> typeTypeAnnotations = this.getCurrentTypeAnnotations(actualTypeAnnotations, typeAnnotations, typeAnnotationLocation);
            if (typeTypeAnnotations != null && !typeTypeAnnotations.isEmpty()) {
                type = CommonUtilities.createAnnotatedJavaType(type, typeTypeAnnotations);
            } else if (!type.getTypeAnnotations().isEmpty()) {
                type = CommonUtilities.createAnnotatedJavaType(type, Collections.emptyList());
            }
        }
        return type;
    }

    private List<JavaAnnotation> getCurrentTypeAnnotations(List<JavaAnnotation> actualTypeAnnotations, Collection<ClassFile.TypeAnnotation> typeAnnotations, List<ClassFile.TargetInfoPath> typeAnnotationLocation) {
        if (actualTypeAnnotations == null) {
            return Collections.emptyList();
        }
        ArrayList<JavaAnnotation> grabbedAnnotations = new ArrayList<JavaAnnotation>();
        Iterator<ClassFile.TypeAnnotation> iterator = typeAnnotations.iterator();
        block0: for (int i = 0; i < typeAnnotations.size(); ++i) {
            ClassFile.TypeAnnotation typeAnnotation = iterator.next();
            JavaAnnotation javaAnnotation = actualTypeAnnotations.get(i);
            if (javaAnnotation == null) continue;
            ClassFile.TargetInfo targetInfo = typeAnnotation.getTargetInfo();
            ClassFile.TargetInfoPaths path = targetInfo.getTargetInfoPaths();
            if (path != null) {
                List<ClassFile.TargetInfoPath> paths = path.getPaths();
                if (paths.size() != typeAnnotationLocation.size()) continue;
                for (int j = 0; j < paths.size(); ++j) {
                    if (!paths.get(j).equals(typeAnnotationLocation.get(j))) continue block0;
                }
            } else if (typeAnnotationLocation.isEmpty()) continue;
            grabbedAnnotations.add(actualTypeAnnotations.get(i));
        }
        return grabbedAnnotations;
    }

    private JavaType resolveTypeArguments(JavaType type, List<JavaHasType> arguments, List<JavaAnnotation> actualTypeAnnotations, Collection<ClassFile.TypeAnnotation> typeAnnotations, List<ClassFile.TargetInfoPath> typeAnnotationLocation) {
        if (type == null) {
            return null;
        }
        if (arguments.isEmpty()) {
            return type;
        }
        if (!type.hasTypeParameters()) {
            return type;
        }
        JavaType[] array = new JavaType[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            int typeLocationIndex = 0;
            if (typeAnnotationLocation != null) {
                typeLocationIndex = typeAnnotationLocation.size();
                typeAnnotationLocation.add(new ClassFile.TargetInfoPath(3, (byte)i));
            }
            SignatureHasType thing = (SignatureHasType)arguments.get(i);
            array[i] = thing.getResolvedType(actualTypeAnnotations, typeAnnotations, typeAnnotationLocation);
            if (typeAnnotationLocation == null) continue;
            typeAnnotationLocation.remove(typeLocationIndex);
        }
        try {
            return CommonUtilities.createParameterizedType(this.provider, type, array);
        }
        catch (IllegalArgumentException e) {
            return type;
        }
    }

    private List<UnresolvedType> processUnresolvedTypeArguments(List<JavaHasType> arguments, List<JavaAnnotation> actualTypeAnnotations, Collection<ClassFile.TypeAnnotation> typeAnnotations, List<ClassFile.TargetInfoPath> typeAnnotationLocation) {
        if (arguments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<UnresolvedType> unresolvedTypes = new ArrayList<UnresolvedType>();
        for (int i = 0; i < arguments.size(); ++i) {
            int typeLocationIndex = 0;
            if (typeAnnotationLocation != null) {
                typeLocationIndex = typeAnnotationLocation.size();
                typeAnnotationLocation.add(new ClassFile.TargetInfoPath(3, (byte)i));
            }
            SignatureHasType argument = (SignatureHasType)arguments.get(i);
            unresolvedTypes.add(argument.getUnresolvedType(actualTypeAnnotations, typeAnnotations, typeAnnotationLocation));
            if (typeAnnotationLocation == null) continue;
            typeAnnotationLocation.remove(typeLocationIndex);
        }
        return unresolvedTypes;
    }

    private JavaTypeVariable resolveTypeVariable(String name) {
        for (JavaIsGeneric generic = this.owningGeneric; generic != null; generic = generic.getOwningClass()) {
            JavaTypeVariable found = generic.getTypeParameter(name);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public UnresolvedType getUnresolvedType() {
        return this.getUnresolvedType(null, null);
    }

    public UnresolvedType getUnresolvedType(List<JavaAnnotation> actualTypeAnnotations, Collection<ClassFile.TypeAnnotation> typeAnnotations) {
        return this.getUnresolvedType(actualTypeAnnotations, typeAnnotations, new ArrayList<ClassFile.TargetInfoPath>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnresolvedType getUnresolvedType(List<JavaAnnotation> actualTypeAnnotations, Collection<ClassFile.TypeAnnotation> typeAnnotations, List<ClassFile.TargetInfoPath> typeAnnotationLocation) {
        SignatureHasType result = new SignatureHasType(this);
        int typeAnnotationLocationAtStart = typeAnnotationLocation != null ? typeAnnotationLocation.size() : 0;
        try {
            if (result.bound != 0) {
                result.unresolvedBoundTypeAnnotations = this.getCurrentTypeAnnotations(actualTypeAnnotations, typeAnnotations, typeAnnotationLocation);
                if (typeAnnotationLocation != null) {
                    typeAnnotationLocation.add(new ClassFile.TargetInfoPath(2, 0));
                }
            }
            ArrayList<List<JavaAnnotation>> arrayTypeAnnotations = new ArrayList<List<JavaAnnotation>>();
            if (result.array > 0) {
                for (int i = 0; i < result.array; ++i) {
                    List<JavaAnnotation> oneDimensionAnnotations = this.getCurrentTypeAnnotations(actualTypeAnnotations, typeAnnotations, typeAnnotationLocation);
                    arrayTypeAnnotations.add(oneDimensionAnnotations);
                    if (typeAnnotationLocation == null) continue;
                    typeAnnotationLocation.add(new ClassFile.TargetInfoPath(0, 0));
                }
            }
            result.unresolvedTypeAnnotations = this.getCurrentTypeAnnotations(actualTypeAnnotations, typeAnnotations, typeAnnotationLocation);
            result.unresolvedTypeArguments = this.processUnresolvedTypeArguments(result.arguments, actualTypeAnnotations, typeAnnotations, typeAnnotationLocation);
            List<InnerType> originalInners = result.inners;
            for (int i = 0; i < originalInners.size(); ++i) {
                InnerType inner = originalInners.get(i);
                if (typeAnnotationLocation != null) {
                    typeAnnotationLocation.add(new ClassFile.TargetInfoPath(1, 0));
                }
                SignatureHasType innerType = new SignatureHasType((char)result.ellTeeOrStar, result.name + "." + inner.name, result.provider);
                innerType.arguments = inner.arguments;
                innerType.array = result.array;
                result.array = 0;
                innerType.bound = result.bound;
                result.bound = 0;
                innerType.owningGeneric = result.owningGeneric;
                if (result.unresolvedBoundTypeAnnotations != null) {
                    innerType.unresolvedBoundTypeAnnotations = new ArrayList<JavaAnnotation>(result.unresolvedBoundTypeAnnotations);
                    result.unresolvedBoundTypeAnnotations.clear();
                }
                ArrayList<InnerType> innerInners = new ArrayList<InnerType>();
                for (int j = i + 1; j < originalInners.size(); ++j) {
                    innerInners.add(originalInners.get(j));
                }
                innerType.inners = innerInners;
                innerType.qualifyingType = result;
                result = innerType;
                result.unresolvedTypeAnnotations = this.getCurrentTypeAnnotations(actualTypeAnnotations, typeAnnotations, typeAnnotationLocation);
                result.unresolvedTypeArguments = this.processUnresolvedTypeArguments(inner.arguments, actualTypeAnnotations, typeAnnotations, typeAnnotationLocation);
            }
            int arrayLen = result.array;
            if (arrayLen > 0) {
                for (int i = 0; i < arrayLen; ++i) {
                    SignatureHasType componentType = new SignatureHasType((char)result.ellTeeOrStar, result.name, result.provider);
                    componentType.arguments = new ArrayList<JavaHasType>(result.arguments);
                    componentType.array = (short)(i + 1);
                    componentType.inners = new ArrayList<InnerType>(result.inners);
                    componentType.owningGeneric = result.owningGeneric;
                    componentType.qualifyingType = result.qualifyingType;
                    if (result.unresolvedBoundTypeAnnotations != null) {
                        componentType.unresolvedBoundTypeAnnotations = new ArrayList<JavaAnnotation>(result.unresolvedBoundTypeAnnotations);
                    }
                    if (result.unresolvedTypeArguments != null) {
                        componentType.unresolvedTypeArguments = new ArrayList<UnresolvedType>(result.unresolvedTypeArguments);
                    }
                    componentType.unresolvedTypeAnnotations = (Collection)arrayTypeAnnotations.get(arrayLen - 1 - i);
                    componentType.componentType = result;
                    result = componentType;
                }
            }
            SignatureHasType signatureHasType = result;
            return signatureHasType;
        }
        finally {
            if (typeAnnotationLocation != null) {
                while (typeAnnotationLocation.size() > typeAnnotationLocationAtStart) {
                    typeAnnotationLocation.remove(typeAnnotationLocation.size() - 1);
                }
            }
        }
    }

    private String getUnresolvedName(boolean simplified, boolean includeTypeArguments) {
        String searchString;
        switch (this.ellTeeOrStar) {
            case 84: {
                searchString = this.name;
                break;
            }
            case 42: {
                searchString = "?";
                break;
            }
            default: {
                if (this.name != null) {
                    if (simplified) {
                        int dollar;
                        int slash = this.name.lastIndexOf(47);
                        searchString = this.name.substring(slash <= (dollar = this.name.lastIndexOf(36)) + 1 ? dollar : slash + 1);
                        break;
                    }
                    searchString = this.name;
                    searchString = searchString.replace('/', '.');
                    searchString = searchString.replace('$', '.');
                    break;
                }
                PrimitiveType primitive = PrimitiveType.PRIMITIVE_alpha[this.ellTeeOrStar - 65];
                searchString = primitive.getName();
            }
        }
        StringBuilder builder = new StringBuilder(searchString);
        if (includeTypeArguments && !this.arguments.isEmpty()) {
            builder.append('<');
            int comma = 0;
            for (JavaHasType arg : this.arguments) {
                UnresolvedType unresolved;
                if (comma++ > 0) {
                    builder.append(", ");
                }
                builder.append((unresolved = arg.getUnresolvedType()) != null ? unresolved : "java.lang.Object");
            }
            builder.append('>');
        }
        builder.append("[]".repeat(this.array));
        switch (this.bound) {
            case 1: {
                builder.insert(0, "? extends ");
                break;
            }
            case 2: {
                builder.insert(0, "? super ");
            }
        }
        return builder.toString();
    }

    @Override
    public String getSimplifiedName() {
        return this.getUnresolvedName(true, false);
    }

    @Override
    public String getVMName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.getUnresolvedName(false, true);
    }

    @Override
    public Collection<UnresolvedType> getTypeArguments() {
        return this.unresolvedTypeArguments == null ? Collections.emptyList() : this.unresolvedTypeArguments;
    }

    @Override
    public Collection<JavaAnnotation> getTypeAnnotations() {
        return this.unresolvedTypeAnnotations == null ? Collections.emptyList() : this.unresolvedTypeAnnotations;
    }

    @Override
    public Collection<JavaAnnotation> getBoundTypeAnnotations() {
        return this.unresolvedBoundTypeAnnotations == null ? Collections.emptyList() : this.unresolvedBoundTypeAnnotations;
    }

    @Override
    public UnresolvedType getQualifyingType() {
        return this.qualifyingType;
    }

    @Override
    public UnresolvedType getComponentType() {
        return this.componentType;
    }

    @Override
    public UnresolvedType getBaseComponentType() {
        SignatureHasType result = this.componentType;
        if (result == null) {
            return result;
        }
        while (result.componentType != null) {
            result = result.componentType;
        }
        return result;
    }

    private class InnerType {
        private final String name;
        protected List<JavaHasType> arguments = Collections.emptyList();

        private InnerType(String name) {
            this.name = name;
        }
    }
}

