/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2;

import oracle.javatools.util.UnexpectedExceptionError;

public enum JdkVersion {
    JDK_UNKNOWN("0.0"),
    JDK_1("1.1"),
    JDK_2("1.2"),
    JDK_3("1.3"),
    JDK_4("1.4"),
    JDK_5("1.5"),
    JDK_6("1.6"),
    JDK_7("1.7"),
    JDK_8("1.8"),
    JDK_9("9"),
    JDK_10("10"),
    JDK_11("11"),
    JDK_12("12"),
    JDK_13("13"),
    JDK_14("14"),
    JDK_15("15"),
    JDK_16("16"),
    JDK_17("17"),
    JDK_18("18"),
    JDK_19("19"),
    JDK_20("20"),
    JDK_21("21"),
    JDK_22("22"),
    JDK_23("23"),
    JDK_24("24"),
    JDK_25("25");

    private String versionString;
    private static JdkVersion currentJdkVersion;
    private static int classFileMajorVersionOffset;
    private static final Object[][] JDK_IDENTIFIER_TABLE;

    public static JdkVersion getMinVersion() {
        return JDK_3;
    }

    public static JdkVersion getMaxVersion() {
        JdkVersion[] versions = JdkVersion.values();
        return versions[versions.length - 1];
    }

    public int getMajorVersion() {
        return this.ordinal();
    }

    public int getClassFileMajorVersion() {
        return this.ordinal() + classFileMajorVersionOffset;
    }

    public boolean hasGenerics() {
        return this.ordinal() >= JDK_5.ordinal();
    }

    public boolean isGreaterThanOrEqualTo2() {
        return this.ordinal() >= JDK_2.ordinal();
    }

    public boolean isGreaterThanOrEqualTo3() {
        return this.ordinal() >= JDK_3.ordinal();
    }

    public boolean isGreaterThanOrEqualTo4() {
        return this.ordinal() >= JDK_4.ordinal();
    }

    public boolean isGreaterThanOrEqualTo5() {
        return this.ordinal() >= JDK_5.ordinal();
    }

    public boolean isGreaterThanOrEqualTo6() {
        return this.ordinal() >= JDK_6.ordinal();
    }

    public boolean isGreaterThanOrEqualTo7() {
        return this.ordinal() >= JDK_7.ordinal();
    }

    public boolean isGreaterThanOrEqualTo8() {
        return this.ordinal() >= JDK_8.ordinal();
    }

    public boolean isGreaterThanOrEqualTo9() {
        return this.ordinal() >= JDK_9.ordinal();
    }

    public boolean isGreaterThanOrEqualTo10() {
        return this.ordinal() >= JDK_10.ordinal();
    }

    public boolean isGreaterThanOrEqualTo11() {
        return this.ordinal() >= JDK_11.ordinal();
    }

    public boolean isGreaterThanOrEqualTo12() {
        return this.ordinal() >= JDK_12.ordinal();
    }

    public boolean isGreaterThanOrEqualTo13() {
        return this.ordinal() >= JDK_13.ordinal();
    }

    public boolean isGreaterThanOrEqualTo14() {
        return this.ordinal() >= JDK_14.ordinal();
    }

    public boolean isGreaterThanOrEqualTo15() {
        return this.ordinal() >= JDK_15.ordinal();
    }

    public boolean isGreaterThanOrEqualTo16() {
        return this.ordinal() >= JDK_16.ordinal();
    }

    public boolean isGreaterThanOrEqualTo17() {
        return this.ordinal() >= JDK_17.ordinal();
    }

    public boolean isGreaterThanOrEqualTo18() {
        return this.ordinal() >= JDK_18.ordinal();
    }

    public boolean isGreaterThanOrEqualTo19() {
        return this.ordinal() >= JDK_19.ordinal();
    }

    public boolean isGreaterThanOrEqualTo20() {
        return this.ordinal() >= JDK_20.ordinal();
    }

    public boolean isGreaterThanOrEqualTo21() {
        return this.ordinal() >= JDK_21.ordinal();
    }

    public boolean isGreaterThanOrEqualTo22() {
        return this.ordinal() >= JDK_22.ordinal();
    }

    public boolean isGreaterThanOrEqualTo23() {
        return this.ordinal() >= JDK_23.ordinal();
    }

    public boolean isGreaterThanOrEqualTo24() {
        return this.ordinal() >= JDK_24.ordinal();
    }

    public boolean isGreaterThanOrEqualTo25() {
        return this.ordinal() >= JDK_25.ordinal();
    }

    public boolean isGreaterThan(JdkVersion that) {
        return that == null || this.ordinal() > that.ordinal();
    }

    public boolean isGreaterThanOrEqualTo(JdkVersion that) {
        return that == null || this.ordinal() >= that.ordinal();
    }

    public boolean isLessThan(JdkVersion that) {
        return that != null && this.ordinal() < that.ordinal();
    }

    public boolean isLessThanOrEqualTo(JdkVersion that) {
        return that != null && this.ordinal() <= that.ordinal();
    }

    public static JdkVersion getJdkVersion(int majorVersion) {
        JdkVersion[] versions = JdkVersion.values();
        if (majorVersion < 0 || majorVersion >= versions.length) {
            return JDK_UNKNOWN;
        }
        return versions[majorVersion];
    }

    public static JdkVersion getJdkVersion(String version) {
        char c;
        int i;
        if (version == null) {
            return JDK_UNKNOWN;
        }
        version = version.stripLeading();
        int v = 0;
        int n = i = version.startsWith("1.") ? 2 : 0;
        while (i < version.length() && Character.isDigit(c = version.charAt(i))) {
            v = 10 * v + (c - 48);
            ++i;
        }
        return v > 0 && v <= JdkVersion.getMaxVersion().ordinal() ? JdkVersion.values()[v] : JDK_UNKNOWN;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public JdkVersion getPreviousVersion() {
        int previous = this.ordinal() - 1;
        if (previous < 0) {
            return this;
        }
        JdkVersion[] versions = (JdkVersion[])JdkVersion.class.getEnumConstants();
        return versions[previous];
    }

    public JdkVersion getNextVersion() {
        int next = this.ordinal() + 1;
        if (next == 1) {
            return this;
        }
        JdkVersion[] versions = (JdkVersion[])JdkVersion.class.getEnumConstants();
        return next < versions.length ? versions[next] : JDK_UNKNOWN;
    }

    private JdkVersion(String versionString) {
        this.versionString = versionString;
    }

    public String toString() {
        return this.versionString;
    }

    public static synchronized JdkVersion getExecutingJdkVersion() {
        JdkVersion version;
        if (currentJdkVersion != null) {
            return currentJdkVersion;
        }
        String property = System.getProperty("java.version");
        if (property != null && (version = JdkVersion.getJdkVersion(property)) != JDK_UNKNOWN) {
            currentJdkVersion = version;
            return currentJdkVersion;
        }
        return JdkVersion.getLoaderJdkVersion(new Loader(){
            private ClassLoader moduleLoader;
            private ClassLoader bootLoader;

            @Override
            public boolean findType(JdkVersion version, String typeName) {
                if (version.isGreaterThanOrEqualTo9()) {
                    if (this.moduleLoader == null) {
                        try {
                            Class.forName("java.lang.Module");
                            this.moduleLoader = ModuleLayer.boot().findModule("java.base").orElseThrow().getClassLoader();
                        }
                        catch (ClassNotFoundException e) {
                            throw new UnexpectedExceptionError(e);
                        }
                    }
                    try {
                        this.moduleLoader.loadClass(typeName);
                        return true;
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                } else {
                    if (this.bootLoader == null) {
                        this.bootLoader = ClassLoader.getSystemClassLoader().getParent();
                    }
                    try {
                        this.bootLoader.loadClass(typeName);
                        return true;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                return false;
            }
        });
    }

    public static synchronized <T> JdkVersion getLoaderJdkVersion(Loader loader) {
        for (int i = 0; i < JDK_IDENTIFIER_TABLE.length; ++i) {
            Object[] row = JDK_IDENTIFIER_TABLE[i];
            JdkVersion version = (JdkVersion)((Object)row[0]);
            String typeName = (String)row[1];
            if (!loader.findType(version, typeName)) continue;
            return version;
        }
        return JdkVersion.getExecutingJdkVersion();
    }

    static {
        classFileMajorVersionOffset = 44;
        JDK_IDENTIFIER_TABLE = new Object[][]{{JDK_22, "java.text.ListFormat"}, {JDK_21, "java.lang.MatchException"}, {JDK_20, "java.lang.reflect.ClassFileFormatVersion"}, {JDK_19, "java.lang.WrongThreadException"}, {JDK_18, "java.net.spi.InetAddressResolver"}, {JDK_17, "java.util.HexFormat"}, {JDK_16, "java.lang.Record"}, {JDK_15, "java.security.interfaces.EdECKey"}, {JDK_14, "java.io.Serial"}, {JDK_13, "sun/security/util/GCMParameters.java"}, {JDK_12, "java.lang.constant.Constable"}, {JDK_11, "java.net.http.HttpClient"}, {JDK_10, "java.lang.invoke.ClassSpecializer"}, {JDK_9, "java.lang.Module"}, {JDK_8, "java.lang.FunctionalInterface"}, {JDK_7, "java.lang.AutoCloseable"}, {JDK_6, "java.util.ArrayDeque"}, {JDK_5, "java.lang.StringBuilder"}, {JDK_4, "java.lang.StackTraceElement"}, {JDK_3, "java.lang.StrictMath"}, {JDK_2, "java.lang.InheritableThreadLocal"}};
    }

    public static interface Loader {
        public boolean findType(JdkVersion var1, String var2);
    }
}

