/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.AbstractTextBuffer;
import oracle.javatools.buffer.ReadOnlyException;

class UndoableTextEdit
extends AbstractUndoableEdit {
    private AbstractTextBuffer.UndoState undoState;
    private int offset;
    private int length;
    private char[] data;
    private boolean isInsert;
    private int startChangeId;
    private int endChangeId;
    private UndoableTextEdit nextEdit;
    private UndoableTextEdit previousEdit;

    UndoableTextEdit(AbstractTextBuffer.UndoState bufferUndoState) {
        this.undoState = bufferUndoState;
        this.offset = -1;
        this.nextEdit = this;
        this.previousEdit = this;
    }

    private AbstractTextBuffer getTextBuffer() {
        return this.undoState.getTextBuffer();
    }

    private boolean isStateAttached() {
        AbstractTextBuffer textBuffer = this.getTextBuffer();
        return textBuffer != null;
    }

    void recordStart() {
        AbstractTextBuffer textBuffer = this.getTextBuffer();
        this.startChangeId = textBuffer.getChangeId();
    }

    void recordEdit(int offset, int length, char[] data, boolean isInsert) {
        this.offset = offset;
        this.length = length;
        this.data = isInsert ? null : data;
        this.isInsert = isInsert;
    }

    void recordEnd() {
        AbstractTextBuffer textBuffer = this.getTextBuffer();
        this.endChangeId = textBuffer.getChangeId();
    }

    @Override
    public boolean canUndo() {
        if (!this.isStateAttached()) {
            return false;
        }
        return super.canUndo();
    }

    @Override
    public void undo() throws CannotUndoException {
        AbstractTextBuffer textBuffer = this.getTextBuffer();
        if (textBuffer == null) {
            throw new CannotUndoException();
        }
        textBuffer.writeLock();
        try {
            textBuffer.fireAttributeUpdate(6);
            UndoableTextEdit firstEdit = this;
            UndoableTextEdit currentEdit = this.previousEdit;
            while (true) {
                currentEdit.undoImpl();
                if (currentEdit == firstEdit) {
                    break;
                }
                currentEdit = currentEdit.previousEdit;
            }
        }
        catch (ReadOnlyException e) {
            throw new IllegalStateException("buffer is read-only");
        }
        finally {
            textBuffer.fireAttributeUpdate(7);
            textBuffer.writeUnlock();
        }
    }

    protected void undoImpl() throws CannotUndoException {
        AbstractTextBuffer textBuffer = this.getTextBuffer();
        int currentId = textBuffer.getChangeId();
        if (currentId != this.endChangeId) {
            throw new IllegalStateException("current change id " + currentId + " does not match " + this.endChangeId);
        }
        super.undo();
        if (this.isInsert) {
            this.data = textBuffer.getChars(this.offset, this.length);
            textBuffer.applyRemove(this.offset, this.data, this.startChangeId);
        } else {
            textBuffer.applyInsert(this.offset, this.data, this.startChangeId);
            this.data = null;
        }
    }

    @Override
    public boolean canRedo() {
        if (!this.isStateAttached()) {
            return false;
        }
        return super.canRedo();
    }

    @Override
    public void redo() throws CannotRedoException {
        AbstractTextBuffer textBuffer = this.getTextBuffer();
        if (textBuffer == null) {
            throw new CannotRedoException();
        }
        textBuffer.writeLock();
        try {
            textBuffer.fireAttributeUpdate(6);
            UndoableTextEdit firstEdit = this;
            UndoableTextEdit currentEdit = this;
            do {
                currentEdit.redoImpl();
            } while ((currentEdit = currentEdit.nextEdit) != firstEdit);
        }
        catch (ReadOnlyException e) {
            throw new IllegalStateException("buffer is read-only");
        }
        finally {
            textBuffer.fireAttributeUpdate(7);
            textBuffer.writeUnlock();
        }
    }

    protected void redoImpl() throws CannotRedoException {
        AbstractTextBuffer textBuffer = this.getTextBuffer();
        int currentId = textBuffer.getChangeId();
        if (currentId != this.startChangeId) {
            throw new IllegalStateException("current change id " + currentId + " does not match " + this.startChangeId);
        }
        super.redo();
        if (this.isInsert) {
            textBuffer.applyInsert(this.offset, this.data, this.endChangeId);
            this.data = null;
        } else {
            this.data = textBuffer.getChars(this.offset, this.length);
            textBuffer.applyRemove(this.offset, this.data, this.endChangeId);
        }
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof UndoableTextEdit) {
            UndoableTextEdit secondEdit = (UndoableTextEdit)anEdit;
            return this.previousEdit.addEditImpl(secondEdit);
        }
        return false;
    }

    protected boolean addEditImpl(UndoableTextEdit anEdit) {
        boolean complexEdit;
        if (this.endChangeId != anEdit.startChangeId) {
            return false;
        }
        boolean bl = complexEdit = anEdit.nextEdit != anEdit;
        if (!complexEdit && this.mergeEdits(this, anEdit)) {
            this.endChangeId = anEdit.endChangeId;
            anEdit.die();
            return true;
        }
        UndoableTextEdit head = this.nextEdit;
        UndoableTextEdit tail = this;
        UndoableTextEdit mergeHead = anEdit;
        UndoableTextEdit mergeTail = anEdit.previousEdit;
        mergeTail.nextEdit = head;
        head.previousEdit = mergeTail;
        mergeHead.previousEdit = tail;
        tail.nextEdit = mergeHead;
        return true;
    }

    @Override
    public boolean replaceEdit(UndoableEdit anEdit) {
        return false;
    }

    private boolean mergeEdits(UndoableTextEdit oldEdit, UndoableTextEdit newEdit) {
        if (oldEdit.isInsert == newEdit.isInsert) {
            boolean merged = false;
            if (oldEdit.isInsert) {
                if (oldEdit.offset <= newEdit.offset && newEdit.offset <= oldEdit.offset + oldEdit.length) {
                    merged = true;
                }
            } else if (newEdit.offset <= oldEdit.offset && oldEdit.offset <= newEdit.offset + newEdit.length) {
                merged = true;
                oldEdit.data = this.insertArrays(newEdit.data, oldEdit.offset - newEdit.offset, oldEdit.data);
                oldEdit.offset = newEdit.offset;
            }
            if (merged) {
                oldEdit.length += newEdit.length;
                newEdit.offset = oldEdit.offset;
                newEdit.length = oldEdit.length;
                newEdit.data = oldEdit.data;
                return true;
            }
        }
        return false;
    }

    @Override
    public void die() {
        super.die();
        this.data = null;
        this.undoState = null;
    }

    private char[] insertArrays(char[] oldData, int offset, char[] newData) {
        char[] combinedData = new char[oldData.length + newData.length];
        System.arraycopy(oldData, 0, combinedData, 0, offset);
        System.arraycopy(newData, 0, combinedData, offset, newData.length);
        System.arraycopy(oldData, offset, combinedData, offset + newData.length, oldData.length - offset);
        return combinedData;
    }

    private char[] mergeArrays(char[] data1, char[] data2) {
        char[] newData = new char[data1.length + data2.length];
        System.arraycopy(data1, 0, newData, 0, data1.length);
        System.arraycopy(data2, data1.length, newData, 0, data2.length);
        return newData;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.isInsert ? "insert " : "remove ");
        s.append("(" + this.offset + ", " + this.length + ")");
        s.append((String)(this.isInsert ? "" : ": " + this.data));
        return s.toString();
    }
}

