/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.text.CharacterIterator;
import oracle.javatools.buffer.ReadTextBuffer;

final class CharacterIteratorWrapper
implements CharacterIterator {
    private ReadTextBuffer textBuffer;
    private int bufferLength;
    private int readOffset;

    CharacterIteratorWrapper(ReadTextBuffer textBuffer) {
        this.textBuffer = textBuffer;
        this.bufferLength = textBuffer.getLength();
        this.readOffset = 0;
    }

    @Override
    public char first() {
        this.readOffset = 0;
        return this.current();
    }

    @Override
    public char last() {
        this.readOffset = Math.max(0, this.bufferLength - 1);
        return this.current();
    }

    @Override
    public char current() {
        if (this.readOffset >= 0 && this.readOffset < this.bufferLength) {
            return this.textBuffer.getChar(this.readOffset);
        }
        return '\uffff';
    }

    @Override
    public char next() {
        this.readOffset = Math.min(this.bufferLength, this.readOffset + 1);
        return this.current();
    }

    @Override
    public char previous() {
        if (this.readOffset > 0) {
            --this.readOffset;
            return this.current();
        }
        return '\uffff';
    }

    @Override
    public char setIndex(int position) {
        if (position < 0 || position > this.bufferLength) {
            throw new IllegalArgumentException("invalid index: " + position);
        }
        this.readOffset = position;
        return this.current();
    }

    @Override
    public int getBeginIndex() {
        return 0;
    }

    @Override
    public int getEndIndex() {
        return this.bufferLength;
    }

    @Override
    public int getIndex() {
        return this.readOffset;
    }

    @Override
    public Object clone() {
        CharacterIteratorWrapper copy = new CharacterIteratorWrapper(this.textBuffer);
        copy.readOffset = this.readOffset;
        return copy;
    }
}

