/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.connections.ConnectionFactory;
import oracle.dbtools.connections.Storage;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.DatabaseProviderStorageFactory;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CancelledSQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DatabaseFactory;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdevimpl.db.adapter.StorageWrapper;

public class CAConnectionCreator
extends DatabaseFactory.ConnectionCreator {
    private final String m_storeName;
    private final StorageWrapper m_wrapper;

    public CAConnectionCreator() {
        this("IdeConnections", null);
    }

    public CAConnectionCreator(String string, StorageWrapper storageWrapper) {
        this.m_storeName = string;
        this.m_wrapper = storageWrapper;
    }

    protected Connection createConnectionImpl(String string) throws DBException {
        try {
            DatabaseProvider databaseProvider;
            Storage<DatabaseProvider> storage = this.m_wrapper == null && "IdeConnections".equals(this.m_storeName) ? StorageWrapper.getDefaultWrapper().getDatabaseStorage() : this.m_wrapper.getDatabaseStorage();
            if (storage != null && (databaseProvider = (DatabaseProvider)storage.getConnection(string, (ConnectionFactory)new DatabaseProviderStorageFactory())) != null) {
                return databaseProvider.getConnection();
            }
        }
        catch (CancelledSQLException cancelledSQLException) {
            throw new CancelledException();
        }
        catch (SQLException sQLException) {
            throw new DBException((Throwable)sQLException);
        }
        catch (StorageException storageException) {
            throw new DBException((Throwable)storageException);
        }
        return null;
    }

    protected String getStoreName() {
        return this.m_storeName;
    }

    protected String getDisplayableStoreName() {
        return DatabaseConnectionStores.getInstance().getShortLabel(this.m_storeName);
    }
}

