/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.ApplyAttributesNamingStandards;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.util.logging.Logger;

public class FKAttributeManager
implements ObjectListener,
ContainerObjectListener {
    private static final Attribute[] ATTRIBUTE_ARRAY_PROTOTYPE = new Attribute[0];
    public static boolean CAN_SYNCHRONIZE = true;
    private Relation relation;
    private boolean needSync = false;
    private boolean canSync = true;
    private List sourceAttributes = new ArrayList();
    private List targetAttributes = new ArrayList();
    private Entity source;
    private Entity target;
    private CandidateKey sourcePk;
    private CandidateKey targetPk;
    private Map fkSort = new HashMap();
    private static final Logger LOGGER = new Logger(FKAttributeManager.class);

    public FKAttributeManager(Relation relation) {
        this.relation = relation;
        relation.addObjectListener(this);
        this.source = relation.getSourceEntity();
        this.target = relation.getTargetEntity();
        if (this.source != null) {
            this.source.addObjectListener(this);
        }
        if (this.target != null) {
            this.target.addObjectListener(this);
        }
        this.makeAttributesForEndpoint(relation.getSourceConnection());
        this.makeAttributesForEndpoint(relation.getTargetConnection());
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
    }

    @Override
    public void changed(ContainerObject container, ContainerObjectEvent event) {
    }

    private boolean isValid() {
        return this.relation != null && this.relation.isValid();
    }

    private boolean isInvalid() {
        return !this.isValid();
    }

    private Design getDesign() {
        return this.relation.getDesignPart().getDesign();
    }

    private void makeAttributesForEndpoints() {
        this.makeAttributesForEndpoint(this.relation.getSourceConnection());
        if (!this.relation.isSelfRefrence()) {
            this.makeAttributesForEndpoint(this.relation.getTargetConnection());
        }
    }

    public void reSync() {
        if (CAN_SYNCHRONIZE && this.needSync) {
            this.makeAttributesForEndpoints();
        }
    }

    public CandidateKey getKeyForEndPoint(Relation.Connection endPoint) {
        if (endPoint.isSource()) {
            return this.getSourcePk();
        }
        return this.getTargetPk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAttributesForEndpoint(Relation.Connection endPoint) {
        if (!CAN_SYNCHRONIZE || !this.canSync) {
            this.needSync = true;
            return;
        }
        boolean useFirstUnique = this.getDesign().getSettings().isUseFirstUniqueForIdentifyingRelation();
        if (this.isInvalid()) {
            return;
        }
        Entity other = endPoint.getOtherEntity();
        CandidateKey pk = null;
        boolean isPKProvider = false;
        Relation rel = endPoint.getRelation();
        if (!this.relation.isUseSurrogateKey()) {
            pk = this.getKeyForEndPoint(endPoint.getOtherConnection());
            if (pk == null) {
                pk = (CandidateKey)other.getHierarchicalPK();
            }
            if (pk == null && useFirstUnique) {
                pk = (CandidateKey)other.getPKorUnique();
            }
            int[] endps = rel.getPKProviderEndPoint();
            for (int ss = 0; ss < endps.length; ++ss) {
                if (rel.getEntity(endps[ss]) != other) continue;
                isPKProvider = true;
            }
        }
        List fkattributes = this.getFKSetFor(endPoint);
        ArrayList fk_copy = new ArrayList(fkattributes);
        if (isPKProvider && !endPoint.getRelation().getIsBeingRemoved() && pk != null && (endPoint.isOneCardinality() && !endPoint.getOtherConnection().isOneCardinality() || endPoint.getOtherConnection().isOneCardinality() && (rel.getDominantRole() == rel.getNONEEntity() || endPoint.isOneCardinality() && other == rel.getDominantRole() || rel.isIdentifying() && !endPoint.isOneCardinality()))) {
            CandidateKey previous;
            Attribute[] attributes = pk.getElementsCollection().toArray(new Attribute[0]);
            this.reuseCreateOrRemoveFKAttributes(attributes, fkattributes, endPoint);
            Attribute[] reusables = fkattributes.toArray(new Attribute[0]);
            fkattributes.clear();
            block13: for (int i = 0; i < attributes.length; ++i) {
                for (int j = 0; j < reusables.length; ++j) {
                    if (reusables[j].getDelegate() == null || !reusables[j].getDelegate().equals(attributes[i])) continue;
                    fkattributes.add(reusables[j]);
                    continue block13;
                }
            }
            if (endPoint.getRelation().isIdentifying()) {
                if (!endPoint.getEntity().hasPK()) {
                    try {
                        endPoint.getEntity().removeObjectListener(this);
                        KeyObject key = null;
                        if (useFirstUnique) {
                            key = endPoint.getEntity().getPKorUnique();
                        }
                        try {
                            CAN_SYNCHRONIZE = false;
                            if (key == null) {
                                key = endPoint.getEntity().createCandidateKey();
                                key.setName(ApplyAttributesNamingStandards.createPrimaryIdentifierName(endPoint.getEntity().getName(), endPoint.getEntity().getShortName(), this.getDesign().getDesignLevelSettings().getNamingStandardRule()));
                            }
                            key.setPK(true);
                        }
                        finally {
                            CAN_SYNCHRONIZE = true;
                        }
                    }
                    finally {
                        endPoint.getEntity().addObjectListener(this);
                    }
                }
                if (!this.getDesign().isLoading()) {
                    Entity end = endPoint.getEntity();
                    CandidateKey pkey = (CandidateKey)end.getPK();
                    pkey.addElement(this.relation);
                    pkey.setDirty(true);
                }
            } else {
                Entity end = endPoint.getEntity();
                CandidateKey pkey = (CandidateKey)end.getPK();
                if (pkey != null) {
                    pkey.removeElement(this.relation);
                    if (!this.getDesign().isLoading()) {
                        pkey.setDirty(true);
                    }
                }
            }
            if ((previous = this.getPkListeneningTo(endPoint.getOtherConnection())) != null) {
                previous.removeObjectListener(this);
                previous.removeContainerListener(this);
            }
            pk.addObjectListener(this);
            pk.addContainerListener(this);
            this.setPkListeneningTo(endPoint.getOtherConnection(), pk);
        } else if (rel.isUseSurrogateKey() && rel.isIdentifying() && !endPoint.isOneCardinality()) {
            if (!endPoint.getEntity().hasPK()) {
                try {
                    endPoint.getEntity().removeObjectListener(this);
                    KeyObject key = null;
                    if (useFirstUnique) {
                        key = endPoint.getEntity().getPKorUnique();
                    }
                    try {
                        CAN_SYNCHRONIZE = false;
                        if (key == null) {
                            key = endPoint.getEntity().createCandidateKey();
                            key.setName(ApplyAttributesNamingStandards.createPrimaryIdentifierName(endPoint.getEntity().getName(), endPoint.getEntity().getShortName(), this.getDesign().getDesignLevelSettings().getNamingStandardRule()));
                        }
                        key.setPK(true);
                    }
                    finally {
                        CAN_SYNCHRONIZE = true;
                    }
                }
                finally {
                    endPoint.getEntity().addObjectListener(this);
                }
            }
            if (!this.getDesign().isLoading()) {
                Entity end = endPoint.getEntity();
                CandidateKey pkey = (CandidateKey)end.getPK();
                pkey.addElement(this.relation);
                pkey.setDirty(true);
            }
        } else {
            CandidateKey previous = this.getPkListeneningTo(endPoint.getOtherConnection());
            if (previous != null) {
                previous.removeObjectListener(this);
                previous.removeContainerListener(this);
            }
            if (!endPoint.getEntity().isBST()) {
                Entity end;
                CandidateKey pkey;
                Attribute[] fks = fkattributes.toArray(new Attribute[0]);
                for (int i = 0; i < fks.length; ++i) {
                    fks[i].setTemporaryWriteable(true);
                    fks[i].remove();
                    fks[i].setDelegate(null);
                    fks[i].setTemporaryWriteable(false);
                }
                fkattributes.clear();
                if (!this.getDesign().isLoading() && (pkey = (CandidateKey)(end = endPoint.getEntity()).getPK()) != null) {
                    pkey.removeElement(this.relation);
                    pkey.setDirty(true);
                }
            }
        }
        if (!fk_copy.equals(fkattributes)) {
            this.relation.fireFK_AttributesChanged();
        }
    }

    private void reuseCreateOrRemoveFKAttributes(Attribute[] attributes, List fkattributes, Relation.Connection connection) {
        int j;
        boolean found;
        int i;
        List<Attribute> list;
        Entity ent = connection.getEntity();
        Entity other = connection.getOtherEntity();
        if (ent.isBST() || other.isBST() && (attributes.length == 0 || attributes[0].isOid())) {
            Attribute attr;
            if (ent.isBST()) {
                if (other.isBST()) {
                    attr = ent.getExactRefToStructurtedType(other.getBasedOnStructuredType(), other);
                    if (attr == null) {
                        attr = ent.getRefToStructurtedType(other.getBasedOnStructuredType(), other);
                    }
                    if (attr != null) {
                        this.replaceRefWithFKAttribute(attr, connection);
                    } else {
                        this.matchPKtoFKattributes(ent, other, connection);
                    }
                } else {
                    this.matchPKtoFKattributes(ent, other, connection);
                }
            } else if (other.isBST()) {
                attr = ent.getExactRefToStructurtedType(other.getBasedOnStructuredType(), other);
                if (attr == null) {
                    attr = ent.getRefToStructurtedType(other.getBasedOnStructuredType(), other);
                }
                if (attr == null) {
                    this.createRefToStructuredType(other.getBasedOnStructuredType(), connection);
                } else {
                    this.replaceRefWithFKAttribute(attr, connection);
                }
                list = connection.getEntity().getAllElementsListGeneratedBy(this.relation);
                fkattributes.clear();
                fkattributes.addAll(list);
            }
        } else {
            List list2 = connection.getEntity().getAllElementsListGeneratedBy(this.relation);
            list2 = this.replacePlainWithFKAttributes(connection, list2);
            fkattributes.clear();
            fkattributes.addAll(list2);
        }
        Attribute[] reusables = fkattributes.toArray(new Attribute[0]);
        list = new ArrayList();
        for (i = 0; i < reusables.length; ++i) {
            found = false;
            for (j = 0; j < attributes.length; ++j) {
                if (reusables[i].getDelegate() == null || !reusables[i].getDelegate().equals(attributes[j])) continue;
                found = true;
                break;
            }
            if (!found) continue;
            list.add(reusables[i]);
            found = false;
        }
        reusables = list.toArray(new Attribute[0]);
        if (reusables.length < attributes.length) {
            for (i = 0; i < attributes.length; ++i) {
                found = false;
                for (j = 0; j < reusables.length; ++j) {
                    if (reusables[j].getDelegate() == null || !reusables[j].getDelegate().equals(attributes[i])) continue;
                    found = true;
                    break;
                }
                if (found || attributes[i].getContainer() == ent && attributes[i].isFKAttribute() && attributes[i].getDelegate() != null && attributes[i].getDelegate().getContainer() == ent || ent.isBST()) continue;
                this.createAttribute(connection, attributes[i]);
            }
        }
        list = connection.getEntity().getAllElementsListGeneratedBy(this.relation);
        ArrayList<Attribute> ord_list = new ArrayList<Attribute>();
        for (int i2 = 0; i2 < attributes.length; ++i2) {
            boolean found2 = false;
            Attribute attr = null;
            for (int j2 = 0; j2 < list.size(); ++j2) {
                attr = (Attribute)list.get(j2);
                if (attr.getDelegate() == null || attr.getDelegate() != attributes[i2]) continue;
                found2 = true;
                break;
            }
            if (!found2 || attr == null) continue;
            ord_list.add(attr);
        }
        fkattributes.clear();
        fkattributes.addAll(ord_list);
    }

    private CandidateKey getPkListeneningTo(Relation.Connection endPoint) {
        return endPoint.isSource() ? this.sourcePk : this.targetPk;
    }

    private void setPkListeneningTo(Relation.Connection endPoint, CandidateKey pk) {
        if (endPoint.isSource()) {
            this.sourcePk = pk;
        } else {
            this.targetPk = pk;
        }
    }

    private void matchPKtoFKattributes(Entity child, Entity parent, Relation.Connection connection) {
        KeyObject pk = parent.getPK();
        if (pk != null) {
            ArrayList<Attribute> list = new ArrayList<Attribute>();
            for (Attribute fkattr : pk.getElementsCollection()) {
                Attribute attr = child.findBestMatchForFKattr(fkattr, list);
                if (attr == null) {
                    return;
                }
                list.add(attr);
            }
            ContainedObject[] fks = pk.getElements();
            if (list.size() == fks.length) {
                this.fkSort.clear();
                for (int i = 0; i < fks.length; ++i) {
                    Attribute fkattr = (Attribute)fks[i];
                    Attribute attr = (Attribute)list.get(i);
                    attr.setReferedAttribute(fkattr.getObjectID());
                    attr.setGeneratorID(this.relation.getObjectID());
                    this.replacePlaneWithFKAttribute(attr, connection);
                }
            }
        }
    }

    private void replaceRefWithFKAttribute(Attribute attribute, Relation.Connection connection) {
        Attribute oidel;
        Entity other = connection.getOtherEntity();
        Attribute refAttribute = null;
        String refid = attribute.getReferedAttribute();
        if (other.isBST() && (oidel = (Attribute)other.getOidElement()) != null) {
            refid = oidel.getObjectID();
            refAttribute = oidel;
        }
        attribute.setTemporaryWriteable(true);
        if (refid != null) {
            attribute.setReferedAttribute(refid);
        }
        if (refAttribute != null) {
            attribute.setDelegate(refAttribute);
        }
        attribute.setConnection(connection);
        attribute.setGeneratorID(this.relation.getObjectID());
        attribute.setScopeId(other.getObjectID());
        attribute.setTemporaryWriteable(false);
    }

    private void replacePlaneWithFKAttribute(Attribute attribute, Relation.Connection connection) {
        DesignObject obj;
        Attribute oidel;
        Entity other = connection.getOtherEntity();
        Attribute refAttribute = null;
        String refid = attribute.getReferedAttribute();
        if (refid == null && other.isBST() && (oidel = (Attribute)other.getOidElement()) != null) {
            refid = oidel.getObjectID();
            refAttribute = oidel;
        }
        if (refid != null && (obj = attribute.getDesign().getDesignObject(refid)) instanceof Attribute) {
            refAttribute = (Attribute)obj;
        }
        attribute.setTemporaryWriteable(true);
        if (refid != null) {
            attribute.setReferedAttribute(refid);
        }
        if (refAttribute != null) {
            attribute.setDelegate(refAttribute);
        }
        attribute.setConnection(connection);
        attribute.setTemporaryWriteable(false);
    }

    private Attribute createRefToStructuredType(StructuredType type, Relation.Connection connection) {
        Entity entity = connection.getEntity();
        Entity other = connection.getOtherEntity();
        Attribute attribute = (Attribute)other.getOidElement();
        if (attribute == null || !other.isBST()) {
            return null;
        }
        String obId = (String)entity.getReferIDMap().get(attribute.getObjectID());
        Attribute fkattribute = this.createAttribute(entity.getDesignPart(), connection, attribute, attribute.getDesign(), obId, attribute);
        fkattribute.setTemporaryWriteable(true);
        fkattribute.setScopeId(other.getObjectID());
        fkattribute.setGeneratorID(connection.getRelation().getObjectID());
        fkattribute.setUse((short)3);
        fkattribute.setReference(true);
        fkattribute.setStructuredType(type);
        if (attribute != null && other.isBST() && type.isParentOf(other.getBasedOnStructuredType())) {
            fkattribute.setReferedAttribute(attribute.getObjectID());
        }
        String name = type.getName();
        fkattribute.setName(name);
        fkattribute.setTemporaryWriteable(false);
        return fkattribute;
    }

    private Attribute createAttribute(Relation.Connection connection, Attribute attribute) {
        Entity entity = connection.getEntity();
        String obId = (String)entity.getReferIDMap().get(attribute.getObjectID());
        Attribute fkattribute = this.createAttribute(entity.getDesignPart(), connection, attribute, attribute.getDesign(), obId, attribute);
        fkattribute.setTemporaryWriteable(true);
        fkattribute.setScopeId(attribute.getScopeId());
        fkattribute.setAllowSubtypeSubstitution(attribute.isAllowSubtypeSubstitution());
        fkattribute.setRestrictedTypeSubstitution(attribute.isRestrictedTypeSubstitution());
        List list = fkattribute.getPermittedSubTypes();
        list.clear();
        list.addAll(attribute.getPermittedSubTypes());
        fkattribute.setReferedAttribute(attribute.getObjectID());
        fkattribute.setName(attribute.getShortName());
        fkattribute.setTemporaryWriteable(false);
        return fkattribute;
    }

    private Attribute createAttribute(DesignPart designPart, Relation.Connection connection, Attribute attribute, Design design, String objectId, Attribute delegate) {
        Attribute fkattribute = new Attribute(designPart);
        fkattribute.setContainer(connection.getEntity());
        fkattribute.setTemporaryWriteable(true);
        fkattribute.setConnectionIfNull(connection);
        fkattribute.setDesign(design);
        fkattribute.setDelegate(delegate);
        fkattribute.setComment(attribute.getComment());
        fkattribute.setUse(attribute.getUse());
        fkattribute.setReference(attribute.isReference());
        fkattribute.setStructuredType(attribute.getStructuredType());
        fkattribute.setStructAttributeID(attribute.getStructAttributeID());
        fkattribute.setRestrictedTypeSubstitution(attribute.isRestrictedTypeSubstitution());
        List list = fkattribute.getPermittedSubTypes();
        list.clear();
        list.addAll(attribute.getPermittedSubTypes());
        fkattribute.setScopeId(attribute.getScopeId());
        fkattribute.setAllowSubtypeSubstitution(attribute.isAllowSubtypeSubstitution());
        fkattribute.setDomain(attribute.getDomain());
        fkattribute.setLogicalDatatype(attribute.getLogicalDatatype());
        fkattribute.copyParametersFrom(attribute);
        fkattribute.setDistinctType(attribute.getDistinctType());
        connection.getEntity().add(fkattribute);
        if (!design.getLogicalDesign().getAttributeSet().add(fkattribute)) {
            LOGGER.error("FKAttributeManager: can not add FKAttribute to AttributeSet. FKAttributeManager.createAttribute");
        }
        this.relation.getDesign().getLogicalDesign().getAttributeSet().add(fkattribute);
        this.getFKSetFor(connection).add(fkattribute);
        fkattribute.setGeneratorID(this.relation.getObjectID());
        fkattribute.setTemporaryWriteable(false);
        return fkattribute;
    }

    private List getFKSetFor(Relation.Connection endPoint) {
        return endPoint.isSource() ? this.sourceAttributes : this.targetAttributes;
    }

    public List replacePlainWithFKAttributes(Relation.Connection connection, List fkattributes) {
        Attribute[] atts = fkattributes.toArray(ATTRIBUTE_ARRAY_PROTOTYPE);
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        this.fkSort.clear();
        for (int i = 0; i < atts.length; ++i) {
            Attribute attribute = atts[i];
            if (!attribute.isFKAttribute()) {
                Attribute oidel;
                Entity other = connection.getOtherEntity();
                Attribute refAttribute = null;
                String refid = attribute.getReferedAttribute();
                if (refid == null && other.isBST() && (oidel = (Attribute)other.getOidElement()) != null) {
                    refid = oidel.getObjectID();
                    refAttribute = oidel;
                }
                attribute.setTemporaryWriteable(true);
                if (refid != null) {
                    attribute.setReferedAttribute(refid);
                    DesignObject obj = attribute.getDesign().getDesignObject(refid);
                    if (obj instanceof Attribute) {
                        refAttribute = (Attribute)obj;
                    }
                }
                if (refAttribute != attribute && refAttribute != null) {
                    attribute.setDelegate(refAttribute);
                } else if (refAttribute != null && refAttribute == attribute) {
                    attribute.setReferedAttribute(null);
                    attribute.setGeneratorID("");
                    attribute = this.createAttribute(connection, refAttribute);
                    fkattributes.add(i, attribute);
                }
                attribute.setConnection(connection);
                attribute.setTemporaryWriteable(false);
            }
            list.add(attribute);
        }
        return list;
    }

    public Attribute[] getFKAttributes(int endPoint) {
        List attributeSet = null;
        if (endPoint == 0) {
            attributeSet = this.sourceAttributes;
        } else if (endPoint == 1) {
            attributeSet = this.targetAttributes;
        } else {
            throw new IllegalArgumentException("endPoint marker is not Relation.SOURCE or Relation.TARGET, was: " + endPoint);
        }
        return attributeSet.toArray(ATTRIBUTE_ARRAY_PROTOTYPE);
    }

    public boolean hasFKAttributesInPK(int endPoint) {
        Attribute[] atts = this.getFKAttributes(endPoint);
        for (int i = 0; i < atts.length; ++i) {
            if (!atts[i].isPKElement()) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimaryForeignKey(int endPoint) {
        return this.hasFKAttributesInPK(endPoint);
    }

    protected void removeAllFKAttributes() {
        HashSet fkAttributes = new HashSet();
        fkAttributes.addAll(this.sourceAttributes);
        fkAttributes.addAll(this.targetAttributes);
        Attribute[] attributes = fkAttributes.toArray(new Attribute[0]);
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i].getContainerWithKeyObject() != null && !attributes[i].getContainerWithKeyObject().isBST()) {
                attributes[i].remove();
                continue;
            }
            attributes[i].setConnection(null);
        }
    }

    public void removeFromListeners() {
        CandidateKey key;
        Entity ent = this.relation.getSourceEntity();
        if (ent != null) {
            key = (CandidateKey)ent.getPKorUnique();
            if (key != null) {
                key.getNewElementsCollection().remove(this.relation);
            }
            ent.removeObjectListener(this);
            ent.removeContainerListener(this);
        }
        if ((ent = this.relation.getTargetEntity()) != null) {
            key = (CandidateKey)ent.getPKorUnique();
            if (key != null) {
                key.getNewElementsCollection().remove(this.relation);
            }
            ent.removeObjectListener(this);
            ent.removeContainerListener(this);
        }
        if (this.sourcePk != null) {
            this.sourcePk.getNewElementsCollection().remove(this.relation);
            this.sourcePk.removeObjectListener(this);
            this.sourcePk.removeContainerListener(this);
        }
        if (this.targetPk != null) {
            this.targetPk.getNewElementsCollection().remove(this.relation);
            this.targetPk.removeObjectListener(this);
            this.targetPk.removeContainerListener(this);
        }
    }

    public CandidateKey getSourcePk() {
        return this.sourcePk;
    }

    public CandidateKey getTargetPk() {
        return this.targetPk;
    }

    public void setSourcePk(CandidateKey sourcePk) {
        this.sourcePk = sourcePk;
    }

    public void setTargetPk(CandidateKey targetPk) {
        this.targetPk = targetPk;
    }
}

