/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.scheduling.SQLStatementBuilderScheduler;
import oracle.dbtools.crest.model.scheduling.SchedulerArgument;
import oracle.dbtools.crest.model.scheduling.SchedulerJob;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public class SSBSchedulerJob
extends SQLStatementBuilderScheduler {
    @Override
    public Map<String, String> getExcludeMap() {
        if (this.excludeMap == null) {
            this.excludeMap = new TreeMap();
        }
        this.excludeMap.put("JOB_NAME", "JOB_NAME");
        this.excludeMap.put("OWNER", "OWNER");
        this.excludeMap.put("JOB_TYPE", "JOB_TYPE");
        this.excludeMap.put("JOB_ACTION", "JOB_ACTION");
        this.excludeMap.put("PROGRAM_NAME", "PROGRAM_NAME");
        this.excludeMap.put("PROGRAM_OWNER", "PROGRAM_OWNER");
        this.excludeMap.put("FILE_WATCHER_NAME", "FILE_WATCHER_NAME");
        this.excludeMap.put("FILE_WATCHER_OWNER", "FILE_WATCHER_OWNER");
        this.excludeMap.put("SCHEDULE_TYPE", "SCHEDULE_TYPE");
        this.excludeMap.put("SCHEDULE_OWNER", "SCHEDULE_OWNER");
        this.excludeMap.put("SCHEDULE_NAME", "SCHEDULE_NAME");
        this.excludeMap.put("EVENT_QUEUE_OWNER", "EVENT_QUEUE_OWNER");
        this.excludeMap.put("EVENT_QUEUE_NAME", "EVENT_QUEUE_NAME");
        this.excludeMap.put("EVENT_QUEUE_AGENT", "EVENT_QUEUE_AGENT");
        this.excludeMap.put("EVENT_CONDITION", "EVENT_CONDITION");
        this.excludeMap.put("HAS_CONSTRAINTS", "HAS_CONSTRAINTS");
        this.excludeMap.put("CREDENTIAL_OWNER", "CREDENTIAL_OWNER");
        this.excludeMap.put("CREDENTIAL_NAME", "CREDENTIAL_NAME");
        this.excludeMap.put("CONNECT_CREDENTIAL_OWNER", "CONNECT_CREDENTIAL_OWNER");
        this.excludeMap.put("CONNECT_CREDENTIAL_NAME", "CONNECT_CREDENTIAL_NAME");
        this.excludeMap.put("DESTINATION", "DESTINATION");
        this.excludeMap.put("DESTINATION_OWNER", "DESTINATION_OWNER");
        this.excludeMap.put("FAIL_ON_SCRIPT_ERROR", "FAIL_ON_SCRIPT_ERROR");
        this.excludeMap.put("HAS_CONSTRAINTS", "HAS_CONSTRAINTS");
        this.excludeMap.put("RAISE_EVENTS", "RAISE_EVENTS");
        this.excludeMap.put("ENABLED", "ENABLED");
        return this.excludeMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        if (object instanceof SchedulerJob) {
            SchedulerJob job = (SchedulerJob)object;
            if (job.isMinimumDefined()) {
                Map<String, String> excludeMap = this.getExcludeMap();
                StringBuffer buffer = new StringBuffer();
                SSBSchedulerJob.appendStringWithSpace(buffer, "BEGIN");
                SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 1);
                SSBSchedulerJob.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.CREATE_JOB (");
                SSBSchedulerJob.appendObjectName(buffer, job, prettyPrint);
                SSBSchedulerJob.appendActionJobType(buffer, job, prettyPrint);
                SSBSchedulerJob.appendProgramName(buffer, job, prettyPrint);
                SSBSchedulerJob.appendSchedule(buffer, job, prettyPrint);
                SSBSchedulerJob.appendFileWatcherQueueSpec(buffer, job, prettyPrint);
                SSBSchedulerJob.appendEventDetails(buffer, job, prettyPrint);
                SSBSchedulerJob.appendDestinationName(buffer, job, prettyPrint);
                SSBSchedulerJob.appendCredential(buffer, job, prettyPrint);
                SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 1);
                SSBSchedulerJob.appendStringWithSpace(buffer, ");");
                SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerJob.appendConnecCredentialAttribute(buffer, job, prettyPrint);
                this.appendAtrtributes(buffer, job, prettyPrint, excludeMap);
                SSBSchedulerJob.appendRaiseEventsAttribute(buffer, job, prettyPrint);
                SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 0);
                this.appendArguments(buffer, job, prettyPrint, excludeMap);
                SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerJob.appendEnable(buffer, job, prettyPrint);
                SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerJob.appendString(buffer, "END");
                SSBSchedulerJob.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, "");
            } else {
                SSBSchedulerJob.appendStringWithSpace(oldbuffer, "invalid job definitiion for " + String.valueOf(job.getName() + "\n program name or jab type and job action should be defined"));
            }
        }
    }

    public static void appendObjectName(StringBuffer buffer, SchedulerJob obj, boolean prettyPrint) {
        SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
        SSBSchedulerJob.appendString(buffer, "job_name => '" + obj.getNameFormatted() + "'");
    }

    public static boolean appendActionJobType(StringBuffer buffer, SchedulerObject obj, boolean prettyPrint) {
        String type;
        String res = "";
        String action = obj.getProperty("JOB_ACTION");
        if (action != null && !action.isEmpty() && (type = obj.getProperty("JOB_TYPE")) != null && !type.isEmpty()) {
            SSBSchedulerJob.appendString(buffer, ',');
            SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerJob.appendString(buffer, "job_type => '" + type + "',");
            SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerJob.appendString(buffer, "job_action => '" + SSBSchedulerJob.replaceSingle_Quote(action) + "'");
            return true;
        }
        return false;
    }

    public static void appendProgramName(StringBuffer buffer, SchedulerJob job, boolean prettyPrint) {
        String res = job.getProgramNameFormatted();
        if (res != null && !res.isEmpty()) {
            SSBSchedulerJob.appendString(buffer, ',');
            SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerJob.appendString(buffer, "program_name => '" + res + "'");
        }
    }

    public static void appendFileWatcherQueueSpec(StringBuffer buffer, SchedulerJob job, boolean prettyPrint) {
        String res = job.getFileWatcherNameFormatted();
        String type = job.getProperty("SCHEDULE_TYPE");
        if (type != null && "FILE_WATCHER".equalsIgnoreCase(type) && res != null && !res.isEmpty()) {
            String condition = job.getProperty("EVENT_CONDITION");
            if (condition != null && !condition.isEmpty()) {
                SSBSchedulerJob.appendString(buffer, ',');
                SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
                SSBSchedulerJob.appendString(buffer, "event_condition => '" + condition + "'");
            }
            SSBSchedulerJob.appendString(buffer, ',');
            SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerJob.appendString(buffer, "queue_spec => '" + res + "'");
        }
    }

    public static void appendSchedule(StringBuffer buffer, SchedulerJob job, boolean prettyPrint) {
        String res = job.getScheduleNameFormatted();
        if (res != null && !res.isEmpty()) {
            SSBSchedulerJob.appendString(buffer, ',');
            SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerJob.appendString(buffer, "schedule_name => '" + res + "'");
        }
    }

    public static void appendEventDetails(StringBuffer buffer, SchedulerJob job, boolean prettyPrint) {
        String condition;
        String res = job.getEventQueueSpecNameFormatted();
        String type = job.getProperty("SCHEDULE_TYPE");
        String schedName = job.getProperty("SCHEDULE_NAME");
        if ((type == null && schedName == null || type != null && !"FILE_WATCHER".equalsIgnoreCase(type)) && res != null && !res.isEmpty() && (condition = job.getProperty("EVENT_CONDITION")) != null && !condition.isEmpty()) {
            SSBSchedulerJob.appendString(buffer, ',');
            SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerJob.appendString(buffer, "event_condition => '" + condition + "'");
            SSBSchedulerJob.appendString(buffer, ',');
            SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerJob.appendString(buffer, "queue_spec => '" + res + "'");
        }
    }

    public static void appendConnecCredentialAttribute(StringBuffer buffer, SchedulerJob job, boolean prettyPrint) {
        String res1 = job.getConnectCredentialNameFormatted();
        if (res1 != null && !res1.isEmpty()) {
            Object name = "";
            String owner = job.getOwner();
            if (owner != null && !owner.isEmpty()) {
                name = SchedulerObject.getFormatedSimpleName(owner) + ".";
            }
            name = (String)name + SchedulerObject.getFormatedSimpleName(job.getName());
            SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerJob.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.SET_ATTRIBUTE(");
            SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerJob.appendString(buffer, "NAME".toLowerCase() + " => '" + (String)name + "',");
            SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerJob.appendString(buffer, "ATTRIBUTE".toLowerCase() + " => 'connect_credential_name',");
            SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerJob.appendString(buffer, "VALUE".toLowerCase() + " => '" + res1 + "'");
            SSBSchedulerJob.appendString(buffer, ");");
        }
    }

    public static void appendRaiseEventsAttribute(StringBuffer buffer, SchedulerJob job, boolean prettyPrint) {
        String res = job.getProperty("RAISE_EVENTS");
        int numb = SchedulerJob.getRaiseEventsNumber(res);
        if (numb > 0) {
            String name = job.getNameFormatted();
            SSBSchedulerJob.appendSetAttribute(buffer, name, "RAISE_EVENTS", String.valueOf(numb), "NUMBER", prettyPrint);
        }
    }

    public void appendArguments(StringBuffer buffer, SchedulerJob prog, boolean prettyPrint, Map<String, String> excludeMap) {
        for (SchedulerArgument arg : prog.getSortedArguments()) {
            SSBSchedulerJob.appendJobArgument(buffer, prog, arg, prettyPrint);
        }
    }

    public static void appendJobArgument(StringBuffer buffer, SchedulerObject prog, SchedulerArgument arg, boolean prettyPrint) {
        String value = arg.getProperty("VALUE");
        if (value != null) {
            SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerJob.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE (");
            SSBSchedulerJob.appendStringAttribute(buffer, "job_name".toLowerCase(), prog.getNameFormatted(), prettyPrint);
            if (!arg.isNullOrEmpty("ARGUMENT_POSITION")) {
                SSBSchedulerJob.appendString(buffer, ',');
                SSBSchedulerJob.appendNonStringAttribute(buffer, "ARGUMENT_POSITION".toLowerCase(), arg.getProperty("ARGUMENT_POSITION"), prettyPrint);
            }
            String type = null;
            if (!arg.isNullOrEmpty("ARGUMENT_TYPE")) {
                type = arg.getProperty("ARGUMENT_TYPE");
            }
            String sqlValue = SSBSchedulerJob.getValue(value, null);
            SSBSchedulerJob.appendString(buffer, ',');
            SSBSchedulerJob.appendNonStringAttribute(buffer, "argument_value".toLowerCase(), sqlValue, prettyPrint);
            SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerJob.appendStringWithSpace(buffer, ");");
        }
    }

    public static void appendDestinationName(StringBuffer buffer, SchedulerObject job, boolean prettyPrint) {
        String res = job.getDestinationNameFormatted();
        if (res != null && !res.isEmpty()) {
            SSBSchedulerJob.appendString(buffer, ',');
            SSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerJob.appendString(buffer, "destination_name => '" + res + "'");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchedulerJob;
    }
}

