/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.digsig;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Properties;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSDataContentInfo;
import oracle.security.crypto.cms.CMSSignedDataContentInfo;
import oracle.security.crypto.cms.CMSSignerInfo;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;
import oracle.security.digsig.CertificateMapper;
import oracle.security.digsig.DigitalSignatureException;
import oracle.security.digsig.KeyStoreWrapper;
import oracle.security.digsig.Signer;

public class PKCS7Signer
extends Signer {
    PKCS7Signer(KeyStoreWrapper pks, CertificateMapper cm, Properties config) throws DigitalSignatureException {
        super(pks, cm, config);
        this.signerFormat = 2;
    }

    @Override
    public void finish() throws DigitalSignatureException {
        try {
            CMSSignedDataContentInfo sdci;
            super.finish();
            if (!this.isAttached) {
                sdci = new CMSSignedDataContentInfo((CMSContentInfo)new CMSDataContentInfo());
            } else {
                CMSDataContentInfo dci = new CMSDataContentInfo(this.signerDocument.toByteArray());
                sdci = new CMSSignedDataContentInfo((CMSContentInfo)dci);
            }
            AttributeSet aaBytes = new AttributeSet();
            aaBytes.addAttribute(CMS.id_signingTime, (ASN1Object)new ASN1Date(Calendar.getInstance().getTime()));
            aaBytes.addAttribute(CMS.id_messageDigest, (ASN1Object)new ASN1OctetString(this.signerDigestBits));
            aaBytes.addAttribute(CMS.id_contentType, (ASN1Object)CMS.id_data);
            Signature sig = null;
            byte[] eDigest = null;
            try {
                if (this.signerPrivateKey.getAlgorithm().compareToIgnoreCase("RSA") != 0 && this.signerPrivateKey.getAlgorithm().compareToIgnoreCase("DSA") != 0) {
                    throw new DigitalSignatureException("Invalid private key");
                }
                sig = Signature.getInstance(CMSUtils.getAlgoName((AlgorithmIdentifier)this.signerAlgorithm, (boolean)true));
                sig.initSign(this.signerPrivateKey);
                sig.update(Utils.toBytes((Streamable)aaBytes));
                eDigest = sig.sign();
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new DigitalSignatureException("Signature algorithm is not supported.", nsae);
            }
            catch (InvalidKeyException ike) {
                throw new DigitalSignatureException("Invalid private key.", ike);
            }
            Vector<X509Certificate> vX509 = new Vector<X509Certificate>();
            Certificate[] cc = this.signerKeyStore.getCertificateChain(this.signerAlias);
            X509Certificate[] scc = new X509Certificate[cc.length];
            for (int i = 0; i < cc.length; ++i) {
                scc[i] = (X509Certificate)cc[i];
                vX509.add(i, scc[i]);
            }
            CMSSignerInfo si = new CMSSignerInfo(scc[0], this.signerDigestAlgorithm, this.signerPKIAlgorithm, aaBytes, null, eDigest);
            try {
                sdci.addSignerInfo(scc[0], si);
            }
            catch (NoSuchAlgorithmException e) {
                throw new DigitalSignatureException("No Such Algorithm");
            }
            sdci.addCertificates(vX509);
            ByteArrayOutputStream baOS = new ByteArrayOutputStream();
            sdci.output((OutputStream)baOS);
            this.signerSignature.append(Utils.toBase64((byte[])baOS.toByteArray()));
        }
        catch (SignatureException sx) {
            throw new DigitalSignatureException(sx.toString());
        }
        catch (IOException ix) {
            throw new DigitalSignatureException(ix.toString());
        }
        catch (KeyStoreException ksx) {
            throw new DigitalSignatureException(ksx.toString());
        }
        catch (CertificateException cx) {
            throw new DigitalSignatureException(cx.toString());
        }
    }
}

