/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.digsig;

import java.util.Properties;
import oracle.security.digsig.CertificateMapper;
import oracle.security.digsig.DigitalSignatureException;

public abstract class BrowserSignRequest {
    public static final int UITYPE_HTML = 1;
    public static final int UITYPE_JSP = 3;
    public static final int UITYPE_OAF = 2;
    public static final int UITYPE_EXTERNAL = 4;
    public static final int SUCCESS = 0;
    public static final int FAILURE = -1;
    public static final int CANCEL = -2;

    BrowserSignRequest() {
    }

    BrowserSignRequest(CertificateMapper certMap, Properties config) {
    }

    public abstract void start(String var1, String var2) throws DigitalSignatureException;

    public void update(byte plaintext) throws DigitalSignatureException {
        byte[] doc = new byte[]{plaintext};
        this.update(doc, 0, 1);
    }

    public void update(byte[] plaintext) throws DigitalSignatureException {
        this.update(plaintext, 0, plaintext.length);
    }

    public abstract void update(byte[] var1, int var2, int var3) throws DigitalSignatureException;

    public abstract void finish() throws DigitalSignatureException;

    public int setBrowserSignResponse(String sigData, String sigInfo) throws DigitalSignatureException {
        return this.setBrowserSignResponse(sigData, sigInfo, null);
    }

    public abstract int setBrowserSignResponse(String var1, String var2, Properties var3) throws DigitalSignatureException;

    public abstract boolean isSupported(int var1);

    public abstract String getBrowserSignRequestHTML(Properties var1, Properties var2, Properties var3) throws DigitalSignatureException;

    public abstract Object getBrowserSignRequestOAF(Properties var1, Properties var2, Properties var3, Object var4) throws DigitalSignatureException;

    public abstract int getSignatureFormat();

    public abstract String getSignature() throws DigitalSignatureException;

    public abstract void addRecipientID(String var1) throws DigitalSignatureException;

    public void addRecipientIDs(String[] ids) throws DigitalSignatureException {
        for (int i = 0; i < ids.length; ++i) {
            this.addRecipientID(ids[i]);
        }
    }
}

